/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataComm;
import cerent.cms.model.NodeModelDelegate;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.job.IJobProgressControl;
import java.net.URL;

public class DataReboot {
    private String hostName;
    private String userName;
    private String password;
    private String session;
    private IJobProgressControl observer;
    private CtcHttpRetriever retriever;
    private int operation;
    private String operationName;
    private int error;
    private String errorMsg;
    private boolean isAuthorizationFailure;
    private String ccName;
    private NodeModelDelegate nodeModel;
    private TDMTerminology terms;
    private SDebug db;

    public DataReboot(NodeModelDelegate nodeModelDelegate, int n, IJobProgressControl iJobProgressControl) {
        this.db = nodeModelDelegate.getChildDebug(DataReboot.class);
        this.observer = iJobProgressControl;
        this.operation = n;
        this.hostName = nodeModelDelegate.getHostName();
        this.userName = nodeModelDelegate.getUserName();
        this.password = nodeModelDelegate.getUserPassword();
        this.terms = nodeModelDelegate.getTDMTerminology();
        this.session = DataComm.getSession(nodeModelDelegate);
        this.retriever = null;
        this.error = 200;
        this.errorMsg = null;
        this.operationName = n == 4 ? "Activate" : "Revert";
        this.ccName = nodeModelDelegate.getPlatform().getControlCardName();
        this.nodeModel = nodeModelDelegate;
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            URL uRL = null;
            switch (this.operation) {
                case 4: {
                    uRL = CtcHttpRetriever.makeUrl((String)this.hostName, (String)"/activate/");
                    break;
                }
                case 5: {
                    uRL = CtcHttpRetriever.makeUrl((String)this.hostName, (String)"/revert/");
                    break;
                }
                default: {
                    throw new Exception("An unexpected request for the data reboot operation " + this.operation + " occurred.");
                }
            }
            this.retriever = new CtcHttpRetriever();
            this.error = this.retriever.transferContent(uRL, this.session + this.userName + ":" + this.password);
            this.errorMsg = DataComm.getErrorMsg(this.error, this.operationName, this.ccName, this.terms);
            this.isAuthorizationFailure = DataComm.isAuthorizationFailure(this.error);
            if (this.isAuthorizationFailure) {
                if (this.db.on()) {
                    this.db.println("An HTTP authentication failure was detected with node: " + this.nodeModel.getName());
                    this.db.println("This can happen due to the NE judging the securit y ticket to be no longer valid (e.g. node has deregistered CTC as a client but CTC has not detected this condition yet)");
                }
                this.nodeModel.setPermissionFailure();
            }
            if (this.db.on()) {
                this.db.println("Returning from DataReboot.run() with value " + this.error);
            }
        }
        catch (Exception exception) {
            this.db.println("Caught exception in DataReboot.run()");
            SDebug.printStackTrace((Throwable)exception);
            this.error = -1;
            this.errorMsg = exception.getMessage();
        }
        finally {
            this.dispose();
        }
    }

    public boolean aborted() {
        return this.retriever == null ? false : this.retriever.aborted();
    }

    public void abort() {
    }

    public boolean failed() {
        return this.error != 200;
    }

    public void dispose() {
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.isAuthorizationFailure ? DataComm.getAuthorizationFailureMessage(this.operationName) : this.errorMsg;
    }

    public boolean isAuthorizationFailure() {
        return this.isAuthorizationFailure;
    }
}

