/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataComm;
import cerent.cms.model.NodeModelDelegate;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.job.IJobProgressControl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.GZIPOutputStream;

public class DataReceive
implements Observer {
    private String hostName;
    private String userName;
    private String password;
    private String session;
    private String fileName;
    private IJobProgressControl observer;
    private CtcHttpRetriever retriever;
    private DownloadState state;
    private int error;
    private int operation;
    private String operationName;
    private String errorMsg;
    private boolean isAuthorizationFailure;
    private String dbTypes;
    private File tempFile;
    private File origFile;
    private String ccName;
    private NodeModelDelegate nodeModel;
    private TDMTerminology terms;
    private Throwable exc;
    private SDebug db;

    public DataReceive(NodeModelDelegate nodeModelDelegate, int n, String string, IJobProgressControl iJobProgressControl) {
        this.db = nodeModelDelegate.getChildDebug(DataReceive.class);
        this.fileName = string;
        this.observer = iJobProgressControl;
        this.operation = n;
        this.origFile = null;
        this.tempFile = null;
        this.hostName = nodeModelDelegate.getHostName();
        this.userName = nodeModelDelegate.getUserName();
        this.password = nodeModelDelegate.getUserPassword();
        this.terms = nodeModelDelegate.getTDMTerminology();
        this.session = DataComm.getSession(nodeModelDelegate);
        this.dbTypes = "";
        this.state = null;
        this.error = 200;
        this.errorMsg = null;
        if (n == 1) {
            this.operationName = "Backup Database";
            this.dbTypes = nodeModelDelegate.getDbTypes();
        } else {
            this.operationName = n == 9 ? "Retrieve OBFL Diagnostics" : "Retrieve Diagnostics";
        }
        this.ccName = nodeModelDelegate.getPlatform().getControlCardName();
        this.nodeModel = nodeModelDelegate;
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        OutputStream outputStream = null;
        try {
            this.checkFileExistence(this.fileName);
            URL uRL = null;
            switch (this.operation) {
                case 6: {
                    uRL = CtcHttpRetriever.makeUrl((String)this.hostName, (String)"/diagnostics/");
                    outputStream = new GZIPOutputStream(new FileOutputStream(this.fileName));
                    break;
                }
                case 9: {
                    uRL = CtcHttpRetriever.makeUrl((String)this.hostName, (String)"/nvdiags/");
                    outputStream = new FileOutputStream(this.fileName);
                    break;
                }
                case 1: {
                    uRL = CtcHttpRetriever.makeUrl((String)this.hostName, (String)"/database/");
                    outputStream = new FileOutputStream(this.fileName);
                    break;
                }
                default: {
                    throw new Exception("The request for the " + this.operation + " operation is invalid.");
                }
            }
            this.state = new DownloadState(this.operationName + " for " + this.hostName);
            this.state.addObserver((Observer)this);
            this.retriever = new CtcHttpRetriever();
            this.error = this.retriever.transferContent(uRL, this.session + this.dbTypes + this.userName + ":" + this.password, outputStream, this.state);
            this.errorMsg = DataComm.getErrorMsg(this.error, this.operationName, this.ccName, this.terms);
            this.isAuthorizationFailure = DataComm.isAuthorizationFailure(this.error);
            if (this.isAuthorizationFailure) {
                if (this.db.on()) {
                    this.db.println("An HTTP authentication failure was detected with node: " + this.nodeModel.getName());
                    this.db.println("This can happen due to the NE judging the security ticket to be no longer valid (e.g. node has deregistered CTC as a client but CTC has not detected this condition yet)");
                }
                this.nodeModel.setPermissionFailure();
            }
            if (this.aborted() || this.error != 200) {
                this.purgeFile(this.fileName);
            } else if (this.origFile != null && this.tempFile != null && this.tempFile.exists()) {
                this.origFile.delete();
                boolean bl = this.tempFile.renameTo(this.origFile);
                this.db.fine("renaming " + this.tempFile.getCanonicalPath() + " to " + this.origFile.getCanonicalPath() + " status=" + bl);
            }
            if (this.db.on()) {
                this.db.println("Returning from DataReceive.run() with value " + this.error);
            }
        }
        catch (Exception exception) {
            if (this.exc != null) {
                this.exc = exception;
            }
            this.db.println("Caught exception in DataReceive.run()");
            SDebug.printStackTrace((Throwable)exception);
            this.error = -1;
            this.errorMsg = exception.getMessage();
            this.purgeFile(this.fileName);
        }
        finally {
            this.dispose();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkFileExistence(String string) {
        block4: {
            try {
                this.origFile = new File(string);
                if (this.origFile.exists()) {
                    this.db.fine(this.origFile.getCanonicalPath() + " exists");
                    this.tempFile = new File(string + "9Z_7Y_5X");
                    this.tempFile.delete();
                    if (this.tempFile.createNewFile()) {
                        this.fileName = this.tempFile.getCanonicalPath();
                        this.db.fine("setting current file to " + this.fileName);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.tempFile = null;
    }

    private void purgeFile(String string) {
        block4: {
            try {
                boolean bl;
                this.db.fine("calling purgeFile");
                File file = new File(string);
                if (file.exists()) {
                    bl = file.delete();
                    this.db.fine("purging temporary file " + string + " status=" + bl);
                }
                if (this.origFile.exists()) {
                    bl = this.origFile.delete();
                    this.db.fine("purging original file " + this.origFile.getAbsolutePath() + " status=" + bl);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block4;
                this.db.println("Caught exception in DataReceive.purgeFile()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean aborted() {
        return this.retriever == null ? false : this.retriever.aborted();
    }

    public void abort() {
        if (this.retriever != null) {
            this.retriever.abort();
        }
    }

    public boolean failed() {
        return this.error != 200;
    }

    public void dispose() {
        if (this.state != null) {
            this.state.deleteObserver((Observer)this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.observer != null) {
            this.observer.setPercentCompleted(this.state.getPercent());
        }
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.isAuthorizationFailure ? DataComm.getAuthorizationFailureMessage(this.operationName) : this.errorMsg;
    }

    public Throwable getError() {
        return this.exc;
    }

    public boolean isAuthorizationFailure() {
        return this.isAuthorizationFailure;
    }
}

