/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Ds123Media.General;
import cerent.cms.idl.Ds123Media.eBertMode;
import cerent.cms.idl.Ds123Media.eDs1Mapping;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Ds123Media.eSendCode;
import cerent.cms.idl.Ds123Media.eTrafficPattern;
import cerent.cms.idl.Ds123Media.portBertConfig;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.idl.Ds123Media.sInfo;
import cerent.cms.idl.Ds123Media.xBusy;
import cerent.cms.idl.Ds123Media.xConfigError;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.If.xLoopbackActive;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xSyncProvBusy;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Synchronization.Sync;
import cerent.cms.idl.Synchronization.xInvalidQuality;
import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.CachedValue;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PersistableCachedValue;

public class Ds123LineInterfaceAttrs
extends AbstractPersistableModelState {
    private ReceivedFrameFormat receivedFrameFormat;
    private Loopback loopback;
    private InhibitedLoopback inhibitedLoopback;
    private InhibitedBackplaneLoopback inhibitedBackplaneLoopback;
    private SendCode sendCode;
    private Ds123Info ds123Info;
    private Config config;
    private SdBerLevel sdBerLevel;
    private SfBerLevel sfBerLevel;
    private SndAISVForDs1AISEnabled sndAISVForDs1AISEnabled;
    private RaiseDs1AISForLOFEnabled raiseDs1AISForLOFEnabled;
    private SyncConfig syncConfig;
    private Ds1RetimingEnabled ds1RetimingEnabled;
    private Ds1Mapping ds1Mapping;
    private E1SaBit e1SaBit;
    private BERTConfig bertConfig;

    public static int getCookie() {
        return 5;
    }

    public Ds123LineInterfaceAttrs(Ds123LineModel ds123LineModel) {
        INodeModel iNodeModel = ds123LineModel == null ? null : ds123LineModel.getNodeModel();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iNodeModel;
        this.receivedFrameFormat = new ReceivedFrameFormat(nodeModelDelegate, "Ds123LineModel.receivedFrameFormat");
        this.loopback = new Loopback(nodeModelDelegate, "Ds123LineModel.loopback");
        this.inhibitedLoopback = new InhibitedLoopback(nodeModelDelegate, "Ds123LineModel.inhibitedLoopback");
        this.inhibitedBackplaneLoopback = new InhibitedBackplaneLoopback(nodeModelDelegate, "Ds123LineModel.inhibitedBackplaneLoopback");
        this.sendCode = new SendCode(nodeModelDelegate, "Ds123LineModel.sendCode");
        this.ds123Info = new Ds123Info(nodeModelDelegate, "Ds123LineModel.ds123Info");
        this.config = new Config(nodeModelDelegate, "Ds123LineModel.config");
        this.sdBerLevel = new SdBerLevel(nodeModelDelegate, "Ds123LineModel.sdBerLevel");
        this.sfBerLevel = new SfBerLevel(nodeModelDelegate, "Ds123LineModel.sfBerLevel");
        this.raiseDs1AISForLOFEnabled = new RaiseDs1AISForLOFEnabled(nodeModelDelegate, "Ds123LineModel.RaiseDs1AISForLOFEnabled");
        this.sndAISVForDs1AISEnabled = new SndAISVForDs1AISEnabled(nodeModelDelegate, "Ds123LineModel.SndAISVForDs1AISEnabled");
        this.syncConfig = new SyncConfig(nodeModelDelegate, "Ds123LineModel.syncConfig");
        this.ds1RetimingEnabled = new Ds1RetimingEnabled(nodeModelDelegate, "Ds123LineModel.ds1RetimingEnabled");
        this.ds1Mapping = new Ds1Mapping(nodeModelDelegate, "Ds123LineModel.ds1Mapping");
        this.e1SaBit = new E1SaBit(nodeModelDelegate, "Ds123LineModel.e1SaBit");
        this.bertConfig = new BERTConfig(nodeModelDelegate, "Ds123LineModel.bertConfig");
    }

    public Ds123LineInterfaceAttrs() {
        this(null);
    }

    private Ds123LineModel getDs123LineModel() {
        return (Ds123LineModel)this.getModel();
    }

    General getDs123Ref() {
        Ds123LineModel ds123LineModel = this.getDs123LineModel();
        return ds123LineModel == null ? null : ds123LineModel.getDs123Ref();
    }

    Sync getSynchronizationRef() {
        Ds123LineModel ds123LineModel = this.getDs123LineModel();
        return ds123LineModel == null ? null : ds123LineModel.getSynchronizationRef();
    }

    ReceivedFrameFormat getReceivedFrameFormat() {
        return this.receivedFrameFormat;
    }

    CachedValue getLoopback() {
        return this.loopback;
    }

    InhibitedLoopback getInhibitedLoopback() {
        return this.inhibitedLoopback;
    }

    InhibitedBackplaneLoopback getInhibitedBackplaneLoopback() {
        return this.inhibitedBackplaneLoopback;
    }

    SendCode getSendCode() {
        return this.sendCode;
    }

    Ds123Info getDs123Info() {
        return this.ds123Info;
    }

    Config getConfig() {
        return this.config;
    }

    BERTConfig getBERT() {
        return this.bertConfig;
    }

    SdBerLevel getSdBerLevel() {
        return this.sdBerLevel;
    }

    SfBerLevel getSfBerLevel() {
        return this.sfBerLevel;
    }

    SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    SndAISVForDs1AISEnabled getSndAISVForDs1AISEnabled() {
        return this.sndAISVForDs1AISEnabled;
    }

    RaiseDs1AISForLOFEnabled getRaiseDs1AISForLOFEnabled() {
        return this.raiseDs1AISForLOFEnabled;
    }

    Ds1RetimingEnabled getDs1RetimingEnabled() {
        return this.ds1RetimingEnabled;
    }

    Ds1Mapping getDs1Mapping() {
        return this.ds1Mapping;
    }

    E1SaBit getE1SaBit() {
        return this.e1SaBit;
    }

    private class BERTConfig
    extends PersistableCachedValue {
        public BERTConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xProvisionError {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getBertConfig(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws cerent.cms.idl.If.xConfigError, xWrongInterfaceType, xUnsupportedOperation, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            eBertMode eBertMode2 = (eBertMode)objectArray[0];
            eTrafficPattern eTrafficPattern2 = (eTrafficPattern)objectArray[1];
            Ds123LineInterfaceAttrs.this.getDs123Ref().setBert(Ds123LineInterfaceAttrs.this.getIndex(), eBertMode2, eTrafficPattern2);
        }

        @Override
        protected Class getObjectClass() {
            return portBertConfig.class;
        }
    }

    private class Config
    extends PersistableCachedValue {
        public Config(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getConfig(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xConfigError, xUnsupportedOperation, xLoopbackActive {
            Ds123LineInterfaceAttrs.this.getDs123Ref().changeConfig(Ds123LineInterfaceAttrs.this.getIndex(), (sConfig)object);
        }

        @Override
        protected Object cloneValue() {
            sConfig sConfig2 = (sConfig)this.value;
            sConfig sConfig3 = new sConfig(sConfig2.clockSource, sConfig2.lineType, sConfig2.lineCoding, sConfig2.signalMode, sConfig2.lineLength, sConfig2.fdlModeMask);
            return sConfig3;
        }

        @Override
        protected Class getObjectClass() {
            return sConfig.class;
        }
    }

    private class Ds123Info
    extends PersistableCachedValue {
        public Ds123Info(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getInfo(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sInfo sInfo2 = (sInfo)this.value;
            sInfo sInfo3 = new sInfo(sInfo2.interfaceType, sInfo2.channelized, sInfo2.usableAsTimingSource);
            return sInfo3;
        }

        @Override
        protected Class getObjectClass() {
            return sInfo.class;
        }
    }

    private class Ds1Mapping
    extends PersistableCachedValue {
        public Ds1Mapping(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xUnsupportedOperation, xNoSuchInterface {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getDs1Mapping(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws cerent.cms.idl.If.xConfigError, xWrongInterfaceType, xUnsupportedOperation, xNoSuchInterface {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setDs1Mapping(Ds123LineInterfaceAttrs.this.getIndex(), (eDs1Mapping)object);
        }

        @Override
        protected Class getObjectClass() {
            return eDs1Mapping.class;
        }
    }

    private class Ds1RetimingEnabled
    extends PersistableCachedValue {
        public Ds1RetimingEnabled(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xUnsupportedOperation, xNoSuchInterface, xWrongInterfaceType {
            return new Boolean(Ds123LineInterfaceAttrs.this.getDs123Ref().getDs1RetimingEnabled(Ds123LineInterfaceAttrs.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xUnsupportedOperation, xNoSuchInterface, xWrongInterfaceType, xBusy, cerent.cms.idl.If.xConfigError {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setDs1RetimingEnabled(Ds123LineInterfaceAttrs.this.getIndex(), (Boolean)object);
        }

        @Override
        protected Class getObjectClass() {
            return Boolean.class;
        }
    }

    private class E1SaBit
    extends PersistableCachedValue {
        public E1SaBit(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xUnsupportedOperation, xNoSuchInterface {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getE1SaBit(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws cerent.cms.idl.If.xConfigError, xWrongInterfaceType, xUnsupportedOperation, xNoSuchInterface {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setE1SaBit(Ds123LineInterfaceAttrs.this.getIndex(), (eSaBit)object);
        }

        @Override
        protected Class getObjectClass() {
            return eSaBit.class;
        }
    }

    private class InhibitedBackplaneLoopback
    extends PersistableCachedValue {
        public InhibitedBackplaneLoopback(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return new Boolean(Ds123LineInterfaceAttrs.this.getDs123Ref().getInhibitBpLpbk(Ds123LineInterfaceAttrs.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xUnsupportedOperation, xProvisionError {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setInhibitBpLpbk(Ds123LineInterfaceAttrs.this.getIndex(), (Boolean)object);
        }

        @Override
        protected Class getObjectClass() {
            return Boolean.class;
        }
    }

    private class InhibitedLoopback
    extends PersistableCachedValue {
        public InhibitedLoopback(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return new Boolean(Ds123LineInterfaceAttrs.this.getDs123Ref().getInhibitLpbk(Ds123LineInterfaceAttrs.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xUnsupportedOperation, xProvisionError {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setInhibitLpbk(Ds123LineInterfaceAttrs.this.getIndex(), (Boolean)object);
        }

        @Override
        protected Class getObjectClass() {
            return Boolean.class;
        }
    }

    private class Loopback
    extends PersistableCachedValue {
        public Loopback(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getLoopback(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xInvalidState, xUnsupportedOperation, xBusy {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setLoopback(Ds123LineInterfaceAttrs.this.getIndex(), (eLoopback)object);
        }

        @Override
        protected Class getObjectClass() {
            return eLoopback.class;
        }
    }

    private class RaiseDs1AISForLOFEnabled
    extends PersistableCachedValue {
        public RaiseDs1AISForLOFEnabled(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xUnsupportedOperation, xNoSuchInterface, xWrongInterfaceType {
            return new Boolean(Ds123LineInterfaceAttrs.this.getDs123Ref().getDs1AisOnLofEnabled(Ds123LineInterfaceAttrs.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xUnsupportedOperation, xNoSuchInterface, xWrongInterfaceType {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setDs1AisOnLofEnabled(Ds123LineInterfaceAttrs.this.getIndex(), (Boolean)object);
        }

        @Override
        protected Class getObjectClass() {
            return Boolean.TYPE;
        }
    }

    private class ReceivedFrameFormat
    extends PersistableCachedValue {
        public ReceivedFrameFormat(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getReceivedFrameFormat(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected Class getObjectClass() {
            return eLineType.class;
        }
    }

    private class SdBerLevel
    extends PersistableCachedValue {
        public SdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return new Short(Ds123LineInterfaceAttrs.this.getDs123Ref().getDeclareSdBerLevel(Ds123LineInterfaceAttrs.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setDeclareSdBerLevel(Ds123LineInterfaceAttrs.this.getIndex(), (Short)object);
        }

        @Override
        protected Class getObjectClass() {
            return Short.class;
        }
    }

    private class SendCode
    extends PersistableCachedValue {
        public SendCode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return Ds123LineInterfaceAttrs.this.getDs123Ref().getSendCode(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xInvalidState, xBusy, xProvisionError {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setSendCode(Ds123LineInterfaceAttrs.this.getIndex(), (eSendCode)object);
        }

        @Override
        protected Class getObjectClass() {
            return eSendCode.class;
        }
    }

    private class SfBerLevel
    extends PersistableCachedValue {
        public SfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return new Short(Ds123LineInterfaceAttrs.this.getDs123Ref().getDeclareSfBerLevel(Ds123LineInterfaceAttrs.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setDeclareSfBerLevel(Ds123LineInterfaceAttrs.this.getIndex(), (Short)object);
        }

        @Override
        protected Class getObjectClass() {
            return Short.class;
        }
    }

    private class SndAISVForDs1AISEnabled
    extends PersistableCachedValue {
        public SndAISVForDs1AISEnabled(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xUnsupportedOperation, xNoSuchInterface, xWrongInterfaceType {
            return new Boolean(Ds123LineInterfaceAttrs.this.getDs123Ref().getDs1AisvEnabled(Ds123LineInterfaceAttrs.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xUnsupportedOperation, xNoSuchInterface, xWrongInterfaceType {
            Ds123LineInterfaceAttrs.this.getDs123Ref().setDs1AisvEnabled(Ds123LineInterfaceAttrs.this.getIndex(), (Boolean)object);
        }

        @Override
        protected Class getObjectClass() {
            return Boolean.TYPE;
        }
    }

    private class SyncConfig
    extends PersistableCachedValue {
        public SyncConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xUnsupportedOperation {
            return Ds123LineInterfaceAttrs.this.getSynchronizationRef().getSonetConfig(Ds123LineInterfaceAttrs.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xUnsupportedOperation, xProvisionError, xSyncProvBusy, xInvalidQuality {
            Ds123LineInterfaceAttrs.this.getSynchronizationRef().setSonetConfig(Ds123LineInterfaceAttrs.this.getIndex(), (sLineSyncConfig)object);
        }

        @Override
        protected Object cloneValue() {
            sLineSyncConfig sLineSyncConfig2 = (sLineSyncConfig)this.value;
            return new sLineSyncConfig(sLineSyncConfig2.providesSyncFromCard, sLineSyncConfig2.syncMessageIn, sLineSyncConfig2.sendDoNotUse, sLineSyncConfig2.adminSSM, sLineSyncConfig2.sendDoNotUseFF);
        }

        @Override
        protected Class getObjectClass() {
            return sLineSyncConfig.class;
        }
    }
}

