/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eCardTransportMode;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.ePortToVtMappingMode;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xUnsupportedTransportMode;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitType;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.IDs1Retiming;
import cerent.cms.model.IDs1Timing;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedCardTransportMode;
import cerent.cms.model.UnsupportedOperation;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class Ds1ModuleModel
extends Ds123ModuleModel
implements IDs1Timing,
IDs1Retiming {
    private CardTransportMode cardTransportMode = new CardTransportMode("Ds1ModuleModel.cardTransportMode");
    private PortToVtMappingMode portToVtMappingMode;
    private CardRetimingEnabled cardRetimingEnabled = new CardRetimingEnabled("Ds1ModuleModel.cardRetimingEnabled");

    public Ds1ModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
        this.portToVtMappingMode = new PortToVtMappingMode("Ds1ModuleModel.portToVtMappingMode");
    }

    @Override
    public List getConnectionsList() {
        ProtectionGroupModel protectionGroupModel = this.getProtectionGroupModel();
        if (protectionGroupModel != null && this.isProtectModule()) {
            Ds123ModuleModel ds123ModuleModel = (Ds123ModuleModel)protectionGroupModel.getProtectedModuleModel();
            if (ds123ModuleModel != null) {
                return ds123ModuleModel.getConnectionsList();
            }
            return new LinkedList();
        }
        PoolModel poolModel = null;
        poolModel = (PoolModel)this.node.getPoolModels().getPoolModel(this.getEntityIndex());
        if (poolModel != null) {
            return poolModel.getConnectionsList();
        }
        return new LinkedList();
    }

    @Override
    public int getMaxVt() {
        throw new DeprecatedMethodCalled("FTG deprecated: EntityModel.getMaxVt()");
    }

    @Override
    public ILoNum getMaxLo(int n) {
        ILoNum iLoNum = null;
        int n2 = this.getEqType();
        switch (n2) {
            case 4: 
            case 5: 
            case 64: 
            case 83: 
            case 108: {
                int n3 = this.calcFramingTypeForLo();
                int n4 = this.getChildren().size();
                if (n4 == 0) break;
                ILoNum iLoNum2 = HoLoFactory.createFirstLoNum(n3, n);
                iLoNum = HoLoFactory.addGroupOffset(iLoNum2, n4 - 1);
                break;
            }
            default: {
                iLoNum = super.getMaxLo(n);
            }
        }
        return iLoNum;
    }

    @Override
    protected IPortModel getPortModelForHoPath(IEntityModel iEntityModel, IHoNum iHoNum) {
        IPortModel iPortModel = null;
        if (this.getEqTypeEnum() == eEqType.DS1_E1_56_LINE_CARD && this.getCardTransportMode() == eCardTransportMode.TRANSPORT_MODE_SONET) {
            int n = (iHoNum.getIdlHoNum() - 1) * 28 + 1;
            iPortModel = this.getPortByNumberAndType(eEqType.DS1_VT_MAPPED, new int[]{n});
        } else {
            iPortModel = this.getPortByNumberAndType(null, new int[]{iHoNum.getIdlHoNum()});
        }
        return iPortModel;
    }

    @Override
    protected IPortModel getPortModelForLoPath(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        IPortModel iPortModel = null;
        if (this.getEqTypeEnum() == eEqType.DS1_E1_56_LINE_CARD && this.getPortToVtMappingMode() == ePortToVtMappingMode.PORT_VT_MAPPING_INDUSTRY) {
            int n = (iLoNum.getIdlGroupNum() - 1) * 4 + iLoNum.getIdlNumInGroup() + (iHoNum.getHoNum() - 1) * 28;
            iPortModel = this.getPortByNumberAndType(eEqType.DS1_VT_MAPPED, new int[]{n});
        } else {
            PortModel[] portModelArray = this.getPortModels();
            int n = iLoNum.getLoPathWidth();
            IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(null, null);
            for (int i = 0; i < portModelArray.length; ++i) {
                IHoNum iHoNum2;
                ILoNum iLoNum2;
                PortModel portModel = portModelArray[i];
                int[] nArray = portModel.getPortNum();
                if (nArray == null || nArray.length != 1 || (iLoNum2 = this.getLoNumForPort(nArray[0], n, iHoLoNum)) == null || !iLoNum2.equals(iLoNum) || (iHoNum2 = this.getHoNumForPort(nArray[0], n, iHoLoNum)) == null || !iHoNum2.equals(iHoNum)) continue;
                iPortModel = portModel;
                break;
            }
        }
        return iPortModel;
    }

    @Override
    public List getPortsInGroup(IPortModel iPortModel, int n, int n2) {
        boolean bl = CircuitType.getCircuitType((int)n).isLoCircuitType();
        if (bl) {
            return super.getPortsInGroup(iPortModel, n, n2);
        }
        if (this.getEqTypeEnum() == eEqType.DS1_E1_56_LINE_CARD && this.getCardTransportMode() == eCardTransportMode.TRANSPORT_MODE_SONET) {
            int n3;
            LinkedList<IPortModel> linkedList = new LinkedList<IPortModel>();
            List list = this.getDescendantsOfClassType(7);
            int n4 = iPortModel.getPortNum()[0];
            for (int i = n3 = n4 / 28 * 28 + 1; i < n3 + 28; ++i) {
                IPortModel iPortModel2 = (IPortModel)list.get(i - 1);
                if (iPortModel2 == null) continue;
                linkedList.add(iPortModel2);
            }
            return linkedList;
        }
        return this.getChildren();
    }

    @Override
    public String toString() {
        return "Ds1" + super.toString();
    }

    @Override
    public eCardTransportMode getCardTransportMode() {
        try {
            return (eCardTransportMode)this.cardTransportMode.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getCardTransportMode ", userException);
        }
    }

    public void setCardTransportMode(eCardTransportMode eCardTransportMode2) throws ProvisionError, UnsupportedCardTransportMode, UnsupportedOperation {
        try {
            this.cardTransportMode.set(eCardTransportMode2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xUnsupportedTransportMode xUnsupportedTransportMode2) {
            throw new UnsupportedCardTransportMode((UserException)xUnsupportedTransportMode2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setCardTransportMode", userException);
        }
    }

    @Override
    public boolean isIndustryMapped(IHoNum iHoNum) {
        return this.getEqType() == 218 && this.getPortToVtMappingMode() == ePortToVtMappingMode.PORT_VT_MAPPING_INDUSTRY;
    }

    @Override
    public ePortToVtMappingMode getPortToVtMappingMode() {
        try {
            return (ePortToVtMappingMode)this.portToVtMappingMode.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getPortToVtMappingMode() ", userException);
        }
    }

    public void setPortToVtMappingMode(ePortToVtMappingMode ePortToVtMappingMode2) throws ProvisionError, NoSuchEquipment, UnsupportedOperation {
        try {
            this.portToVtMappingMode.set(ePortToVtMappingMode2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setCardTransportMode", userException);
        }
    }

    public boolean getCardRetimingEnabled() {
        try {
            return (Boolean)this.cardRetimingEnabled.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("isUnprovisionOnExtract", userException);
        }
    }

    public void setCardRetimingEnabled(boolean bl) throws UnsupportedOperation, ProvisionError {
        try {
            Boolean bl2 = new Boolean(bl);
            this.cardRetimingEnabled.set(bl2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPortGroupState", userException);
        }
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(): entry");
        }
        this.cardRetimingEnabled.update();
        this.portToVtMappingMode.update();
        this.cardTransportMode.update();
        this.setChanged();
        super.updateLocal();
        if (this.db.on()) {
            this.db.println("updateLocal(): exit");
        }
    }

    @Override
    public void dispose() {
        this.cardRetimingEnabled.dispose();
        this.portToVtMappingMode.dispose();
        this.cardTransportMode.dispose();
        super.dispose();
    }

    @Override
    public boolean mustTheBoardAlwaysSendAISVOnDefects() {
        return this.getEqType() != 218 && this.getEqType() != 4 && this.getEqType() != 5;
    }

    @Override
    public boolean displaySendAISVForDs1AISColumn() {
        int n = this.getNodeModel().getTdmProtocolType();
        return n == 0;
    }

    @Override
    public boolean displayRaiseDs1AISForLOFColumn() {
        return this.getEqType() == 218;
    }

    @Override
    public boolean supportsDs1Timing() {
        return this.getEqType() == 218;
    }

    @Override
    public boolean supportsDs1Retiming() {
        return this.getEqType() == 218;
    }

    private class CardRetimingEnabled
    extends CachedValue {
        public CardRetimingEnabled(String string) {
            super(Ds1ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            Ds1ModuleModel.this.getCardModuleRef().setCardRetimingEnabled(Ds1ModuleModel.this.entityIndex, (Boolean)object);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            return new Boolean(Ds1ModuleModel.this.getCardModuleRef().getCardRetimingEnabled(Ds1ModuleModel.this.entityIndex));
        }

        public Object outer() {
            return Ds1ModuleModel.this;
        }
    }

    private class CardTransportMode
    extends CachedValue {
        public CardTransportMode(String string) {
            super(Ds1ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment, xUnsupportedTransportMode {
            Ds1ModuleModel.this.getCardModuleRef().setCardTransportMode(Ds1ModuleModel.this.entityIndex, (eCardTransportMode)object);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return Ds1ModuleModel.this.getCardModuleRef().getCardTransportMode(Ds1ModuleModel.this.entityIndex);
        }

        public Object outer() {
            return Ds1ModuleModel.this;
        }
    }

    private class PortToVtMappingMode
    extends CachedValue {
        public PortToVtMappingMode(String string) {
            super(Ds1ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            Ds1ModuleModel.this.getCardModuleRef().setPortToVtMappingMode(Ds1ModuleModel.this.entityIndex, (ePortToVtMappingMode)object);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return Ds1ModuleModel.this.getCardModuleRef().getPortToVtMappingMode(Ds1ModuleModel.this.entityIndex);
        }

        public Object outer() {
            return Ds1ModuleModel.this;
        }
    }
}

