/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.eNodeOpticalType;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class DwdmNodeTypeModel
extends Model
implements Observer {
    private NodeModelDelegate nmd;
    private NodeOpticalType nodeOpticalType;
    private EventDispatcher dispatcher;
    private static NodeSingletonFactory<DwdmNodeTypeModel> sfactory = new NodeSingletonFactory<DwdmNodeTypeModel>(DwdmNodeTypeModel.class);

    private DwdmNodeTypeModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(DwdmNodeTypeModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.nodeOpticalType = new NodeOpticalType("NodeOpticalType");
    }

    public static DwdmNodeTypeModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    @Override
    protected void updateLocal() {
        this.nodeOpticalType.update();
        super.updateLocal();
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("Got update from " + observable + " arg=" + object);
        }
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings(eUpdateType.class)[n]);
            }
            switch (n) {
                case 2: {
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    this.updateLocal();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    public eNodeOpticalType getNodeOpticalType() {
        try {
            return (eNodeOpticalType)this.nodeOpticalType.get();
        }
        catch (UserException userException) {
            return eNodeOpticalType.NODE_TYPE_UNKNOWN;
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalSetup, 6, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalSetup, 6, (Observer)this);
        }
        this.nodeOpticalType.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    private DwdmOpticalSetup getDwdmOpticalSetupRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    class NodeOpticalType
    extends CachedValue {
        public NodeOpticalType(String string) {
            super(DwdmNodeTypeModel.this.nmd, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return DwdmNodeTypeModel.this.getDwdmOpticalSetupRef().getNodeOpticalType();
        }
    }
}

