/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.SonetTopology.Element;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.sElementData;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PoolModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.UserException;

public abstract class ElementModel
extends Model
implements Comparable,
IElementModel {
    private Name name;
    private Type type;
    protected NodeModelDelegate node;
    private Element elementRef;
    private String bufferedName;
    private EventDispatcher dispatcher;

    public ElementModel(NodeModelDelegate nodeModelDelegate, int n, Element element, SDebug sDebug) {
        super(sDebug);
        this.node = nodeModelDelegate;
        this.index = n;
        if (element == null) {
            element = nodeModelDelegate.getElementModelsDelegate().getElementRef(n);
        }
        this.elementRef = element;
        this.name = new Name(nodeModelDelegate, "ElementModel.name");
        this.type = new Type(nodeModelDelegate, "ElementModel.type");
        this.dispatcher = null;
    }

    public ElementModel(NodeModelDelegate nodeModelDelegate, int n, SDebug sDebug) throws AbstractCmsIOException {
        this(nodeModelDelegate, n, null, sDebug);
    }

    public void init() {
        if (this.db.on()) {
            this.db.println("init(): entry");
        }
        super.init0();
        this.name.init();
        this.type.init();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectTopologyElement, this.getIndex(), (Observer)this);
        }
        this.observeModules();
        if (this.db.on()) {
            this.db.println("init(): exit");
        }
    }

    protected void observeModules() {
    }

    protected void unobserveModules() {
    }

    public void setAttributes(sElementData sElementData2) {
        this.name.setValueExternally(sElementData2.name);
        this.type.setValueExternally(sElementData2.type);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose(): entry");
        }
        this.unobserveModules();
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectTopologyElement, this.getIndex(), (Observer)this);
        }
        this.name.dispose();
        this.type.dispose();
        super.dispose();
        if (this.db.on()) {
            this.db.println("dispose(): exit");
        }
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ElementModel)) {
            return false;
        }
        ElementModel elementModel = (ElementModel)object;
        return elementModel.getIndex() == this.index && elementModel.getNodeModel().getNodeId() == this.getNodeModel().getNodeId();
    }

    protected Element getElementRef() {
        return this.elementRef;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    public String getName() {
        try {
            this.bufferedName = (String)this.name.get();
            return this.bufferedName;
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            return this.bufferedName;
        }
        catch (NullPointerException nullPointerException) {
            return this.bufferedName;
        }
        catch (UserException userException) {
            return this.bufferedName;
        }
    }

    public void setName(String string) {
        try {
            this.name.set(string);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getType() {
        return this.getTypeEnum().value();
    }

    public eElementType getTypeEnum() {
        try {
            return (eElementType)this.type.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public int compareTo(Object object) {
        int n = this.getIndex();
        int n2 = ((ElementModel)object).getIndex();
        return ComparisonUtil.compare((int)n, (int)n2);
    }

    protected void setIndex(int n) {
        this.index = n;
    }

    abstract boolean referencesEntityIndex(int var1);

    abstract int[] getIndices();

    protected abstract IPoolModel getPoolModel(int var1);

    protected abstract boolean containsPool(PoolModel var1);

    public IEntityModel getEntityModel() throws AbstractCmsNoSuchEntityException {
        return this.node.getEntityTableModel().getEntityModelByIndex(this.getIndex());
    }

    public int getEntityEqType() throws AbstractCmsNoSuchEntityException {
        return this.getEntityModel().getEqType();
    }

    public abstract int getMainEntityIndex() throws AbstractCmsIOException;

    public IEntityModel getMainEntityModel() throws AbstractCmsIOException, AbstractCmsNoSuchEntityException {
        return this.node.getEntityTableModel().getEntityModelByIndex(this.getMainEntityIndex());
    }

    public abstract int getProtectEntityIndex() throws AbstractCmsIOException;

    public IEntityModel getProtectEntityModel() throws AbstractCmsIOException, AbstractCmsNoSuchEntityException {
        return this.node.getEntityTableModel().getEntityModelByIndex(this.getProtectEntityIndex());
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(): entry");
        }
        int n = this.getType();
        this.name.update();
        this.type.update();
        if (this.getType() != n) {
            this.node.getElementModelsDelegate().reregister(this);
        }
        this.setChanged();
        if (this.db.on()) {
            this.db.println("updateLocal(): CHANGED");
        }
        super.updateLocal();
        if (this.db.on()) {
            this.db.println("updateLocal(): exit");
        }
    }

    protected void updateStructure() {
        if (this.db.on()) {
            this.db.println("updateStructure(): entry [null]");
        }
        if (this.db.on()) {
            this.db.println("updateStructure(): exit [null]");
        }
    }

    private void watchParent(EntityModel entityModel) {
        Model model = (Model)entityModel.getParent();
        if (model == null) {
            model = ChassisModels.getInstance((NodeModelDelegate)entityModel.getNodeModel());
        }
        if (this.db.on()) {
            this.db.println("unwatch " + entityModel);
        }
        entityModel.deleteObserver(this);
        if (this.db.on()) {
            this.db.println("watch " + model);
        }
        model.addObserver(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void update(Observable observable, Object object) {
        String string = "";
        if (this.db.on()) {
            this.db.println("update(): entry");
        }
        if (observable instanceof CmsObservable) {
            Object object2;
            int n;
            Class<eUpdateType> clazz = eUpdateType.class;
            if (object instanceof IObjectMessageInfo) {
                n = ((IObjectMessageInfo)object).getUpdateType();
            } else if (object instanceof Integer) {
                n = (Integer)object;
                clazz = ModelUpdateType.class;
            } else {
                if (this.db.on()) {
                    this.db.println("unexpected arg class: " + object.getClass().getName());
                }
                n = -1;
            }
            string = this.toString();
            if (this.db.on()) {
                object2 = EnumStrings.getStrings(clazz);
                String string2 = object2 == null || ((String[])object2).length <= n ? Integer.toString(n) : object2[n];
                this.db.println("update(): this=" + string + " Observable=" + observable + " arg=" + string2);
            }
            switch (n) {
                case 0: {
                    if (observable instanceof ChassisModels) {
                        ((ChassisModels)((Object)observable)).deleteObserver(this);
                        if (this.db.on()) {
                            this.db.println("ChassisModels deleted, no parent");
                        }
                        return;
                    }
                    if (observable instanceof EntityModel) {
                        this.watchParent((EntityModel)((Object)observable));
                        return;
                    }
                    if (observable instanceof PoolModel) {
                        this.unobserveModules();
                        return;
                    }
                    if (this.node != null) {
                        if (this.db.on()) {
                            this.db.println("update(): DELETED [" + string + "]");
                        }
                        if ((object2 = this.node.getElementModelsDelegate()) != null) {
                            ((ElementModelsDelegate)object2).remove(this);
                            break;
                        }
                        this.dispose();
                        break;
                    }
                    this.dispose();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("update(): CHANGED [" + string + "]");
                    }
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (observable instanceof EntityModel || observable instanceof ChassisModels) {
                        if (this.db.on()) {
                            this.db.println("watch modules");
                        }
                        ((Model)((Object)observable)).deleteObserver(this);
                        this.observeModules();
                        if (this.db.on()) {
                            this.db.println("notify CHANGED");
                        }
                        this.setChanged();
                        this.notifyObservers(ModelUpdateType.CHANGED);
                        return;
                    }
                    if (!this.db.on()) break;
                    this.db.println("update(): ADDED");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println("update(): UNKNOWN NE UPDATE TYPE=" + n);
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
        if (this.db.on()) {
            this.db.println("update(): exit");
        }
    }

    public abstract String toString();

    class Name
    extends CachedValue {
        public Name(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            ElementModel.this.elementRef.name((String)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return ElementModel.this.elementRef.name();
        }

        public Object outer() {
            return ElementModel.this;
        }
    }

    class Type
    extends CachedValue {
        public Type(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return ElementModel.this.elementRef.type();
        }

        public Object outer() {
            return ElementModel.this;
        }
    }
}

