/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Epos.MSTBridge;
import cerent.cms.idl.Epos.eCardMode;
import cerent.cms.idl.Epos.sEtherCardAdminInfo;
import cerent.cms.idl.Epos.sLearnedAddress;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.UserException;

public class EtherModuleModel
extends ModuleModel {
    private EtherCardAdminInfo etherCardAdminInfo;
    private LearnedAddrList learnedAddrList;
    private ClearLearnedAddr clearLearnedAddr;
    private DeleteLearnedAddrList deleteLearnedAddrList;

    public EtherModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(EtherModuleModel.class));
        this.etherCardAdminInfo = new EtherCardAdminInfo(nodeModelDelegate, "EtherModuleModel::EtherCardAdminInfo");
        this.learnedAddrList = new LearnedAddrList(nodeModelDelegate, "EtherModuleModel::getLearnedAddressList");
        this.clearLearnedAddr = new ClearLearnedAddr(nodeModelDelegate, "EtherModuleModel::clearLearnedAddress");
        this.deleteLearnedAddrList = new DeleteLearnedAddrList(nodeModelDelegate, "EtherModuleModel::deleteLearnedAddrList");
    }

    protected void updateEther() {
        this.etherCardAdminInfo.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    @Override
    public void init() {
        this.dispatcher = this.getNodeModelDelegate().getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectEtherBridge, this.getEntityIndex(), (Observer)this);
        }
        super.init();
    }

    @Override
    protected void addedReceived(CmsObservable cmsObservable, ObjectMessageInfo objectMessageInfo) {
    }

    @Override
    protected void changedReceived(CmsObservable cmsObservable, ObjectMessageInfo objectMessageInfo) {
        int n = objectMessageInfo.getObjectType();
        if (n == ObjectType.ObjectEtherBridge.value()) {
            this.updateEther();
        } else {
            super.changedReceived(cmsObservable, objectMessageInfo);
        }
    }

    public eCardMode getEtherCardMode() throws xNoSuchEquipment {
        try {
            return ((sEtherCardAdminInfo)this.etherCardAdminInfo.get()).cardMode;
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw xNoSuchEquipment2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getEtherCardMode", userException);
        }
    }

    public void setEtherCardMode(eCardMode eCardMode2) throws xNoSuchEquipment, xInUse {
        try {
            this.etherCardAdminInfo.set(new sEtherCardAdminInfo(eCardMode2));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw xNoSuchEquipment2;
        }
        catch (xInUse xInUse2) {
            throw xInUse2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setEtherCardMode", userException);
        }
    }

    public sLearnedAddress[] getLearnedAddressList() throws xNoSuchEquipment {
        try {
            return (sLearnedAddress[])this.learnedAddrList.get(new Integer(this.entityIndex));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw xNoSuchEquipment2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getLearnedAddressList", userException);
        }
    }

    public void clearLearnedAddress() throws xNoSuchEquipment {
        try {
            this.clearLearnedAddr.set(new Integer(this.entityIndex));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw xNoSuchEquipment2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "clearLearnedAddress", userException);
        }
    }

    public void deleteLearnedAddressList(sLearnedAddress[] sLearnedAddressArray, boolean bl, boolean bl2, boolean bl3) throws xNoSuchEquipment {
        Object[] objectArray = new Object[]{bl3 ? new Integer(sLearnedAddressArray[0].ifIndex / 4096 * 4096) : new Integer(this.entityIndex), sLearnedAddressArray, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)};
        try {
            this.deleteLearnedAddrList.set(objectArray);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw xNoSuchEquipment2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "deleteLearnedAddressList", userException);
        }
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectEtherBridge, this.getEntityIndex(), (Observer)this);
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        InterfaceModel[] interfaceModelArray = new EtherLineModel[portModelArray.length];
        for (int i = 0; i < portModelArray.length; ++i) {
            interfaceModelArray[i] = (EtherLineModel)portModelArray[i].getInterfaceModel();
        }
        return interfaceModelArray;
    }

    @Override
    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 != null ? (EtherPortModel[])this.getChildrenOfType(eEqType2).toArray(new PortModel[0]) : this.getDescendantsOfClassType(7).toArray(new EtherPortModel[0]);
        return portModelArray == null ? new EtherPortModel[]{} : portModelArray;
    }

    @Override
    public List getConnectionsList() {
        List list;
        block8: {
            list = new ArrayList();
            try {
                eCardMode eCardMode2 = this.getEtherCardMode();
                if (eCardMode2 == eCardMode.MULTI_CARD_SWITCH) {
                    list = ((ConnectionModelsDelegate)this.getNodeModelDelegate().getConnectionModels()).getEtherStitchedConnections();
                } else if (eCardMode2 == eCardMode.LINEAR_NO_SWITCH) {
                    EtherPortModel[] etherPortModelArray = (EtherPortModel[])this.getPortModels();
                    for (int i = 0; i < etherPortModelArray.length; ++i) {
                        list.addAll(etherPortModelArray[i].getConnectionsList());
                    }
                } else {
                    PoolModel poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(this.getEntityIndex());
                    if (poolModel != null) {
                        list = poolModel.getConnectionsList();
                    }
                }
            }
            catch (xNoSuchEquipment xNoSuchEquipment2) {
                this.db.println("Error in getConnectionsList!");
                if (!this.db.on) break block8;
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
        }
        return list;
    }

    @Override
    public String toString() {
        return "Ether" + super.toString();
    }

    @Override
    public boolean supportsClearPM() {
        return false;
    }

    private MSTBridge getEtherBridgeRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherBridgeRef();
    }

    class ClearLearnedAddr
    extends NonCachedValue {
        public ClearLearnedAddr(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            EtherModuleModel.this.getEtherBridgeRef().clearAllLearnedAddresses((Integer)object);
        }

        public Object outer() {
            return EtherModuleModel.this;
        }
    }

    class DeleteLearnedAddrList
    extends NonCachedValue {
        public DeleteLearnedAddrList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            EtherModuleModel.this.getEtherBridgeRef().deleteLearnedAddressList((Integer)objectArray[0], (sLearnedAddress[])objectArray[1], (Boolean)objectArray[2], (Boolean)objectArray[3], (Boolean)objectArray[4]);
        }

        public Object outer() {
            return EtherModuleModel.this;
        }
    }

    class EtherCardAdminInfo
    extends CachedValue {
        public EtherCardAdminInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            sEtherCardAdminInfo sEtherCardAdminInfo2 = null;
            try {
                sEtherCardAdminInfo2 = EtherModuleModel.this.getEtherBridgeRef().getEtherCardAdminInfo(EtherModuleModel.this.getEntityIndex());
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                EtherModuleModel.this.db.println("This node does not support retrieval of Ethernet Card Admin Info\n  (older software version)");
                SDebug.printStackTrace((Throwable)bAD_OPERATION);
            }
            return sEtherCardAdminInfo2;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            try {
                EtherModuleModel.this.getEtherBridgeRef().setEtherCardAdminInfo(EtherModuleModel.this.getEntityIndex(), (sEtherCardAdminInfo)object);
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                EtherModuleModel.this.db.println("This node does not support setting of Ethernet Card Admin Info\n  (older software version)");
                SDebug.printStackTrace((Throwable)bAD_OPERATION);
            }
        }

        public Object outer() {
            return EtherModuleModel.this;
        }
    }

    class LearnedAddrList
    extends NonCachedValue {
        public LearnedAddrList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            sLearnedAddress[] sLearnedAddressArray = EtherModuleModel.this.getEtherBridgeRef().getLearnedAddressList((Integer)object);
            return sLearnedAddressArray;
        }

        public Object outer() {
            return EtherModuleModel.this;
        }
    }
}

