/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo_4_01;
import cerent.cms.idl.EtherMedia.sIngressQOSInfo;
import cerent.cms.idl.EtherMedia.sL1AdminInfo;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.EtherMedia.sML2PosPortAdminInfo;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.HoPathTraceModel;
import cerent.cms.model.IHdGeLineModel;
import cerent.cms.model.IPathTraceModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PoolModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EMC;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class HdGeLineModel
extends EtherLineModel
implements IHdGeLineModel {
    private StatsLastCleared statsLastCleared;
    private HoPathTraceModel hoPathTraceModel = null;
    private AdmPosAdminInfo admPosAdminInfo = null;
    private EtherL1Info etherL1Info;
    private EtherL1AdminInfo etherL1AdminInfo;

    public HdGeLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate, n);
        this.index = n;
        this.statsLastCleared = new StatsLastCleared(nodeModelDelegate, "HdGeLineModel.statsLastCleared");
        this.etherL1Info = new EtherL1Info(nodeModelDelegate, "EtherL1Info.etherL1Info");
        this.etherL1AdminInfo = new EtherL1AdminInfo(nodeModelDelegate, "HdGeLineModel.etherL1AdminInfo");
        this.admPosAdminInfo = new AdmPosAdminInfo(nodeModelDelegate, "HdGeLineModel.admPosAdminInfo");
    }

    @Override
    public List getConnectionsList() {
        PoolModel poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(this.getIndex());
        if (poolModel != null) {
            return poolModel.getConnectionsList();
        }
        return new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLoopbackAsInt() {
        int n = 0;
        Throwable throwable = null;
        try {
            n = this.getGmacLineAdminInfo_4_01().loopback.value();
        }
        catch (NoSuchInterface noSuchInterface) {
            throwable = noSuchInterface;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            throwable = wrongInterfaceType;
        }
        finally {
            if (throwable != null && this.db.on()) {
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
        return n;
    }

    @Override
    protected void updateLocal(long l) {
        this.etherL1Info.update();
        this.etherL1AdminInfo.update();
        this.admPosAdminInfo.update();
        this.setChanged();
        super.updateLocal(l);
    }

    @Override
    public void dispose() {
        if (this.hoPathTraceModel != null) {
            this.hoPathTraceModel.dispose();
        }
        this.etherL1Info.dispose();
        this.etherL1AdminInfo.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.hoPathTraceModel != null) {
            this.hoPathTraceModel.destroy();
        }
        super.destroy();
    }

    public int getLineLastClearedStats() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (Integer)this.statsLastCleared.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface("Attempted to access non-existant interface [ HdGeLineModel.clearStats( " + this.getIndex() + ", ...) ]");
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType("Attempted an operation that cannot be performed for this interface type [ HdGeLineModel.clearStats( " + this.getIndex() + ", ...) ]");
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new UnsupportedOperation("Attempted an operation that cannot be performed for this interface type [ HdGeLineModel.clearStats( " + this.getIndex() + ", ...) ]");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public int getPathTraceMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getPathTraceMode() not supported");
    }

    public void setPathTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("setPathTraceMode() not supported");
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        throw new FeatureNotSupported("getCurrentPayloadLabel() not supported");
    }

    public String getSendPathTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getSendPathTrace() not supported");
    }

    public void setSendPathTrace(String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("setSendPathTrace() not supported");
    }

    public char[] getExpectedPathTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getExpectedPathTrace() not supported");
    }

    public void setExpectedPathTrace(String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("setExpectedPathTrace() not supported");
    }

    public char[] getReceivedPathTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        throw new FeatureNotSupported("getReceivedPathTrace() not supported");
    }

    public int getPathTraceFormat() {
        throw new FeatureNotSupported("getPathTraceFormat() not supported");
    }

    public void setPathTraceFormat(int n) {
        throw new FeatureNotSupported("setPathTraceFormat() not supported");
    }

    public synchronized IPathTraceModel getHoPathTraceModel() {
        if (this.hoPathTraceModel == null) {
            this.hoPathTraceModel = new HoPathTraceModel(this);
        }
        return this.hoPathTraceModel;
    }

    public boolean isTransponder() {
        boolean bl = false;
        try {
            bl = this.getGmacLineAdminInfo_4_01().mode.value() != 0;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return bl;
    }

    public sL1Info getEtherL1Info() throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::getEtherL1Info");
        }
        try {
            return (sL1Info)this.etherL1Info.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchInterface2));
            }
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xWrongInterfaceType2));
            }
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            }
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("getEtherL1Info", userException);
        }
    }

    public sML2PosPortAdminInfo getAdmPosPortInfo(int n) {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::getEtherL1Info");
        }
        try {
            this.admPosAdminInfo.portNum = n;
            return (sML2PosPortAdminInfo)this.admPosAdminInfo.get();
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("getAdmPosAdminInfo", userException);
        }
    }

    public List getPortFramingCrcEncap(int n) throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType {
        int n2 = 1;
        int n3 = 2;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        int n7 = n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.getModuleModel().getEqType() == 273) {
            sML2PosPortAdminInfo sML2PosPortAdminInfo2 = this.getAdmPosPortInfo(n);
            if (sML2PosPortAdminInfo2.framingType.value() == 1) {
                n7 = n3;
            }
            arrayList.add(n7);
            n7 = n4;
            if (sML2PosPortAdminInfo2.payloadCrcType.value() == 1) {
                n7 = n5;
            }
            if (sML2PosPortAdminInfo2.payloadCrcType.value() == 2) {
                n7 = n6;
            }
            arrayList.add(n7);
            return arrayList;
        }
        n7 = n3;
        arrayList.add(n7);
        sGmacLineAdminInfo_4_01 sGmacLineAdminInfo_4_012 = this.getGmacLineAdminInfo_4_01();
        if (sGmacLineAdminInfo_4_012.fcsType.value() == 0) {
            n7 = n5;
        }
        if (sGmacLineAdminInfo_4_012.fcsType.value() == 1) {
            n7 = n6;
        }
        arrayList.add(n7);
        return arrayList;
    }

    public void setEtherL1Info(sL1Info sL1Info2) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError, ConfigError {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::setEtherL1Info");
        }
        try {
            this.etherL1Info.set(sL1Info2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("setEtherL1Info", userException);
        }
    }

    public void setAdmPosPortInfo(sML2PosPortAdminInfo sML2PosPortAdminInfo2, int n) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError, ConfigError {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::setAdmPosAdminInfo");
        }
        try {
            this.admPosAdminInfo.portNum = n;
            this.admPosAdminInfo.set(sML2PosPortAdminInfo2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            EMCProvisionError eMCProvisionError = new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
            String string = "";
            if (eMCProvisionError.getEID().equals(EMC.EID_INVALID_CONFIG_PARAM_1)) {
                string = EMC.EID_WRONG_FRAMING_CRC_ENCAP.getMessage();
                throw new EMCProvisionError(xProvisionError2, string, this.getNodeModelDelegate().getPlatform());
            }
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("setEtherL1Info", userException);
        }
    }

    public sL1AdminInfo getEtherL1AdminInfo() throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        if (this.db.on()) {
            this.db.println("HdGeLineModel::getEtherL1AdminInfo");
        }
        try {
            return (sL1AdminInfo)this.etherL1AdminInfo.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNoSuchInterface2));
            }
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xWrongInterfaceType2));
            }
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            }
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("getEtherL1AdminInfo", userException);
        }
    }

    public sML2PosPortAdminInfo getAdmPosPortInfo() {
        int n;
        block3: {
            if (this.db.on()) {
                this.db.println("HdGeLineModel::getEtherL1Info");
            }
            n = 0;
            try {
                n = this.getPort().getPortNum()[0];
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.getAdmPosPortInfo(n);
    }

    public void setAdmPosPortInfo(sML2PosPortAdminInfo sML2PosPortAdminInfo2) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError, ConfigError {
        int n;
        block3: {
            if (this.db.on()) {
                this.db.println("HdGeLineModel::getEtherL1Info");
            }
            n = 0;
            try {
                n = this.getPort().getPortNum()[0];
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        this.setAdmPosPortInfo(sML2PosPortAdminInfo2, n);
    }

    public TdmLineModel getChildWISLineModel() {
        TdmLineModel tdmLineModel = null;
        try {
            InterfaceModel interfaceModel;
            boolean bl;
            ModuleModel moduleModel = this.getModuleModel();
            boolean bl2 = bl = moduleModel.getEqType() == 301 || moduleModel.getEqType() == 356;
            if (bl && this.getHigherLayerModels().length > 0 && (interfaceModel = this.getHigherLayerModels()[0]) instanceof TdmLineModel) {
                tdmLineModel = (TdmLineModel)interfaceModel;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return tdmLineModel;
    }

    public boolean hasChildWISPort() {
        return this.getChildWISLineModel() != null;
    }

    private class AdmPosAdminInfo
    extends CachedValue {
        public int portNum;
        private IPortModel posPortModel;
        private InterfaceModel posLineModel;

        public AdmPosAdminInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
            this.portNum = 0;
            this.posPortModel = null;
            this.posLineModel = null;
        }

        private void setAdmPosPorts() {
            block3: {
                try {
                    IPortModel[] iPortModelArray = ((DwdmModuleModel)HdGeLineModel.this.getModuleModel()).getAllPosPortModels();
                    InterfaceModel[] interfaceModelArray = ((DwdmModuleModel)HdGeLineModel.this.getModuleModel()).getAllPosLineModels();
                    for (int i = 0; i < interfaceModelArray.length; ++i) {
                        if (iPortModelArray[i].getPortNum()[0] != this.portNum) continue;
                        this.posPortModel = iPortModelArray[i];
                        this.posLineModel = interfaceModelArray[i];
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!HdGeLineModel.this.db.on()) break block3;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }

        private int getAdmPosIndex() {
            return this.posLineModel.getIndex();
        }

        private boolean isPosPortsForAdm() {
            boolean bl;
            block2: {
                bl = false;
                try {
                    bl = ((DwdmModuleModel)HdGeLineModel.this.getModuleModel()).isADMCard();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!HdGeLineModel.this.db.on()) break block2;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            return bl;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            this.setAdmPosPorts();
            HdGeLineModel.this.getEtherMediaRef().setAdmPosAdminInfo(this.getAdmPosIndex(), (sML2PosPortAdminInfo)object);
        }

        @Override
        protected Object getValue() throws UserException {
            this.setAdmPosPorts();
            return HdGeLineModel.this.getEtherMediaRef().getAdmPosAdminInfo(this.getAdmPosIndex());
        }

        @Override
        protected Object cloneValue() {
            if (this.isPosPortsForAdm()) {
                sML2PosPortAdminInfo sML2PosPortAdminInfo2 = (sML2PosPortAdminInfo)this.value;
                sML2PosPortAdminInfo sML2PosPortAdminInfo3 = new sML2PosPortAdminInfo(sML2PosPortAdminInfo2.framingType, sML2PosPortAdminInfo2.payloadCrcType);
                return sML2PosPortAdminInfo3;
            }
            Object object = super.cloneValue();
            return object;
        }

        public Object outer() {
            return HdGeLineModel.this;
        }
    }

    private class EtherL1AdminInfo
    extends CachedValue {
        public EtherL1AdminInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xNotSupportedOnEquipment {
            return HdGeLineModel.this.getEtherMediaRef().getL1AdminInfo(HdGeLineModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sL1AdminInfo sL1AdminInfo2 = (sL1AdminInfo)this.value;
            sL1AdminInfo sL1AdminInfo3 = new sL1AdminInfo(sL1AdminInfo2.duplex, sL1AdminInfo2.speed, sL1AdminInfo2.flowControl);
            return sL1AdminInfo3;
        }

        public Object outer() {
            return HdGeLineModel.this;
        }
    }

    private class EtherL1Info
    extends CachedValue {
        public EtherL1Info(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            HdGeLineModel.this.getEtherMediaRef().setL1Info(HdGeLineModel.this.getIndex(), (sL1Info)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return HdGeLineModel.this.getEtherMediaRef().getL1Info(HdGeLineModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sL1Info sL1Info2 = (sL1Info)this.value;
            sL1Info sL1Info3 = new sL1Info(sL1Info2.duplex, sL1Info2.speed, sL1Info2.flowControl, new sIngressQOSInfo(sL1Info2.ingressQos.committedInfoRate, sL1Info2.ingressQos.committedBurstSize, sL1Info2.ingressQos.excOrPeakBurstSize, sL1Info2.ingressQos.peakInfoRate, sL1Info2.ingressQos.couplingFlag, sL1Info2.ingressQos.colorMode), sL1Info2.mtu, sL1Info2.mappingMode, sL1Info2.etherMode);
            return sL1Info3;
        }

        public Object outer() {
            return HdGeLineModel.this;
        }
    }

    class StatsLastCleared
    extends NonCachedValue {
        public StatsLastCleared(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Integer(HdGeLineModel.this.getEtherMediaRef().getStatsLineLastClearedTime(HdGeLineModel.this.getIndex()));
        }

        public Object outer() {
            return HdGeLineModel.this;
        }
    }
}

