/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.Roll;
import cerent.cms.idl.SonetTopology.StsRoll;
import cerent.cms.idl.SonetTopology.eRollFinish;
import cerent.cms.idl.SonetTopology.eRollMode;
import cerent.cms.idl.SonetTopology.sStsRollItem;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.HoPathDefModelFactory;
import cerent.cms.model.HoRolls;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoRollModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RollModel;
import org.omg.CORBA.UserException;

public class HoRollModel
extends RollModel
implements IHoRollModel {
    HoRollItem hoRollItem;

    public HoRollModel(NodeModelDelegate nodeModelDelegate, HoRolls hoRolls, sStsRollItem sStsRollItem2) {
        super(nodeModelDelegate, hoRolls, nodeModelDelegate.getChildDebug(HoRollModel.class));
        this.hoRollItem = new HoRollItem(nodeModelDelegate, "HoRollModel::getHoRollItem");
        this.setValueExternally(sStsRollItem2);
    }

    @Override
    public ObjectType getObjectType() {
        return ObjectType.ObjectStsRoll;
    }

    private void setValueExternally(sStsRollItem sStsRollItem2) {
        this.hoRollItem.setValueExternally(new HoRollItemCache(sStsRollItem2));
        this.connectionIndex = sStsRollItem2.connectionIndex;
    }

    private HoRollItemCache getRollItemCache() {
        try {
            return (HoRollItemCache)this.hoRollItem.get();
        }
        catch (UserException userException) {
            return null;
        }
    }

    @Override
    protected void updateLocal() {
        this.hoRollItem.update();
        super.updateLocal();
    }

    public boolean isValidRoll() {
        Roll roll = this.getRollReference();
        return roll != null;
    }

    @Override
    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    @Override
    protected Roll getRollReference() {
        return this.getRollItemCache().rollRef;
    }

    @Override
    public int getRollMode() {
        return this.getRollItemCache().rollMode.value();
    }

    public int getRollFinish() {
        return this.getRollItemCache().rollFinish.value();
    }

    public boolean getRollValidSignal() {
        return this.getRollItemCache().rollValidSignal;
    }

    public boolean isAcknowledged() {
        return this.getRollItemCache().rollAcknowledge;
    }

    public IHoPathDefModel getRollPath() {
        return this.getRollItemCache().rollPath;
    }

    public IHoPathDefModel getRollFromPath() {
        return this.getRollItemCache().rollFromPath;
    }

    public IHoPathDefModel getRollToPath() {
        return this.getRollItemCache().rollToPath;
    }

    public ICircuitId getRollFromCircuit() {
        return this.getRollItemCache().rollFromCircuit;
    }

    public ICircuitId getRollToCircuit() {
        return this.getRollItemCache().rollToCircuit;
    }

    public short getCircuitRollNumber() {
        return this.getRollItemCache().circuitRollNumber;
    }

    public short getCircuitRollMode() {
        return this.getRollItemCache().circuitRollMode;
    }

    @Override
    public void dispose() {
        this.hoRollItem.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public class HoRollItem
    extends CachedValue {
        public HoRollItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new HoRollItemCache(HoRollModel.this.getSonetFactoryRef().getStsRoll(HoRollModel.this.connectionIndex));
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }
    }

    protected class HoRollItemCache {
        sStsRollItem rollItemSrc;
        IHoPathDefModel rollPath;
        IHoPathDefModel rollFromPath;
        IHoPathDefModel rollToPath;
        ICircuitId rollFromCircuit;
        ICircuitId rollToCircuit;
        eRollMode rollMode;
        eRollFinish rollFinish;
        StsRoll rollRef;
        boolean rollValidSignal;
        boolean rollAcknowledge;
        int connectionIndex;
        short circuitRollMode;
        short circuitRollNumber;

        public HoRollItemCache(sStsRollItem sStsRollItem2) {
            this.rollPath = HoPathDefModelFactory.getIHoPathDef(HoRollModel.this.node, sStsRollItem2.rollPath);
            this.rollFromPath = HoPathDefModelFactory.getIHoPathDef(HoRollModel.this.node, sStsRollItem2.rollFromPath);
            this.rollToPath = HoPathDefModelFactory.getIHoPathDef(HoRollModel.this.node, sStsRollItem2.rollToPath);
            this.rollValidSignal = sStsRollItem2.rollValidSignal;
            this.rollAcknowledge = sStsRollItem2.rollControlled;
            this.rollMode = sStsRollItem2.rollMode;
            this.rollFinish = sStsRollItem2.rollFinish;
            this.connectionIndex = sStsRollItem2.connectionIndex;
            this.rollFromCircuit = HoRollModel.this.node.getConnectionModels().findHoConnectionModel(this.connectionIndex).getCircuitId();
            this.rollToCircuit = CircuitIdFactory.getICircuitId(sStsRollItem2.newCircuitId);
            this.rollRef = sStsRollItem2.rollRef;
            this.circuitRollMode = sStsRollItem2.circuitData.circuitRollMode;
            this.circuitRollNumber = sStsRollItem2.circuitData.numCircuitRolls;
        }
    }
}

