/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.ServerTrail.StsTrailCTP;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.HoPathDefModelFactory;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoServerTrailEnd;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ServerTrailEnd;
import cerent.util.SDebug;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class HoServerTrailEnd
extends ServerTrailEnd
implements IHoServerTrailEnd {
    protected StsServerTrailDeletor stsServerTrailDeletor;
    protected InUse inUse;
    protected StsTrailCTP stsTrailCTPRef;
    protected IHoPathDefModel trailStart;
    protected IHoPathDefModel trailEnd;

    public HoServerTrailEnd(NodeModelDelegate nodeModelDelegate, StsTrailCTP stsTrailCTP) {
        super(nodeModelDelegate, stsTrailCTP);
        this.stsTrailCTPRef = stsTrailCTP;
        this.trailStart = HoPathDefModelFactory.getIHoPathDef(nodeModelDelegate, stsTrailCTP.getTrailCTPStart());
        this.trailEnd = HoPathDefModelFactory.getIHoPathDef(nodeModelDelegate, stsTrailCTP.getTrailCTPEnd());
        this.stsServerTrailDeletor = new StsServerTrailDeletor("StsServerTrailDeletor", nodeModelDelegate);
        this.inUse = new InUse("HoServertrailEnd.InUse", nodeModelDelegate);
        EventDispatcher eventDispatcher = nodeModelDelegate.getDispatcher();
        eventDispatcher.addObserver(ObjectType.ObjectStsTrailCTPList, this.trailId.getUniqueId(), (Observer)this);
    }

    @Override
    protected void updateLocal() {
        this.inUse.update();
        super.updateLocal();
    }

    @Override
    public void dispose() {
        EventDispatcher eventDispatcher = this.node.getDispatcher();
        eventDispatcher.deleteObserver(ObjectType.ObjectStsTrailCTPList, this.trailId.getUniqueId(), (Observer)this);
        this.inUse.dispose();
    }

    public IHoPathDefModel getTrailStart() {
        return this.trailStart;
    }

    public IHoPathDefModel getTrailEnd() {
        return this.trailEnd;
    }

    @Override
    public boolean delete() {
        boolean bl = false;
        try {
            this.stsServerTrailDeletor.set();
            bl = true;
        }
        catch (UserException userException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean inUse() {
        try {
            return (Boolean)this.inUse.get();
        }
        catch (UserException userException) {
            this.db.println("HoServerTrailEnd: user exception in inUse");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    private class InUse
    extends CachedValue {
        public InUse(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            boolean bl = HoServerTrailEnd.this.stsTrailCTPRef.inUse();
            return new Boolean(bl);
        }
    }

    private class StsServerTrailDeletor
    extends NonCachedValue {
        public StsServerTrailDeletor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws xBusy {
            HoServerTrailEnd.this.stsTrailCTPRef.destroyStsTrailCTP();
        }

        public Object outer() {
            return HoServerTrailEnd.this;
        }
    }
}

