/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherMedia.sL2scEtherPortInfo;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.model.CachedValue;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.L2scEtherLineModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class L2scEtherPortModel
extends L2scPortModel {
    private L2scEtherPortInfo l2scEtherPortInfo;

    public L2scEtherPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(L2scEtherPortModel.class));
    }

    public L2scEtherPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
        this.index = n;
        this.l2scEtherPortInfo = new L2scEtherPortInfo(nodeModelDelegate, "L2scEtherPortModel.L2scEtherPortInfo");
    }

    @Override
    public void init() {
        super.init();
        this.l2scEtherPortInfo.init();
    }

    public L2scEtherLineModel getL2scEtherLineModel() {
        return (L2scEtherLineModel)this.getInterfaceModel();
    }

    @Override
    public String toString() {
        return "L2scEther" + super.toString();
    }

    @Override
    public boolean isInLoopback() {
        return this.getL2scEtherLineModel().getLoopbackAsInt() != 0;
    }

    private sL2scEtherPortInfo debugOut(sL2scEtherPortInfo sL2scEtherPortInfo2) {
        if (this.db.isInfoEnabled()) {
            this.db.info(Integer.toHexString(this.getIndex()) + " " + this.getPort() + " state " + sL2scEtherPortInfo2.adminState + " linkProtocol " + sL2scEtherPortInfo2.linkProtocolState + " mtu " + sL2scEtherPortInfo2.mtu + " speed " + sL2scEtherPortInfo2.speed.value() + " duplex " + sL2scEtherPortInfo2.duplex.value() + " flowControl " + sL2scEtherPortInfo2.flowControlNegotiated.value() + " opticsType " + sL2scEtherPortInfo2.opticsType.value());
        }
        return sL2scEtherPortInfo2;
    }

    public sL2scEtherPortInfo getL2scEtherPortInfo() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.db.fine("getL2scEtherPortInfo");
        try {
            return this.debugOut((sL2scEtherPortInfo)this.l2scEtherPortInfo.get());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getEtherPortInfo", userException);
        }
    }

    @Override
    public int getAdminState() throws NoSuchInterface {
        try {
            InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
            if (interfaceModel != null) {
                return interfaceModel.getAdminState();
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        return -1;
    }

    @Override
    public int getServiceStateType() throws NoSuchInterface {
        int n = 101;
        try {
            n = this.getL2scEtherPortInfo().linkProtocolState ? 100 : 101;
        }
        catch (InternalCommError internalCommError) {
            this.db.severe(internalCommError.toString());
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.severe(wrongInterfaceType.toString());
        }
        return n;
    }

    @Override
    protected void updateLocal() {
        this.l2scEtherPortInfo.update();
        if (this.db.isInfoEnabled()) {
            this.db.info("L2scEtherPortModel::updateLocal " + Integer.toHexString(this.getIndex()));
            try {
                this.debugOut((sL2scEtherPortInfo)this.l2scEtherPortInfo.get());
            }
            catch (Exception exception) {
                this.db.severe(exception.toString());
            }
        }
        super.updateLocal();
    }

    @Override
    public void dispose() {
        this.db.fine("L2scEtherPortModel::dispose");
        this.l2scEtherPortInfo.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        this.db.fine("L2scEtherPortModel::destroy()");
        super.destroy();
        this.l2scEtherPortInfo = null;
    }

    @Override
    public int getPort() {
        int n = this.getPositionInParent();
        return n - 5;
    }

    private class L2scEtherPortInfo
    extends CachedValue {
        public L2scEtherPortInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xInternalCommError {
            return L2scEtherPortModel.this.getEtherMediaRef().getL2scEtherPortInfo(L2scEtherPortModel.this.getIndex());
        }

        public Object outer() {
            return L2scEtherPortModel.this;
        }
    }
}

