/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class LdccTermConnectionModel
extends AbstractTermConnectionModel {
    private static OhChannelType LDCC_TERM_CHANNEL = OhChannelType.LDCC_OBJ;
    private static OhChannelType LDCC_TUNNEL1_CHANNEL = OhChannelType.LDCC_TUNNEL1_OBJ;
    private static OhChannelType LDCC_TUNNEL2_CHANNEL = OhChannelType.LDCC_TUNNEL2_OBJ;
    private static OhChannelType LDCC_TUNNEL3_CHANNEL = OhChannelType.LDCC_TUNNEL3_OBJ;
    private static OhChannelType UDC_MS_CHANNEL = OhChannelType.UDC_MS_OBJ;
    private static NodeSingletonFactory<LdccTermConnectionModel> sfactory = new NodeSingletonFactory<LdccTermConnectionModel>(LdccTermConnectionModel.class);

    public static LdccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private LdccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        LdccTermConnectionModel ldccTermConnectionModel = (LdccTermConnectionModel)nodeModelDelegate.getLdccTermConnectionModel();
        ldccTermConnectionModel.init();
    }

    @Override
    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    @Override
    public IEntityModel[] getTermCandidates() {
        Set set;
        Object object;
        Object object2;
        HashSet<IEntityModel> hashSet = new HashSet<IEntityModel>();
        ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
        if (this.nmd.getTdmProtocolTypeObj().isSonet()) {
            IEntityModel iEntityModel;
            object2 = elementModelsDelegate.getNonProtectOpticalEntities();
            object = elementModelsDelegate.getNonProtectDwdmEntities();
            set = new TreeSet<IPortModel>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                iEntityModel = (IEntityModel)iterator.next();
                if (!(iEntityModel instanceof DwdmPortModel)) continue;
                try {
                    if (((DwdmPortModel)iEntityModel).getInterfaceModel().getHigherLayerModelsForNet().length <= 0 || !((DwdmPortModel)iEntityModel).isClientPort()) continue;
                    IPortModel iPortModel = ((PortModel)iEntityModel).getInterfaceModel().getHigherLayerModelsForNet()[0].getPortModel();
                    int n = iEntityModel.getModuleModel().getEqType();
                    if (!(iPortModel instanceof TdmPortModel)) continue;
                    int n2 = ((DwdmPortModel)iEntityModel).getDwdmLineModel().getTermMode();
                    if (n != 301 && n != 300 && n != 356 && n != 358 || n2 != 2) continue;
                    set.add(iPortModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            object2.addAll(set);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                try {
                    iEntityModel = (EntityModel)iterator.next();
                    if (iEntityModel.getMediumType() != 1) continue;
                    if (this.db.on()) {
                        this.db.println("Found a Sonet port " + iEntityModel + " adding ...");
                    }
                    hashSet.add(iEntityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        } else {
            hashSet.addAll(elementModelsDelegate.getNonProtectOpticalEntities());
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (IPortModel)object2.next();
            if (object.getModuleModel().getEqType() != 273 || object.getPortNum()[0] != 17) continue;
            object2.remove();
        }
        object = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        hashSet.removeAll(((OhConnectionModelsDelegate)object).getUsedOpticalPorts(LDCC_TERM_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object).getUsedOpticalPorts(LDCC_TUNNEL1_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object).getUsedOpticalPorts(LDCC_TUNNEL2_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object).getUsedOpticalPorts(LDCC_TUNNEL3_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object).getUsedOpticalPorts(UDC_MS_CHANNEL));
        hashSet.removeAll(this.getNotSupportedTdmPorts(hashSet));
        hashSet.removeAll(this.dwdmNotAllowedPorts(hashSet, 4));
        set = this.excludeUcpTerms(hashSet);
        return set.toArray(new IEntityModel[0]);
    }

    @Override
    protected String getTypeName() {
        return this.nmd.getTDMTerminology().getGeneralTerms(10);
    }

    @Override
    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return LDCC_TERM_CHANNEL;
    }

    @Override
    protected boolean termQualifies(OhTermModel ohTermModel) {
        return ohTermModel.getChannelType() == 4 && !this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }

    private Set getNotSupportedTdmPorts(Set set) {
        HashSet<ITdmPortModel> hashSet = new HashSet<ITdmPortModel>();
        for (Object e : set) {
            ITdmPortModel iTdmPortModel;
            ITdmLineModel iTdmLineModel;
            if (!(e instanceof ITdmPortModel) || (iTdmLineModel = (iTdmPortModel = (ITdmPortModel)e).getITdmLineModel()).supportsOhChannel(4)) continue;
            hashSet.add(iTdmPortModel);
        }
        return hashSet;
    }
}

