/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.Roll;
import cerent.cms.idl.SonetTopology.VtRoll;
import cerent.cms.idl.SonetTopology.eRollFinish;
import cerent.cms.idl.SonetTopology.eRollMode;
import cerent.cms.idl.SonetTopology.sVtRollItem;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoRollModel;
import cerent.cms.model.LoDefModelFactory;
import cerent.cms.model.LoRolls;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RollModel;
import org.omg.CORBA.UserException;

public class LoRollModel
extends RollModel
implements ILoRollModel {
    LoRollItem loRollItem;

    public LoRollModel(NodeModelDelegate nodeModelDelegate, LoRolls loRolls, sVtRollItem sVtRollItem2) {
        super(nodeModelDelegate, loRolls, nodeModelDelegate.getChildDebug(LoRollModel.class));
        this.loRollItem = new LoRollItem(nodeModelDelegate, "LoRollModel::getLoRollItem");
        this.setValueExternally(sVtRollItem2);
    }

    @Override
    public ObjectType getObjectType() {
        return ObjectType.ObjectVtRoll;
    }

    private void setValueExternally(sVtRollItem sVtRollItem2) {
        this.loRollItem.setValueExternally(new LoRollItemCache(sVtRollItem2));
        this.connectionIndex = sVtRollItem2.connectionIndex;
    }

    private LoRollItemCache getRollItemCache() {
        try {
            return (LoRollItemCache)this.loRollItem.get();
        }
        catch (UserException userException) {
            return null;
        }
    }

    @Override
    protected void updateLocal() {
        this.loRollItem.update();
        super.updateLocal();
    }

    public boolean isValidRoll() {
        Roll roll = this.getRollReference();
        return roll != null;
    }

    @Override
    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    @Override
    protected Roll getRollReference() {
        return this.getRollItemCache().rollRef;
    }

    @Override
    public int getRollMode() {
        return this.getRollItemCache().rollMode.value();
    }

    public int getRollFinish() {
        return this.getRollItemCache().rollFinish.value();
    }

    public boolean getRollValidSignal() {
        return this.getRollItemCache().rollValidSignal;
    }

    public boolean isAcknowledged() {
        return this.getRollItemCache().rollAcknowledge;
    }

    public ILoDefModel getRollPath() {
        return this.getRollItemCache().rollPath;
    }

    public ILoDefModel getRollFromPath() {
        return this.getRollItemCache().rollFromPath;
    }

    public ILoDefModel getRollToPath() {
        return this.getRollItemCache().rollToPath;
    }

    public ICircuitId getRollFromCircuit() {
        return this.getRollItemCache().rollFromCircuit;
    }

    public ICircuitId getRollToCircuit() {
        return this.getRollItemCache().rollToCircuit;
    }

    public short getCircuitRollNumber() {
        return this.getRollItemCache().circuitRollNumber;
    }

    public short getCircuitRollMode() {
        return this.getRollItemCache().circuitRollMode;
    }

    @Override
    public void dispose() {
        this.loRollItem.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public class LoRollItem
    extends CachedValue {
        public LoRollItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new LoRollItemCache(LoRollModel.this.getSonetFactoryRef().getVtRoll(LoRollModel.this.connectionIndex));
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }
    }

    protected class LoRollItemCache {
        sVtRollItem rollItemSrc;
        ILoDefModel rollPath;
        ILoDefModel rollFromPath;
        ILoDefModel rollToPath;
        ICircuitId rollFromCircuit;
        ICircuitId rollToCircuit;
        eRollMode rollMode;
        eRollFinish rollFinish;
        VtRoll rollRef;
        boolean rollValidSignal;
        boolean rollAcknowledge;
        int connectionIndex;
        short circuitRollMode;
        short circuitRollNumber;

        public LoRollItemCache(sVtRollItem sVtRollItem2) {
            this.rollPath = LoDefModelFactory.getILoDef(LoRollModel.this.node, sVtRollItem2.rollPath);
            this.rollFromPath = LoDefModelFactory.getILoDef(LoRollModel.this.node, sVtRollItem2.rollFromPath);
            this.rollToPath = LoDefModelFactory.getILoDef(LoRollModel.this.node, sVtRollItem2.rollToPath);
            this.rollValidSignal = sVtRollItem2.rollValidSignal;
            this.rollAcknowledge = sVtRollItem2.rollControlled;
            this.rollMode = sVtRollItem2.rollMode;
            this.rollFinish = sVtRollItem2.rollFinish;
            this.connectionIndex = sVtRollItem2.connectionIndex;
            this.rollFromCircuit = LoRollModel.this.node.getConnectionModels().findLoConnectionModel(this.connectionIndex).getCircuitId();
            this.rollToCircuit = CircuitIdFactory.getICircuitId(sVtRollItem2.newCircuitId);
            this.rollRef = sVtRollItem2.rollRef;
            this.circuitRollMode = sVtRollItem2.circuitData.circuitRollMode;
            this.circuitRollNumber = sVtRollItem2.circuitData.numCircuitRolls;
        }
    }
}

