/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.ServerTrail.VtTrailCTP;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoServerTrailEnd;
import cerent.cms.model.LoDefModelFactory;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ServerTrailEnd;
import cerent.util.SDebug;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LoServerTrailEnd
extends ServerTrailEnd
implements ILoServerTrailEnd {
    protected VtServerTrailDeletor vtServerTrailDeletor;
    protected InUse inUse;
    protected ILoDefModel trailStart;
    protected ILoDefModel trailEnd;
    protected VtTrailCTP vtTrailCTPRef;

    public LoServerTrailEnd(NodeModelDelegate nodeModelDelegate, VtTrailCTP vtTrailCTP) {
        super(nodeModelDelegate, vtTrailCTP);
        this.vtTrailCTPRef = vtTrailCTP;
        this.trailStart = LoDefModelFactory.getILoDef(nodeModelDelegate, vtTrailCTP.getTrailCTPStart());
        this.trailEnd = LoDefModelFactory.getILoDef(nodeModelDelegate, vtTrailCTP.getTrailCTPEnd());
        this.vtServerTrailDeletor = new VtServerTrailDeletor("VtServerTrailDeletor", nodeModelDelegate);
        this.inUse = new InUse("VtServertrailEnd.InUse", nodeModelDelegate);
        EventDispatcher eventDispatcher = nodeModelDelegate.getDispatcher();
        eventDispatcher.addObserver(ObjectType.ObjectVtTrailCTPList, this.trailId.getUniqueId(), (Observer)this);
    }

    @Override
    protected void updateLocal() {
        this.inUse.update();
        super.updateLocal();
    }

    @Override
    public void dispose() {
        EventDispatcher eventDispatcher = this.node.getDispatcher();
        eventDispatcher.deleteObserver(ObjectType.ObjectVtTrailCTPList, this.trailId.getUniqueId(), (Observer)this);
        this.inUse.dispose();
    }

    public ILoDefModel getTrailStart() {
        return this.trailStart;
    }

    public ILoDefModel getTrailEnd() {
        return this.trailEnd;
    }

    @Override
    public boolean delete() {
        boolean bl = false;
        try {
            this.vtServerTrailDeletor.set();
            bl = true;
        }
        catch (xBusy xBusy2) {
            SDebug.printStackTrace((Throwable)((Object)xBusy2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return bl;
    }

    @Override
    public boolean inUse() {
        try {
            return (Boolean)this.inUse.get();
        }
        catch (UserException userException) {
            this.db.println("HoServerTrailEnd: user exception in inUse");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    private class InUse
    extends CachedValue {
        public InUse(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            boolean bl = LoServerTrailEnd.this.vtTrailCTPRef.inUse();
            return new Boolean(bl);
        }
    }

    private class VtServerTrailDeletor
    extends NonCachedValue {
        public VtServerTrailDeletor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws xBusy {
            LoServerTrailEnd.this.vtTrailCTPRef.destroyVtTrailCTP();
        }

        public Object outer() {
            return LoServerTrailEnd.this;
        }
    }
}

