/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.EtherL2Media.sMEP;
import cerent.cms.idl.EtherL2Media.sMaintenanceDomain;
import cerent.cms.model.MEPInfo;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;

public class MEPInfoFactory {
    private MEPInfoFactory() {
    }

    public static MEPInfo[] getMEPModels(sMEP[] sMEPArray, XPL2ModuleModel xPL2ModuleModel) {
        if (sMEPArray == null) {
            return null;
        }
        MEPInfo[] mEPInfoArray = new MEPInfo[sMEPArray.length];
        for (int i = 0; i < sMEPArray.length; ++i) {
            mEPInfoArray[i] = MEPInfoFactory.getMEPModelFromMEP(sMEPArray[i], xPL2ModuleModel);
        }
        return mEPInfoArray;
    }

    public static sMEP getMEPFromMEPModel(MEPInfo mEPInfo) {
        sMEP sMEP2 = new sMEP();
        sMEP2.mpId = mEPInfo.getMpId();
        sMEP2.portindex = mEPInfo.getLineModel().getLayer2LineModel().getIndex();
        sMEP2.svlanId = mEPInfo.getVlanId();
        sMEP2.maintenanceDomain = new sMaintenanceDomain();
        sMEP2.maintenanceDomain.name = mEPInfo.getDomainName();
        return sMEP2;
    }

    private static MEPInfo getMEPModelFromMEP(sMEP sMEP2, XPL2ModuleModel xPL2ModuleModel) {
        MEPInfo mEPInfo = new MEPInfo(MEPInfoFactory.getLineModelFromL2Index(sMEP2.portindex, xPL2ModuleModel), sMEP2.maintenanceDomain.name, sMEP2.mpId, sMEP2.svlanId);
        return mEPInfo;
    }

    private static XPL2LineModel getLineModelFromL2Index(int n, XPL2ModuleModel xPL2ModuleModel) {
        XPL2LineModel[] xPL2LineModelArray = xPL2ModuleModel.getXPL2EtherLines();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            if (xPL2LineModelArray[i].getLayer2LineModel().getIndex() != n) continue;
            return xPL2LineModelArray[i];
        }
        return null;
    }
}

