/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.NodeModelDelegate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ML2EnhModuleModel
extends ML2ModuleModel {
    public static final int numEtherPorts = 10;
    public static final int numPosPorts = 26;
    public static final int numRprPorts = 2;
    public static final int RPR_EAST_PORT = 28;
    public static final int RPR_WEST_PORT = 29;
    public static final int numPorts = 28;
    ML2PosPortModel[] portsArray = new ML2PosPortModel[28];
    ML2PosLineModel[] linesArray = new ML2PosLineModel[28];

    public ML2EnhModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
    }

    public int getNumberOfEtherPorts() {
        return 10;
    }

    public int getNumberOfPosPorts() {
        return 26;
    }

    public int getNumberOfRprPorts() {
        return 2;
    }

    @Override
    public int getRPREastPort() {
        return 28;
    }

    @Override
    public IPortModel getRPREastPortModel() {
        return this.getAllPortModels()[26];
    }

    @Override
    public int getRPRWestPort() {
        return 29;
    }

    @Override
    public ML2PosPortModel[] getPosPortModels() {
        ML2PosPortModel[] mL2PosPortModelArray = new ML2PosPortModel[26];
        this.portsArray = this.getAllPortModels();
        for (int i = 0; i < 26; ++i) {
            mL2PosPortModelArray[i] = this.portsArray[i];
        }
        return mL2PosPortModelArray;
    }

    @Override
    public ML2PosLineModel[] getPosLineModels() {
        ML2PosLineModel[] mL2PosLineModelArray = new ML2PosLineModel[26];
        this.linesArray = this.getAllLineModels();
        for (int i = 0; i < 26; ++i) {
            mL2PosLineModelArray[i] = this.linesArray[i];
        }
        return mL2PosLineModelArray;
    }

    public ML2PosPortModel[] getRprPortModels() {
        ML2PosPortModel[] mL2PosPortModelArray = new ML2PosPortModel[2];
        this.portsArray = this.getAllPortModels();
        int n = 0;
        int n2 = 26;
        while (n < 2) {
            mL2PosPortModelArray[n] = this.portsArray[n2];
            ++n;
            ++n2;
        }
        return mL2PosPortModelArray;
    }

    public ML2PosLineModel[] getRprLineModels() {
        ML2PosLineModel[] mL2PosLineModelArray = new ML2PosLineModel[2];
        this.linesArray = this.getAllLineModels();
        int n = 0;
        int n2 = 26;
        while (n < 2) {
            mL2PosLineModelArray[n] = this.linesArray[n2];
            ++n;
            ++n2;
        }
        return mL2PosLineModelArray;
    }

    @Override
    public boolean isResourceInUse() {
        ML2PosPortModel[] mL2PosPortModelArray = this.getAllPortModels();
        if (mL2PosPortModelArray != null) {
            for (int i = 0; i < mL2PosPortModelArray.length; ++i) {
                List list = mL2PosPortModelArray[i].getConnectionsList();
                if (list == null || list.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List getConnectionsList() {
        LinkedList linkedList = new LinkedList();
        ML2PosPortModel[] mL2PosPortModelArray = this.getAllPortModels();
        if (mL2PosPortModelArray != null) {
            for (int i = 0; i < mL2PosPortModelArray.length; ++i) {
                List list = mL2PosPortModelArray[i].getConnectionsList();
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(iterator.next());
                }
            }
        }
        return linkedList;
    }

    @Override
    public InterfaceModel[] getPathTraceLines() {
        return this.getAllLineModels();
    }

    public ML2PosPortModel[] getAllPortModels() {
        return (ML2PosPortModel[])this.getPortModels(eEqType.L1P_POS_PORT);
    }

    public ML2PosLineModel[] getAllLineModels() {
        return (ML2PosLineModel[])this.getLineModels(eEqType.L1P_POS_PORT);
    }

    @Override
    public boolean isRPRMode() {
        return false;
    }
}

