/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.ExternalInitializationRequired;
import cerent.cms.model.ILRUManager;
import cerent.cms.model.IModel;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.INodeAdapter;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStateTransition;
import cerent.cms.model.InterfaceLRUHandler;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.LRUManager;
import cerent.cms.model.Model;
import cerent.cms.model.ModelObserver;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.ReflectionUtil;
import cerent.cms.model.SequenceNumberLRUMap;
import cerent.cms.model.UninitializedNode;
import cerent.cms.xml.IAssociationIterator;
import cerent.cms.xml.IXmlAdapter;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.id.INetwideNodeIdentity;
import cerent.util.id.ModelIdentityFactory;
import cerent.util.xml.DOMUtil;
import cerent.util.xml.XercesDOMParser;
import com.cisco.crs.model.PlatformNodeModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeAdapter
implements INodeAdapter {
    private static NodeSingletonFactory<NodeAdapter> sfactory = new NodeSingletonFactory<NodeAdapter>(NodeAdapter.class);
    private INodeModel nmd;
    private SDebug db;
    private String ENCODING = "UTF8";
    private String PREFS_XML = "ctc.xml";
    private String PREFS_XML_DIR = "dir";
    private IXmlAdapter xa = null;
    private static final String XML_ADAPTER = "cerent.cms.xml.XmlAdapter";
    private static final String XA_INSTANCE_METH = "getInstance";

    public static NodeAdapter getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public static NodeAdapter getInstance(PlatformNodeModel platformNodeModel) {
        return sfactory.getInstance(platformNodeModel);
    }

    private NodeAdapter(NodeModelDelegate nodeModelDelegate) {
        if (nodeModelDelegate == null) {
            throw new IllegalArgumentException("INodeModel is NULL");
        }
        this.nmd = nodeModelDelegate;
        this.db = nodeModelDelegate.getDebug().getChildDebug("NodeAdapter");
    }

    private NodeAdapter(PlatformNodeModel platformNodeModel) {
        if (platformNodeModel == null) {
            throw new IllegalArgumentException("INodeModel is NULL");
        }
        this.nmd = platformNodeModel;
        this.db = platformNodeModel.getDebug().getChildDebug("NodeAdapter");
    }

    public IXmlAdapter getXmlAdapter(INodeModel iNodeModel) throws CTCUserException {
        if (this.xa == null) {
            Class[] classArray = new Class[]{INodeModel.class};
            Object[] objectArray = new Object[]{iNodeModel};
            try {
                Class clazz = ReflectionUtil.forName(XML_ADAPTER);
                Method method = clazz.getMethod(XA_INSTANCE_METH, classArray);
                this.xa = (IXmlAdapter)method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                this.db.display("NodeAdapter.getXmlAdapter() failed: " + exception);
                throw new CTCUserException("NodeAdapter.getXmlAdapter() failed", (Throwable)exception);
            }
        }
        return this.xa;
    }

    public void loadxml() throws CTCUserException {
        this.getXmlAdapter(this.nmd);
    }

    public String xmlCommand(String string) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        if (this.db.on()) {
            this.db.print("Received XML: ");
            this.db.println(string);
        }
        String string2 = "";
        this.isNodeInited();
        try {
            string2 = this.getXmlAdapter(this.nmd).xmlCommand(string);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
        if (this.db.on()) {
            this.db.print("Returned XML: ");
            this.db.println(string2);
        }
        return string2;
    }

    public String xmlCommand(String string, String string2) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        if (this.db.on()) {
            this.db.print("Received XML: ");
            this.db.println(string);
        }
        String string3 = "";
        this.isNodeInited();
        try {
            string3 = this.getXmlAdapter(this.nmd).xmlCommand(string, string2);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
        if (this.db.on()) {
            this.db.print("Returned XML: ");
            this.db.println(string3);
        }
        return string3;
    }

    public Document xmlCommand(Document document, Document document2) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        if (this.db.on()) {
            this.db.print("Received XML: ");
        }
        if (this.db.on()) {
            try {
                this.db.println(DOMUtil.nodeToString((Node)document));
            }
            catch (CTCUserException cTCUserException) {
                // empty catch block
            }
        }
        this.isNodeInited();
        try {
            document2 = this.getXmlAdapter(this.nmd).xmlCommand(document, document2);
            if (this.db.on()) {
                this.db.print("Returned XML: ");
                this.db.println(DOMUtil.nodeToString((Node)document2, (int)2, (boolean)false));
            }
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
        return document2;
    }

    public Document domXmlCommand(Document document) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        if (this.db.on()) {
            this.db.print("Received XML: ");
        }
        if (this.db.on()) {
            try {
                this.db.println(DOMUtil.nodeToString((Node)document));
            }
            catch (CTCUserException cTCUserException) {
                // empty catch block
            }
        }
        this.isNodeInited();
        try {
            Document document2 = this.getXmlAdapter(this.nmd).domXmlCommand(document);
            if (this.db.on()) {
                this.db.print("Returned XML: ");
                this.db.println(DOMUtil.nodeToString((Node)document2, (int)2, (boolean)false));
            }
            return document2;
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
    }

    public String xmlCommandFromFile(String string, String string2, String string3) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        if (this.db.on()) {
            this.db.print("Using XML from file: ");
        }
        if (this.db.on()) {
            this.db.println(string);
        }
        String string4 = "";
        this.isNodeInited();
        try {
            return this.getXmlAdapter(this.nmd).xmlCommandFromFile(string, string2, string3);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
    }

    public List getAssociation(String string, int n, String string2) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        List list = null;
        try {
            this.isNodeInited();
            list = this.getXmlAdapter(this.nmd).getAssociation(string, n, string2);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
        return list;
    }

    public Iterator getAssociationUseFile(String string, int n, String string2, String string3) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        this.isNodeInited();
        try {
            return this.getXmlAdapter(this.nmd).getAssociationUseFile(string, n, string2, string3);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
    }

    public List getAssociation(String string, String string2, String string3) throws CTCUserException {
        if (string2.startsWith("0x")) {
            return this.getAssociation(string, Integer.decode(string2), string3);
        }
        throw new CTCUserException("getAssociation failed because index expected to be hex format (0x1000).  Index received: " + string2);
    }

    public IAssociationIterator getAssociation(String string, int n, String string2, Document document) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        IAssociationIterator iAssociationIterator = null;
        try {
            this.isNodeInited();
            iAssociationIterator = this.getXmlAdapter(this.nmd).getAssociation(string, n, string2, document);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
        return iAssociationIterator;
    }

    public List domGetAssociation(String string, int n, String string2) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        List list = null;
        try {
            this.isNodeInited();
            list = this.getXmlAdapter(this.nmd).domGetAssociation(string, n, string2);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (Exception exception) {
            throw new CTCUserException("XmlAdapter.getInstance() failed", (Throwable)exception);
        }
        return list;
    }

    public List domGetAssociation(String string, String string2, String string3) throws CTCUserException {
        if (string2.startsWith("0x")) {
            return this.domGetAssociation(string, Integer.decode(string2), string3);
        }
        throw new CTCUserException("getAssociation failed because index expected to be hex format (0x1000).  Index received: " + string2);
    }

    public void registerForAllModelUpdates(Observer observer) throws CTCUserException {
        if (this.db.on()) {
            this.db.print("Registering for updates for: " + this.nmd.getHostName());
        }
        ModelObserver.getInstance(this.nmd).addObserver(observer);
    }

    public void unregisterForAllModelUpdates(Observer observer) throws CTCUserException {
        if (this.db.on()) {
            this.db.print("Unregistering for updates for: " + this.nmd.getHostName());
        }
        ModelObserver.getInstance(this.nmd).deleteObserver(observer);
    }

    public static String prettyXmlString(String string) {
        String string2 = string;
        try {
            XercesDOMParser xercesDOMParser = XercesDOMParser.instance((URL)null, (KDebug)null);
            Document document = xercesDOMParser.parseString(string);
            string2 = DOMUtil.nodeToString((Node)document, (int)2, (boolean)false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private void isNodeInited() throws UninitializedNode {
        if (!this.nmd.isInited()) {
            throw new UninitializedNode("The caller is accessing uninitialized node: " + InetUtil.makeDottedString(this.nmd.getIpConfig().getIpAddress()) + "...this is not permitted");
        }
    }

    public ILRUManager getLRUManager() {
        return LRUManager.getInstance((NodeModelDelegate)this.nmd, InterfaceLRUHandler.instance((NodeModelDelegate)this.nmd), SequenceNumberLRUMap.class);
    }

    public void removePersistedNodeId(int n) throws CTCUserException {
        try {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.nmd;
            IModelPersistenceStrategy iModelPersistenceStrategy = nodeModelDelegate.getModelPersistenceStrategy(InterfaceModel.class);
            ModelIdentityFactory modelIdentityFactory = ModelIdentityFactory.instance();
            INetwideNodeIdentity iNetwideNodeIdentity = modelIdentityFactory.createNetwideNodeIdentity(n);
            iModelPersistenceStrategy.delete(iNetwideNodeIdentity);
        }
        catch (PersistenceException persistenceException) {
            throw new CTCUserException("removePersistedNodeId failed", (Throwable)((Object)persistenceException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociation(String string, int n, String string2, String string3, SDebug sDebug) {
        FileOutputStream fileOutputStream = null;
        String string4 = System.getProperty("line.separator");
        String string5 = string + " " + n + " " + string2;
        String string6 = "ResultOfGetAssociation" + string + string2 + ".txt";
        String string7 = this.getXmlCommandDir();
        File file = new File(string7 = string7 + "Results");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        File file2 = new File(file, string6);
        try {
            String string8;
            if (file2.exists() && !file2.canWrite()) {
                sDebug.display("Cannot overwrite read-only output file: " + file2.getCanonicalPath());
                return;
            }
            fileOutputStream = new FileOutputStream(file2);
            Iterator iterator = this.getAssociationUseFile(string, n, string2, string3);
            int n2 = 0;
            while (iterator.hasNext()) {
                Document document = (Document)iterator.next();
                String string9 = DOMUtil.nodeToString((Node)document);
                string9 = NodeAdapter.prettyXmlString(string9);
                if (n2 > 0) {
                    fileOutputStream.write("\n".getBytes(this.ENCODING));
                }
                string8 = "# assoc result: " + n2 + "\n";
                fileOutputStream.write(string8.getBytes(this.ENCODING));
                fileOutputStream.write(string9.getBytes(this.ENCODING));
                fileOutputStream.flush();
                ++n2;
            }
            string8 = "\n# total # of assoc results: " + n2 + "\n";
            fileOutputStream.write(string8.getBytes(this.ENCODING));
        }
        catch (CTCUserException cTCUserException) {
            if (fileOutputStream != null) {
                sDebug.println("NodeAdapter getAssocation() " + (Object)((Object)cTCUserException));
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
        }
        catch (Exception exception) {
            if (fileOutputStream != null) {
                sDebug.println("NodeAdapter getAssocation() " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    sDebug.println("XML written to File " + file2.getCanonicalPath());
                    sDebug.println("Current print state of OutOfBand (ctc.xml.debug.printoob) set to " + DOMUtil.getPrintOobSetting());
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    SDebug.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private String getXmlCommandDir() {
        String string = Preferences.instance().getProperty(this.PREFS_XML, this.PREFS_XML_DIR, "");
        if (string.length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    public boolean doDomCache() {
        boolean bl = false;
        try {
            bl = this.getXmlAdapter(this.nmd).doDomCache();
        }
        catch (CTCUserException cTCUserException) {
            bl = false;
        }
        return bl;
    }

    public IModel getModel(String string, int n) {
        String string2 = Model.createInstanceName(string, n);
        return Model.getInstance(this.nmd, string2);
    }

    public IStateTransition getStateTransition() {
        return this.nmd == null ? null : ((NodeModelDelegate)this.nmd).getStateTransition();
    }
}

