/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.SonetTopology.OchTrailAdit;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.idl.SonetTopology.sOchTrailAditItem;
import cerent.cms.idl.SonetTopology.sOchncPathDef;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xTestAccessActive;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchncPathDefModelFactory;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TestAccessActive;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OchTrailAditModel
extends ConnectionModel
implements IOchTrailAditModel {
    private OchTrailAdit aditRef = null;
    private Paths paths = null;
    private InUse inUse = null;
    private ObjIndex objIndex;
    private Destroy destroy = null;
    private CircuitId circuitId;
    private ConnectionType connectionType;
    private AdminState adminState;
    private ServiceState serviceState;
    private ConnectionName connectionName = null;
    private int entityIndex = -1;
    private IPortModel trunkPort;

    public OchTrailAditModel(NodeModelDelegate nodeModelDelegate, OchTrailAdit ochTrailAdit, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(OchTrailAditModel.class));
        this.aditRef = ochTrailAdit;
        this.destroy = new Destroy(nodeModelDelegate, "OchTrailAditModel.destroy");
        this.objIndex = new ObjIndex(nodeModelDelegate, "OchTrailAditModel.objIndex");
        this.circuitId = new CircuitId(nodeModelDelegate, "OchTrailAditModel.circuitId");
        this.connectionType = new ConnectionType(nodeModelDelegate, "OchTrailAditModel.connectionType");
        this.adminState = new AdminState(nodeModelDelegate, "OchTrailAditModel.adminState");
        this.serviceState = new ServiceState(nodeModelDelegate, "OchTrailAditModel.serviceState");
        this.connectionName = new ConnectionName(nodeModelDelegate, "OchTrailAditModel.connectionName");
        this.paths = new Paths(nodeModelDelegate, "OchTrailAditModel.paths");
        this.inUse = new InUse(nodeModelDelegate, "OchTrailAditModel.inUse");
        this.getPortModel();
    }

    public OchTrailAditModel(NodeModelDelegate nodeModelDelegate, sOchTrailAditItem sOchTrailAditItem2, Connections connections) {
        this(nodeModelDelegate, sOchTrailAditItem2.adit, connections);
        this.setAttributes(sOchTrailAditItem2);
    }

    @Override
    public void init() {
        super.init();
    }

    public void setAttributes(sOchTrailAditItem sOchTrailAditItem2) {
        this.adminState.setValueExternally(sOchTrailAditItem2.adminState);
        this.serviceState.setValueExternally(sOchTrailAditItem2.serviceState);
        this.circuitId.setValueExternally(sOchTrailAditItem2.circuitId);
        this.connectionName.setValueExternally(sOchTrailAditItem2.name);
        this.connectionType.setValueExternally(sOchTrailAditItem2.connectionType);
        this.objIndex.setValueExternally(new Integer(sOchTrailAditItem2.objIndex));
        this.paths.setValueExternally(sOchTrailAditItem2.paths);
    }

    @Override
    protected void updateLocal() {
        if (this.db.on) {
            this.db.println("OchTrailAditModel Update Local called:" + Integer.toHexString(this.index));
        }
        this.adminState.update();
        this.serviceState.update();
        this.circuitId.update();
        this.connectionType.update();
        this.connectionName.update();
        this.paths.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void dispose() {
        this.adminState.dispose();
        this.serviceState.dispose();
        this.circuitId.dispose();
        this.connectionType.dispose();
        this.connectionName.dispose();
        this.paths.dispose();
        if (this.trunkPort != null) {
            this.trunkPort.deleteObserver((Observer)this);
            this.trunkPort = null;
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.aditRef = null;
    }

    public OchTrailAdit getOchTrailAditRef() {
        if (this.aditRef == null) {
            throw new CmsObjectNotExistException(ErrorMsg.getString((EID)EMC.EID_ERROR_ACCESS_OCHTRAILADIT));
        }
        return this.aditRef;
    }

    public void localDestroy() throws Busy {
        try {
            this.destroy.get();
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel.destroy(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public ICircuitId getCircuitId() {
        try {
            sCircuitId sCircuitId2 = (sCircuitId)this.circuitId.get();
            return CircuitIdFactory.getICircuitId(sCircuitId2);
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel.getCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public String getConnectionName() {
        try {
            return (String)this.connectionName.get();
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel.getConnectionName(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public void setConnectionName(String string) throws InvalidCircuitName {
        try {
            this.connectionName.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel.setConnectionName(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel.getObjIndex(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ObjectOchTrailAdit;
    }

    @Override
    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel.setCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getConnectionType() {
        try {
            eConnectionType eConnectionType2 = (eConnectionType)this.connectionType.get();
            return eConnectionType2.value();
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel.getConnectionType(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getOptChannel() {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        return iOchncPathDefModelArray[0].getOptChannel();
    }

    @Override
    public eAdminState getAdminStateEnum() throws AbstractCmsIOException {
        try {
            return (eAdminState)this.adminState.get();
        }
        catch (UserException userException) {
            this.db.severe("OchTrailAditModel: user exception in getAdminState");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public void setAdminState(eAdminState eAdminState2) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
        try {
            this.adminState.set(eAdminState2);
        }
        catch (xTestAccessActive xTestAccessActive2) {
            throw new TestAccessActive((UserException)xTestAccessActive2);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xInvalidState xInvalidState2) {
            this.db.println("OchTrailAditModel.setAdminState: state = " + eAdminState2.value());
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (UserException userException) {
            this.db.severe("OchTrailAditModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public int getServiceState() throws AbstractCmsIOException {
        try {
            return ServiceStateFactory.getServiceState((sServiceState)this.serviceState.get()).getType();
        }
        catch (UserException userException) {
            this.db.severe("OchTrailAditModel: user exception in getServiceState");
            SDebug.printStackTrace((Throwable)userException);
            return -2;
        }
    }

    public IOchncPathDefModel[] getPaths() {
        try {
            return (IOchncPathDefModel[])this.paths.get();
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel: user exception in getOchncPaths");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public boolean inUse() {
        try {
            return (Boolean)this.inUse.get();
        }
        catch (UserException userException) {
            this.db.println("OchTrailAditModel: user exception in inUse");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getEntityIndex() {
        if (this.entityIndex == -1) {
            this.entityIndex = this.getPaths()[0].getPortEntityIdx();
        }
        return this.entityIndex;
    }

    @Override
    public List getPortModels() {
        return new LinkedList();
    }

    public boolean inRoll() {
        return false;
    }

    @Override
    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        return true;
    }

    public IPortModel getPortModel() {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        if (this.trunkPort == null) {
            IEntityTableModel iEntityTableModel;
            if (iOchncPathDefModelArray.length != 0) {
                try {
                    iEntityTableModel = iOchncPathDefModelArray[0].getNodeModel().getEntityTable();
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(iOchncPathDefModelArray[0].getPortEntityIdx());
                    if (iEntityModel instanceof IPortModel) {
                        this.trunkPort = (IPortModel)iEntityModel;
                    } else {
                        this.db.warning("Port Model for OchTrailAdit is not instance of IPortModel: " + iEntityModel);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.warning("Cannot get OchTrailAdit port model: " + abstractCmsNoSuchEntityException.getMessage());
                }
            }
            if (this.trunkPort != null) {
                iEntityTableModel = this.trunkPort.getInterfaceModel();
                if (this.db.on()) {
                    this.db.println("getPortModel(): adding as observer to " + iEntityTableModel);
                }
                iEntityTableModel.addObserver((Observer)this);
            }
        }
        return this.trunkPort;
    }

    @Override
    public int getShelfId() {
        IPortModel iPortModel = this.getPortModel();
        if (iPortModel != null) {
            return iPortModel.getShelfId();
        }
        return 1;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof IInterfaceModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.db.on()) {
                    this.db.println("update: type = DELETED (" + this.trunkPort + ") at " + this.getConnectionName());
                }
                if (this.trunkPort != null) {
                    this.trunkPort.deleteObserver((Observer)this);
                }
                this.trunkPort = null;
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED) && this.db.on()) {
                this.db.println("node.update: type = CHANGED (" + this.trunkPort + ") at " + this.getConnectionName());
            }
            this.setChanged();
            this.notifyObservers(object);
        } else {
            super.update(observable, object);
        }
    }

    @Override
    protected void printString(SDebug sDebug) {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        sDebug.println("Connection Type " + EnumStrings.getStrings((Object)eConnectionType.TWOWAY)[this.getConnectionType()]);
        sDebug.println("CktName =  " + this.getConnectionName());
        sDebug.println("Observers are :");
        this.printObservers();
        sDebug.println("OchTrail Adit Path = " + iOchncPathDefModelArray[0]);
    }

    private class AdminState
    extends CachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchTrailAditModel.this.getOchTrailAditRef().adminState();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchTrailAditModel.this.getOchTrailAditRef().setAdminState((eAdminState)object, eEdAdminStateCmd.EDSTATE_ED);
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState)this.value);
        }
    }

    private class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchTrailAditModel.this.getOchTrailAditRef().circuitId();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchTrailAditModel.this.getOchTrailAditRef().circuitId((sCircuitId)object);
        }
    }

    private class ConnectionName
    extends CachedValue {
        public ConnectionName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchTrailAditModel.this.getOchTrailAditRef().getConnectionName();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            OchTrailAditModel.this.getOchTrailAditRef().setConnectionName((String)object);
        }
    }

    private class ConnectionType
    extends CachedValue {
        public ConnectionType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchTrailAditModel.this.getOchTrailAditRef().connectionType();
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            OchTrailAditModel.this.getOchTrailAditRef().destroy();
            return null;
        }
    }

    private class InUse
    extends NonCachedValue {
        public InUse(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            boolean bl = OchTrailAditModel.this.getOchTrailAditRef().inUse();
            return new Boolean(bl);
        }
    }

    private class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            int n = OchTrailAditModel.this.getOchTrailAditRef().objIndex();
            return new Integer(n);
        }
    }

    private class Paths
    extends CachedValue {
        public Paths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchncPathDefModelFactory.getIOchncPathDefArray(this.node, OchTrailAditModel.this.getOchTrailAditRef().paths());
        }

        @Override
        public void setValueExternally(Object object) {
            super.setValueExternally(OchncPathDefModelFactory.getIOchncPathDefArray(this.node, (sOchncPathDef[])object));
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((IOchncPathDefModel[])this.value);
        }
    }

    private class ServiceState
    extends CachedValue {
        public ServiceState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return OchTrailAditModel.this.getOchTrailAditRef().getServiceState();
        }

        @Override
        protected Object cloneValue() {
            return CloneHelper.clone((sServiceState)this.value);
        }
    }
}

