/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eBandGridOpticalType;
import cerent.cms.idl.Common.eOpticalPortType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.IModuleModel;
import cerent.cms.ui.DwdmSide;
import java.util.Map;
import java.util.TreeMap;

public class OpticalPortType {
    private final int direction;
    private final String str;
    private final int val;
    private static Map<OptKey, OpticalPortType> ptmap = new TreeMap<OptKey, OpticalPortType>();
    private static final int OPTICS_PORT_RX = 1;
    private static final int OPTICS_PORT_TX = 2;
    private static final int OPTICS_PORT_PT = 3;
    private static final int OPTICS_PORT_BIDI = 4;
    public static final OpticalPortType ADD = new OpticalPortType(eOpticalPortType.ADD, eEqType.OTS_PORT, 1, "ADD-RX");
    public static final OpticalPortType DROP = new OpticalPortType(eOpticalPortType.DROP, eEqType.OTS_PORT, 2, "DROP-TX");
    public static final OpticalPortType BAND_RX = new OpticalPortType(eOpticalPortType.ADD, eEqType.OMS_PORT, 1, "BAND-RX");
    public static final OpticalPortType BAND_TX = new OpticalPortType(eOpticalPortType.DROP, eEqType.OMS_PORT, 2, "BAND-TX");
    public static final OpticalPortType CHAN_RX = new OpticalPortType(eOpticalPortType.ADD, eEqType.OCH_PORT, 1, "CHAN-RX");
    public static final OpticalPortType CHAN_TX = new OpticalPortType(eOpticalPortType.DROP, eEqType.OCH_PORT, 2, "CHAN-TX");
    public static final OpticalPortType IN_PASS_THROUGH = new OpticalPortType(eOpticalPortType.IN_PASS_THROUGH, 3, "PASS-THROUGH");
    public static final OpticalPortType IN_EXPRESS = new OpticalPortType(eOpticalPortType.IN_EXPRESS, 1, "EXP-RX");
    public static final OpticalPortType OUT_EXPRESS = new OpticalPortType(eOpticalPortType.OUT_EXPRESS, 2, "EXP-TX");
    public static final OpticalPortType IN_EXPRESS_A = new OpticalPortType(eOpticalPortType.IN_EXPRESS_A, 1, "EXP A-RX");
    public static final OpticalPortType OUT_EXPRESS_A = new OpticalPortType(eOpticalPortType.OUT_EXPRESS_A, 2, "EXP A-TX");
    public static final OpticalPortType IN_LINE = new OpticalPortType(eOpticalPortType.IN_LINE, 1, "LINE-RX");
    public static final OpticalPortType OUT_LINE = new OpticalPortType(eOpticalPortType.OUT_LINE, 2, "LINE-TX");
    public static final OpticalPortType IN_COM = new OpticalPortType(eOpticalPortType.IN_COM, 1, "COM-RX");
    public static final OpticalPortType OUT_COM = new OpticalPortType(eOpticalPortType.OUT_COM, 2, "COM-TX");
    public static final OpticalPortType IN_OSC = new OpticalPortType(eOpticalPortType.IN_OSC, 1, "OSC-RX");
    public static final OpticalPortType OUT_OSC = new OpticalPortType(eOpticalPortType.OUT_OSC, 2, "OSC-TX");
    public static final OpticalPortType IN_DC = new OpticalPortType(eOpticalPortType.IN_DC, 1, "DC-RX");
    public static final OpticalPortType OUT_DC = new OpticalPortType(eOpticalPortType.OUT_DC, 2, "DC-TX");
    public static final OpticalPortType IN_RAMAN = new OpticalPortType(eOpticalPortType.IN_RAMAN, 1, "RAMAN-RX");
    public static final OpticalPortType OUT_RAMAN = new OpticalPortType(eOpticalPortType.OUT_RAMAN, 2, "RAMAN-TX");
    public static final OpticalPortType IN_WRK = new OpticalPortType(eOpticalPortType.IN_WRK, 1, "W-RX");
    public static final OpticalPortType OUT_WRK = new OpticalPortType(eOpticalPortType.OUT_WRK, 2, "W-TX");
    public static final OpticalPortType IN_PROT = new OpticalPortType(eOpticalPortType.IN_PROT, 1, "P-RX");
    public static final OpticalPortType OUT_PROT = new OpticalPortType(eOpticalPortType.OUT_PROT, 2, "P-TX");
    public static final OpticalPortType EAD_BIDI = new OpticalPortType(eOpticalPortType.EAD_BIDI, 4, "EAD");
    public static final OpticalPortType AD_BIDI = new OpticalPortType(eOpticalPortType.AD_BIDI, 4, "AD");
    public static final OpticalPortType COM_BIDI = new OpticalPortType(eOpticalPortType.COM_BIDI, 4, "COM");

    private OpticalPortType(eOpticalPortType eOpticalPortType2, eEqType eEqType2, int n, String string) {
        this.direction = n;
        this.str = string;
        this.val = eOpticalPortType2.value();
        ptmap.put(new OptKey(eOpticalPortType2, eEqType2), this);
    }

    private OpticalPortType(eOpticalPortType eOpticalPortType2, int n, String string) {
        this(eOpticalPortType2, eEqType.UNKNOWN, n, string);
    }

    public static OpticalPortType get(eOpticalPortType eOpticalPortType2, eEqType eEqType2) {
        return ptmap.get(new OptKey(eOpticalPortType2, eEqType2));
    }

    public static String getOptPortNumberLabel(IModuleModel iModuleModel, int n, eBandGridOpticalType eBandGridOpticalType2) {
        if (n != 0) {
            switch (iModuleModel.getEqType()) {
                case 310: 
                case 357: {
                    if (eBandGridOpticalType2 == eBandGridOpticalType.GHz_100_ODD_GRID) {
                        return "Odd";
                    }
                    if (eBandGridOpticalType2 == eBandGridOpticalType.GHz_100_EVEN_GRID) {
                        return "Even";
                    }
                    return "";
                }
                case 311: 
                case 313: 
                case 314: {
                    return DwdmSide.getSideLabelFromOffset(n);
                }
            }
            return Integer.toString(n);
        }
        return "";
    }

    public String getTypeString() {
        return this.str;
    }

    public int value() {
        return this.val;
    }

    public boolean isPortTypeTX() {
        return this.direction == 2;
    }

    public boolean isPortTypeRX() {
        return this.direction == 1;
    }

    public boolean isPortTypePT() {
        return this.direction == 3;
    }

    public boolean isPortTypeBIDI() {
        return this.direction == 4;
    }

    private static class OptKey
    implements Comparable<OptKey> {
        private final eOpticalPortType pt;
        private final eEqType et;

        OptKey(eOpticalPortType eOpticalPortType2, eEqType eEqType2) {
            this.pt = eOpticalPortType2;
            this.et = eEqType2;
        }

        OptKey(eOpticalPortType eOpticalPortType2) {
            this(eOpticalPortType2, eEqType.UNKNOWN);
        }

        @Override
        public int compareTo(OptKey optKey) {
            int n = this.pt.value() - optKey.pt.value();
            if (n != 0 || this.et == eEqType.UNKNOWN || optKey.et == eEqType.UNKNOWN) {
                return n;
            }
            return this.et.value() - optKey.et.value();
        }

        public String toString() {
            return "OptKey " + this.pt.value() + ", " + this.et.value();
        }
    }
}

