/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.idl.Common.eBandGridOpticalType;
import cerent.cms.idl.Common.eBandOpticalType;
import cerent.cms.idl.Common.eOpticalDirection;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Equipment.OpticalPort;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eOchncRole;
import cerent.cms.idl.Equipment.sOpticalPortAttributes;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OpticsTopology.eTopologyDirection;
import cerent.cms.idl.OpticsTopology.eTopologyMask;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class OpticsPortModel
extends PortModel
implements IOpticsPortModel,
IFvOpticsPortModel {
    private static final eEqType[] supportedPorts = new eEqType[]{eEqType.OCH_PORT, eEqType.OMS_PORT, eEqType.OTS_PORT, eEqType.AOTS_PORT};
    private PortAttributes attributes;
    private PortInUse inUse;

    public OpticsPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(OpticsPortModel.class));
        this.attributes = new PortAttributes(nodeModelDelegate, "PortAttributes");
        this.inUse = new PortInUse(nodeModelDelegate, "PortInUse");
    }

    @Override
    public void dispose() {
        this.attributes.dispose();
        this.inUse.dispose();
        super.dispose();
    }

    @Override
    protected void updateLocal() {
        this.attributes.update();
        this.inUse.update();
        super.updateLocal();
    }

    @Override
    public void init() {
        super.init();
    }

    public static boolean isPortSupported(eEqType eEqType2) {
        for (eEqType eEqType3 : supportedPorts) {
            if (!eEqType3.equals(eEqType2)) continue;
            return true;
        }
        return false;
    }

    public static eEqType[] getSupportePortTypes() {
        return supportedPorts;
    }

    public AbstractOpticsLineModel getOpticsLineModel() {
        if (this.hasOpticsLineModel()) {
            return (AbstractOpticsLineModel)this.getInterfaceModel();
        }
        return null;
    }

    public boolean hasOpticsLineModel() {
        try {
            return this.getInterfaceModel() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public List getConnectionsList() {
        LinkedList linkedList = new LinkedList();
        List list = ((ConnectionModelsDelegate)this.node.getConnectionModels()).getOchncConnectionModels(this.getEntityIndex());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                linkedList.add(iterator.next());
            }
            return linkedList;
        }
        return new LinkedList();
    }

    @Override
    public final int getShelfId() {
        return this.getModuleModel().getShelfId();
    }

    @Override
    public int getSide() {
        try {
            return this.getAttributes().sideId;
        }
        catch (Exception exception) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return 0;
        }
    }

    public boolean isSidePort() {
        return this.node.getSideModels().getSideUsedByPort(this.entityIndex) != null;
    }

    public int getFeatures() throws NoSuchInterface, WrongInterfaceType {
        if (this.hasOpticsLineModel()) {
            return this.getOpticsLineModel().getFeatures();
        }
        return 0;
    }

    private sOpticalPortAttributes getAttributes() throws NoSuchEquipment, WrongPortType {
        try {
            return (sOpticalPortAttributes)this.attributes.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xWrongEquipmentType xWrongEquipmentType2) {
            throw new WrongPortType((UserException)xWrongEquipmentType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPortType", userException);
        }
    }

    public OpticalPortType getOptPortType() throws NoSuchEquipment, WrongPortType {
        return OpticalPortType.get(this.getAttributes().opticalPortType, this.getEqTypeEnum());
    }

    public String getOptPortTypeString() throws NoSuchEquipment, WrongPortType {
        OpticalPortType opticalPortType = this.getOptPortType();
        if (opticalPortType != null) {
            StringBuilder stringBuilder = new StringBuilder(opticalPortType.getTypeString());
            sOpticalPortAttributes sOpticalPortAttributes2 = this.getAttributes();
            if (sOpticalPortAttributes2.mpoNumber != 0) {
                stringBuilder.append(" " + OpticalPortType.getOptPortNumberLabel(this.getModuleModel(), sOpticalPortAttributes2.mpoNumber, sOpticalPortAttributes2.grid) + "-" + sOpticalPortAttributes2.posInMpo);
            } else if (sOpticalPortAttributes2.optPortTypeSeqNum != 0) {
                stringBuilder.append(" " + OpticalPortType.getOptPortNumberLabel(this.getModuleModel(), sOpticalPortAttributes2.optPortTypeSeqNum, sOpticalPortAttributes2.grid));
            }
            return stringBuilder.toString();
        }
        return "N/A";
    }

    public List<String> getFullPortStringPath() {
        return new EntityCellRenderer().getFullPortStringPath(this, false, false);
    }

    public boolean isOptPortTypeTX() {
        try {
            return this.getAttributes().opticalPortDirection == eOpticalDirection.TX;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public boolean isOptPortTypeRX() {
        try {
            return this.getAttributes().opticalPortDirection == eOpticalDirection.RX;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public boolean isOptPortTypePT() {
        try {
            return this.getAttributes().opticalPortDirection == eOpticalDirection.PT;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public boolean isWavelengthSupported() {
        try {
            int n = this.getWaveLength();
            return n != 174;
        }
        catch (WrongPortType wrongPortType) {
            if (this.db.on()) {
                this.db.println("Non-optical channel models do not support wavelength attributes.");
            }
            return false;
        }
    }

    public int getWaveLength() throws WrongPortType {
        try {
            return this.getAttributes().wavelength.value();
        }
        catch (Exception exception) {
            throw new WrongPortType("Non-optical channel models do not support wavelength attributes.");
        }
    }

    public String getWaveLengthString() {
        int n;
        try {
            n = this.getWaveLength();
        }
        catch (Exception exception) {
            n = 174;
        }
        return Wavelength.getWavelengthStringFromWavelength(n);
    }

    public boolean isLinePort() {
        int n = this.getEqType();
        return n == 304 || n == 305;
    }

    public boolean isBandPort() {
        int n = this.getEqType();
        return n == 307;
    }

    public boolean isChannelPort() {
        return this.isWavelengthSupported();
    }

    public boolean isOchType() {
        return this.isChannelPort();
    }

    public boolean isOchncAddPort() {
        try {
            return this.getAttributes().ochncRole == eOchncRole.OCHNC_ADD;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public boolean isOchncDropPort() {
        try {
            return this.getAttributes().ochncRole == eOchncRole.OCHNC_DROP;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public boolean isOchncLinePort() {
        try {
            return this.getAttributes().ochncRole == eOchncRole.OCHNC_LINE;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public eBandOpticalType getBand() throws NoSuchEquipment, WrongPortType {
        return this.getAttributes().band;
    }

    public String getBandString() {
        block6: {
            try {
                switch (this.getBand().value()) {
                    case 1: {
                        return "C";
                    }
                    case 2: {
                        return "L";
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "?";
    }

    public eBandGridOpticalType getGrid() throws NoSuchEquipment, WrongPortType {
        return this.getAttributes().grid;
    }

    public String getGridString() {
        block8: {
            try {
                switch (this.getGrid().value()) {
                    case 0: {
                        return "A/G";
                    }
                    case 3: {
                        return "50G";
                    }
                    case 1: {
                        return "100/O";
                    }
                    case 2: {
                        return "100/E";
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "?";
    }

    public int getMPO() throws NoSuchEquipment, WrongPortType {
        return this.getAttributes().mpoNumber;
    }

    public String getMPOString() {
        try {
            OpticalPortType opticalPortType = this.getOptPortType();
            sOpticalPortAttributes sOpticalPortAttributes2 = this.getAttributes();
            if (opticalPortType != null && sOpticalPortAttributes2.mpoNumber != 0) {
                return opticalPortType.getTypeString() + " MPO# " + OpticalPortType.getOptPortNumberLabel(this.getModuleModel(), sOpticalPortAttributes2.mpoNumber, sOpticalPortAttributes2.grid);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return "";
    }

    public int getPositionInMPO() throws NoSuchEquipment, WrongPortType {
        return this.getAttributes().posInMpo;
    }

    public boolean isOptPortColorless() {
        try {
            return this.getAttributes().isColorLess;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public boolean isInUse() throws NoSuchEquipment, WrongPortType {
        try {
            return (Boolean)this.inUse.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xWrongEquipmentType xWrongEquipmentType2) {
            throw new WrongPortType((UserException)xWrongEquipmentType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isInUse", userException);
        }
    }

    public boolean isPassivePort() {
        return this.getModuleModel() instanceof PassiveModuleModel;
    }

    public int getPassiveModuleID() {
        IModuleModel iModuleModel = this.getModuleModel();
        if (iModuleModel instanceof PassiveModuleModel) {
            return ((PassiveModuleModel)iModuleModel).getID();
        }
        return 0;
    }

    public int[] getReversePortList() throws NoSuchEquipment, WrongPortType {
        return this.node.getOpticalPatchCordModel().getReversePort(this.getIndex());
    }

    public IEntityModel[] getReversePortModels() throws NoSuchEquipment, WrongPortType, AbstractCmsNoSuchEntityException {
        int[] nArray = this.getReversePortList();
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        EntityTableModel entityTableModel = this.node.getEntityTableModel();
        for (int n : nArray) {
            if (n == 0) continue;
            arrayList.add(entityTableModel.getEntityModelByIndex(n));
        }
        return arrayList.toArray(new IEntityModel[0]);
    }

    private List<IPortModel> getPortTopology(eWavelength eWavelength2, eTopologyDirection eTopologyDirection2, eTopologyMask eTopologyMask2) {
        try {
            if (eWavelength2 == eWavelength.WV_UNKNOWN && (eWavelength2 = this.getAttributes().wavelength) == eWavelength.WV_UNKNOWN) {
                eWavelength2 = eWavelength.WV_AUTOPROV;
            }
            return this.getPortTopology(this.getAttributes().opticalPortDirection, eWavelength2, eTopologyDirection2, eTopologyMask2);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return new ArrayList<IPortModel>();
        }
    }

    @Override
    public List<IPortModel> getNextLogicalPorts() {
        return this.getPortTopology(eWavelength.WV_UNKNOWN, eTopologyDirection.FORWARD, eTopologyMask.TOPO_MASK_INTERFACE);
    }

    @Override
    public List<IPortModel> getNextLogicalPorts(int n) {
        return this.getPortTopology(eWavelength.from_int(n), eTopologyDirection.FORWARD, eTopologyMask.TOPO_MASK_INTERFACE);
    }

    @Override
    public List<IPortModel> getNextPhysicalPorts() {
        return this.getPortTopology(eWavelength.WV_UNKNOWN, eTopologyDirection.FORWARD, eTopologyMask.TOPO_MASK_ALL);
    }

    @Override
    public List<IPortModel> getNextPhysicalPorts(int n) {
        return this.getPortTopology(eWavelength.from_int(n), eTopologyDirection.FORWARD, eTopologyMask.TOPO_MASK_ALL);
    }

    @Override
    public List<IPortModel> getPrevLogicalPorts() {
        return this.getPortTopology(eWavelength.WV_UNKNOWN, eTopologyDirection.BACKWARD, eTopologyMask.TOPO_MASK_INTERFACE);
    }

    @Override
    public List<IPortModel> getPrevLogicalPorts(int n) {
        return this.getPortTopology(eWavelength.from_int(n), eTopologyDirection.BACKWARD, eTopologyMask.TOPO_MASK_INTERFACE);
    }

    @Override
    public List<IPortModel> getPrevPhysicalPorts() {
        return this.getPortTopology(eWavelength.WV_UNKNOWN, eTopologyDirection.BACKWARD, eTopologyMask.TOPO_MASK_ALL);
    }

    @Override
    public List<IPortModel> getPrevPhysicalPorts(int n) {
        return this.getPortTopology(eWavelength.from_int(n), eTopologyDirection.BACKWARD, eTopologyMask.TOPO_MASK_ALL);
    }

    private OpticalPort getOpticalPortRef() {
        return this.getNodeModelDelegate().getIorRepository().getOpticalPortRef();
    }

    private String getDirectionString() {
        try {
            switch (this.getAttributes().opticalPortDirection.value()) {
                case 2: {
                    return "PT";
                }
                case 0: {
                    return "RX";
                }
                case 1: {
                    return "TX";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private String getOchncRoleString() {
        try {
            switch (this.getAttributes().ochncRole.value()) {
                case 0: {
                    return "ADD";
                }
                case 1: {
                    return "DROP";
                }
                case 2: {
                    return "LINE";
                }
                case 3: {
                    return "INTERNAL";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public String toString() {
        return "OpticsPortModel-" + super.toString() + "-" + this.getDirectionString() + "-" + this.getOchncRoleString() + "-" + this.getSideString() + "-{" + this.getGridString() + "," + this.getBandString() + "," + this.getNumberOfWavelengths() + "}";
    }

    public boolean isLineOptPort() throws NoSuchEquipment, WrongPortType {
        OpticalPortType opticalPortType = this.getOptPortType();
        return opticalPortType == OpticalPortType.IN_LINE || opticalPortType == OpticalPortType.OUT_LINE;
    }

    public boolean isDCPort() throws NoSuchEquipment, WrongPortType {
        OpticalPortType opticalPortType = this.getOptPortType();
        return opticalPortType == OpticalPortType.IN_DC || opticalPortType == OpticalPortType.OUT_DC;
    }

    public boolean isPPMeshPort() {
        return this.getCardModel().getEqType() == 314 || this.getCardModel().getEqType() == 313 || this.getCardModel().getEqType() == 311;
    }

    public Attribute[] getSupportedWavelengths() {
        return this.getSupportedWavelengths(false);
    }

    public Attribute[] getSupportedWavelengths(boolean bl) {
        int n = this.getWavelengthBand();
        int n2 = this.getWavelengthOddity();
        int n3 = this.getNumberOfWavelengths();
        return Wavelength.getWavelengthAttrs(n, n2, n3, bl);
    }

    public int getWavelengthBand() {
        block6: {
            try {
                switch (this.getBand().value()) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return 2;
    }

    public int getWavelengthOddity() {
        int n;
        block6: {
            n = 2;
            try {
                switch (this.getGrid().value()) {
                    case 1: {
                        n = 0;
                        break;
                    }
                    case 2: {
                        n = 1;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n;
    }

    public int getNumberOfWavelengths() {
        int n;
        block7: {
            n = 0;
            try {
                switch (this.getAttributes().maxSupportedWl.value()) {
                    case 1: {
                        n = 32;
                        break;
                    }
                    case 2: {
                        n = 40;
                        break;
                    }
                    case 3: {
                        n = 80;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n;
    }

    private class PortAttributes
    extends CachedValue {
        private PortAttributes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return OpticsPortModel.this.getOpticalPortRef().getAttributes(OpticsPortModel.this.entityIndex);
        }
    }

    private class PortInUse
    extends CachedValue {
        private PortInUse(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return OpticsPortModel.this.getOpticalPortRef().inUse(OpticsPortModel.this.entityIndex);
        }
    }
}

