/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eOpticalDirection;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.eTopologyDirection;
import cerent.cms.idl.OpticsTopology.eTopologyMask;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISonetStsModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RanSvcModuleModel;
import cerent.cms.model.SimpleMuxIndex;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PortModel
extends EntityModel
implements IPortModel,
IFvPortModel {
    private InterfaceModels ifModels;
    protected int[] portNum;
    private final PortTopology topology;

    public PortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(PortModel.class));
    }

    public PortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
        this.ifModels = nodeModelDelegate.getIfModels();
        this.topology = new PortTopology(nodeModelDelegate, "PortTopology");
        if (this.db.on()) {
            this.db.println("PortModel.<init>");
        }
    }

    @Override
    public void init() {
        if (this.db.on()) {
            this.db.println("init");
        }
        super.init();
    }

    @Override
    public void dispose() {
        this.topology.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        if (this.ifModels != null) {
            this.ifModels.deleteInterfaces(this.getChassis(), this);
        }
        super.destroy();
        this.ifModels = null;
    }

    @Override
    protected void updateLocal() {
        this.topology.update();
        super.updateLocal();
    }

    public IInterfaceModel getInterfaceModel() {
        InterfaceModel interfaceModel = null;
        if (this.ifModels != null) {
            interfaceModel = this.ifModels.getInterfaceModel(this);
        }
        if (interfaceModel == null) {
            throw new CmsObjectNotExistException("The line interface for the index " + Integer.toHexString(this.getIndex()) + " could not be found.");
        }
        return interfaceModel;
    }

    @Override
    public List getConnectionsList() {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            return interfaceModel.getConnectionsList();
        }
        return new LinkedList();
    }

    public boolean isOptical() {
        return false;
    }

    public boolean hasOpticalProtection() {
        return false;
    }

    public boolean isSpecial() {
        return false;
    }

    public int getAdminState() throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            return interfaceModel.getAdminState();
        }
        return -1;
    }

    public int getServiceStateType() throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            if (this.getModuleModel() instanceof RanSvcModuleModel) {
                return interfaceModel.getServiceSt().equals(0) ? 100 : 101;
            }
            return interfaceModel.getServiceSt().getType();
        }
        return -1;
    }

    public eAdminState getAdminStateEnum() throws NoSuchInterface {
        return eAdminState.from_int(this.getAdminState());
    }

    private int getNumberOfCircuits() throws NoSuchInterface {
        int n;
        int n2 = 0;
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            n2 = interfaceModel.getNumberOfCircuitInterfaces();
            this.db.info(this.node.getName() + ": candidate: number of circuit interfaces: " + n2);
        }
        if ((n = n2) > 0) {
            n = this.getConnectionsList().size();
            this.db.info(this.node.getName() + ": candidate: number of circuits: " + n);
        }
        this.db.info(this.node.getName() + ": final number of circuits: " + n);
        return n;
    }

    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        InterfaceModel interfaceModel;
        int n4;
        if (this.getModuleModel() instanceof RanSvcModuleModel) {
            this.db.info("maybeSetAdminState(): cannot set state - RAN_SVC");
            return false;
        }
        int n5 = this.getAdminState();
        this.db.info("PortModel" + this + ".maybeSetAdminState(): targetState: " + n + ", current state: " + n5 + ", policy: " + n2 + ", circuitSize: " + n3);
        if (n5 == n) {
            return true;
        }
        if (n != 0 && n5 != 1) {
            if (this.isTimingSource()) {
                this.db.info(this.node.getName() + ": maybeSetAdminState: cannot set state - port is timing source");
                return false;
            }
            n4 = this.getNumberOfCircuits();
            if (n2 == 2) {
                if (n4 > 1) {
                    this.db.info(this.node.getName() + ": maybeSetAdminState: cannot set state - port has other circuits");
                    n = -1;
                }
            } else if (n4 > 0) {
                this.db.info(this.node.getName() + ": maybeSetAdminState: cannot set state - port has circuits");
                n = -1;
            }
        }
        n4 = 0;
        if (n != -1 && (interfaceModel = (InterfaceModel)this.getInterfaceModel()) != null) {
            this.db.info(this.node.getName() + ": maybeSetAdminState: passing on to NE");
            interfaceModel.setAdminState(n);
            n4 = 1;
        }
        return n4 != 0;
    }

    public boolean setAdminState(int n) throws Exception {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            interfaceModel.setAdminState(n);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Port[" + super.toShortString() + "]";
    }

    public ITdmHoModel getTdmHoModel(IHoNum iHoNum) {
        int n;
        boolean bl = false;
        if (this.getModuleModel().getEqType() == 145 && (n = this.getPort()) > 12 && n % 2 == 0) {
            bl = true;
        }
        n = iHoNum == null ? (short)0 : iHoNum.getIdlHoNum();
        try {
            boolean bl2 = this.isOptical();
            InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
            while (interfaceModel != null) {
                InterfaceModel[] interfaceModelArray = interfaceModel.getHigherLayerModels();
                if (this.db.on()) {
                    this.db.println("IntModel: " + interfaceModel);
                    this.db.println("IntModel Class: " + interfaceModel.getClass());
                    if (interfaceModelArray != null && interfaceModelArray.length > 0) {
                        this.db.println("higher[0]: " + interfaceModelArray[0]);
                        this.db.println("higher is tdmHomodel? " + (interfaceModelArray[0] instanceof ITdmHoModel));
                        this.db.println("higher/length: " + interfaceModelArray.length);
                        this.db.println("seeking STS: " + n);
                    }
                }
                if (interfaceModelArray == null || interfaceModelArray.length == 0) {
                    if (this.db.on()) {
                        this.db.println("getTdmHoModel:ran out of higher interfaces!");
                    }
                    break;
                }
                if (bl) {
                    return (ITdmHoModel)interfaceModelArray[interfaceModelArray.length - 1];
                }
                if (interfaceModelArray[0] instanceof ITdmHoModel) {
                    if (bl2) {
                        for (int i = 0; i < interfaceModelArray.length; ++i) {
                            int n2 = interfaceModelArray[i].getInfo().muxIndex;
                            if (this.db.on()) {
                                this.db.print(this.getChassis().getNodeModel().getHostName() + ", " + this.getSlot() + "/" + PortHelper.getConcatenatedString((int[])this.getPortNum()));
                                this.db.println("sonet model #" + i + " maps to STS #" + n2 + " (want " + n + ")");
                            }
                            if (n2 != n) continue;
                            return (ITdmHoModel)interfaceModelArray[i];
                        }
                    } else {
                        if (interfaceModelArray.length > 1) {
                            if (this.db.on()) {
                                this.db.println("more than one TdmHoModel mapped to by a non-optical port model: " + interfaceModelArray.length);
                            }
                            break;
                        }
                        if (this.db.on()) {
                            this.db.print(this.getChassis().getNodeModel().getHostName() + ", " + this.getSlot() + "/" + PortHelper.getConcatenatedString((int[])this.getPortNum()));
                            this.db.println("sonet model <0> --> STS " + n);
                        }
                        return (ITdmHoModel)interfaceModelArray[0];
                    }
                }
                if (this.db.on()) {
                    this.db.println("Going higher.");
                }
                interfaceModel = interfaceModelArray[0];
            }
        }
        catch (Exception exception) {
            this.db.println("Caught exception in getTdmHoModel");
            SDebug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public ISonetStsModel getSonetStsModel(int n) {
        throw new DeprecatedMethodCalled("FTG deprecated ConnectionModelsDelegate.getStsStsModel(int sts)");
    }

    public boolean isInLoopback() {
        return false;
    }

    public boolean supportsMonitorCircuits() {
        int n = this.getEqType();
        return n != eEqType.ETHER_10_100_T.value() && n != eEqType.ETHER_1000_F.value() && n != eEqType.EPOS_100_LINE_CARD.value() && n != eEqType.EPOS_1000_LINE_CARD.value();
    }

    public boolean supportsSplitRouting() {
        return false;
    }

    public void supportsLoCircuitsCheck() throws WrongPortType {
        int n = this.getEqType();
        if (this.node.getTdmProtocolTypeObj().isSdh()) {
            if (n != eEqType.E1_PORT.value() && n != eEqType.E3_PORT.value() && n != eEqType.DS1_VT_MAPPED.value() && n != eEqType.DS3I_PORT.value() && n != eEqType.DS3.value()) {
                throw new WrongPortType("This port type does not support LO circuits.");
            }
        } else {
            IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
            if (!(n == eEqType.DS1_VT_MAPPED.value() || n == eEqType.DS3_TRANS_MUX.value() || n == eEqType.EC1_PORT.value() && iPlatform.supportsJ2PathTraceOnEc1())) {
                throw new WrongPortType("This port type does not support LO circuits.");
            }
        }
    }

    private boolean isTransMux() {
        int n = this.getEqType();
        return this.node.getTdmProtocolTypeObj().isSonet() && n == eEqType.DS3_TRANS_MUX.value();
    }

    public ITdmLoModel getTdmLoModel(ILoNum iLoNum) throws WrongPortType {
        int n = 0;
        if (this.isTransMux()) {
            n = iLoNum.getIdlFlatNum() - 1;
        }
        this.supportsLoCircuitsCheck();
        try {
            InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
            while (interfaceModel != null) {
                InterfaceModel[] interfaceModelArray = interfaceModel.getHigherLayerModels();
                if (interfaceModelArray == null || interfaceModelArray.length == 0) {
                    if (this.db.on()) {
                        this.db.println("getTdmLoModel:ran out of higher interfaces!");
                    }
                    break;
                }
                if (interfaceModelArray[0] instanceof ITdmLoModel) {
                    IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
                    if (interfaceModelArray.length == 1 && !iPlatform.supportsJ2PathTraceOnEc1()) {
                        return (ITdmLoModel)interfaceModelArray[0];
                    }
                    if (!iPlatform.supportsJ2PathTraceOnEc1()) {
                        if (this.db.on()) {
                            this.db.println("more than one TdmLoModel mapped to a non-optical port model and no J2 support on EC1 ports: " + interfaceModelArray.length);
                        }
                        break;
                    }
                    if (this.db.on()) {
                        this.db.println("J2 supported on EC1 ports, find TdmLoModel in TdmLoModel[" + interfaceModelArray.length + "]");
                    }
                    for (int i = 0; i < interfaceModelArray.length; ++i) {
                        int n2 = new SimpleMuxIndex(interfaceModelArray[i]).getExternalMuxIndex();
                        if (iLoNum.getIdlFlatNum() != n2) continue;
                        if (this.db.on) {
                            this.db.println("ILoNum.flatNum= " + iLoNum.getIdlFlatNum() + " SimpleMuxIndex.muxIndex= " + n2 + ", returning " + interfaceModelArray[i].toString());
                        }
                        return (ITdmLoModel)interfaceModelArray[i];
                    }
                }
                interfaceModel = interfaceModelArray[n];
            }
        }
        catch (Exception exception) {
            this.db.println("Caught exception in getTdmHoModel");
            KDebug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public int[] getPortNum() {
        if (this.portNum == null) {
            this.portNum = PluggableHelper.getHierarchyNums(this);
        }
        return this.portNum;
    }

    public boolean isMutable() {
        ModuleModel moduleModel = (ModuleModel)this.getModuleModel();
        if (moduleModel instanceof PluggableCarrierModel) {
            return true;
        }
        if (moduleModel != null) {
            return moduleModel.isComboModule() && !moduleModel.isProtectModule();
        }
        return false;
    }

    public boolean isPortNumUnique() {
        ModuleModel moduleModel = (ModuleModel)this.getModuleModel();
        return moduleModel != null && moduleModel.isPortNumUnique(this.getEqType());
    }

    public boolean isTimingSource() throws NoSuchInterface {
        return this.getChassis().getSyncModel().isTimingSource(this.getIndex());
    }

    private DwdmOpticalSetup getDwdmOpticalSetupRef() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmOpticalSetupRef();
    }

    protected List<IPortModel> getPortTopology(eOpticalDirection eOpticalDirection2, eWavelength eWavelength2, eTopologyDirection eTopologyDirection2, eTopologyMask eTopologyMask2) {
        ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
        try {
            int[] nArray;
            Object[] objectArray = new Object[]{new Integer(this.getEntityIndex()), eOpticalDirection2, eWavelength2, eTopologyDirection2, eTopologyMask2};
            for (int n : nArray = (int[])this.topology.get(objectArray)) {
                arrayList.add((IPortModel)this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n));
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return arrayList;
    }

    public List<IPortModel> getNextLogicalPorts() {
        return new ArrayList<IPortModel>();
    }

    public List<IPortModel> getNextLogicalPorts(int n) {
        return this.getNextLogicalPorts();
    }

    public List<IPortModel> getNextPhysicalPorts() {
        return new ArrayList<IPortModel>();
    }

    public List<IPortModel> getNextPhysicalPorts(int n) {
        return this.getNextPhysicalPorts();
    }

    public List<IPortModel> getPrevLogicalPorts() {
        return new ArrayList<IPortModel>();
    }

    public List<IPortModel> getPrevLogicalPorts(int n) {
        return this.getPrevLogicalPorts();
    }

    public List<IPortModel> getPrevPhysicalPorts() {
        return new ArrayList<IPortModel>();
    }

    public List<IPortModel> getPrevPhysicalPorts(int n) {
        return this.getPrevPhysicalPorts();
    }

    public List findFramingCRC() throws Exception {
        boolean bl = true;
        int n = 2;
        boolean bl2 = true;
        int n2 = 2;
        int n3 = 3;
        boolean bl3 = bl;
        int n4 = this.getModuleModel().getEqType();
        List<Integer> list = new ArrayList<Integer>();
        int n5 = this.getPortNum()[0];
        switch (n4) {
            case 273: {
                int n6 = this.getEqType();
                if (n6 != 167) {
                    list.add(0);
                    list.add(0);
                    break;
                }
                HdGeLineModel hdGeLineModel = (HdGeLineModel)this.getInterfaceModel();
                list = hdGeLineModel.getPortFramingCrcEncap(n5);
                break;
            }
            case 163: 
            case 229: 
            case 283: 
            case 284: {
                ML2PosLineModel mL2PosLineModel = ((ML2ModuleModel)this.getModuleModel()).getPosLineModels()[n5 - 1];
                list = mL2PosLineModel.getPortFramingCrcEncap(n5);
                break;
            }
            case 102: 
            case 103: 
            case 221: {
                list.add(n);
                list.add(n3);
                break;
            }
            case 62: {
                HdGeLineModel hdGeLineModel = (HdGeLineModel)((HdGeModuleModel)this.getModuleModel()).getLines()[n5 - 1];
                list = hdGeLineModel.getPortFramingCrcEncap(n5);
                break;
            }
            default: {
                list.add(new Integer(0));
                list.add(new Integer(0));
            }
        }
        return list;
    }

    public IFvCardModel getCardModel() {
        return (IFvCardModel)this.getModuleModel();
    }

    public IFvInterfaceModel getIFvInterfaceModel() {
        return (IFvInterfaceModel)this.getInterfaceModel();
    }

    @Override
    public IFvEntityModel getParentModel() {
        return this.getParent();
    }

    private ElementModel getElementModel(InterfaceModel interfaceModel) throws AbstractCmsNoSuchElementException {
        ElementModel elementModel = null;
        if (interfaceModel != null) {
            try {
                elementModel = interfaceModel.getElementModel();
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                InterfaceModel interfaceModel2 = interfaceModel.getHighestParent();
                if (interfaceModel2 != null && interfaceModel2 != interfaceModel) {
                    elementModel = interfaceModel2.getElementModel();
                }
                throw abstractCmsNoSuchElementException;
            }
        }
        return elementModel;
    }

    private boolean isInService() throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            int n = interfaceModel.getAdminState();
            return 1 != n && n != -1;
        }
        return false;
    }

    public boolean shouldCrossHatchPort() {
        try {
            ElementModel elementModel = this.getElementModel((InterfaceModel)this.getInterfaceModel());
            if (elementModel != null) {
                return this.isInService() && elementModel.getTypeEnum() != eElementType.UNPROTECTED_LINE;
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
        }
        catch (NoSuchInterface noSuchInterface) {
            // empty catch block
        }
        return false;
    }

    public IFvNodeModel getIFvNodeModel() {
        return super.getNodeModelDelegate().getFvNodeModelDelegate();
    }

    public List<IFvPortModel> getIFVNextPorts(boolean bl) {
        List<IPortModel> list = bl ? this.getNextPhysicalPorts() : this.getNextLogicalPorts();
        ArrayList<IFvPortModel> arrayList = new ArrayList<IFvPortModel>();
        for (IPortModel iPortModel : list) {
            IPortModel iPortModel2 = iPortModel;
            if (iPortModel2 == null) continue;
            arrayList.add((IFvPortModel)iPortModel2);
        }
        return arrayList;
    }

    public List<IFvPortModel> getIFVPrevPorts(boolean bl) {
        List<IPortModel> list = bl ? this.getPrevPhysicalPorts() : this.getPrevLogicalPorts();
        ArrayList<IFvPortModel> arrayList = new ArrayList<IFvPortModel>();
        for (IPortModel iPortModel : list) {
            IPortModel iPortModel2 = iPortModel;
            if (iPortModel2 == null) continue;
            arrayList.add((IFvPortModel)iPortModel2);
        }
        return arrayList;
    }

    public boolean isClientPort() {
        return false;
    }

    public String getProtectionDescription(IFvInterfaceModel iFvInterfaceModel) {
        StringBuffer stringBuffer = new StringBuffer();
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
        if (iFvInterfaceModel instanceof TdmLineModel) {
            stringBuffer.append(entityCellRenderer.getSonetLineProtectionDescription((TdmLineModel)iFvInterfaceModel, true));
        }
        return stringBuffer.toString();
    }

    public String getPortString() {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
        return entityCellRenderer.getPortString(this, false);
    }

    public String getServiceStateDescription(int n) {
        TDMTerminology tDMTerminology = this.getNodeModel().getTDMTerminology();
        return tDMTerminology.getTermForServiceState(n);
    }

    public List<IFvPortModel> getIFvNextPhysicalPorts(int n) {
        List<IPortModel> list = this.getNextPhysicalPorts(n);
        ArrayList<IFvPortModel> arrayList = new ArrayList<IFvPortModel>();
        for (IPortModel iPortModel : list) {
            arrayList.add((IFvPortModel)iPortModel);
        }
        return arrayList;
    }

    public List<IFvPortModel> getIFvPrevPhysicalPorts(int n) {
        List<IPortModel> list = this.getPrevPhysicalPorts(n);
        ArrayList<IFvPortModel> arrayList = new ArrayList<IFvPortModel>();
        for (IPortModel iPortModel : list) {
            arrayList.add((IFvPortModel)iPortModel);
        }
        return arrayList;
    }

    public List<IFvPortModel> getIFvNextLogicalPorts(int n) {
        List<IPortModel> list = this.getNextLogicalPorts(n);
        ArrayList<IFvPortModel> arrayList = new ArrayList<IFvPortModel>();
        for (IPortModel iPortModel : list) {
            arrayList.add((IFvPortModel)iPortModel);
        }
        return arrayList;
    }

    public List<IFvPortModel> getIFvPrevLogicalPorts(int n) {
        List<IPortModel> list = this.getPrevLogicalPorts(n);
        ArrayList<IFvPortModel> arrayList = new ArrayList<IFvPortModel>();
        for (IPortModel iPortModel : list) {
            arrayList.add((IFvPortModel)iPortModel);
        }
        return arrayList;
    }

    private class PortTopology
    extends NonCachedValue {
        private PortTopology(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            eOpticalDirection eOpticalDirection2 = (eOpticalDirection)objectArray[1];
            eWavelength eWavelength2 = (eWavelength)objectArray[2];
            eTopologyDirection eTopologyDirection2 = (eTopologyDirection)objectArray[3];
            eTopologyMask eTopologyMask2 = (eTopologyMask)objectArray[4];
            return PortModel.this.getDwdmOpticalSetupRef().getTopologyPorts(n, eOpticalDirection2, eWavelength2, eTopologyDirection2, eTopologyMask2);
        }
    }
}

