/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Node.NetworkConfig;
import cerent.cms.idl.Node.sRadiusClient;
import cerent.cms.idl.Node.sRadiusServer;
import cerent.cms.idl.Node.xConfigError;
import cerent.cms.idl.Node.xDupRadiusServer;
import cerent.cms.idl.Node.xEmptyAaaServerList;
import cerent.cms.idl.Node.xInvalidOperation;
import cerent.cms.idl.Node.xMaxRadiusServers;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DuplicateRadiusServerException;
import cerent.cms.model.EmptyAaaServerListException;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.MaxRadiusServersExceededException;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.RadiusServer;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class RadiusServerModel
extends Model {
    private RadiusServerList radiusServerList;
    private AppendRadiusServer appendRadiusServer;
    private DeleteRadiusServerList deleteRadiusServerList;
    private AAAServerAuthentication aaaServerAuthentication;
    private AAAServerAccounting aaaServerAccounting;
    private UseDbIfNoRemoteServer useDbIfNoRemoteServer;
    private RadiusClientConfig radiusClientConfig;
    private NodeModelDelegate nmd;
    private static NodeSingletonFactory<RadiusServerModel> sfactory = new NodeSingletonFactory<RadiusServerModel>(RadiusServerModel.class);
    private EventDispatcher dispatcher;

    public static RadiusServerModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public static int getMaxRadiusServers() {
        return 10;
    }

    public static int getMaxSecretLength() {
        return 128;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    private RadiusServerModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(RadiusServerModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.radiusServerList = new RadiusServerList(this.nmd, "RadiusServerModel.RadiusServerList");
        this.appendRadiusServer = new AppendRadiusServer(this.nmd, "RadiusServerModel.AppendRadiusServer");
        this.deleteRadiusServerList = new DeleteRadiusServerList(this.nmd, "RadiusServerModel.DeleteRadiusServerList");
        this.aaaServerAuthentication = new AAAServerAuthentication(this.nmd, "RadiusServerModel.AAAServerAuthentication");
        this.aaaServerAccounting = new AAAServerAccounting(this.nmd, "RadiusServerModel.AAAServerAccounting");
        this.useDbIfNoRemoteServer = new UseDbIfNoRemoteServer(this.nmd, "RadiusServerModel.UseDbIfNoRemoteSever");
        this.radiusClientConfig = new RadiusClientConfig(this.nmd, "RadiusServerModel.RadiusClientConfig");
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSystem, 1, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter RadiusServerModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSystem, 1, (Observer)this);
        }
        this.radiusServerList.dispose();
        this.aaaServerAuthentication.dispose();
        this.aaaServerAccounting.dispose();
        this.useDbIfNoRemoteServer.dispose();
        this.radiusClientConfig.dispose();
        super.dispose();
        if (this.db.on) {
            this.db.println("Exit RadiusServerModel dispose()");
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("RadiusServerModel Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("RadiusServerModel update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    @Override
    protected void updateLocal() {
        this.radiusServerList.update();
        this.aaaServerAuthentication.update();
        this.aaaServerAccounting.update();
        this.useDbIfNoRemoteServer.update();
        this.radiusClientConfig.update();
        this.setChanged();
        super.updateLocal();
    }

    public RadiusServer[] getRadiusServerList() {
        sRadiusServer[] sRadiusServerArray = this.getNeRadiusServerList();
        if (sRadiusServerArray != null) {
            RadiusServer[] radiusServerArray = new RadiusServer[sRadiusServerArray.length];
            for (int i = 0; i < radiusServerArray.length; ++i) {
                sRadiusServer sRadiusServer2 = sRadiusServerArray[i];
                byte[] byArray = new byte[sRadiusServer2.secretLen];
                System.arraycopy(sRadiusServer2.secret, 0, byArray, 0, sRadiusServer2.secretLen);
                radiusServerArray[i] = new RadiusServer(IpAddrFactory.getIIpAddr(sRadiusServer2.serverIp), sRadiusServer2.authPort, sRadiusServer2.acctPort, byArray);
            }
            return radiusServerArray;
        }
        return null;
    }

    public sRadiusServer[] getNeRadiusServerList() {
        try {
            return (sRadiusServer[])this.radiusServerList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setRadiusServerList(RadiusServer[] radiusServerArray) throws MaxRadiusServersExceededException, DuplicateRadiusServerException, ConfigError, EmptyAaaServerListException {
        sRadiusServer[] sRadiusServerArray = new sRadiusServer[radiusServerArray.length];
        for (int i = 0; i < sRadiusServerArray.length; ++i) {
            sRadiusServerArray[i] = this.getsRadiusServerFrom(radiusServerArray[i]);
        }
        this.setNeRadiusServerList(sRadiusServerArray);
    }

    public void setNeRadiusServerList(sRadiusServer[] sRadiusServerArray) throws MaxRadiusServersExceededException, DuplicateRadiusServerException, ConfigError, EmptyAaaServerListException {
        try {
            this.radiusServerList.set(sRadiusServerArray);
        }
        catch (xMaxRadiusServers xMaxRadiusServers2) {
            throw new MaxRadiusServersExceededException((Throwable)((Object)xMaxRadiusServers2));
        }
        catch (xDupRadiusServer xDupRadiusServer2) {
            throw new DuplicateRadiusServerException((Throwable)((Object)xDupRadiusServer2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xEmptyAaaServerList xEmptyAaaServerList2) {
            throw new EmptyAaaServerListException((Throwable)((Object)xEmptyAaaServerList2));
        }
        catch (UserException userException) {
            throw this.doUnknown("setNeRadiusServerList", userException);
        }
    }

    public void appendToRadiusServerList(RadiusServer radiusServer) throws MaxRadiusServersExceededException, DuplicateRadiusServerException, ConfigError {
        this.appendToNeRadiusServerList(this.getsRadiusServerFrom(radiusServer));
    }

    public void appendToNeRadiusServerList(sRadiusServer sRadiusServer2) throws MaxRadiusServersExceededException, DuplicateRadiusServerException, ConfigError {
        try {
            this.appendRadiusServer.set(sRadiusServer2);
        }
        catch (xMaxRadiusServers xMaxRadiusServers2) {
            throw new MaxRadiusServersExceededException((Throwable)((Object)xMaxRadiusServers2));
        }
        catch (xDupRadiusServer xDupRadiusServer2) {
            throw new DuplicateRadiusServerException((Throwable)((Object)xDupRadiusServer2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("appendToNeRadiusServerList", userException);
        }
    }

    sRadiusServer getsRadiusServerFrom(RadiusServer radiusServer) {
        byte[] byArray = new byte[128];
        short s = radiusServer.getSecretLength();
        s = s < byArray.length ? s : (short)byArray.length;
        System.arraycopy(radiusServer.getSecret(), 0, byArray, 0, s);
        return new sRadiusServer(new sIpAddr(radiusServer.getIpAddr().getAddr()), (short)radiusServer.getAuthPort(), (short)radiusServer.getAcctPort(), byArray, s);
    }

    public void deleteRadiusServerList() throws EmptyAaaServerListException {
        try {
            this.deleteRadiusServerList.set();
        }
        catch (xEmptyAaaServerList xEmptyAaaServerList2) {
            throw new EmptyAaaServerListException((Throwable)((Object)xEmptyAaaServerList2));
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteRadiusServerList", userException);
        }
    }

    public boolean getAAAServerAuthentication() {
        try {
            return (Boolean)this.aaaServerAuthentication.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setAAAServerAuthentication(boolean bl) throws EmptyAaaServerListException {
        try {
            this.aaaServerAuthentication.set(new Boolean(bl));
        }
        catch (xEmptyAaaServerList xEmptyAaaServerList2) {
            throw new EmptyAaaServerListException((Throwable)((Object)xEmptyAaaServerList2));
        }
        catch (UserException userException) {
            throw this.doUnknown("setAAAServerAuthentication", userException);
        }
    }

    public boolean getAAAServerAccounting() {
        try {
            return (Boolean)this.aaaServerAccounting.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setAAAServerAccounting(boolean bl) throws InvalidOperation {
        try {
            this.aaaServerAccounting.set(new Boolean(bl));
        }
        catch (xInvalidOperation xInvalidOperation2) {
            throw new InvalidOperation((UserException)xInvalidOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setAAAServerAccounting", userException);
        }
    }

    public boolean getUseLocalDatabase() {
        try {
            return (Boolean)this.useDbIfNoRemoteServer.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setUseLocalDatabase(boolean bl) {
        try {
            this.useDbIfNoRemoteServer.set(new Boolean(bl));
        }
        catch (UserException userException) {
            throw this.doUnknown("setUseLocalDatabase", userException);
        }
    }

    public boolean getClientChallengeResponse() {
        try {
            sRadiusClient sRadiusClient2 = (sRadiusClient)this.radiusClientConfig.get();
            return sRadiusClient2.chalRspEn;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setClientChallengeResponse(boolean bl) {
        try {
            this.radiusClientConfig.set(new sRadiusClient(bl));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw this.doUnknown("setClientChallengeResponse", userException);
        }
    }

    private NetworkConfig getNodeNetRef() {
        return this.nmd.getIorRepository().getNodeNetRef();
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    class AAAServerAccounting
    extends CachedValue {
        public AAAServerAccounting(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return new Boolean(RadiusServerModel.this.getNodeNetRef().getAaaServerAccounting());
        }

        @Override
        protected void setValue(Object object) throws xInvalidOperation {
            RadiusServerModel.this.getNodeNetRef().setAaaServerAccounting((Boolean)object);
        }

        public Object outer() {
            return RadiusServerModel.this;
        }
    }

    class AAAServerAuthentication
    extends CachedValue {
        public AAAServerAuthentication(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return new Boolean(RadiusServerModel.this.getNodeNetRef().getAaaServerAuthentication());
        }

        @Override
        protected void setValue(Object object) throws xEmptyAaaServerList {
            RadiusServerModel.this.getNodeNetRef().setAaaServerAuthentication((Boolean)object);
        }

        public Object outer() {
            return RadiusServerModel.this;
        }
    }

    class AppendRadiusServer
    extends NonCachedValue {
        public AppendRadiusServer(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xMaxRadiusServers, xDupRadiusServer, xConfigError {
            RadiusServerModel.this.getNodeNetRef().appendToRadiusServerList((sRadiusServer)object);
        }

        public Object outer() {
            return RadiusServerModel.this;
        }
    }

    class DeleteRadiusServerList
    extends NonCachedValue {
        public DeleteRadiusServerList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws xEmptyAaaServerList {
            RadiusServerModel.this.getNodeNetRef().deleteRadiusServerList();
        }

        public Object outer() {
            return RadiusServerModel.this;
        }
    }

    class RadiusClientConfig
    extends CachedValue {
        public RadiusClientConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return RadiusServerModel.this.getNodeNetRef().getRadiusClientConfig();
        }

        @Override
        protected void setValue(Object object) {
            RadiusServerModel.this.getNodeNetRef().setRadiusClientConfig((sRadiusClient)object);
        }

        public Object outer() {
            return RadiusServerModel.this;
        }
    }

    class RadiusServerList
    extends CachedValue {
        public RadiusServerList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return RadiusServerModel.this.getNodeNetRef().getRadiusServerList();
        }

        @Override
        protected void setValue(Object object) throws xMaxRadiusServers, xDupRadiusServer, xConfigError, xEmptyAaaServerList {
            RadiusServerModel.this.getNodeNetRef().setRadiusServerList((sRadiusServer[])object);
        }

        public Object outer() {
            return RadiusServerModel.this;
        }
    }

    class UseDbIfNoRemoteServer
    extends CachedValue {
        public UseDbIfNoRemoteServer(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return new Boolean(RadiusServerModel.this.getNodeNetRef().getUseDbIfNoRemoteServer());
        }

        @Override
        protected void setValue(Object object) {
            RadiusServerModel.this.getNodeNetRef().setUseDbIfNoRemoteServer((Boolean)object);
        }

        public Object outer() {
            return RadiusServerModel.this;
        }
    }
}

