/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.eRamanSetupError;
import cerent.cms.idl.OpticsTopology.eRamanSetupErrorHolder;
import cerent.cms.idl.OpticsTopology.eRamanSetupType;
import cerent.cms.idl.OpticsTopology.sRamanPowerMeasures;
import cerent.cms.idl.OpticsTopology.sRamanPowerMeasuresHolder;
import cerent.cms.idl.OpticsTopology.sRamanSetupResultHolder;
import cerent.cms.idl.OpticsTopology.xSideInUse;
import cerent.cms.idl.OpticsTopology.xWrongNodeSide;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SideInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EMC;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.UserException;

public class RamanModel
extends Model
implements IRamanModel {
    private static final float NA_VALUE = -100000.0f;
    private NodeModelDelegate nmd;
    private static NodeSingletonFactory<RamanModel> sfactory = new NodeSingletonFactory<RamanModel>("ramanModelsSingletons", RamanModel.class);
    private EventDispatcher dispatcher;
    private RamanStartTest ramanStartTest;
    private RamanMeasure ramanMeasure;
    private RamanParams ramanParams;
    private RamanParams wizardRamanParams;
    private RamanAccept ramanAccept;
    private RamanStartVer ramanStartVer;
    private RamanGetVer ramanGetVer;
    private RamanAcceptVer ramanAcceptVer;
    private RamanRestore ramanRestore;
    private RamanCalculation ramanCalculation;
    private RamanReset ramanReset;
    private RamanDeltaPwr ramanDeltaPwr;
    private RamanResultInstallation ramanResultInstallation;
    private RamanResultInstallation wizardResultInstallation;
    private RestoreFC restoreFC;
    private TimeOutObjChange handleTimeOut;
    private long sendMsg;
    private static SDebug db = new SDebug("RamanModel");

    private RamanModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(RamanModel.class));
        if (db.on()) {
            db.println("RamanModel(NodeModelDelegate node)");
        }
        this.nmd = nodeModelDelegate;
        this.ramanStartTest = new RamanStartTest("ramanTest", this.nmd);
        this.ramanMeasure = new RamanMeasure("ramanMeasure", this.nmd);
        this.ramanParams = new RamanParams("RamanParams", this.nmd);
        this.wizardRamanParams = new RamanParams("RamanParams", this.nmd);
        this.wizardRamanParams.setObjChange(true);
        this.ramanAccept = new RamanAccept("RamanAccept", this.nmd);
        this.ramanStartVer = new RamanStartVer("RamanStartVer", this.nmd);
        this.ramanGetVer = new RamanGetVer("RamanStartVer", this.nmd);
        this.ramanAcceptVer = new RamanAcceptVer("RamanAcceptVer", this.nmd);
        this.ramanRestore = new RamanRestore("RamanRestore", this.nmd);
        this.ramanCalculation = new RamanCalculation("RamanCalculation", this.nmd);
        this.ramanReset = new RamanReset("RamanReset", this.nmd);
        this.ramanDeltaPwr = new RamanDeltaPwr("RamanDeltaPwr", this.nmd);
        this.ramanResultInstallation = new RamanResultInstallation("RamanResultInstallation", this.nmd);
        this.wizardResultInstallation = new RamanResultInstallation("RamanResultInstallation", this.nmd);
        this.wizardResultInstallation.setObjChange(true);
        this.restoreFC = new RestoreFC("RestoreFromFiberCut", this.nmd);
        this.sendMsg = 0L;
    }

    public static final RamanModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            int n2 = ((IObjectMessageInfo)object).getObjectType();
            int n3 = ((IObjectMessageInfo)object).getChildObjectType();
            block0 : switch (n) {
                case 1: {
                    switch (n2) {
                        case 97: {
                            eRamanSetupError eRamanSetupError2;
                            if (this.handleTimeOut == null || object == null) {
                                if (!db.on()) break block0;
                                db.println("handleTimeOut = " + this.handleTimeOut + " msg = " + object);
                                break;
                            }
                            if (this.handleTimeOut.isInvalid()) {
                                if (!db.on()) break block0;
                                db.println(">> node_" + this.nmd.getName() + ") " + "handleTimeOut = INVALID don't care of it");
                                break;
                            }
                            switch (n3) {
                                case 98: {
                                    eRamanSetupError2 = eRamanSetupError.from_int(((IObjectMessageInfo)object).getChildIndex());
                                    break;
                                }
                                case 102: {
                                    eRamanSetupError2 = eRamanSetupError.from_int(((IObjectMessageInfo)object).getChildIndex());
                                    break;
                                }
                                default: {
                                    eRamanSetupError2 = eRamanSetupError.RS_NO_ERROR;
                                }
                            }
                            if (this.handleTimeOut != null) {
                                this.handleTimeOut.wakeUp(eRamanSetupError2);
                                break;
                            }
                        }
                        default: {
                            if (this.handleTimeOut == null || !db.on()) break block0;
                            db.println(">> node_" + this.nmd.getName() + ") [" + this.sendMsg + "] Wrong Type = " + n2);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    if (this.handleTimeOut == null || !db.on()) break;
                    db.println(">> node_" + this.nmd.getName() + ") [" + this.sendMsg + "] Wrong Event = " + n);
                }
            }
        }
    }

    private DwdmOpticalSetup getRamanRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    public void init() {
        super.init0();
        if (db.on()) {
            db.println("init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectRamanSetup, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectRamanSetupError, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        if (db.on()) {
            db.println("dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectRamanSetup, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectRamanSetupError, (Observer)this);
            this.dispatcher = null;
        }
        this.ramanStartTest.dispose();
        this.ramanMeasure.dispose();
        this.ramanParams.dispose();
        this.ramanAccept.dispose();
        this.ramanStartVer.dispose();
        this.ramanGetVer.dispose();
        this.ramanAcceptVer.dispose();
        this.ramanRestore.dispose();
        super.dispose();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void startTest(int n, int n2, int n3, IRamanModel.ramanSetupTypeEnum ramanSetupTypeEnum2, int n4, IRamanDayZeroOperation iRamanDayZeroOperation) throws WrongNodeSide, SideInUse, ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
    }

    public void startTest(int n, int n2, int n3, int n4, IRamanModel.ramanSetupTypeEnum ramanSetupTypeEnum2, int n5, IRamanDayZeroOperation iRamanDayZeroOperation) throws WrongNodeSide, SideInUse, ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "startTest");
        this.handleTimeOut.start();
        this.startTest(n, n2, n3, n4, ramanSetupTypeEnum2, n5);
    }

    public void startTest(int n, int n2, int n3, int n4, IRamanModel.ramanSetupTypeEnum ramanSetupTypeEnum2, int n5) throws WrongNodeSide, SideInUse, ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        Object[] objectArray = new Object[]{n, n2, n4, n5, ramanSetupTypeEnum2, n3};
        try {
            this.ramanStartTest.set(objectArray);
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (xSideInUse xSideInUse2) {
            throw new SideInUse((UserException)xSideInUse2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public void calculation(int n, IRamanDayZeroOperation iRamanDayZeroOperation) throws WrongNodeSide, SideInUse, ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        try {
            this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "doCalcRamanParams");
            this.handleTimeOut.start();
            this.calculation(n);
        }
        catch (WrongNodeSide wrongNodeSide) {
            KDebug.printStackTrace((Throwable)wrongNodeSide);
        }
        catch (SideInUse sideInUse) {
            KDebug.printStackTrace((Throwable)sideInUse);
        }
        catch (ConfigError configError) {
            KDebug.printStackTrace((Throwable)configError);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (ProvisionError provisionError) {
            KDebug.printStackTrace((Throwable)provisionError);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
    }

    public void calculation(int n) throws WrongNodeSide, SideInUse, ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        try {
            this.ramanCalculation.set(new Integer(n));
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (xSideInUse xSideInUse2) {
            throw new SideInUse((UserException)xSideInUse2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public void ramanMeasure(int n, int n2, IRamanDayZeroOperation iRamanDayZeroOperation) {
        try {
            this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "getRamanMeasure");
            this.handleTimeOut.start();
            this.ramanMeasure(n, n2);
        }
        catch (WrongNodeSide wrongNodeSide) {
            KDebug.printStackTrace((Throwable)wrongNodeSide);
        }
        catch (SideInUse sideInUse) {
            KDebug.printStackTrace((Throwable)sideInUse);
        }
        catch (ConfigError configError) {
            KDebug.printStackTrace((Throwable)configError);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (ProvisionError provisionError) {
            KDebug.printStackTrace((Throwable)provisionError);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
    }

    public void ramanReset(int n, int n2) throws WrongNodeSide, SideInUse, ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        Object[] objectArray = new Object[3];
        objectArray[0] = n;
        objectArray[1] = n2;
        try {
            this.handleTimeOut = null;
            this.ramanReset.set(objectArray);
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (xSideInUse xSideInUse2) {
            throw new SideInUse((UserException)xSideInUse2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public void ramanMeasure(int n, int n2) throws WrongNodeSide, SideInUse, ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        Object[] objectArray = new Object[3];
        objectArray[0] = n;
        objectArray[1] = n2;
        try {
            this.ramanMeasure.set(objectArray);
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (xSideInUse xSideInUse2) {
            throw new SideInUse((UserException)xSideInUse2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public IRamanModel.RamanPowerMeasures getRamanParams(int n, int n2, IRamanDayZeroOperation iRamanDayZeroOperation) {
        IRamanModel.RamanPowerMeasures ramanPowerMeasures = null;
        try {
            this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "getRamanParams");
            this.handleTimeOut.start();
            return this.getRamanParamsforWizard(n, n2);
        }
        catch (ConfigError configError) {
            KDebug.printStackTrace((Throwable)configError);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (ProvisionError provisionError) {
            KDebug.printStackTrace((Throwable)provisionError);
        }
        return ramanPowerMeasures;
    }

    public IRamanModel.RamanPowerMeasures getRamanParams(int n, int n2) throws ConfigError, WrongInterfaceType, ProvisionError {
        Object[] objectArray = new Object[]{n, n2};
        IRamanModel.RamanPowerMeasures ramanPowerMeasures = null;
        try {
            sRamanPowerMeasures sRamanPowerMeasures2 = (sRamanPowerMeasures)this.ramanParams.get(objectArray);
            if (sRamanPowerMeasures2 != null) {
                ramanPowerMeasures = new IRamanModel.RamanPowerMeasures(sRamanPowerMeasures2.powerMinRamanLevel, sRamanPowerMeasures2.powerMaxRamanLevel, sRamanPowerMeasures2.hiPowerForRamanMeasure, sRamanPowerMeasures2.loPowerForRamanMeasure, sRamanPowerMeasures2.measureTimeStamp);
            }
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
        return ramanPowerMeasures;
    }

    private IRamanModel.RamanPowerMeasures getRamanParamsforWizard(int n, int n2) throws ConfigError, WrongInterfaceType, ProvisionError {
        Object[] objectArray = new Object[]{n, n2};
        IRamanModel.RamanPowerMeasures ramanPowerMeasures = null;
        try {
            sRamanPowerMeasures sRamanPowerMeasures2 = (sRamanPowerMeasures)this.wizardRamanParams.get(objectArray);
            if (sRamanPowerMeasures2 != null) {
                ramanPowerMeasures = new IRamanModel.RamanPowerMeasures(sRamanPowerMeasures2.powerMinRamanLevel, sRamanPowerMeasures2.powerMaxRamanLevel, sRamanPowerMeasures2.hiPowerForRamanMeasure, sRamanPowerMeasures2.loPowerForRamanMeasure, sRamanPowerMeasures2.measureTimeStamp);
            }
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
        return ramanPowerMeasures;
    }

    public void acceptTuningParams(int n, IRamanDayZeroOperation iRamanDayZeroOperation) throws ConfigError, WrongInterfaceType, ProvisionError {
        this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "acceptTuningParams");
        this.handleTimeOut.start();
        this.acceptTuningParams(n);
    }

    public void acceptTuningParams(int n) throws ConfigError, WrongInterfaceType, ProvisionError {
        try {
            this.ramanAccept.set(n);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public void startVerification(int n) throws ConfigError, WrongInterfaceType, ProvisionError {
        try {
            this.ramanStartVer.set(n);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public void getVerification(int n) throws ConfigError, WrongInterfaceType, ProvisionError {
        try {
            this.ramanGetVer.get(n);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public void acceptVerification(int n) throws ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        try {
            this.ramanAcceptVer.set(n);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public void restoreRaman(int n, int n2, int n3, IRamanDayZeroOperation iRamanDayZeroOperation) throws ConfigError, WrongInterfaceType, NoSuchInterface {
        if (this.handleTimeOut != null) {
            this.handleTimeOut.setInvalid();
        }
        this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "restoreRaman");
        this.handleTimeOut.start();
        this.restoreRaman(n, n2, n3);
    }

    public void restoreRaman(int n, int n2, int n3) throws ConfigError, WrongInterfaceType, NoSuchInterface {
        Object[] objectArray = new Object[]{n, n2, n3};
        try {
            this.ramanRestore.set(objectArray);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    public ArrayList<String> getNewValues(IEntityModel iEntityModel) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        ArrayList<String> arrayList = this.getInstallation(iEntityModel.getIndex());
        return arrayList;
    }

    public ArrayList<String> getNewValues(IEntityModel iEntityModel, IRamanDayZeroOperation iRamanDayZeroOperation) {
        ArrayList<String> arrayList = null;
        try {
            this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "getRamanSetupResult");
            this.handleTimeOut.start();
            arrayList = this.getNewValues(iEntityModel);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return arrayList;
    }

    public int ramanDeltaPwr(int n) throws ConfigError, WrongInterfaceType, ProvisionError {
        Integer n2 = 0;
        try {
            n2 = (Integer)this.ramanDeltaPwr.get(n);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{xProvisionError2.dataError});
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            KDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
        return n2;
    }

    public ArrayList<String> getInstallation(int n) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        sRamanSetupResultHolder sRamanSetupResultHolder2 = (sRamanSetupResultHolder)this.wizardResultInstallation.get(n);
        arrayList.add(String.valueOf(sRamanSetupResultHolder2.value.quality.value()));
        float f = sRamanSetupResultHolder2.value.ratio;
        arrayList.add(String.valueOf(f / 10.0f) + "%");
        arrayList.add(String.valueOf(sRamanSetupResultHolder2.value.powerTot));
        SimpleDateFormat simpleDateFormat = Preferences.instance().getProperty("ctc", "dateFormat", "MM/DD/YY").equals("MM/DD/YY") ? new SimpleDateFormat("MM/dd/yy HH:mm:ss") : new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        if (sRamanSetupResultHolder2.value.setupTimeStamp != 0) {
            Date date = new Date((long)sRamanSetupResultHolder2.value.setupTimeStamp * 1000L);
            arrayList.add(simpleDateFormat.format(date));
        } else {
            arrayList.add("N/A");
        }
        arrayList.add(String.valueOf((float)sRamanSetupResultHolder2.value.gainObt / 10.0f));
        arrayList.add(String.valueOf((float)sRamanSetupResultHolder2.value.tiltObt / 10.0f));
        arrayList.add(String.valueOf((float)sRamanSetupResultHolder2.value.specStartSpanLoss / 10.0f));
        arrayList.add(String.valueOf((float)sRamanSetupResultHolder2.value.specEndSpanLoss / 10.0f));
        arrayList.add(String.valueOf((float)sRamanSetupResultHolder2.value.pump1SpanLoss / 10.0f));
        arrayList.add(String.valueOf((float)sRamanSetupResultHolder2.value.pump2SpanLoss / 10.0f));
        arrayList.add(String.valueOf((float)sRamanSetupResultHolder2.value.remotePerChPwr / 10.0f));
        return arrayList;
    }

    public String getSpanLoss(int n) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        sRamanSetupResultHolder sRamanSetupResultHolder2 = (sRamanSetupResultHolder)this.ramanResultInstallation.get(n);
        Float f = new Float((float)sRamanSetupResultHolder2.value.specEndSpanLoss / 10.0f);
        Float f2 = new Float((float)sRamanSetupResultHolder2.value.specStartSpanLoss / 10.0f);
        Float f3 = null;
        f3 = f.floatValue() == -100000.0f ? f2 : (f2.floatValue() == -100000.0f ? f : Float.valueOf((f2.floatValue() + f.floatValue()) / 2.0f));
        if (f3.floatValue() != -100000.0f) {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMaximumFractionDigits(1);
            return decimalFormat.format(f3);
        }
        return "N/A";
    }

    public void restoreFiberCut(int n, int n2) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException, ProvisionError {
        this.restoreFC.set(n);
    }

    public void restoreFiberCut(int n, int n2, IRamanDayZeroOperation iRamanDayZeroOperation) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException, ProvisionError {
        this.handleTimeOut = new TimeOutObjChange(iRamanDayZeroOperation, "restoreFc");
        this.handleTimeOut.start();
        this.restoreFiberCut(n, n2);
    }

    private class RamanAccept
    extends NonCachedValue {
        public RamanAccept(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            RamanModel.this.getRamanRef().acceptTuningParams((Integer)object);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") acceptTuningParams" + " LineIn: " + object);
            }
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanAcceptVer
    extends NonCachedValue {
        public RamanAcceptVer(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            RamanModel.this.getRamanRef().applyVerrification((Integer)object);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") applyVerrification" + " LineIn: " + object);
            }
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanCalculation
    extends NonCachedValue {
        public RamanCalculation(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xSideInUse, xWrongNodeSide, xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            int n = (Integer)object;
            RamanModel.this.getRamanRef().doCalcRamanParams(n);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") doCalcRamanParams" + " LineIn: " + n);
            }
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanDeltaPwr
    extends NonCachedValue {
        public RamanDeltaPwr(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            int n = (Integer)object;
            IntHolder intHolder = new IntHolder();
            eRamanSetupErrorHolder eRamanSetupErrorHolder2 = new eRamanSetupErrorHolder();
            RamanModel.this.getRamanRef().getRamanSetupDeltaPwr(n, false, intHolder, eRamanSetupErrorHolder2);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") getRamanSetupDeltaPwr" + " LineIn: " + n + " deltaRamanPwr: " + intHolder);
            }
            return intHolder.value;
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanGetVer
    extends NonCachedValue {
        public RamanGetVer(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            RamanModel.this.getRamanRef().getVerificationValues((Integer)object);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") getVerificationValues" + " LineIn: " + object);
            }
            return object;
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanMeasure
    extends NonCachedValue {
        public RamanMeasure(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xSideInUse, xWrongNodeSide, xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            RamanModel.this.getRamanRef().doRamanMeasure(n, n2);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") doRamanMeasure" + " LineIn: " + n + " MeasureIdx: " + n2);
            }
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanParams
    extends NonCachedValue {
        private boolean needObjChange;

        public RamanParams(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
            this.needObjChange = false;
        }

        public void setObjChange(boolean bl) {
            this.needObjChange = bl;
        }

        @Override
        protected Object getValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            sRamanPowerMeasuresHolder sRamanPowerMeasuresHolder2 = new sRamanPowerMeasuresHolder();
            eRamanSetupErrorHolder eRamanSetupErrorHolder2 = new eRamanSetupErrorHolder();
            RamanModel.this.getRamanRef().getRamanMeasure(n, n2, this.needObjChange, sRamanPowerMeasuresHolder2, eRamanSetupErrorHolder2);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") getRamanMeasure" + " LineIn: " + n + " MeasureIdx: " + n2);
            }
            return sRamanPowerMeasuresHolder2.value;
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanReset
    extends NonCachedValue {
        public RamanReset(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xSideInUse, xWrongNodeSide, xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") doRamanRestartSM" + " LineIn: " + n + " LineOut: " + n2);
            }
            RamanModel.this.getRamanRef().doRamanRestartSM(n, n2);
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanRestore
    extends NonCachedValue {
        public RamanRestore(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            eWavelength eWavelength2 = eWavelength.from_int((Integer)objectArray[2]);
            RamanModel.this.getRamanRef().restoreAfterRamanTest(n, n2, eWavelength2);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") restoreAfterRamanTest" + " lineInId: " + n + " lineOutId: " + n2);
            }
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanResultInstallation
    extends NonCachedValue {
        private boolean needObjChange;

        public RamanResultInstallation(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
            this.needObjChange = false;
        }

        public void setObjChange(boolean bl) {
            this.needObjChange = bl;
        }

        @Override
        protected Object getValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            int n = (Integer)object;
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") getRamanSetupResult" + " Line In: " + n);
            }
            sRamanSetupResultHolder sRamanSetupResultHolder2 = new sRamanSetupResultHolder();
            eRamanSetupErrorHolder eRamanSetupErrorHolder2 = new eRamanSetupErrorHolder();
            RamanModel.this.getRamanRef().getRamanSetupResult(n, this.needObjChange, sRamanSetupResultHolder2, eRamanSetupErrorHolder2);
            return sRamanSetupResultHolder2;
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanStartTest
    extends NonCachedValue {
        public RamanStartTest(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xSideInUse, xWrongNodeSide, xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            int n3 = (Integer)objectArray[2];
            eWavelength eWavelength2 = eWavelength.from_int(n3);
            int n4 = (Integer)objectArray[3];
            IRamanModel.ramanSetupTypeEnum ramanSetupTypeEnum2 = (IRamanModel.ramanSetupTypeEnum)objectArray[4];
            int n5 = (Integer)objectArray[5];
            RamanModel.this.getRamanRef().doRamanTest(n5, n2, n, eRamanSetupType.from_int(ramanSetupTypeEnum2.toIntValue()), eWavelength2, n4);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") doRamanTest" + " Line In: " + n + " Line Out: " + n2 + " Mux Card: " + n5 + " Used Lambda: " + n3);
            }
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RamanStartVer
    extends NonCachedValue {
        public RamanStartVer(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            RamanModel.this.getRamanRef().startVerificationPhase((Integer)object);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") startVerificationPhase" + " LineIn: " + object);
            }
        }

        public Object outer() {
            return RamanModel.this;
        }
    }

    private class RestoreFC
    extends NonCachedValue {
        public RestoreFC(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            RamanModel.this.getRamanRef().doRamanRestoreAfterFiberCut((Integer)object);
            if (db.on()) {
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") RestoreFC" + " Line : " + (Integer)object);
            }
        }
    }

    private class TimeOutObjChange
    implements Runnable {
        private static final long RAMAN_TIME_OUT = 450L;
        private static final long RAMAN_CICLE = 1000L;
        private boolean objChanged;
        private int nReceived;
        private eRamanSetupError error = eRamanSetupError.RS_NO_ERROR;
        private IRamanDayZeroOperation execPage;
        Thread thread;
        String dbStr;
        private boolean invalid;

        public TimeOutObjChange(IRamanDayZeroOperation iRamanDayZeroOperation, String string) {
            this.execPage = iRamanDayZeroOperation;
            this.dbStr = string;
            this.thread = new Thread((Runnable)this, this.dbStr + "_" + RamanModel.this.nmd.getName());
        }

        public void start() {
            this.thread.start();
            this.waitResponse(100L);
            this.invalid = false;
        }

        public boolean isInvalid() {
            return this.invalid;
        }

        public void setInvalid() {
            this.invalid = true;
            if (db.on()) {
                db.println("A timeout is still charged ... mark as INVALID");
            }
        }

        @Override
        public void run() {
            if (db.on()) {
                RamanModel.this.sendMsg++;
                db.println(">> node_" + RamanModel.this.nmd.getName() + ") [" + RamanModel.this.sendMsg + "] Sent " + this.dbStr + " on ThreadId = " + this.thread);
            }
            this.objChanged = false;
            this.nReceived = 0;
            int n = 0;
            while ((long)n < 1000L) {
                this.waitResponse(450L);
                if (this.objChanged) {
                    if (db.on()) {
                        db.println("<< node_" + RamanModel.this.nmd.getName() + ") [" + RamanModel.this.sendMsg + "] Obj Changed received from " + this.dbStr + "\n");
                    }
                    if (this.execPage != null) {
                        this.execPage.objChanged(this.error.value(), RamanModel.this.nmd.getName());
                        break;
                    }
                } else if (db.on()) {
                    db.println("+++++++++++++++++++ node_" + RamanModel.this.nmd.getName() + ") [" + RamanModel.this.sendMsg + "] NOT received from " + this.dbStr + "\n");
                }
                ++n;
            }
            if (!this.objChanged && !this.isInvalid()) {
                if (db.on()) {
                    db.println("<< node_" + RamanModel.this.nmd.getName() + " " + RamanModel.this.sendMsg + ") Time Out from " + this.dbStr + "\n");
                }
                if (this.execPage != null) {
                    this.execPage.timeOut(RamanModel.this.nmd.getName());
                }
            }
        }

        public void wakeUp(eRamanSetupError eRamanSetupError2) {
            if (db.on()) {
                db.println("<< node_" + RamanModel.this.nmd.getName() + ") [" + RamanModel.this.sendMsg + "] " + "WakeUp for \"" + this.dbStr + "\" with error = " + eRamanSetupError2.value() + " for ThreadId = " + this.thread);
            }
            this.objChanged = true;
            ++this.nReceived;
            if (this.nReceived > 1 && db.on()) {
                db.println("ERROR, two message received on the same task");
            }
            this.error = eRamanSetupError2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitResponse(long l) {
            TimeOutObjChange timeOutObjChange = this;
            synchronized (timeOutObjChange) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

