/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.sRamanParamsHolder;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.IRamanOpticsLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.Preferences;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;

public class RamanOpticsLineModel
extends OpticsLineModel
implements IRamanOpticsLineModel {
    public static final String FC_NOT_EXECUTED = "Not Need";
    public static final String FC_FAILED = "Failed";
    public static final String FC_OK = "Executed";
    public static final String FC_PENDING = "Pending...";
    private static final float NA_VALUE = -100000.0f;
    private String[] ramanFCState = new String[]{"Not Need", "Failed", "Executed", "Pending..."};
    private RamanInstallationParams ramanParam = new RamanInstallationParams(this.node, "RamanParam");
    private RamanOscBased oscBased = new RamanOscBased(this.node, "RamanoscBased");

    public RamanOpticsLineModel(OpticsLineModel opticsLineModel) {
        super(opticsLineModel.node, opticsLineModel.getIndex());
    }

    public String getRatio() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            return "N/A";
        }
        sRamanParamsHolder sRamanParamsHolder2 = ramanInstallationParamModel.getRamanParam();
        return this.convertRatio(sRamanParamsHolder2.value.ratio);
    }

    public String[] getInstallation() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            arrayList.add("N/A");
            arrayList.add("N/A");
            arrayList.add("N/A");
            arrayList.add("N/A");
            return arrayList.toArray(new String[0]);
        }
        sRamanParamsHolder sRamanParamsHolder2 = ramanInstallationParamModel.getRamanParam();
        arrayList.add(String.valueOf(sRamanParamsHolder2.value.quality.value()));
        float f = sRamanParamsHolder2.value.ratio;
        arrayList.add(this.convertRatio(f));
        arrayList.add(this.getTotPower());
        SimpleDateFormat simpleDateFormat = Preferences.instance().getProperty("ctc", "dateFormat", "MM/DD/YY").equals("MM/DD/YY") ? new SimpleDateFormat("MM/dd/yy HH:mm:ss") : new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        if (sRamanParamsHolder2.value.setupTimeStamp != 0) {
            Date date = new Date((long)sRamanParamsHolder2.value.setupTimeStamp * 1000L);
            arrayList.add(simpleDateFormat.format(date));
        } else {
            arrayList.add("N/A");
        }
        return arrayList.toArray(new String[0]);
    }

    private String convertRatio(float f) {
        return String.valueOf(f / 10.0f) + "%";
    }

    public boolean getOscBased() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        return (Integer)this.oscBased.get() == 1;
    }

    public void setOscBased(Boolean bl) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        if (bl.booleanValue()) {
            this.oscBased.set(1);
        } else {
            this.oscBased.set(0);
        }
    }

    public String getTotPower() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            return "N/A";
        }
        return String.valueOf(ramanInstallationParamModel.getTotPower());
    }

    public String getUserName() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            return "N/A";
        }
        return String.valueOf(ramanInstallationParamModel.getUserName());
    }

    public String getFCResult() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            return "N/A";
        }
        return this.ramanFCState[ramanInstallationParamModel.getRamanParam().value.restoreFCResult.value()];
    }

    public String getFCspanLoss() throws AbstractCmsIOException, UserException {
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            return "N/A";
        }
        float f = (float)ramanInstallationParamModel.getRamanParam().value.insertionLossAfterFC / 10.0f;
        if (f != -100000.0f) {
            return String.valueOf(f);
        }
        return "N/A";
    }

    public String getFCTimeStamp() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            return "N/A";
        }
        int n = ramanInstallationParamModel.getRamanParam().value.restoreFCTimeStamp;
        if (n == 0) {
            return String.valueOf("N/A");
        }
        SimpleDateFormat simpleDateFormat = Preferences.instance().getProperty("ctc", "dateFormat", "MM/DD/YY").equals("MM/DD/YY") ? new SimpleDateFormat("MM/dd/yy HH:mm:ss") : new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        Date date = new Date((long)n * 1000L);
        return simpleDateFormat.format(date);
    }

    public String[] InstallationPowerLevel() {
        String[] stringArray = new String[4];
        IRamanModel iRamanModel = this.getNodeModel().getRamanModels();
        try {
            IRamanModel.RamanPowerMeasures ramanPowerMeasures = iRamanModel.getRamanParams(this.getIndex(), 0);
            stringArray[0] = RamanOpticsLineModel.convertPwrToDb(String.valueOf(ramanPowerMeasures.powerMinRamanLevel));
            stringArray[1] = RamanOpticsLineModel.convertPwrToDb(String.valueOf(ramanPowerMeasures.powerMaxRamanLevel));
            ramanPowerMeasures = iRamanModel.getRamanParams(this.getIndex(), 1);
            stringArray[2] = RamanOpticsLineModel.convertPwrToDb(String.valueOf(ramanPowerMeasures.powerMinRamanLevel));
            stringArray[3] = RamanOpticsLineModel.convertPwrToDb(String.valueOf(ramanPowerMeasures.powerMaxRamanLevel));
        }
        catch (ConfigError configError) {
            return stringArray;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            return stringArray;
        }
        catch (ProvisionError provisionError) {
            return stringArray;
        }
        catch (NoSuchInterface noSuchInterface) {
            return stringArray;
        }
        return stringArray;
    }

    private static String convertPwrToDb(String string) {
        int n = string.startsWith("-") ? 2 : 1;
        string = string.length() > n ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (n == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    public int getSetupStatus() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        sRamanParamsHolder sRamanParamsHolder2 = this.getRamanWizardResult();
        int n = sRamanParamsHolder2.value.status.value();
        if (n == 2 && this.getSetupQuality() == 3) {
            return 4;
        }
        return n;
    }

    public int getSetupQuality() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        sRamanParamsHolder sRamanParamsHolder2 = this.getRamanWizardResult();
        return sRamanParamsHolder2.value.quality.value();
    }

    private sRamanParamsHolder getRamanWizardResult() throws AbstractCmsIOException, UserException {
        RamanInstallationParamModel ramanInstallationParamModel = (RamanInstallationParamModel)this.ramanParam.get();
        if (ramanInstallationParamModel == null) {
            return new sRamanParamsHolder();
        }
        sRamanParamsHolder sRamanParamsHolder2 = ramanInstallationParamModel.getRamanParam();
        return sRamanParamsHolder2;
    }

    public String getWizardResultStatus() throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        int n = this.getSetupStatus();
        return RamanStateStr[n];
    }

    private class RamanInstallationParamModel {
        private sRamanParamsHolder ramanParam;
        private IntHolder totPower;
        private StringHolder userName;

        public RamanInstallationParamModel(sRamanParamsHolder sRamanParamsHolder2, IntHolder intHolder, StringHolder stringHolder) {
            this.ramanParam = sRamanParamsHolder2;
            this.totPower = intHolder;
            this.userName = stringHolder;
        }

        public sRamanParamsHolder getRamanParam() {
            return this.ramanParam;
        }

        public int getTotPower() {
            return this.totPower.value;
        }

        public String getUserName() {
            return this.userName.value;
        }
    }

    private class RamanInstallationParams
    extends NonCachedValue {
        public RamanInstallationParams(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            RamanInstallationParamModel ramanInstallationParamModel;
            IntHolder intHolder = new IntHolder();
            sRamanParamsHolder sRamanParamsHolder2 = new sRamanParamsHolder();
            StringHolder stringHolder = new StringHolder();
            try {
                RamanOpticsLineModel.this.ifReference.getRamanParams(RamanOpticsLineModel.this.getIndex(), intHolder, sRamanParamsHolder2, stringHolder);
                ramanInstallationParamModel = new RamanInstallationParamModel(sRamanParamsHolder2, intHolder, stringHolder);
            }
            catch (RuntimeException runtimeException) {
                ramanInstallationParamModel = null;
            }
            return ramanInstallationParamModel;
        }
    }

    private class RamanOscBased
    extends NonCachedValue {
        public RamanOscBased(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Integer(RamanOpticsLineModel.this.ifReference.getOscBasedRamanStartup(RamanOpticsLineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            int n = (Integer)object;
            RamanOpticsLineModel.this.ifReference.setOscBasedRamanStartup(RamanOpticsLineModel.this.getIndex(), n);
        }
    }
}

