/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.EtherMedia.eMauType;
import cerent.cms.idl.EtherMedia.sLineAdminInfo;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Rmon.General;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sIdStats;
import cerent.cms.idl.Rmon.sStatsSeriesAdminInfo;
import cerent.cms.idl.Rmon.sTimedIdStats;
import cerent.cms.idl.Rmon.sTimedStats;
import cerent.cms.idl.Rmon.sTimedStatsPair;
import cerent.cms.idl.Rmon.xNoSuchSampleIndex;
import cerent.cms.idl.Rmon.xNoSuchStatsId;
import cerent.cms.idl.Rmon.xNoSuchStatsSeries;
import cerent.cms.idl.Rmon.xUnsupportedAlarm;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchSampleIndex;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.RmonThresholdManager;
import cerent.cms.model.UnsupportedAlarm;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.UserException;

public class RmonModel
extends Model
implements IRmonModel {
    protected RmonClearStats rmonClearStats;
    protected RmonCurrentStats rmonCurrentStats;
    protected RmonSnapshotStats rmonSnapshotStats;
    protected RmonHistoricalStats rmonHistoricalStats;
    protected RmonStatsSeries rmonStatsSeries;
    protected RmonStatsSeriesAdminInfo rmonStatsSeriesAdminInfo;
    protected RmonUtilizationSeries rmonUtilizationSeries;
    protected RmonTxRxUtilizationSeries rmonTxRxUtilizationSeries;
    protected RmonLineStatus rmonLineStatus;
    private RmonThresholdManager rtm;
    private NodeModelDelegate node;
    private InterfaceModel ifModel;
    private boolean supportsLineStatus;
    private boolean supportsRmonUtil;

    protected RmonModel(NodeModelDelegate nodeModelDelegate, InterfaceModel interfaceModel) {
        this(nodeModelDelegate, interfaceModel, true);
    }

    protected RmonModel(NodeModelDelegate nodeModelDelegate, InterfaceModel interfaceModel, boolean bl) {
        this(nodeModelDelegate, interfaceModel, bl, true);
    }

    protected RmonModel(NodeModelDelegate nodeModelDelegate, InterfaceModel interfaceModel, boolean bl, boolean bl2) {
        super(nodeModelDelegate.getChildDebug(RmonModel.class));
        this.node = nodeModelDelegate;
        this.ifModel = interfaceModel;
        this.rtm = RmonThresholdManager.getInstance(nodeModelDelegate);
        this.supportsLineStatus = bl;
        this.supportsRmonUtil = bl2;
        this.index = this.ifModel.getIndex();
        super.init0();
        this.rmonClearStats = new RmonClearStats("rmonClearStats", nodeModelDelegate);
        this.rmonCurrentStats = new RmonCurrentStats("rmonCurrentStats", nodeModelDelegate);
        this.rmonSnapshotStats = new RmonSnapshotStats("rmonSnapshotStats", nodeModelDelegate);
        this.rmonHistoricalStats = new RmonHistoricalStats("rmonHistoricalStats", nodeModelDelegate);
        this.rmonStatsSeriesAdminInfo = new RmonStatsSeriesAdminInfo("statsSeriesAdminInfo", nodeModelDelegate);
        this.rmonStatsSeries = new RmonStatsSeries("statsSeries", nodeModelDelegate);
        this.rmonUtilizationSeries = new RmonUtilizationSeries("rmonUtilizationSeries", nodeModelDelegate);
        this.rmonTxRxUtilizationSeries = new RmonTxRxUtilizationSeries("rmonTxRxUtilizationSeries", nodeModelDelegate);
        this.rmonLineStatus = new RmonLineStatus("rmonLineStatus", nodeModelDelegate);
        this.rtm = RmonThresholdManager.getInstance(nodeModelDelegate);
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    @Override
    public final void clearStats() throws WrongInterfaceType, InternalCommError, NoSuchInterface {
        try {
            this.rmonClearStats.set();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    @Override
    public final int getStatsLastClearedTime() throws WrongInterfaceType, InternalCommError, NoSuchInterface {
        try {
            return (Integer)this.rmonClearStats.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    @Override
    public final eStatsId[] getStatsIdList() throws WrongInterfaceType, NoSuchInterface {
        return this.rtm.getStatsIdList(this.getIndex());
    }

    @Override
    public final eStatsId[] getCumulativeStatsIdList() throws WrongInterfaceType, NoSuchInterface {
        return this.rtm.getCumulativeStatsIdList(this.getIndex());
    }

    @Override
    public final eStatsId[] getNonCumulativeStatsIdList() throws WrongInterfaceType, NoSuchInterface {
        return this.rtm.getNonCumulativeStatsIdList(this.getIndex());
    }

    @Override
    public final String[] getStatsIdListStr(eStatsId[] eStatsIdArray) {
        return this.rtm.getStatsIdListStr(eStatsIdArray);
    }

    @Override
    public final String getStatsIdStr(eStatsId eStatsId2) throws WrongInterfaceType, NoSuchInterface {
        return this.rtm.getStatsIdStr(eStatsId2);
    }

    @Override
    public final sIdStats[] getCurrentStats() throws WrongInterfaceType, InternalCommError, NoSuchInterface {
        try {
            return (sIdStats[])this.rmonCurrentStats.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public final long getSnapShotStats(eStatsId eStatsId2) throws WrongInterfaceType, NoSuchInterface, NoSuchStatsId, UnsupportedAlarm {
        try {
            return (Long)this.rmonSnapshotStats.get(eStatsId2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchStatsId xNoSuchStatsId2) {
            throw new NoSuchStatsId((UserException)xNoSuchStatsId2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedAlarm xUnsupportedAlarm2) {
            throw new UnsupportedAlarm((UserException)xUnsupportedAlarm2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1L;
        }
    }

    @Override
    public final sTimedIdStats getHistoricalStats(short s, int n) throws WrongInterfaceType, NoSuchSampleIndex, InternalCommError, NoSuchStatsSeries, NoSuchInterface {
        try {
            Object[] objectArray = new Object[]{new Short(s), new Integer(n)};
            Object[] objectArray2 = (Object[])this.rmonHistoricalStats.get(objectArray);
            return (sTimedIdStats)objectArray2[0];
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchSampleIndex xNoSuchSampleIndex2) {
            throw new NoSuchSampleIndex((UserException)xNoSuchSampleIndex2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNoSuchStatsSeries xNoSuchStatsSeries2) {
            throw new NoSuchStatsSeries((UserException)xNoSuchStatsSeries2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public final sTimedStats[] getStatsSeries(short s, eStatsId eStatsId2) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface {
        try {
            Object[] objectArray = new Object[]{new Short(s), eStatsId2};
            return (sTimedStats[])this.rmonStatsSeries.get(objectArray);
        }
        catch (xNoSuchStatsSeries xNoSuchStatsSeries2) {
            throw new NoSuchStatsSeries((UserException)xNoSuchStatsSeries2);
        }
        catch (xNoSuchStatsId xNoSuchStatsId2) {
            throw new NoSuchStatsId((UserException)xNoSuchStatsId2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getStatsSeries", userException);
        }
    }

    @Override
    public final sStatsSeriesAdminInfo getStatsSeriesAdminInfo(short s) throws NoSuchStatsSeries {
        try {
            return (sStatsSeriesAdminInfo)this.rmonStatsSeriesAdminInfo.get(new Short(s));
        }
        catch (xNoSuchStatsSeries xNoSuchStatsSeries2) {
            throw new NoSuchStatsSeries((UserException)xNoSuchStatsSeries2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    public final sTimedStatsPair[] getTxRxUtilizationSeries(short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError, NoSuchStatsSeries {
        try {
            Object[] objectArray = (Object[])this.rmonTxRxUtilizationSeries.get(new Short(s));
            return (sTimedStatsPair[])objectArray[0];
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNoSuchStatsSeries xNoSuchStatsSeries2) {
            throw new NoSuchStatsSeries((UserException)xNoSuchStatsSeries2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getTxRxUtilizationSeries", userException);
        }
    }

    @Override
    public final boolean getLineStatus() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.rmonLineStatus.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getFcLineStatus", userException);
        }
    }

    @Override
    public final short getMaxBuckets(short s) throws NoSuchStatsSeries {
        return this.getStatsSeriesAdminInfo((short)s).maxBuckets;
    }

    public static String getSeriesDesc(int n) {
        for (int i = 0; i < ElementDefaults.PM_INTERVAL_TYPES.length; ++i) {
            if (n != ElementDefaults.PM_INTERVAL_TYPES[i].getIntValue()) continue;
            return ElementDefaults.PM_INTERVAL_TYPES[i].getKey();
        }
        return "!ERROR!";
    }

    @Override
    public final String getSeriesDescription(short s) {
        return RmonModel.getSeriesDesc(s);
    }

    @Override
    public boolean supportsLineStatus() {
        return this.supportsLineStatus;
    }

    @Override
    public boolean supportsRmonUtil() {
        return this.supportsRmonUtil;
    }

    @Override
    public InterfaceModel getInterfaceModel() {
        return this.ifModel;
    }

    @Override
    public PortModel getPortModel() throws AbstractCmsNoSuchEntityException {
        return (PortModel)this.ifModel.getPortModel();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    @Override
    public eMauType getModeType() throws NoSuchInterface, WrongInterfaceType {
        if (this.getInterfaceModel() instanceof EtherLineModel) {
            EtherLineModel etherLineModel = (EtherLineModel)this.getInterfaceModel();
            sLineAdminInfo sLineAdminInfo2 = etherLineModel.getLineAdminInfo();
            return sLineAdminInfo2.mauDefaultType;
        }
        throw new WrongInterfaceType("An error occurred while trying to perform an operation that is not supported\nby the interface type " + this.getInterfaceModel() + ".");
    }

    public static IRmonModel[] getRmonModels(ISupportsRMON[] iSupportsRMONArray) {
        ArrayList<IRmonModel> arrayList = new ArrayList<IRmonModel>();
        for (int i = 0; i < iSupportsRMONArray.length; ++i) {
            IRmonModel iRmonModel = iSupportsRMONArray[i].getRmonModel();
            if (iRmonModel == null) continue;
            arrayList.add(iRmonModel);
        }
        return arrayList.toArray(new IRmonModel[arrayList.size()]);
    }

    private General getRmonRef() {
        return this.node.getIorRepository().getRmonRef();
    }

    private class RmonClearStats
    extends NonCachedValue {
        public RmonClearStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws UserException {
            RmonModel.this.getRmonRef().clearLineStats(RmonModel.this.getIndex());
        }

        @Override
        protected Object getValue() throws UserException {
            return new Integer(RmonModel.this.getRmonRef().getStatsLineLastClearedTime(RmonModel.this.getIndex()));
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonCurrentStats
    extends NonCachedValue {
        public RmonCurrentStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return RmonModel.this.getRmonRef().getStatsSnapshotForAllCounters(RmonModel.this.getIndex());
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonHistoricalStats
    extends NonCachedValue {
        public RmonHistoricalStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[0];
            int n = (Integer)objectArray[1];
            LongHolder longHolder = new LongHolder();
            LongHolder longHolder2 = new LongHolder();
            sTimedIdStats sTimedIdStats2 = RmonModel.this.getRmonRef().getStatsHistoryForAllCounters(RmonModel.this.getIndex(), s, n, longHolder, longHolder2);
            return new Object[]{sTimedIdStats2, longHolder, longHolder2};
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonLineStatus
    extends NonCachedValue {
        public RmonLineStatus(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return RmonModel.this.getRmonRef().getLineStatus(RmonModel.this.getIndex()) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonSnapshotStats
    extends NonCachedValue {
        public RmonSnapshotStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return new Long(RmonModel.this.getRmonRef().getSnapShotStats(RmonModel.this.getIndex(), (eStatsId)object));
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonStatsSeries
    extends NonCachedValue {
        public RmonStatsSeries(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return RmonModel.this.getRmonRef().getStatsSeries((Short)objectArray[0], RmonModel.this.getIndex(), (eStatsId)objectArray[1], new LongHolder());
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    class RmonStatsSeriesAdminInfo
    extends NonCachedValue {
        public RmonStatsSeriesAdminInfo(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            short s = (Short)object;
            return RmonModel.this.getRmonRef().getStatsSeriesAdminInfo(s);
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonStatsSeriesSampleForAllCounters
    extends NonCachedValue {
        public RmonStatsSeriesSampleForAllCounters(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return RmonModel.this.getRmonRef().getStatsSeriesSampleForAllCounters((Short)objectArray[0], RmonModel.this.getIndex(), (Integer)objectArray[1], new LongHolder(((Long)objectArray[2]).longValue()));
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonTxRxUtilizationSeries
    extends NonCachedValue {
        public RmonTxRxUtilizationSeries(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            LongHolder longHolder = new LongHolder();
            sTimedStatsPair[] sTimedStatsPairArray = RmonModel.this.getRmonRef().getTxRxUtilizationSeries((Short)object, RmonModel.this.getIndex(), longHolder);
            return new Object[]{sTimedStatsPairArray, longHolder};
        }

        public Object outer() {
            return RmonModel.this;
        }
    }

    private class RmonUtilizationSeries
    extends NonCachedValue {
        public RmonUtilizationSeries(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            LongHolder longHolder = new LongHolder();
            sTimedStats[] sTimedStatsArray = RmonModel.this.getRmonRef().getUtilizationSeries((Short)object, RmonModel.this.getIndex(), longHolder);
            return new Object[]{sTimedStatsArray, longHolder};
        }

        public Object outer() {
            return RmonModel.this;
        }
    }
}

