/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Rmon.General;
import cerent.cms.idl.Rmon.eAlarmSampleType;
import cerent.cms.idl.Rmon.eAlarmType;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sAlarmAdminInfo;
import cerent.cms.idl.Rmon.sAlarmCombinedInfo;
import cerent.cms.idl.Rmon.sAlarmInfo;
import cerent.cms.idl.Rmon.xDuplicateAlarm;
import cerent.cms.idl.Rmon.xInvalidAlarmInterval;
import cerent.cms.idl.Rmon.xInvalidAlarmThresholds;
import cerent.cms.idl.Rmon.xInvalidAlarmType;
import cerent.cms.idl.Rmon.xInvalidSampleType;
import cerent.cms.idl.Rmon.xNoMoreAlarms;
import cerent.cms.idl.Rmon.xNoSuchAlarm;
import cerent.cms.idl.Rmon.xNoSuchStatsId;
import cerent.cms.idl.Rmon.xUnsupportedAlarm;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DuplicateAlarm;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidAlarmInterval;
import cerent.cms.model.InvalidAlarmThresholds;
import cerent.cms.model.InvalidAlarmType;
import cerent.cms.model.InvalidSampleType;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreAlarms;
import cerent.cms.model.NoSuchAlarm;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.RmonThresholdModel;
import cerent.cms.model.UnsupportedAlarm;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class RmonThresholdManager
extends Model {
    private NodeModelDelegate nmd;
    private RmonThresholds rmonThresholds;
    private RmonAllThresholds rmonAllThresholds;
    private RmonThresholdsCreator rmonThresholdsCreator;
    private RmonStatsSorting rmonStatsSorting;
    private RmonApplicableStats rmonApplicableStats;
    private RmonCumulativeStats rmonCumulativeStats;
    private RmonNonCumulativeStats rmonNonCumulativeStats;
    private RmonApplicableStatsStr rmonApplicableStatsStr;
    private Map rmonThresholdMap;
    private boolean isRmonThresholdMapInitialized;
    private EventDispatcher dispatcher;
    private Map statsStrCache;
    private static NodeSingletonFactory<RmonThresholdManager> sfactory = new NodeSingletonFactory<RmonThresholdManager>(RmonThresholdManager.class);

    private RmonThresholdManager(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(RmonThresholdManager.class));
        this.index = 0;
        this.nmd = nodeModelDelegate;
        this.rmonThresholds = new RmonThresholds("rmonThresholds", nodeModelDelegate);
        this.rmonAllThresholds = new RmonAllThresholds("rmonAllThresholds", nodeModelDelegate);
        this.rmonThresholdsCreator = new RmonThresholdsCreator("rmonThresholdsCreator", nodeModelDelegate);
        this.rmonStatsSorting = new RmonStatsSorting("rmonStatsSorting", nodeModelDelegate);
        this.rmonApplicableStats = new RmonApplicableStats("rmonApplicableStats", nodeModelDelegate);
        this.rmonCumulativeStats = new RmonCumulativeStats("rmonCumulativeStats", nodeModelDelegate);
        this.rmonNonCumulativeStats = new RmonNonCumulativeStats("rmonNonCumulativeStats", nodeModelDelegate);
        this.rmonApplicableStatsStr = new RmonApplicableStatsStr("rmonApplicableStatsStr", nodeModelDelegate);
        this.rmonThresholdMap = new TreeMap();
        this.isRmonThresholdMapInitialized = false;
        this.dispatcher = null;
    }

    public static RmonThresholdManager getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public void deleteThreshold(short s) throws NoSuchAlarm {
        try {
            this.rmonThresholds.set(new Short(s));
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw new NoSuchAlarm((UserException)xNoSuchAlarm2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sAlarmCombinedInfo[] getThresholds() {
        try {
            return (sAlarmCombinedInfo[])this.rmonAllThresholds.get(Boolean.TRUE);
        }
        catch (UserException userException) {
            throw this.doUnknown("getThresholds", userException);
        }
    }

    public sAlarmCombinedInfo[] getThresholds(int n) throws WrongInterfaceType, NoSuchInterface {
        try {
            return (sAlarmCombinedInfo[])this.rmonThresholds.get(new Integer(n));
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void createThreshold(sAlarmAdminInfo sAlarmAdminInfo2) throws InvalidAlarmType, InvalidAlarmInterval, DuplicateAlarm, InvalidAlarmThresholds, WrongInterfaceType, NoMoreAlarms, InvalidSampleType, UnsupportedAlarm, NoSuchInterface {
        try {
            this.rmonThresholdsCreator.set(sAlarmAdminInfo2);
        }
        catch (xInvalidAlarmType xInvalidAlarmType2) {
            throw new InvalidAlarmType((UserException)xInvalidAlarmType2);
        }
        catch (xInvalidAlarmInterval xInvalidAlarmInterval2) {
            throw new InvalidAlarmInterval((UserException)xInvalidAlarmInterval2);
        }
        catch (xDuplicateAlarm xDuplicateAlarm2) {
            throw new DuplicateAlarm((UserException)xDuplicateAlarm2);
        }
        catch (xInvalidAlarmThresholds xInvalidAlarmThresholds2) {
            throw new InvalidAlarmThresholds((UserException)xInvalidAlarmThresholds2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoMoreAlarms xNoMoreAlarms2) {
            throw new NoMoreAlarms((UserException)xNoMoreAlarms2);
        }
        catch (xInvalidSampleType xInvalidSampleType2) {
            throw new InvalidSampleType((UserException)xInvalidSampleType2);
        }
        catch (xUnsupportedAlarm xUnsupportedAlarm2) {
            throw new UnsupportedAlarm((UserException)xUnsupportedAlarm2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xNoSuchStatsId xNoSuchStatsId2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchStatsId2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void createThreshold(int n, eStatsId eStatsId2, eAlarmType eAlarmType2, eAlarmSampleType eAlarmSampleType2, int n2, long l, long l2, String string) throws InvalidAlarmType, InvalidAlarmInterval, DuplicateAlarm, InvalidAlarmThresholds, WrongInterfaceType, NoMoreAlarms, InvalidSampleType, UnsupportedAlarm, NoSuchInterface {
        this.createThreshold(new sAlarmAdminInfo(n, eStatsId2, eAlarmType2, eAlarmSampleType2, n2, l, l2, string.toCharArray()));
    }

    private eStatsId[] getStatsIdSorting() {
        try {
            return (eStatsId[])this.rmonStatsSorting.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public Comparator getStatsIdSorter() {
        eStatsId[] eStatsIdArray = this.getStatsIdSorting();
        if (eStatsIdArray != null) {
            return new RmonStatsComparator(eStatsIdArray);
        }
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((eStatsId)object).value() - ((eStatsId)object2).value();
            }
        };
    }

    public eStatsId[] getStatsIdList(int n) throws WrongInterfaceType, NoSuchInterface {
        try {
            eStatsId[] eStatsIdArray = (eStatsId[])this.rmonApplicableStats.get(new Integer(n));
            Arrays.sort(eStatsIdArray, this.getStatsIdSorter());
            return eStatsIdArray;
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public eStatsId[] getCumulativeStatsIdList(int n) throws WrongInterfaceType, NoSuchInterface {
        try {
            eStatsId[] eStatsIdArray = (eStatsId[])this.rmonCumulativeStats.get(new Integer(n));
            Arrays.sort(eStatsIdArray, this.getStatsIdSorter());
            return eStatsIdArray;
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public eStatsId[] getNonCumulativeStatsIdList(int n) throws WrongInterfaceType, NoSuchInterface {
        try {
            eStatsId[] eStatsIdArray = (eStatsId[])this.rmonNonCumulativeStats.get(new Integer(n));
            Arrays.sort(eStatsIdArray, this.getStatsIdSorter());
            return eStatsIdArray;
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public String[] getStatsIdListStr(eStatsId[] eStatsIdArray) {
        String[] stringArray = new String[eStatsIdArray.length];
        for (int i = 0; i < eStatsIdArray.length; ++i) {
            stringArray[i] = this.getStatsIdStr(eStatsIdArray[i]);
        }
        return stringArray;
    }

    private String[] getStatsIdString(eStatsId[] eStatsIdArray) throws NoSuchStatsId {
        try {
            return (String[])this.rmonApplicableStatsStr.get(eStatsIdArray);
        }
        catch (xNoSuchStatsId xNoSuchStatsId2) {
            throw new NoSuchStatsId((UserException)xNoSuchStatsId2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public String getStatsIdStr(eStatsId eStatsId2) {
        if (this.statsStrCache == null) {
            try {
                eStatsId[] eStatsIdArray = this.getStatsIdSorting();
                String[] stringArray = this.getStatsIdString(eStatsIdArray);
                this.statsStrCache = new HashMap();
                for (int i = 0; i < eStatsIdArray.length; ++i) {
                    this.statsStrCache.put(new Integer(eStatsIdArray[i].value()), stringArray[i]);
                }
            }
            catch (NoSuchStatsId noSuchStatsId) {
                SDebug.printStackTrace((Throwable)noSuchStatsId);
                return "!ERROR!";
            }
        }
        return (String)this.statsStrCache.get(new Integer(eStatsId2.value()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmonThresholdModel[] getRmonThresholdList() {
        Map map = this.rmonThresholdMap;
        synchronized (map) {
            return this.rmonThresholdMap.values().toArray(new RmonThresholdModel[0]);
        }
    }

    private void discoverRmonThresholds(Map map) {
        try {
            sAlarmInfo[] sAlarmInfoArray = (sAlarmInfo[])this.rmonAllThresholds.get(Boolean.FALSE);
            for (int i = 0; i < sAlarmInfoArray.length; ++i) {
                RmonThresholdModel rmonThresholdModel = new RmonThresholdModel(this.nmd, sAlarmInfoArray[i].alarmIndex, sAlarmInfoArray[i].adminInfo, null);
                map.put(new Short(sAlarmInfoArray[i].alarmIndex), rmonThresholdModel);
            }
        }
        catch (UserException userException) {
            this.db.println("user exception in discoverRmonThresholds");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        super.init0();
        Map map = this.rmonThresholdMap;
        synchronized (map) {
            if (!this.isRmonThresholdMapInitialized) {
                this.discoverRmonThresholds(this.rmonThresholdMap);
                this.initializeRmonThresholds();
            }
            this.isRmonThresholdMapInitialized = true;
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectRmonAlarm, 0, (Observer)this);
            if (this.db.on()) {
                this.db.println("RmonThresholdManager now observing 0");
            }
        }
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectRmonAlarm, 0, (Observer)this);
            if (this.db.on()) {
                this.db.println("RmonThresholdManager no longer observing 0");
            }
            this.dispatcher = null;
        }
        this.disposeRmonThresholdModels();
        this.statsStrCache = null;
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private void initializeRmonThresholds() {
        for (RmonThresholdModel rmonThresholdModel : this.rmonThresholdMap.values()) {
            rmonThresholdModel.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeRmonThresholdModels() {
        Map map = this.rmonThresholdMap;
        synchronized (map) {
            for (RmonThresholdModel rmonThresholdModel : this.rmonThresholdMap.values()) {
                rmonThresholdModel.destroy();
            }
            this.rmonThresholdMap.clear();
            this.isRmonThresholdMapInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRmonThreshold(RmonThresholdModel rmonThresholdModel) {
        Map map = this.rmonThresholdMap;
        synchronized (map) {
            Object v = this.rmonThresholdMap.remove(new Short(rmonThresholdModel.getThresholdIndex()));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on) {
            this.db.println("RmonThresholdManager.update(" + observable + ", " + object + ")");
        }
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 2: {
                    if (this.db.on) {
                        this.db.println("Making structural changes.");
                    }
                    this.updateStructure();
                    break;
                }
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else if (this.db.on) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    @Override
    protected void updateLocal() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private void updateStructure() {
        if (this.db.on) {
            this.db.println("Sending UpdateStructure");
        }
        this.updateRmonThresholdStructure();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRmonThresholdStructure() {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        Map map = this.rmonThresholdMap;
        synchronized (map) {
            RmonThresholdModel rmonThresholdModel;
            this.discoverRmonThresholds(hashMap);
            Collection collection = this.getAddedObjects(this.rmonThresholdMap.keySet(), hashMap.keySet());
            Collection collection2 = this.getDeletedObjects(this.rmonThresholdMap.keySet(), hashMap.keySet());
            for (Object e : collection) {
                rmonThresholdModel = (RmonThresholdModel)hashMap.get(e);
                rmonThresholdModel.init();
                this.rmonThresholdMap.put(e, rmonThresholdModel);
                bl = true;
            }
            for (Object e : collection2) {
                rmonThresholdModel = (RmonThresholdModel)this.rmonThresholdMap.get(e);
                this.rmonThresholdMap.remove(e);
                rmonThresholdModel.destroy();
            }
        }
        return bl;
    }

    private Collection getAddedObjects(Set set, Set set2) {
        HashSet hashSet = new HashSet(set2);
        hashSet.removeAll(set);
        return hashSet;
    }

    private Collection getDeletedObjects(Set set, Set set2) {
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(set2);
        return hashSet;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    private General getRmonRef() {
        return this.nmd.getIorRepository().getRmonRef();
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        RmonThresholdManager rmonThresholdManager = RmonThresholdManager.getInstance(nodeModelDelegate);
    }

    private UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        SDebug.printStackTrace((Throwable)userException);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    private class RmonAllThresholds
    extends NonCachedValue {
        public RmonAllThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            if (object == Boolean.TRUE) {
                return RmonThresholdManager.this.getRmonRef().getAlarmCombinedInfoList();
            }
            return RmonThresholdManager.this.getRmonRef().getAlarmInfoList();
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }

    private class RmonApplicableStats
    extends NonCachedValue {
        public RmonApplicableStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return RmonThresholdManager.this.getRmonRef().getStatsIdList(n);
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }

    private class RmonApplicableStatsStr
    extends NonCachedValue {
        public RmonApplicableStatsStr(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return RmonThresholdManager.this.getRmonRef().getStatsIdListStr((eStatsId[])object);
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }

    private class RmonCumulativeStats
    extends NonCachedValue {
        public RmonCumulativeStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return RmonThresholdManager.this.getRmonRef().getCumulativeStatsIdList(n);
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }

    private class RmonNonCumulativeStats
    extends NonCachedValue {
        public RmonNonCumulativeStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return RmonThresholdManager.this.getRmonRef().getNonCumulativeStatsIdList(n);
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }

    private class RmonStatsComparator
    implements Comparator {
        private final HashMap sorting = new HashMap();

        public RmonStatsComparator(eStatsId[] eStatsIdArray) {
            for (int i = 0; i < eStatsIdArray.length; ++i) {
                this.sorting.put(eStatsIdArray[i], new Integer(i));
            }
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)this.sorting.get((eStatsId)object);
            Integer n2 = (Integer)this.sorting.get((eStatsId)object2);
            return n.compareTo(n2);
        }
    }

    private class RmonStatsSorting
    extends CachedValue {
        public RmonStatsSorting(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return RmonThresholdManager.this.getRmonRef().getStatsIdSorting();
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }

    private class RmonThresholds
    extends NonCachedValue {
        public RmonThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            short s = (Short)object;
            RmonThresholdManager.this.getRmonRef().deleteAlarm(s);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return RmonThresholdManager.this.getRmonRef().getAlarmThresholds((Integer)object);
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }

    private class RmonThresholdsCreator
    extends NonCachedValue {
        public RmonThresholdsCreator(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            short s = RmonThresholdManager.this.getRmonRef().createAlarm((sAlarmAdminInfo)object);
        }

        public Object outer() {
            return RmonThresholdManager.this;
        }
    }
}

