/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IDccConnectionTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchTerm;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class SdccTermConnectionModel
extends AbstractTermConnectionModel
implements IDccConnectionTableModel {
    private static final OhChannelType DCC_TERM_CHANNEL = OhChannelType.SDCC_OBJ;
    private static final OhChannelType SDCC_IPTUNNEL_CHANNEL = OhChannelType.SDCC_IPTUNNEL_OBJ;
    private static NodeSingletonFactory<SdccTermConnectionModel> sfactory = new NodeSingletonFactory<SdccTermConnectionModel>(SdccTermConnectionModel.class);

    public static SdccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private SdccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        SdccTermConnectionModel sdccTermConnectionModel = (SdccTermConnectionModel)nodeModelDelegate.getDccTermConnectionModel();
        sdccTermConnectionModel.init();
    }

    public void addSdccObserver(int n, Observer observer) throws NoSuchTerm {
        this.addTermObserver(n, observer);
    }

    public void deleteSdccObserver(int n, Observer observer) {
        this.deleteTermObserver(n, observer);
    }

    @Override
    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    @Override
    public IEntityModel[] getTermCandidates() {
        Set set;
        Object object;
        HashSet<IEntityModel> hashSet = new HashSet<IEntityModel>();
        ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        if (this.nmd.getTdmProtocolTypeObj().isSonet()) {
            object = elementModelsDelegate.getNonProtectOpticalEntities();
            set = elementModelsDelegate.getNonProtectDwdmEntities();
            TreeSet<IPortModel> treeSet = new TreeSet<IPortModel>();
            for (IEntityModel iEntityModel : set) {
                if (!(iEntityModel instanceof DwdmPortModel)) continue;
                try {
                    if (((DwdmPortModel)iEntityModel).getInterfaceModel().getHigherLayerModelsForNet().length <= 0 || !((DwdmPortModel)iEntityModel).isClientPort()) continue;
                    IPortModel iPortModel = ((PortModel)iEntityModel).getInterfaceModel().getHigherLayerModelsForNet()[0].getPortModel();
                    int n = iEntityModel.getModuleModel().getEqType();
                    if (!(iPortModel instanceof TdmPortModel)) continue;
                    int n2 = ((DwdmPortModel)iEntityModel).getDwdmLineModel().getTermMode();
                    if (n != 301 && n != 300 && n != 356 && n != 358 || n2 != 2 && n2 != 1) continue;
                    treeSet.add(iPortModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            object.addAll(treeSet);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                try {
                    IEntityModel iEntityModel;
                    iEntityModel = (EntityModel)iterator.next();
                    if (iEntityModel.getMediumType() != 1) continue;
                    if (this.db.on()) {
                        this.db.println("Found a Sonet port " + iEntityModel + " adding ...");
                    }
                    hashSet.add(iEntityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        } else {
            hashSet.addAll(elementModelsDelegate.getNonProtectOpticalEntities());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            set = (IPortModel)object.next();
            if (set.getModuleModel().getEqType() != 273 || set.getPortNum()[0] != 17) continue;
            object.remove();
        }
        hashSet.removeAll(ohConnectionModelsDelegate.getUsedOpticalPorts(DCC_TERM_CHANNEL));
        hashSet.removeAll(ohConnectionModelsDelegate.getUsedOpticalPorts(SDCC_IPTUNNEL_CHANNEL));
        hashSet.removeAll(this.dwdmNotAllowedPorts(hashSet, 0));
        set = this.excludeUcpTerms(hashSet);
        return set.toArray(new IEntityModel[0]);
    }

    @Override
    protected String getTypeName() {
        return this.nmd.getTDMTerminology().getGeneralTerms(8);
    }

    @Override
    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return DCC_TERM_CHANNEL;
    }

    @Override
    protected boolean termQualifies(OhTermModel ohTermModel) {
        return ohTermModel.getChannelType() == 0 && !this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }
}

