/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ePST;
import cerent.cms.idl.Common.eSST;
import cerent.cms.model.IServiceState;
import cerent.util.TDMTerminology;
import java.util.ArrayList;

public class ServiceState
implements IServiceState {
    private int type;
    private ePST primaryState;
    private eSST[] secondaryStates;
    private static ArrayList disallowEquipAdminChange = new ArrayList();

    ServiceState(int n, ePST ePST2, eSST eSST2) {
        eSST[] eSSTArray = new eSST[]{eSST2};
        this.init(n, ePST2, eSSTArray);
    }

    ServiceState(int n, ePST ePST2, eSST eSST2, eSST eSST3) {
        eSST[] eSSTArray = new eSST[]{eSST2, eSST3};
        this.init(n, ePST2, eSSTArray);
    }

    ServiceState(int n, ePST ePST2, eSST eSST2, eSST eSST3, eSST eSST4) {
        eSST[] eSSTArray = new eSST[]{eSST2, eSST3, eSST4};
        this.init(n, ePST2, eSSTArray);
    }

    ServiceState(int n, ePST ePST2, eSST eSST2, eSST eSST3, eSST eSST4, eSST eSST5) {
        eSST[] eSSTArray = new eSST[]{eSST2, eSST3, eSST4, eSST5};
        this.init(n, ePST2, eSSTArray);
    }

    ServiceState() {
    }

    private void init(int n, ePST ePST2, eSST[] eSSTArray) {
        this.type = n;
        this.primaryState = ePST2;
        this.secondaryStates = eSSTArray;
    }

    static boolean isIS_NR(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_IS_NR, ePST2, eSST.SST_NONE, eSSTArray);
    }

    static boolean isOOS_AU_AINS(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_AINS, eSSTArray);
    }

    static boolean isOOS_MA_DSBLD(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_DSBLD, eSSTArray);
    }

    static boolean isOOS_MA_MT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_MT, eSSTArray);
    }

    static boolean isOOS_MA_LPBK_MT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_LPBK, eSST.SST_MT, eSSTArray);
    }

    static boolean isOOS_AU_AINS_MEA(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_AINS, eSST.SST_MEA, eSSTArray);
    }

    static boolean isOOS_AU_AINS_SWDL(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_AINS, eSST.SST_SWDL, eSSTArray);
    }

    static boolean isOOS_AU_AINS_UEQ(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_AINS, eSST.SST_UEQ, eSSTArray);
    }

    static boolean isOOS_AU_MEA(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_MEA, eSSTArray);
    }

    static boolean isOOS_AU_SWDL(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_SWDL, eSSTArray);
    }

    static boolean isOOS_AU_UEQ(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_UEQ, eSSTArray);
    }

    static boolean isOOS_AUMA_MEA_MT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_MEA, eSST.SST_MT, eSSTArray);
    }

    static boolean isOOS_AUMA_MEA_UAS(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_MEA, eSST.SST_UAS, eSSTArray);
    }

    static boolean isOOS_AUMA_MT_UEQ(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_MT, eSST.SST_UEQ, eSSTArray);
    }

    static boolean isOOS_AUMA_MT_SWDL(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_MT, eSST.SST_SWDL, eSSTArray);
    }

    static boolean isOOS_AUMA_UAS(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_UAS, eSSTArray);
    }

    static boolean isOOS_AUMA_UAS_UEQ(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_UAS, eSST.SST_UEQ, eSSTArray);
    }

    static boolean isOOS_MA_DSBLD_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_DSBLD, eSST.SST_OOG, eSSTArray);
    }

    static boolean isOOS_MA_MT_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_MT, eSST.SST_OOG, eSSTArray);
    }

    static boolean isOOS_MA_LPBK_MT_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_LPBK, eSST.SST_MT, eSST.SST_OOG, eSSTArray);
    }

    static boolean isOOS_AU(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_NONE, eSSTArray);
    }

    static boolean isOOS_MA_FLT_MT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_FLT, eSST.SST_MT, eSSTArray);
    }

    static boolean isOOS_MA_FLT_LPBK_MT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_FLT, eSST.SST_LPBK, eSST.SST_MT, eSSTArray);
    }

    static boolean isOOS_AU_FLT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_FLT, eSSTArray);
    }

    static boolean isOOS_AU_AINS_FLT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_AINS, eSST.SST_FLT, eSSTArray);
    }

    static boolean isOOS_AU_FLT_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_FLT, eSST.SST_OOG, eSSTArray);
    }

    static boolean isOOS_AUMA_FLT_MT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_FLT, eSST.SST_MT, eSSTArray);
    }

    static boolean isOOS_AUMA_FLT_LPBK_MT(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_FLT, eSST.SST_LPBK, eSST.SST_MT, eSSTArray);
    }

    static boolean isOOS_AUMA_FLT_MT_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_FLT, eSST.SST_MT, eSST.SST_OOG, eSSTArray);
    }

    static boolean isOOS_MA_FLT_MT_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_MA, ePST2, eSST.SST_FLT, eSST.SST_MT, eSST.SST_OOG, eSSTArray);
    }

    static boolean isOOS_AUMA_FLT_LPBK_MT_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AUMA, ePST2, eSST.SST_FLT, eSST.SST_LPBK, eSST.SST_MT, eSST.SST_OOG, eSSTArray);
    }

    static boolean isOOS_AU_AINS_FLT_OOG(ePST ePST2, eSST[] eSSTArray) {
        return ServiceState.verifyState(ePST.PST_OOS_AU, ePST2, eSST.SST_AINS, eSST.SST_FLT, eSST.SST_OOG, eSSTArray);
    }

    private static boolean verifyState(ePST ePST2, ePST ePST3, eSST eSST2, eSST[] eSSTArray) {
        return ePST2 == ePST3 && eSSTArray.length == 1 && eSST2 == eSSTArray[0];
    }

    private static boolean verifyState(ePST ePST2, ePST ePST3, eSST eSST2, eSST eSST3, eSST[] eSSTArray) {
        return ePST2 == ePST3 && eSSTArray.length == 2 && ServiceState.contains(eSST2, eSSTArray) && ServiceState.contains(eSST3, eSSTArray);
    }

    private static boolean verifyState(ePST ePST2, ePST ePST3, eSST eSST2, eSST eSST3, eSST eSST4, eSST[] eSSTArray) {
        return ePST2 == ePST3 && eSSTArray.length == 3 && ServiceState.contains(eSST2, eSSTArray) && ServiceState.contains(eSST3, eSSTArray) && ServiceState.contains(eSST4, eSSTArray);
    }

    private static boolean verifyState(ePST ePST2, ePST ePST3, eSST eSST2, eSST eSST3, eSST eSST4, eSST eSST5, eSST[] eSSTArray) {
        return ePST2 == ePST3 && eSSTArray.length == 4 && ServiceState.contains(eSST2, eSSTArray) && ServiceState.contains(eSST3, eSSTArray) && ServiceState.contains(eSST4, eSSTArray) && ServiceState.contains(eSST5, eSSTArray);
    }

    private static boolean contains(eSST eSST2, eSST[] eSSTArray) {
        for (int i = 0; i < eSSTArray.length; ++i) {
            if (eSST2 != eSSTArray[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isFormOfMT() {
        return ServiceState.contains(eSST.SST_MT, this.secondaryStates);
    }

    public static boolean isEquipmentAdminStateChangeAllowed(IServiceState iServiceState) {
        return !disallowEquipAdminChange.contains(new Integer(iServiceState.getType()));
    }

    public static boolean isEquipmentResetAvailable(IServiceState iServiceState) {
        return iServiceState.equals(0) || iServiceState.equals(3) || iServiceState.equals(22) || iServiceState.equals(25);
    }

    public boolean equals(IServiceState iServiceState) {
        if (iServiceState == null) {
            return false;
        }
        return iServiceState.getType() == this.type;
    }

    public boolean equals(Object object) {
        if (null == object || !(object instanceof IServiceState)) {
            return false;
        }
        return this.equals((IServiceState)object);
    }

    public int hashCode() {
        return this.type;
    }

    public boolean equals(int n) {
        return n == this.type;
    }

    public int getType() {
        return this.type;
    }

    public String toString(TDMTerminology tDMTerminology) {
        if (this.type == -1) {
            return "Unknown";
        }
        if (this.type == -2) {
            return "";
        }
        return tDMTerminology.getTermForServiceState(this.type);
    }

    public int getPSTValue() {
        if (this.primaryState != null) {
            return this.primaryState.value();
        }
        return -1;
    }

    static {
        disallowEquipAdminChange.add(new Integer(16));
        disallowEquipAdminChange.add(new Integer(15));
        disallowEquipAdminChange.add(new Integer(12));
        disallowEquipAdminChange.add(new Integer(7));
        disallowEquipAdminChange.add(new Integer(5));
        disallowEquipAdminChange.add(new Integer(9));
        disallowEquipAdminChange.add(new Integer(6));
        disallowEquipAdminChange.add(new Integer(14));
    }
}

