/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvSideModel;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.Node.xConfigError;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.sSideInfo;
import cerent.cms.idl.OpticsTopology.xInvalidPortsForSide;
import cerent.cms.idl.OpticsTopology.xInvalidTopology;
import cerent.cms.idl.OpticsTopology.xPortIsConnected;
import cerent.cms.idl.OpticsTopology.xPortUsedBySide;
import cerent.cms.idl.OpticsTopology.xSideInUse;
import cerent.cms.idl.OpticsTopology.xWrongNodeSide;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISideModels;
import cerent.cms.model.InvalidPortsForSide;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortIsConnected;
import cerent.cms.model.PortUsedBySide;
import cerent.cms.model.SideInUse;
import cerent.cms.model.SideModel;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.DwdmSide;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.UserException;

public class SideModels
extends Model
implements ISideModels {
    private HashMap<Integer, ISideModel> sides = new HashMap();
    private SideCreator sideCreator;
    private SideDeletor sideDeletor;
    private SidesRetriever sidesRetriever;
    private SideEditor sideEditor;
    private PortsForSideList portsForSideList;
    private NodeModelDelegate nmd;
    private EventDispatcher dispatcher;
    private UniqueLinkSRLG uniqueLinkSRLG;
    private AdditionalLinkSRLG additionalLinkSRLG;
    private static NodeSingletonFactory<SideModels> sfactory = new NodeSingletonFactory<SideModels>(SideModels.class);

    public static final SideModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private SideModels(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(SideModels.class, SideModelsDebug.class, this));
        if (this.db.on()) {
            this.db.println("SideModels(NodeModelDelegate node)");
        }
        this.index = 0;
        this.nmd = nodeModelDelegate;
        this.sideCreator = new SideCreator("sideCreator", this.nmd);
        this.sideDeletor = new SideDeletor("sideDeletor", this.nmd);
        this.sideEditor = new SideEditor("sideEditor", this.nmd);
        this.sidesRetriever = new SidesRetriever("sideRetriever", this.nmd);
        this.portsForSideList = new PortsForSideList("portsForSideList", this.nmd);
        this.uniqueLinkSRLG = new UniqueLinkSRLG("uniqueLinkSRLG", this.nmd);
        this.additionalLinkSRLG = new AdditionalLinkSRLG("additionalLinkSRLG", this.nmd);
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmSideList, (Observer)this);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Iterator<ISideModel> iterator = this.sides.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().destroy();
        }
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmSideList, (Observer)this);
            this.dispatcher = null;
        }
        this.clearCache();
        this.sideCreator.dispose();
        this.sideDeletor.dispose();
        this.sidesRetriever.dispose();
        this.portsForSideList.dispose();
        this.sideEditor.dispose();
        this.uniqueLinkSRLG.dispose();
        this.additionalLinkSRLG.dispose();
        super.dispose();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public ISideModel[] getSides() {
        Object object;
        if (this.db.on()) {
            object = "----- getSides() is called from ";
            Throwable throwable = new Throwable();
            if (throwable.getStackTrace().length > 1) {
                object = (String)object + throwable.getStackTrace()[1].toString();
            }
            this.db.fine((String)object);
        }
        if (this.sides.isEmpty()) {
            this.updateCache();
        } else {
            this.db.fine("getSides() ----- get Sides from cache ...");
            if (this.db.on) {
                for (ISideModel iSideModel : this.sides.values()) {
                    this.db.println(iSideModel.toString());
                }
            }
        }
        object = this.sides.values().toArray(new ISideModel[0]);
        Arrays.sort(object, new SideSorter());
        return object;
    }

    public IEntityModel[] getAvailablePorts() throws AbstractCmsIOException, UserException, AbstractCmsNoSuchEntityException {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        int[] nArray = (int[])this.portsForSideList.get();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.nmd.getEntityTableModel().getEntityModelByIndex(nArray[i]));
        }
        return arrayList.toArray(new IEntityModel[0]);
    }

    public void addSide(int n, int n2, int n3) throws NoSuchInterface, WrongNodeSide, InvalidPortsForSide, SideInUse, PortUsedBySide, PortIsConnected, UserException {
        try {
            this.sideCreator.set(new Object[]{new Integer(n), new Integer(n2), new Integer(n3)});
        }
        catch (xInvalidPortsForSide xInvalidPortsForSide2) {
            throw new InvalidPortsForSide((UserException)xInvalidPortsForSide2);
        }
        catch (xSideInUse xSideInUse2) {
            throw new SideInUse((UserException)xSideInUse2);
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (xPortUsedBySide xPortUsedBySide2) {
            throw new PortUsedBySide((UserException)xPortUsedBySide2, xPortUsedBySide2.portBusy);
        }
        catch (xPortIsConnected xPortIsConnected2) {
            throw new PortIsConnected((UserException)xPortIsConnected2, xPortIsConnected2.connectedPort);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
    }

    public void deleteSide(int n, int n2) throws WrongNodeSide, SideInUse, UserException {
        try {
            this.sideDeletor.set(new Object[]{new Integer(n), new Integer(n2)});
        }
        catch (xSideInUse xSideInUse2) {
            throw new SideInUse((UserException)xSideInUse2);
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
    }

    public void editSide(int n, int n2, int n3) throws WrongNodeSide, SideInUse, UserException {
        try {
            this.sideEditor.set(new Object[]{new Integer(n), new Integer(n3), new Integer(n2)});
        }
        catch (xSideInUse xSideInUse2) {
            throw new SideInUse((UserException)xSideInUse2);
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
    }

    private DwdmOpticalSetup getSideRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.db.info("update from " + observable + " regarding " + object);
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: {
                    this.db.fine("\tObjectChanged");
                    this.updateLocal();
                    this.cacheAdd();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    @Override
    protected void updateLocal() {
        this.sidesRetriever.update();
        this.uniqueLinkSRLG.update();
        this.additionalLinkSRLG.update();
        super.updateLocal();
    }

    private void clearCache() {
        Iterator<ISideModel> iterator = this.sides.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().destroy();
        }
        this.sides.clear();
    }

    private void cacheDelete(int n) {
        if (this.sides.containsKey(n)) {
            this.sides.remove(n);
        }
    }

    private void updateCache() {
        try {
            sSideInfo[] sSideInfoArray = (sSideInfo[])this.sidesRetriever.get();
            if (sSideInfoArray != null) {
                for (int i = 0; i < sSideInfoArray.length; ++i) {
                    SideModel sideModel = new SideModel(sSideInfoArray[i].side, sSideInfoArray[i].portIn, sSideInfoArray[i].portOut, sSideInfoArray[i].osc, sSideInfoArray[i].dcnEnabled, sSideInfoArray[i].UniqueLinkSRLG, sSideInfoArray[i].AdditionalLinkSRLG, this.nmd);
                    this.sides.put(sSideInfoArray[i].portIn, sideModel);
                }
            }
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            if (this.db.on()) {
                this.db.println("Node does not support side retrieval");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    private void cacheAdd() {
        try {
            sSideInfo[] sSideInfoArray = (sSideInfo[])this.sidesRetriever.get();
            if (sSideInfoArray != null) {
                for (int i = 0; i < sSideInfoArray.length; ++i) {
                    if (!this.sides.containsKey(sSideInfoArray[i].portIn)) {
                        SideModel sideModel = new SideModel(sSideInfoArray[i].side, sSideInfoArray[i].portIn, sSideInfoArray[i].portOut, sSideInfoArray[i].osc, sSideInfoArray[i].dcnEnabled, sSideInfoArray[i].UniqueLinkSRLG, sSideInfoArray[i].AdditionalLinkSRLG, this.nmd);
                        this.sides.put(sSideInfoArray[i].portIn, sideModel);
                        this.db.fine("cacheAdd() ---- added  a new model into the cache! (" + ((Object)sideModel).toString() + ")");
                        continue;
                    }
                    this.db.fine("cacheAdd() ---- the model is already stored into the cache (" + this.sides.get(sSideInfoArray[i].portIn).toString() + ")");
                }
                if (this.db.on()) {
                    this.checkCache(sSideInfoArray);
                }
            }
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            if (this.db.on()) {
                this.db.println("Node does not support side retrieval");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    private void checkCache(sSideInfo[] sSideInfoArray) {
        for (int i = 0; i < sSideInfoArray.length; ++i) {
            if (!this.sides.containsKey(sSideInfoArray[i].portIn)) {
                this.db.println("WARNING: ---- checkCache() --- The following Side is not contained into cache: " + this.printSideInfo(sSideInfoArray[i]));
                continue;
            }
            ISideModel iSideModel = this.sides.get(sSideInfoArray[i].portIn);
            if (iSideModel.getId() == sSideInfoArray[i].side && iSideModel.getLineOut() == sSideInfoArray[i].portOut && iSideModel.isDcnEnabled() == sSideInfoArray[i].dcnEnabled && iSideModel.getUniqueLinkSRLG() == sSideInfoArray[i].UniqueLinkSRLG && iSideModel.getAdditionalLinkSRLG() == sSideInfoArray[i].AdditionalLinkSRLG) continue;
            this.db.println("WARNING: ---- checkCache() --- The following Side in the cache " + iSideModel.toString() + "\nhas different values of the same into tcc: " + this.printSideInfo(sSideInfoArray[i]));
        }
        if (this.sides.size() > sSideInfoArray.length) {
            HashMap hashMap = (HashMap)this.sides.clone();
            for (int i = 0; i < sSideInfoArray.length; ++i) {
                hashMap.remove(sSideInfoArray[i].portIn);
            }
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                this.db.println("WARNING: ---- cacheAdd() ----  one Side more into local cache (" + ((ISideModel)iterator.next()).toString() + ")");
            }
        }
    }

    private String printSideInfo(sSideInfo sSideInfo2) {
        String string = "SideId: " + sSideInfo2.side + "[" + DwdmSide.getSideFromOffset(sSideInfo2.side) + "] LineIn: " + sSideInfo2.portIn + " LineOut: " + sSideInfo2.portOut + " DCNEnabled: " + sSideInfo2.dcnEnabled + " UniqueLinkSRLG: " + sSideInfo2.UniqueLinkSRLG + " AdditionalLinkSRLG: " + sSideInfo2.AdditionalLinkSRLG;
        return string;
    }

    private void cacheEdit(int n) {
        try {
            sSideInfo[] sSideInfoArray = (sSideInfo[])this.sidesRetriever.get();
            if (sSideInfoArray != null) {
                for (int i = 0; i < sSideInfoArray.length; ++i) {
                    if (n != sSideInfoArray[i].portIn) continue;
                    if (this.sides.containsKey(n)) {
                        this.sides.get(sSideInfoArray[i].portIn).updateModel(sSideInfoArray[i].side, sSideInfoArray[i].portIn, sSideInfoArray[i].portOut, sSideInfoArray[i].osc, sSideInfoArray[i].dcnEnabled, sSideInfoArray[i].UniqueLinkSRLG, sSideInfoArray[i].AdditionalLinkSRLG);
                        this.db.fine("cacheEdit() ---- updated  a model already stored into local cache (" + this.sides.get(sSideInfoArray[i].portIn).toString() + ")");
                        break;
                    }
                    this.db.fine("WARNING ------- cacheEdit() ---- the side model is not yet into local cache! (SideId: " + sSideInfoArray[i].side + ")");
                }
                if (this.db.on()) {
                    this.checkCache(sSideInfoArray);
                }
            }
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            if (this.db.on()) {
                this.db.println("Node does not support side retrieval");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void removeSide(int n) {
        this.cacheDelete(n);
        this.updateLocal();
    }

    public void updateSide(int n) {
        this.updateLocal();
        this.cacheEdit(n);
    }

    public boolean hasSideForCard(IModuleModel iModuleModel) {
        ISideModel[] iSideModelArray = this.getSides();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            IEntityModel iEntityModel = null;
            IEntityModel iEntityModel2 = null;
            try {
                iEntityModel = this.nmd.getEntityTableModel().getEntityModelByIndex(iSideModelArray[i].getLineIn());
                iEntityModel2 = this.nmd.getEntityTableModel().getEntityModelByIndex(iSideModelArray[i].getLineOut());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.info(abstractCmsNoSuchEntityException.getMessage());
            }
            if ((iEntityModel == null || iEntityModel.getModuleModel() != iModuleModel) && (iEntityModel2 == null || iEntityModel2.getModuleModel() != iModuleModel)) continue;
            return true;
        }
        return false;
    }

    public ISideModel getSideById(int n) throws WrongNodeSide {
        ISideModel[] iSideModelArray = this.getSides();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            if (iSideModelArray[i].getId() != n) continue;
            return iSideModelArray[i];
        }
        throw new WrongNodeSide("Invalid SideId specified 0x" + Integer.toHexString(n));
    }

    public long getUniqueLinkSRLG(int n) throws NoSuchInterface, WrongNodeSide, UserException {
        return this.getSideById(n).getUniqueLinkSRLG();
    }

    public void setUniqueLinkSRLG(int n, long l) throws NoSuchInterface, WrongNodeSide, ConfigError, UserException {
        try {
            this.uniqueLinkSRLG.set(new Object[]{new Integer(n), new Long(l)});
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw xWrongNodeSide2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (xConfigError xConfigError2) {
            throw xConfigError2;
        }
        catch (UserException userException) {
            throw userException;
        }
    }

    public void setDefaultUniqueLinkSRLG(int n) throws NoSuchInterface, WrongNodeSide, UserException {
        try {
            this.uniqueLinkSRLG.set(new Object[]{new Integer(n)});
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw xWrongNodeSide2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw userException;
        }
    }

    public String getAdditionalLinkSRLG(int n) throws NoSuchInterface, WrongNodeSide, UserException {
        return this.getSideById(n).getAdditionalLinkSRLG();
    }

    public void setAdditionalLinkSRLG(int n, String string) throws NoSuchInterface, WrongNodeSide, UserException {
        try {
            this.additionalLinkSRLG.set(new Object[]{new Integer(n), new String(string)});
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw userException;
        }
    }

    public void setDefaultAdditionalLinkSRLG(int n) throws NoSuchInterface, WrongNodeSide, UserException {
        try {
            this.additionalLinkSRLG.set(new Object[]{new Integer(n)});
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw userException;
        }
    }

    public IFvSideModel[] getIFvSides() {
        if (this.db.on()) {
            Object object = "----- getSides() is called from ";
            Throwable throwable = new Throwable();
            if (throwable.getStackTrace().length > 1) {
                object = (String)object + throwable.getStackTrace()[1].toString();
            }
            this.db.fine((String)object);
        }
        if (this.sides.isEmpty()) {
            this.updateCache();
        } else {
            this.db.fine("getSides() ----- get Sides from cache ...");
            if (this.db.on) {
                for (ISideModel iSideModel : this.sides.values()) {
                    this.db.println(iSideModel.toString());
                }
            }
        }
        return this.sides.values().toArray(new IFvSideModel[0]);
    }

    public Set<String> getAllSidesString() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ISideModel iSideModel : this.sides.values()) {
            hashSet.add(iSideModel.getName());
        }
        return hashSet;
    }

    public Set<String> getAllSidesLabels() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ISideModel iSideModel : this.sides.values()) {
            hashSet.add(iSideModel.getNameLabel());
        }
        return hashSet;
    }

    public ISideModel getSideUsedByPort(int n) {
        for (ISideModel iSideModel : this.sides.values()) {
            if (iSideModel.getLineIn() != n && iSideModel.getLineOut() != n) continue;
            return iSideModel;
        }
        return null;
    }

    public ISideModel getSideUsedByPort(IEntityModel iEntityModel) {
        return this.getSideUsedByPort(iEntityModel.getEntityIndex());
    }

    public ISideModel getSide(int n, int n2, int n3) {
        for (ISideModel iSideModel : this.sides.values()) {
            if (iSideModel.getId() != n || iSideModel.getLineIn() != n2 || iSideModel.getLineOut() != n3) continue;
            return iSideModel;
        }
        return null;
    }

    public ISideModel getSide(int n, IPortModel iPortModel, IPortModel iPortModel2) {
        return this.getSide(n, iPortModel.getIndex(), iPortModel2.getIndex());
    }

    private class AdditionalLinkSRLG
    extends CachedValue {
        public AdditionalLinkSRLG(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xNoSuchInterface, xWrongNodeSide, xInvalidTopology {
            int n = (Integer)object;
            return SideModels.this.getSideRef().getAdditionalLinkSRLG(n);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongNodeSide, xInvalidTopology {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 2) {
                int n = (Integer)objectArray[0];
                String string = (String)objectArray[1];
                SideModels.this.getSideRef().setAdditionalLinkSRLG(n, string);
            } else {
                SideModels.this.getSideRef().resetToDefaultAdditionalLinkSRLG((Integer)objectArray[0]);
            }
        }

        public Object outer() {
            return SideModels.this;
        }
    }

    private class PortsForSideList
    extends NonCachedValue {
        public PortsForSideList(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            if (SideModels.this.db.on) {
                SideModels.this.db.println("PortsForSideList::getValue");
            }
            int[] nArray = SideModels.this.getSideRef().getPortsAvailableForSide();
            return nArray;
        }

        public Object outer() {
            return SideModels.this;
        }
    }

    private class SideCreator
    extends NonCachedValue {
        public SideCreator(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xInvalidPortsForSide, xSideInUse, xWrongNodeSide, xPortUsedBySide, xPortIsConnected, xNoSuchInterface, xInvalidTopology {
            Object[] objectArray = (Object[])object;
            if (SideModels.this.db.on()) {
                SideModels.this.db.println("SideCreator::setVale() SIDE CREATION___ SideId: " + (Integer)objectArray[0] + " LineIn: " + (Integer)objectArray[1] + " LineOut: " + (Integer)objectArray[2]);
            }
            SideModels.this.getSideRef().createSide((Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[0]);
        }

        public Object outer() {
            return SideModels.this;
        }
    }

    private class SideDeletor
    extends NonCachedValue {
        public SideDeletor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xSideInUse, xWrongNodeSide {
            Object[] objectArray = (Object[])object;
            if (SideModels.this.db.on()) {
                SideModels.this.db.println("SideDeletor::setValue() SIDE DELETE___ SideId: " + (Integer)objectArray[0] + " LineIn: " + (Integer)objectArray[1]);
            }
            SideModels.this.getSideRef().deleteSide((Integer)objectArray[0], (Integer)objectArray[1]);
        }

        public Object outer() {
            return SideModels.this;
        }
    }

    private class SideEditor
    extends NonCachedValue {
        public SideEditor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xSideInUse, xWrongNodeSide {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            int n3 = (Integer)objectArray[2];
            if (SideModels.this.db.on()) {
                SideModels.this.db.println("SideEditor::setValue() SIDE EDIT___  OldSideId: " + n + " NewSideId: " + n3 + " LineIn: " + n2);
            }
            SideModels.this.getSideRef().editSide(n, n2, n3);
        }

        public Object outer() {
            return SideModels.this;
        }
    }

    public class SideModelsDebug
    extends SDebug {
        public SideModelsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            SideModels.this.db.println("------ SideModels -------");
            if (SideModels.this.sides != null) {
                HashMap hashMap = SideModels.this.sides;
                synchronized (hashMap) {
                    for (ISideModel iSideModel : SideModels.this.sides.values()) {
                        SideModels.this.db.println(iSideModel.toString());
                    }
                }
            }
            SideModels.this.db.println("^^^^^^ SideModels ^^^^^^");
        }
    }

    public static class SideSorter
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            if (!(object instanceof ISideModel) || !(object2 instanceof ISideModel)) {
                throw new ClassCastException("Cannot Cast to ISideModel");
            }
            return ((ISideModel)object).getName().compareTo(((ISideModel)object2).getName());
        }
    }

    private class SidesRetriever
    extends CachedValue {
        public SidesRetriever(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xFeatureUnsupported {
            sSideInfo[] sSideInfoArray = SideModels.this.getSideRef().getSideList();
            SideModels.this.db.fine("SidesRetriever::getValue()   get Sides from node ...");
            if (SideModels.this.db.on()) {
                for (int i = 0; i < sSideInfoArray.length; ++i) {
                    SideModels.this.db.println("SideId : " + sSideInfoArray[i].side + "[" + DwdmSide.getSideFromOffset(sSideInfoArray[i].side) + "] LineIn : " + sSideInfoArray[i].portIn + " LineOut : " + sSideInfoArray[i].portOut + " Osc : " + sSideInfoArray[i].osc + " DcnEnabled : " + sSideInfoArray[i].dcnEnabled + " UniqueLinkSRLG : " + sSideInfoArray[i].UniqueLinkSRLG + " AdditionalLinkSRLG : " + sSideInfoArray[i].AdditionalLinkSRLG);
                }
            }
            return sSideInfoArray;
        }

        public Object outer() {
            return SideModels.this;
        }
    }

    private class UniqueLinkSRLG
    extends CachedValue {
        public UniqueLinkSRLG(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xNoSuchInterface, xWrongNodeSide, xInvalidTopology {
            int n = (Integer)object;
            return new Long(SideModels.this.getSideRef().getUniqueLinkSRLG(n));
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongNodeSide, xConfigError, xInvalidTopology {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 2) {
                int n = (Integer)objectArray[0];
                long l = (Long)objectArray[1];
                SideModels.this.getSideRef().setUniqueLinkSRLG(n, l);
            } else {
                SideModels.this.getSideRef().resetToDefaultUniqueLinkSRLG((Integer)objectArray[0]);
            }
        }

        public Object outer() {
            return SideModels.this;
        }
    }
}

