/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.sParameterInfo;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.idl.OpticsTopology.sSpanLossInfo;
import cerent.cms.idl.OpticsTopology.xCannotPerform;
import cerent.cms.model.AnsParamModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISpanCheckModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.DwdmSide;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class SpanCheckModel
extends Model
implements ISpanCheckModel {
    protected NodeModelDelegate nmd;
    protected EventDispatcher dispatcher;
    private CalculateSpanLoss calcSpanLossRef;
    private SpanLossInfo spanLossInfoRef;
    private static final int MEASURED_SPAN_LOSS = 0;
    private static final int EXPECTED_MIN_SPAN_LOSS = 1;
    private static final int EXPECTED_MAX_SPAN_LOSS = 2;
    private static final int RESOLUTION = 3;
    private static final int DIFFERENCE = 4;
    private static final int CALCTYPE = 5;
    public static final String UNDEFINED = "N/A";
    private boolean calcResponseStatus = false;
    private static final int VAL_UNDEF = -1000000;
    private AnsParamModel spanMinExpElem;
    private AnsParamModel spanMaxExpElem;
    private sParameterKey spanExpKey;

    SpanCheckModel(NodeModelDelegate nodeModelDelegate, sSpanLossInfo sSpanLossInfo2) {
        super(nodeModelDelegate.getChildDebug(SpanCheckModel.class));
        this.nmd = nodeModelDelegate;
        this.index = sSpanLossInfo2.side;
        this.dispatcher = null;
        this.calcSpanLossRef = new CalculateSpanLoss(this.nmd, "SpanCheckModel::CalculateSpanLoss");
        this.spanLossInfoRef = new SpanLossInfo(this.nmd, "SpanCheckModel::SpanLossInfo");
    }

    SpanCheckModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(SpanCheckModel.class));
        this.nmd = nodeModelDelegate;
        this.dispatcher = null;
        this.calcSpanLossRef = new CalculateSpanLoss(this.nmd, "SpanCheckModel::CalculateSpanLoss");
        this.spanLossInfoRef = new SpanLossInfo(this.nmd, "SpanCheckModel::SpanLossInfo");
    }

    @Override
    protected void updateLocal() {
        this.spanLossInfoRef.update();
        this.spanMinExpElem = null;
        this.spanMaxExpElem = null;
        this.localInit();
        super.updateLocal();
    }

    @Override
    public String getSide() {
        return DwdmSide.getSideFromOffset(this.index);
    }

    public int getSideId() {
        return this.index;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        if (this.db.on()) {
            this.db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings(eUpdateType.class)[n]);
        }
        if (n == 1) {
            this.calcResponseStatus = true;
            this.updateLocal();
            this.setChanged();
            if (this.db.on()) {
                this.db.println("notifyObservers CHANGED");
            }
            this.notifyObservers(ModelUpdateType.CHANGED);
        } else if (n == 0) {
            this.nmd.getSpanCheckModels().delSpanCheckModel(this.index);
            this.calcResponseStatus = false;
            if (this.db.on()) {
                this.db.println("notifyObservers DELETED");
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.DELETED);
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSpanCheck, this.index, (Observer)this);
        }
        this.localInit();
    }

    private void localInit() {
        if (this.spanMinExpElem != null && this.spanMaxExpElem != null) {
            return;
        }
        AnsParamModel[] ansParamModelArray = this.nmd.getANSManager().getNeANSModel().getAnsParamList();
        boolean bl = false;
        boolean bl2 = false;
        sSpanLossInfo sSpanLossInfo2 = this.getSpanLossInfo();
        for (int i = 0; i < ansParamModelArray.length && !(bl && bl2); ++i) {
            this.spanExpKey = ansParamModelArray[i].getParamKey();
            if (this.spanExpKey == null || sSpanLossInfo2 == null) continue;
            try {
                if (this.spanExpKey.paramLocation != sSpanLossInfo2.inputPort) continue;
                if (this.spanExpKey.type == eParamType.TY_MINEXPSPANLOSS) {
                    if (this.db.on()) {
                        this.db.println("spanMinExpElem add observer for side:" + this.getSide());
                    }
                    this.spanMinExpElem = ansParamModelArray[i];
                    bl = true;
                    continue;
                }
                if (this.spanExpKey.type != eParamType.TY_MAXEXPSPANLOSS) continue;
                this.spanMaxExpElem = ansParamModelArray[i];
                if (this.db.on()) {
                    this.db.println("spanMaxExpElem add observer for side:" + this.getSide());
                }
                bl2 = true;
                continue;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void dispose() {
        block5: {
            if (this.db.on()) {
                this.db.println("dispose for index:" + this.index);
            }
            if (this.dispatcher != null) {
                this.dispatcher.deleteObserver(ObjectType.ObjectSpanCheck, this.index, (Observer)this);
                this.dispatcher = null;
            }
            if (this.spanLossInfoRef != null) {
                try {
                    this.spanLossInfoRef.dispose();
                }
                catch (Exception exception) {
                    this.db.println("Unexpected exception occurred while trying to dispose " + this.spanLossInfoRef);
                    if (!this.db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy for index:" + this.index);
        }
        super.destroy();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    @Override
    public String getMeasuredSpanLoss() {
        int n = this.getSpanAttribute(0);
        if (n != -1000000) {
            this.calcResponseStatus = true;
            return Float.toString((float)n / 10.0f);
        }
        this.calcResponseStatus = false;
        return UNDEFINED;
    }

    @Override
    public String getCalcType() {
        int n = this.getSpanAttribute(5);
        return SpanCheckModel.enumToStringCalcType(n);
    }

    @Override
    public void calculateSpanLoss() throws CannotPerform {
        try {
            this.calcSpanLossRef.setValue();
        }
        catch (xCannotPerform xCannotPerform2) {
            this.calcResponseStatus = false;
            throw new CannotPerform("calculateSpanLoss Error");
        }
    }

    public String[] getSpanLoss() {
        String[] stringArray = new String[3];
        sSpanLossInfo sSpanLossInfo2 = this.getSpanLossInfo();
        if (sSpanLossInfo2 != null) {
            stringArray[2] = sSpanLossInfo2.value == -1000000 ? UNDEFINED : Float.toString((float)sSpanLossInfo2.value / 10.0f);
            stringArray[0] = this.getMinExpectedSpanLoss();
            stringArray[1] = this.getMaxExpectedSpanLoss();
            return stringArray;
        }
        stringArray[0] = UNDEFINED;
        stringArray[1] = UNDEFINED;
        stringArray[2] = UNDEFINED;
        return stringArray;
    }

    public String getExpectedSpanLoss() {
        return UNDEFINED;
    }

    @Override
    public String getMinExpectedSpanLoss() {
        int n = this.getSpanAttribute(1);
        if (n == -1000000) {
            return UNDEFINED;
        }
        return Float.toString((float)n / 10.0f);
    }

    @Override
    public String getMaxExpectedSpanLoss() {
        int n = this.getSpanAttribute(2);
        if (n == -1000000) {
            return UNDEFINED;
        }
        return Float.toString((float)n / 10.0f);
    }

    public void setExpectedSpanLoss(String string) throws EMCProvisionError {
        this.setMinExpectedSpanLoss(string);
        this.setMaxExpectedSpanLoss(string);
    }

    @Override
    public void setMinExpectedSpanLoss(String string) throws EMCProvisionError {
        this.nmd.getANSManager().getNeANSModel().setParam(this.spanMinExpElem.getParamKey(), (int)(Float.parseFloat(string) * 10.0f));
    }

    @Override
    public void setMaxExpectedSpanLoss(String string) throws EMCProvisionError {
        this.nmd.getANSManager().getNeANSModel().setParam(this.spanMaxExpElem.getParamKey(), (int)(Float.parseFloat(string) * 10.0f));
    }

    @Override
    public String getResolution() {
        int n = this.getSpanAttribute(3);
        if (n != -1000000) {
            return Float.toString((float)n / 10.0f);
        }
        return UNDEFINED;
    }

    public String getDifference() {
        int n = this.getSpanAttribute(4);
        if (n != -1000000) {
            return Float.toString((float)n / 10.0f);
        }
        return UNDEFINED;
    }

    private int getSpanAttribute(int n) {
        int n2 = -1000000;
        switch (n) {
            case 0: {
                sSpanLossInfo sSpanLossInfo2 = this.getSpanLossInfo();
                if (sSpanLossInfo2 == null) break;
                n2 = sSpanLossInfo2.value;
                break;
            }
            case 1: {
                sParameterInfo sParameterInfo2;
                if (this.spanMinExpElem == null || (sParameterInfo2 = this.spanMinExpElem.getParamInfo()) == null) break;
                n2 = sParameterInfo2.value.currentValue;
                break;
            }
            case 2: {
                sParameterInfo sParameterInfo3;
                if (this.spanMaxExpElem == null || (sParameterInfo3 = this.spanMaxExpElem.getParamInfo()) == null) break;
                n2 = sParameterInfo3.value.currentValue;
                break;
            }
            case 3: {
                sSpanLossInfo sSpanLossInfo3 = this.getSpanLossInfo();
                if (sSpanLossInfo3 == null) break;
                n2 = sSpanLossInfo3.resolution;
                break;
            }
            case 5: {
                sSpanLossInfo sSpanLossInfo4 = this.getSpanLossInfo();
                if (sSpanLossInfo4 == null) break;
                n2 = sSpanLossInfo4.type.value();
                break;
            }
        }
        return n2;
    }

    private sSpanLossInfo getSpanLossInfo() {
        sSpanLossInfo[] sSpanLossInfoArray = null;
        try {
            sSpanLossInfoArray = (sSpanLossInfo[])this.spanLossInfoRef.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getSpanLossInfo", userException);
        }
        for (int i = 0; i < sSpanLossInfoArray.length; ++i) {
            if (sSpanLossInfoArray[i].side != this.getSideId()) continue;
            return sSpanLossInfoArray[i];
        }
        return null;
    }

    @Override
    public boolean isCalcSuccessful() {
        return this.calcResponseStatus;
    }

    public static String enumToStringCalcType(int n) {
        switch (n) {
            case 0: {
                return UNDEFINED;
            }
            case 2: {
                return "CHANNEL";
            }
            case 1: {
                return "OSC";
            }
        }
        return UNDEFINED;
    }

    @Override
    public boolean hasMinValuebyAns() {
        return this.spanMinExpElem != null;
    }

    @Override
    public boolean hasMaxValuebyAns() {
        return this.spanMaxExpElem != null;
    }

    private class CalculateSpanLoss
    extends NonCachedValue {
        public CalculateSpanLoss(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws xCannotPerform {
            if (SpanCheckModel.this.db.on) {
                SpanCheckModel.this.db.println(this.getClass() + "::getValue");
            }
            this.node.getIorRepository().getDwdmOpticalSetupRef().calculateSpanLoss(SpanCheckModel.this.getSideId());
        }

        public Object outer() {
            return SpanCheckModel.this;
        }
    }

    private class SpanLossInfo
    extends CachedValue {
        public SpanLossInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            if (SpanCheckModel.this.db.on) {
                SpanCheckModel.this.db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getSpanLoss();
        }

        @Override
        protected Object cloneValue() {
            Object[] objectArray = null;
            sSpanLossInfo sSpanLossInfo2 = null;
            sSpanLossInfo[] sSpanLossInfoArray = null;
            objectArray = (Object[])this.value;
            sSpanLossInfoArray = new sSpanLossInfo[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                sSpanLossInfo2 = (sSpanLossInfo)objectArray[i];
                sSpanLossInfoArray[i] = new sSpanLossInfo(sSpanLossInfo2.index, sSpanLossInfo2.inputPort, sSpanLossInfo2.side, sSpanLossInfo2.resolution, sSpanLossInfo2.value, sSpanLossInfo2.type);
            }
            return sSpanLossInfoArray;
        }

        public Object outer() {
            return SpanCheckModel.this;
        }
    }
}

