/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.EtherL2Media.SvlanCircuits;
import cerent.cms.idl.EtherL2Media.sSvlanConnectionItem;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.SvlanPathDefModel;
import cerent.cms.model.TestAccessActive;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.UserException;

public class SvlanConnectionModel
extends ConnectionModel
implements ISvlanConnectionModel {
    private List<ISvlanPathDefModel> paths = new ArrayList<ISvlanPathDefModel>();
    private String name = null;
    private SetName setName = new SetName(this.nmd, "SvlanConnectionModel.SetName");
    private int state = 103;

    public SvlanConnectionModel(NodeModelDelegate nodeModelDelegate, sSvlanConnectionItem sSvlanConnectionItem2, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(SvlanConnectionModel.class));
        this.state = sSvlanConnectionItem2.serviceState.value();
        short s = 29;
        for (int i = 0; i < sSvlanConnectionItem2.indexList.length; ++i) {
            this.paths.add(new SvlanPathDefModel(nodeModelDelegate, sSvlanConnectionItem2.svlanId, sSvlanConnectionItem2.indexList[i], s));
        }
        this.name = sSvlanConnectionItem2.circuitName;
    }

    @Override
    public void init() {
        this.index = this.getObjIndex();
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println("SvlanConnectionModel dispose()");
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on) {
            this.db.println("SvlanConnectionModel destroy()");
        }
        super.destroy();
    }

    public ISvlanPathDefModel[] getPaths() {
        return this.paths.toArray(new ISvlanPathDefModel[0]);
    }

    public List getPathList() {
        return this.paths;
    }

    public short getSvlan() {
        ISvlanPathDefModel[] iSvlanPathDefModelArray = this.getPaths();
        if (iSvlanPathDefModelArray.length > 0) {
            return iSvlanPathDefModelArray[0].getSvlan();
        }
        return 0;
    }

    @Override
    public ICircuitId getCircuitId() {
        return new CircuitId(0, 0);
    }

    @Override
    public String getConnectionName() {
        return this.name;
    }

    @Override
    public void setConnectionName(String string) throws InvalidCircuitName {
        try {
            ISvlanPathDefModel[] iSvlanPathDefModelArray = this.getPaths();
            int[] nArray = new int[iSvlanPathDefModelArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = iSvlanPathDefModelArray[i].getPortEntityIdx();
            }
            Object[] objectArray = new Object[]{nArray, string, new Short(this.getSvlan())};
            this.setName.set(objectArray);
            this.name = string;
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new InvalidCircuitName((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new InvalidCircuitName((UserException)xProvisionError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new InvalidCircuitName((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "SvlanConnectionModel::setName", userException);
        }
    }

    public void addPath(ISvlanPathDefModel iSvlanPathDefModel) throws InvalidPath {
        if (this.paths.contains(iSvlanPathDefModel)) {
            if (this.db.on) {
                this.db.println("addPath: WARNING!! path already present");
            }
            throw new InvalidPath("Path already present");
        }
        this.paths.add(iSvlanPathDefModel);
    }

    public void removePath(ISvlanPathDefModel iSvlanPathDefModel) throws InvalidPath {
        if (!this.paths.contains(iSvlanPathDefModel)) {
            if (this.db.on) {
                this.db.println("removePath: WARNING!! path NOT found");
            }
            throw new InvalidPath("Path not found");
        }
        this.paths.remove(iSvlanPathDefModel);
    }

    @Override
    protected int getObjIndex() {
        return this.getModuleEntIdx() + this.getSvlan();
    }

    private int getModuleEntIdx() {
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        int n = 0;
        if (this.paths != null && this.paths.size() > 0) {
            n = this.paths.get(0).getPortEntityIdx();
        }
        try {
            IEntityModel iEntityModel = entityTableModel.getEntityModelByIndex(n);
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            return iModuleModel.getEntityIndex();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.println("getModuleEntIdx() : no such entity for " + Integer.toHexString(n));
            return 0;
        }
    }

    @Override
    public int getShelfId() {
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        try {
            IEntityModel iEntityModel = entityTableModel.getEntityModelByIndex(this.getModuleEntIdx());
            return iEntityModel.getShelfId();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.println("getShelfId(): no such entity for " + Integer.toHexString(this.getModuleEntIdx()));
            return 1;
        }
    }

    @Override
    public int getConnectionType() {
        return eConnectionType.TWOWAY_SVLAN.value();
    }

    @Override
    public int getServiceState() {
        return this.state;
    }

    @Override
    protected void printString(SDebug sDebug) {
        ISvlanPathDefModel[] iSvlanPathDefModelArray = this.getPaths();
        sDebug.println("Connection Type " + EnumStrings.getStrings((Object)eConnectionType.TWOWAY_SVLAN)[this.getConnectionType()]);
        sDebug.println("CktName =  " + this.getConnectionName());
        sDebug.println("Observers are :");
        this.printObservers();
        sDebug.println("Number of Paths Are " + iSvlanPathDefModelArray.length);
        for (int i = 0; i < iSvlanPathDefModelArray.length; ++i) {
            sDebug.println("Path " + i + iSvlanPathDefModelArray[i]);
        }
    }

    @Override
    public eAdminState getAdminStateEnum() throws AbstractCmsIOException {
        return null;
    }

    @Override
    public void setAdminState(eAdminState eAdminState2) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
    }

    @Override
    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        return false;
    }

    @Override
    public List getPortModels() {
        return null;
    }

    public boolean inRoll() {
        return false;
    }

    @Override
    protected ObjectType getObjectType() {
        return null;
    }

    @Override
    public void setCircuitId(ICircuitId iCircuitId) {
    }

    public SvlanCircuits getSvlanCircuitRef() {
        return this.nmd.getIorRepository().getSvlanCircuitsRef();
    }

    private class SetName
    extends NonCachedValue {
        public SetName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            SvlanConnectionModel.this.getSvlanCircuitRef().setSvlanCircuitName((int[])objectArray[0], (String)objectArray[1], (Short)objectArray[2]);
        }
    }
}

