/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Node.eSwUpgradeActivity;
import cerent.cms.idl.Node.eSwUpgradeState;
import cerent.cms.idl.Node.sSwUpgradeUpdate;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISwUpgradeModel;
import cerent.cms.model.ISwUpgradeUpdate;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.SwUpgradeUpdate;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.job.IJobProgressControl;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class SwUpgradeModel
extends Model
implements ISwUpgradeModel {
    private NodeModelDelegate nodeModel = null;
    private GetSwUpgradeUpdate getSwUpgradeUpdate = null;
    private final int SW_UPGRADE_OBJECT = 3;
    private String[] swUpgradeActivities = new String[]{"Idle", "Downloading", "Qualifying", "Copying to standby ", "Wait", "Acquiring", "Invalid"};
    private final String COMPLETE = "Complete";
    private final String CLEAR = "";
    private static NodeSingletonFactory<SwUpgradeModel> sfactory = new NodeSingletonFactory<SwUpgradeModel>(SwUpgradeModel.class);
    private AcceptSwUpgrade acceptSwUpgrade = null;
    private CancelSwUpgrade cancelSwUpgrade = null;
    private EventDispatcher dispatcher;
    private sSwUpgradeUpdate swUpgradeUpdate = null;
    public static final String UPGRADE = "Download";
    public static final String CANCEL = "Cancel";
    public static final String ACTIVATE = "Activate";
    public static final String REVERT = "Revert";
    public static final String ACCEPT = "Accept";
    private IJobProgressControl jobProgressControl;
    public static final int REVERT_ALLOWED = 0;
    public static final int SSXC_PRESENT = 1;
    public static final int REVERT_DISALLOWED_UNKNOWN = 2;
    public static final String MAVERICK_VER = "5.0.0";
    static final String SSXC_MANUF_NAME = "15600-SSXC";

    private SwUpgradeModel(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.db = new SwUpgradeDebug(nodeModelDelegate.getDebug(), "SwUpgradeModel");
        this.nodeModel = nodeModelDelegate;
        this.swUpgradeActivities[3] = this.swUpgradeActivities[3] + nodeModelDelegate.getPlatform().getControlCardName();
        this.getSwUpgradeUpdate = new GetSwUpgradeUpdate(nodeModelDelegate, "SwUpgradeModel.getSwUpgradeUpdate");
        this.acceptSwUpgrade = new AcceptSwUpgrade(nodeModelDelegate, "SwUpgradeModel.acceptSwUpgrade");
        this.cancelSwUpgrade = new CancelSwUpgrade(nodeModelDelegate, "SwUpgradeModel.cancelSwUpgrade");
        this.dispatcher = null;
        this.index = 0;
    }

    public static SwUpgradeModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("Enter SwUpgradeModel init()");
        }
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSystem, 3, (Observer)this);
        }
        if (this.db.on()) {
            this.db.println("Leaving SwUpgradeModel init()");
        }
        this.getSwUpgradeUpdateInfo();
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("Enter SwUpgradeModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSystem, 3, (Observer)this);
        }
        this.getSwUpgradeUpdate.dispose();
        if (this.db.on()) {
            this.db.println("Leaving SwUpgradeModel dispose()");
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("Enter SwUpgradeModel update()");
        }
        this.getSwUpgradeUpdate.update();
        this.setChanged();
        this.updateSwUpgradeState();
        this.notifyObservers(ModelUpdateType.CHANGED);
        if (this.db.on()) {
            this.db.println("Leaving SwUpgradeModel update()");
        }
    }

    public void setJobProgressControl(IJobProgressControl iJobProgressControl) {
        this.jobProgressControl = iJobProgressControl;
    }

    private void updateSwUpgradeState() {
        this.getSwUpgradeUpdateInfo();
        if (this.jobProgressControl == null) {
            return;
        }
        if (this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_IDLE) {
            if (this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_ACTIVATED) {
                this.jobProgressControl.setProgressText("Complete");
            } else {
                this.jobProgressControl.setPercentCompleted(-1);
            }
        } else if (this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_BOOT) {
            this.jobProgressControl.setProgressText(this.swUpgradeActivities[this.swUpgradeUpdate.swUpgradeActivity.value()]);
        } else {
            this.jobProgressControl.setProgressText(this.swUpgradeActivities[this.swUpgradeUpdate.swUpgradeActivity.value()]);
            this.jobProgressControl.setPercentCompleted(this.swUpgradeUpdate.percentComplete);
        }
    }

    public sSwUpgradeUpdate getLocalSwUpgradeUpdateInfo() {
        try {
            this.swUpgradeUpdate = (sSwUpgradeUpdate)this.getSwUpgradeUpdate.get();
            if (this.db.isFinestEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Software upgrade update info:");
                stringBuffer.append("\n\tTSC A Working = ");
                stringBuffer.append(String.valueOf(this.swUpgradeUpdate.workingSwVerTscA));
                stringBuffer.append("\n\tTSC A Protect = ");
                stringBuffer.append(String.valueOf(this.swUpgradeUpdate.protectSwVerTscA));
                stringBuffer.append("\n\tTSC B Working = ");
                stringBuffer.append(String.valueOf(this.swUpgradeUpdate.workingSwVerTscB));
                stringBuffer.append("\n\tTSC B Protect = ");
                stringBuffer.append(String.valueOf(this.swUpgradeUpdate.protectSwVerTscB));
                stringBuffer.append("\n\tActivity = ");
                stringBuffer.append(this.swUpgradeUpdate.swUpgradeActivity.value());
                stringBuffer.append("\n\tState = ");
                stringBuffer.append(this.swUpgradeUpdate.swUpgradeState.value());
                stringBuffer.append("\n\tPercentage Complete = ");
                stringBuffer.append(String.valueOf(this.swUpgradeUpdate.percentComplete));
                this.db.fine(stringBuffer.toString());
            }
            return this.swUpgradeUpdate;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public ISwUpgradeUpdate getSwUpgradeUpdateInfo() {
        sSwUpgradeUpdate sSwUpgradeUpdate2 = this.getLocalSwUpgradeUpdateInfo();
        if (sSwUpgradeUpdate2 != null) {
            return new SwUpgradeUpdate(sSwUpgradeUpdate2);
        }
        return null;
    }

    public void cancelSwUpgrade() throws Exception {
        if (!this.isCancelAllowed()) {
            throw new Exception("The Cancel operation is not allowed.");
        }
        this.cancelSwUpgrade.get();
    }

    public int acceptSwUpgrade() throws Exception {
        if (this.isAcceptAllowed()) {
            return (Integer)this.acceptSwUpgrade.get();
        }
        throw new Exception("The Cancel operation is not allowed.");
    }

    public boolean isIdle() {
        this.swUpgradeUpdate = this.getLocalSwUpgradeUpdateInfo();
        return (this.swUpgradeUpdate.swUpgradeState.value() == 0 || this.swUpgradeUpdate.swUpgradeState.value() == 1 || this.swUpgradeUpdate.swUpgradeState.value() == 4) && this.swUpgradeUpdate.swUpgradeActivity.value() == 0;
    }

    public boolean isOperationAllowed(int n) {
        switch (n) {
            case 3: {
                return this.isDownloadAllowed();
            }
            case 4: {
                return this.isActivateAllowed();
            }
            case 5: {
                return this.isRevertAllowed();
            }
        }
        return false;
    }

    public boolean isOperationAllowed(String string) {
        if (string.equals(UPGRADE)) {
            return this.isDownloadAllowed();
        }
        if (string.equals(CANCEL)) {
            return this.isCancelAllowed();
        }
        if (string.equals(ACTIVATE)) {
            return this.isActivateAllowed();
        }
        if (string.equals(REVERT)) {
            return this.isRevertAllowed();
        }
        if (string.equals(ACCEPT)) {
            return this.isAcceptAllowed();
        }
        return false;
    }

    public int getSpecialRevertDisallowedReason(String string) {
        if (string.compareTo(MAVERICK_VER) < 0 && ((EntityTableModel)this.nodeModel.getEntityTable()).hasCardNamed(SSXC_MANUF_NAME)) {
            return 1;
        }
        if (this.isRevertAllowed()) {
            return 0;
        }
        return 2;
    }

    private boolean isDownloadAllowed() {
        return this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_IDLE && this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_IDLE;
    }

    private boolean isCancelAllowed() {
        return this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_DOWNLOAD || (this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_REVERT || this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_ACTIVATED) && (this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_IDLE || this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_ACQUIRE);
    }

    private boolean isActivateAllowed() {
        return this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_DOWNLOAD && this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_IDLE;
    }

    private boolean isRevertAllowed() {
        return this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_REVERT && this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_IDLE;
    }

    private boolean isAcceptAllowed() {
        if (this.swUpgradeUpdate.swUpgradeState == eSwUpgradeState.SWUP_ACTIVATED) {
            return this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_IDLE || this.swUpgradeUpdate.swUpgradeActivity == eSwUpgradeActivity.SWACT_ACQUIRE;
        }
        return false;
    }

    class AcceptSwUpgrade
    extends NonCachedValue {
        public AcceptSwUpgrade(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Integer(this.getNode().getNodeRef().acceptSwUpgrade());
        }

        public Object outer() {
            return SwUpgradeModel.this;
        }
    }

    class CancelSwUpgrade
    extends NonCachedValue {
        public CancelSwUpgrade(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Integer(this.getNode().getNodeRef().cancelSwUpgrade());
        }

        public Object outer() {
            return SwUpgradeModel.this;
        }
    }

    class GetSwUpgradeUpdate
    extends CachedValue {
        public GetSwUpgradeUpdate(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return this.getNode().getNodeRef().getSwUpgradeUpdate();
        }

        public Object outer() {
            return SwUpgradeModel.this;
        }
    }

    public class SwUpgradeDebug
    extends SDebug {
        public SwUpgradeDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void showUpgradeState() {
            StringBuffer stringBuffer = new StringBuffer("Software upgrade update info:");
            stringBuffer.append("\n\tTSC A Working = ");
            stringBuffer.append(String.valueOf(((SwUpgradeModel)SwUpgradeModel.this).swUpgradeUpdate.workingSwVerTscA));
            stringBuffer.append("\n\tTSC A Protect = ");
            stringBuffer.append(String.valueOf(((SwUpgradeModel)SwUpgradeModel.this).swUpgradeUpdate.protectSwVerTscA));
            stringBuffer.append("\n\tTSC B Working = ");
            stringBuffer.append(String.valueOf(((SwUpgradeModel)SwUpgradeModel.this).swUpgradeUpdate.workingSwVerTscB));
            stringBuffer.append("\n\tTSC B Protect = ");
            stringBuffer.append(String.valueOf(((SwUpgradeModel)SwUpgradeModel.this).swUpgradeUpdate.protectSwVerTscB));
            stringBuffer.append("\n\tActivity = ");
            stringBuffer.append(((SwUpgradeModel)SwUpgradeModel.this).swUpgradeUpdate.swUpgradeActivity.value());
            stringBuffer.append("\n\tState = ");
            stringBuffer.append("\n\tPercentage Complete = ");
            stringBuffer.append(String.valueOf(((SwUpgradeModel)SwUpgradeModel.this).swUpgradeUpdate.percentComplete));
            this.println(stringBuffer.toString());
        }
    }
}

