/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvPortModel;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.RmonModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class TNCModuleModel
extends PluggableCarrierModel {
    public TNCModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(TNCModuleModel.class));
    }

    public TNCModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
        this.index = n;
    }

    public EtherLineModel[] getEtherLineModels() {
        EtherPortModel[] etherPortModelArray = this.getEtherPortModels();
        EtherLineModel[] etherLineModelArray = new EtherLineModel[etherPortModelArray.length];
        for (int i = 0; i < etherPortModelArray.length; ++i) {
            etherLineModelArray[i] = (EtherLineModel)etherPortModelArray[i].getInterfaceModel();
        }
        this.db.fine("Returning " + etherLineModelArray.length + " EtherLineModels");
        return etherLineModelArray;
    }

    public HdGeLineModel[] getGigeLineModels() {
        List list = this.getAllGigEPortModels();
        Iterator iterator = list.iterator();
        HdGeLineModel[] hdGeLineModelArray = new HdGeLineModel[list.size()];
        int n = 0;
        while (iterator.hasNext()) {
            PortModel portModel = (PortModel)iterator.next();
            hdGeLineModelArray[n] = (HdGeLineModel)portModel.getInterfaceModel();
            ++n;
        }
        return hdGeLineModelArray;
    }

    public IRmonModel[] getRmonModels() {
        ArrayList<EtherLineModel> arrayList;
        block2: {
            EtherLineModel[] etherLineModelArray = this.getAllEtherLineModels();
            arrayList = new ArrayList<EtherLineModel>();
            try {
                arrayList.addAll(Arrays.asList(etherLineModelArray));
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return RmonModel.getRmonModels(arrayList.toArray(new ISupportsRMON[arrayList.size()]));
    }

    public IOpticsPmModel[] getOpticsPmModels() {
        ArrayList<InterfaceModel> arrayList;
        block2: {
            arrayList = new ArrayList<InterfaceModel>();
            InterfaceModel[] interfaceModelArray = this.getAllInterfaceModels();
            try {
                arrayList.addAll(Arrays.asList(interfaceModelArray));
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return arrayList.toArray(new IOpticsPmModel[arrayList.size()]);
    }

    public TdmPortModel[] getAllTdmPorts() {
        TreeSet treeSet = new TreeSet(new EntityModel.EntityModelComparator());
        List list = null;
        list = this.getTdmPortsOfType(eEqType.OC3_PORT);
        treeSet.addAll(list);
        if (this.db.on()) {
            this.db.println("Total number of ASAP TDM ports " + treeSet.size());
        }
        return treeSet.toArray(new TdmPortModel[treeSet.size()]);
    }

    public EtherLineModel[] getAllEtherLineModels() {
        int n;
        EtherLineModel[] etherLineModelArray = this.getEtherLineModels();
        HdGeLineModel[] hdGeLineModelArray = this.getGigeLineModels();
        EtherLineModel[] etherLineModelArray2 = new EtherLineModel[etherLineModelArray.length + hdGeLineModelArray.length];
        for (n = 0; n < etherLineModelArray.length; ++n) {
            etherLineModelArray2[n] = etherLineModelArray[n];
        }
        n = etherLineModelArray.length;
        for (int i = 0; i < hdGeLineModelArray.length; ++i) {
            etherLineModelArray2[n] = hdGeLineModelArray[i];
            ++n;
        }
        return etherLineModelArray2;
    }

    public TdmLineModel[] getAllTdmLines() {
        TdmLineModel[] tdmLineModelArray = null;
        TdmPortModel[] tdmPortModelArray = null;
        try {
            tdmPortModelArray = this.getAllTdmPorts();
            tdmLineModelArray = new TdmLineModel[tdmPortModelArray.length];
            for (int i = 0; i < tdmPortModelArray.length; ++i) {
                tdmLineModelArray[i] = tdmPortModelArray[i].getTdmLineModel();
            }
        }
        catch (Exception exception) {
            this.db.println("Error in getting ASAP TDM line interfaces" + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return tdmLineModelArray;
    }

    protected List getTdmPortsOfType(eEqType eEqType2) {
        List list = null;
        list = this.getDescendantsOfType(eEqType2);
        if (this.db.on()) {
            this.db.println("Number of TDM ports of eqType= " + eEqType2.value() + ", num= " + list.size());
        }
        return list;
    }

    public EtherPortModel[] getEtherPortModels() {
        return this.getAllEtherPortModels().toArray(new EtherPortModel[0]);
    }

    protected List getAllEtherPortModels() {
        return this.getDescendantsOfType(eEqType.FE_PORT);
    }

    protected List getAllGigEPortModels() {
        return this.getDescendantsOfType(eEqType.ONE_GE_PORT);
    }

    @Override
    public String getEqLabel() {
        return super.getEqLabel();
    }

    @Override
    public String getEqTypeName() {
        if (this.getEqType() == 330) {
            return "TNC";
        }
        if (this.getEqType() == 331) {
            return "TSC";
        }
        return null;
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("TNCModuleModel.updateLocal(): entry");
        }
        super.updateLocal();
        if (this.db.on()) {
            this.db.println("TNCModuleModel.updateLocal(): exit");
        }
    }

    public boolean supportPPM() {
        return true;
    }

    public IPortModel getPayloadPortModel(DwdmPortModel dwdmPortModel) throws AbstractCmsNoSuchEntityException {
        return ((AbstractDwdmLineModel)dwdmPortModel.getInterfaceModel()).getPayloadModel().getPortModel();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public List<IFvPortModel> getListOfPorts() {
        List list = this.getChildren();
        ArrayList<IFvPortModel> arrayList = new ArrayList<IFvPortModel>();
        for (IModel iModel : list) {
            PpmModel ppmModel;
            List list2;
            List list3 = ((PluggableSlotModel)iModel).getChildren();
            if (list3.size() != 1 || (list2 = (ppmModel = (PpmModel)list3.get(0)).getChildren()).size() == 0) continue;
            PortModel portModel = (PortModel)list2.get(0);
            arrayList.add(portModel);
        }
        return arrayList;
    }
}

