/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.util.SDebug;
import cerent.util.SvlanRange;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;

public class VlanList {
    private VLANListType vlanType;
    private static final SvlanRange[] RANGE_ARRAY_TEMPLATE = new SvlanRange[0];
    public static final int MAX_NUM_SVLANS = 4093;
    public static final int MAX_NUM_CVLANS = 4094;
    private int _max_num_vlan;
    private BitSet bs;
    private short[] vlans;
    private SvlanRange[] ranges;
    private static SDebug db = new SDebug("VLANList");

    public VlanList(VLANListType vLANListType) {
        this.vlanType = vLANListType;
        this._max_num_vlan = vLANListType.getMaxNum();
        this.bs = this.createBitSet();
        this.vlans = new short[0];
    }

    public VlanList(String string, VLANListType vLANListType) {
        this.vlanType = vLANListType;
        this._max_num_vlan = vLANListType.getMaxNum();
        this.bs = this.createBitSet();
        this.init(string);
    }

    public VlanList(VlanList vlanList, VLANListType vLANListType) {
        this.vlanType = vLANListType;
        this._max_num_vlan = vLANListType.getMaxNum();
        this.init(vlanList.vlans.length, vlanList.bs);
    }

    private void init(String string) {
        if (string == null) {
            string = "";
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            int n3;
            block11: {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                n3 = -1;
                n2 = -1;
                if (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    try {
                        if (string3.equals("*")) {
                            this.bs.set(0, this._max_num_vlan);
                            n = this._max_num_vlan;
                            break;
                        }
                        n2 = n3 = Integer.parseInt(string3);
                        if (!stringTokenizer2.hasMoreTokens()) break block11;
                        string3 = stringTokenizer2.nextToken();
                        try {
                            if (string3.equals("*")) {
                                this.bs.set(0, this._max_num_vlan);
                                n = this._max_num_vlan;
                                break;
                            }
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Not a number");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Not a number");
                    }
                }
            }
            if (n3 > 0) {
                for (int i = n3; i <= n2; ++i) {
                    int n4 = i - 1;
                    if (this.bs.get(n4)) continue;
                    ++n;
                    this.bs.set(n4);
                }
                continue;
            }
            throw new IllegalArgumentException("Zero not admitted");
        }
        this.init(n, this.bs);
    }

    private void init(int n, BitSet bitSet) {
        if (bitSet.length() > this._max_num_vlan) {
            throw new IllegalArgumentException("BitSet must be exactly: " + this._max_num_vlan + " in size");
        }
        if (this.bs == null) {
            this.bs = new BitSet(bitSet.size());
            this.bs.or(bitSet);
        }
        this.vlans = new short[n];
        int n2 = this.bs.nextSetBit(0);
        int n3 = 0;
        while (n2 >= 0 && n3 < n) {
            short s = (short)(n2 + 1);
            this.vlans[n3++] = s;
            n2 = this.bs.nextSetBit(n2 + 1);
        }
        this.ranges = null;
    }

    private static int getCount(BitSet bitSet) {
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            ++n;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return n;
    }

    public boolean isAllxVLANs() {
        return this.vlans != null && this.vlans.length == this._max_num_vlan;
    }

    private BitSet createBitSet() {
        return new BitSet(this._max_num_vlan);
    }

    public void or(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (this.bs.length() > this._max_num_vlan) {
            throw new IllegalArgumentException("BitSet must be exactly: " + this._max_num_vlan + " in size");
        }
        this.bs.or(bitSet);
        this.init(VlanList.getCount(this.bs), this.bs);
    }

    public void andNot(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (this.bs.length() > this._max_num_vlan) {
            throw new IllegalArgumentException("BitSet must be exactly: " + this._max_num_vlan + " in size");
        }
        this.bs.andNot(bitSet);
        this.init(VlanList.getCount(this.bs), this.bs);
    }

    public void and(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (this.bs.length() > this._max_num_vlan) {
            throw new IllegalArgumentException("BitSet must be exactly: " + this._max_num_vlan + " in size");
        }
        this.bs.and(bitSet);
        this.init(VlanList.getCount(this.bs), this.bs);
    }

    public short[] getVLANs() {
        return this.vlans;
    }

    public BitSet getBitSet() {
        return this.bs;
    }

    public SvlanRange[] getRanges() {
        SvlanRange svlanRange;
        if (this.ranges != null) {
            return this.ranges;
        }
        if (this.vlans.length == 0) {
            return RANGE_ARRAY_TEMPLATE;
        }
        ArrayList<SvlanRange> arrayList = new ArrayList<SvlanRange>();
        short s = this.vlans[0];
        int n = this.vlans[0];
        for (int i = 1; i < this.vlans.length; ++i) {
            short s2 = this.vlans[i];
            if (s2 == n + 1) {
                ++n;
                continue;
            }
            svlanRange = new SvlanRange(s, (short)n);
            arrayList.add(svlanRange);
            s = s2;
            n = this.vlans[i];
        }
        svlanRange = new SvlanRange(s, (short)n);
        arrayList.add(svlanRange);
        this.ranges = arrayList.toArray(RANGE_ARRAY_TEMPLATE);
        return this.ranges;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.vlans.length;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4 = this.vlans[i];
            if (n4 > n3) {
                if (n4 >= 0) {
                    if (bl) {
                        stringBuilder.append(",");
                    }
                    bl = true;
                    stringBuilder.append(Integer.toString(n4));
                    if (n3 > n2) {
                        stringBuilder.append("-");
                        stringBuilder.append(Integer.toString(n3));
                    }
                }
                n3 = n2 = n4;
                continue;
            }
            ++n3;
        }
        String string = stringBuilder.toString();
        return string.length() == 0 ? "empty" : string;
    }

    public int hashCode() {
        return this.bs.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof VlanList) {
            VlanList vlanList = (VlanList)object;
            bl = this.bs.equals(vlanList.bs);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = "1,2-3,4";
        VlanList vlanList = new VlanList("1,2-3,4", VLANListType.CVLAN);
        System.out.println("list1(" + string + "): " + vlanList);
        string = "1,3,4";
        VlanList vlanList2 = new VlanList("1,3,4", VLANListType.CVLAN);
        System.out.println("list2(" + string + "): " + vlanList2);
        string = "1";
        VlanList vlanList3 = new VlanList("1", VLANListType.CVLAN);
        System.out.println("list3(" + string + "): " + vlanList3);
        string = "1-2";
        VlanList vlanList4 = new VlanList("1-2", VLANListType.CVLAN);
        System.out.println("list4(" + string + "): " + vlanList4);
        string = "1,3-6,6-7";
        VlanList vlanList5 = new VlanList("1,3-6,6-7", VLANListType.CVLAN);
        System.out.println("list5(" + string + "): " + vlanList5);
        SvlanRange[] svlanRangeArray = vlanList5.getRanges();
        for (int i = 0; i < svlanRangeArray.length; ++i) {
            System.out.println("  " + svlanRangeArray[i]);
        }
        string = "1,3-6,5-7";
        VlanList vlanList6 = new VlanList("1,3-6,5-7", VLANListType.CVLAN);
        System.out.println("list6(" + string + "): " + vlanList6);
        string = "";
        VlanList vlanList7 = new VlanList("", VLANListType.CVLAN);
        System.out.println("list8(" + string + "): " + vlanList7);
        string = "1-8";
        VlanList vlanList8 = new VlanList("1-8", VLANListType.CVLAN);
        System.out.println("list10(" + string + "): " + vlanList8);
        svlanRangeArray = vlanList8.getRanges();
        System.out.println("list10(" + string + "): # of ranges " + svlanRangeArray.length);
        for (int i = 0; i < svlanRangeArray.length; ++i) {
            System.out.println("  " + svlanRangeArray[i]);
        }
        String string2 = "1-4,6-8";
        VlanList vlanList9 = new VlanList("1-4,6-8", VLANListType.CVLAN);
        System.out.println("list11(" + string2 + "): " + vlanList9);
        svlanRangeArray = vlanList9.getRanges();
        System.out.println("list11(" + string + "): # of ranges " + svlanRangeArray.length);
        for (int i = 0; i < svlanRangeArray.length; ++i) {
            System.out.println("  " + svlanRangeArray[i]);
        }
        vlanList8.andNot(vlanList9.getBitSet());
        System.out.println("list10-list11: " + vlanList8);
        vlanList8.or(vlanList9.getBitSet());
        System.out.println("list10+list11: " + vlanList8);
        string = "*";
        VlanList vlanList10 = new VlanList("*", VLANListType.CVLAN);
        System.out.println("list12(" + string + "): " + vlanList10);
        string = "*,8";
        VlanList vlanList11 = new VlanList("*,8", VLANListType.CVLAN);
        System.out.println("list13(" + string + "): " + vlanList11);
        string = "*-8";
        VlanList vlanList12 = new VlanList("*-8", VLANListType.CVLAN);
        System.out.println("list14(" + string + "): " + vlanList12);
        string = "8-*";
        VlanList vlanList13 = new VlanList("8-*", VLANListType.CVLAN);
        System.out.println("list15(" + string + "): " + vlanList13);
        string = "8-4095";
        VlanList vlanList14 = new VlanList("8-4095", VLANListType.CVLAN);
        System.out.println("list16(" + string + "): " + vlanList14);
        svlanRangeArray = vlanList14.getRanges();
        for (int i = 0; i < svlanRangeArray.length; ++i) {
            System.out.println("  " + svlanRangeArray[i]);
        }
    }

    public static enum VLANListType {
        SVLAN(4093),
        CVLAN(4094);

        int max_num;

        private VLANListType(int n2) {
            this.max_num = n2;
        }

        public int getMaxNum() {
            return this.max_num;
        }
    }
}

