/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Epos.xNoSuchVlan;
import cerent.cms.idl.Vlan.sVlanInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.VlanInfo;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class VlanModel
extends Model
implements IVlanModel {
    short vlanId;
    VlanName vlanName;
    VlanInUse vlanInUse;
    VlanDelete vlanDelete;
    private NodeModelDelegate nmd;
    VlanInfo vlanInfo;
    Short key;
    private EventDispatcher dispatcher;
    private String myString;

    public VlanModel(NodeModelDelegate nodeModelDelegate, short s) {
        super(nodeModelDelegate.getChildDebug(VlanModel.class));
        this.nmd = nodeModelDelegate;
        this.vlanId = s;
        this.index = this.vlanId;
        this.vlanName = new VlanName(nodeModelDelegate, "VlanModel::vlanName");
        this.vlanInUse = new VlanInUse(nodeModelDelegate, "VlanModel::vlanInUse");
        this.vlanDelete = new VlanDelete(nodeModelDelegate, "VlanModel::vlanDelete");
        this.dispatcher = null;
        this.myString = null;
    }

    public VlanModel(NodeModelDelegate nodeModelDelegate, short s, String string) {
        this(nodeModelDelegate, s);
        this.vlanName.setValueExternally(string);
    }

    @Override
    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("VlanModel::init()");
        }
        this.dispatcher = this.getNodeModelDelegate().getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectVlan, (int)this.vlanId, (Observer)this);
        }
        this.key = new Short(this.getId());
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectVlan, (int)this.vlanId, (Observer)this);
        }
        this.myString = null;
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("VlanModel::destroy()");
        }
        super.destroy();
    }

    public short getId() {
        if (this.db.on()) {
            this.db.println("VlanModel::getId()");
        }
        return this.vlanId;
    }

    public String getName() throws AbstractCmsIOException, IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("VlanModel::getName()");
        }
        try {
            return (String)this.vlanName.get();
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent VLAN [ VlanModel.getName(" + this.vlanId + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public boolean inUse() throws AbstractCmsIOException {
        if (this.db.on()) {
            this.db.println("VlanModel::getName()");
        }
        try {
            return (Boolean)this.vlanInUse.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void delete() throws AbstractCmsIOException, IllegalArgumentException {
        try {
            this.vlanDelete.set(null);
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent VLAN [ VlanModel.delete(" + this.vlanId + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Vlan[" + this.getName() + "]";
            }
            catch (Exception exception) {
                return "Vlan[deleted/inaccessible]";
            }
        }
        return this.myString;
    }

    public boolean equals(Object object) {
        if (object instanceof VlanModel) {
            return ((VlanModel)object).getId() == this.getId();
        }
        if (object instanceof String) {
            return ((String)object).equals(this.getName());
        }
        if (object instanceof sVlanInfo) {
            return ((sVlanInfo)object).vlanId == this.getId();
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.vlanId;
    }

    public IVlanInfo getVlanInfo() {
        if (this.vlanInfo == null) {
            this.vlanInfo = new VlanInfo(this.getId(), this.getName());
        }
        return this.vlanInfo;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("VlanModel::update()");
        }
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("Object deleted.");
                    }
                    this.nmd.getEtherBridgeModel().removeVlan((IVlanModel)this);
                    this.destroy();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Making local changes.");
                    }
                    this.vlanName.update();
                    this.vlanInUse.update();
                    this.vlanInfo = null;
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    private class VlanDelete
    extends NonCachedValue {
        public VlanDelete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getEtherBridgeRef().deleteVlan(VlanModel.this.vlanId);
        }

        public Object outer() {
            return VlanModel.this;
        }
    }

    private class VlanInUse
    extends NonCachedValue {
        public VlanInUse(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(this.node.getIorRepository().getEtherBridgeRef().isVlanInUse(VlanModel.this.vlanId));
        }

        public Object outer() {
            return VlanModel.this;
        }
    }

    private class VlanName
    extends CachedValue {
        public VlanName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherBridgeRef().getVlanName(VlanModel.this.vlanId);
        }

        public Object outer() {
            return VlanModel.this;
        }
    }
}

