/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.EtherL2Media.EtherEOAM;
import cerent.cms.idl.EtherL2Media.EtherL2Module;
import cerent.cms.idl.EtherL2Media.eCCTimer;
import cerent.cms.idl.EtherL2Media.eCardFrpRole;
import cerent.cms.idl.EtherL2Media.eCardFrpState;
import cerent.cms.idl.EtherL2Media.eMultiGetProtocolStates;
import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.eProtectionInterOPMode;
import cerent.cms.idl.EtherL2Media.eVlanOperator;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherL2Media.sCFMCondReportInfo;
import cerent.cms.idl.EtherL2Media.sCFMIICondReportInfo;
import cerent.cms.idl.EtherL2Media.sCfmCmdReqInfo;
import cerent.cms.idl.EtherL2Media.sCfmCmdRspInfo;
import cerent.cms.idl.EtherL2Media.sCrcInfo;
import cerent.cms.idl.EtherL2Media.sFrpInfo;
import cerent.cms.idl.EtherL2Media.sMAProfile;
import cerent.cms.idl.EtherL2Media.sMEP;
import cerent.cms.idl.EtherL2Media.sMEPCCDB;
import cerent.cms.idl.EtherL2Media.sMEPStats;
import cerent.cms.idl.EtherL2Media.sMIP;
import cerent.cms.idl.EtherL2Media.sMIPCCDB;
import cerent.cms.idl.EtherL2Media.sMaintenanceDomain;
import cerent.cms.idl.EtherL2Media.sMcastInfo;
import cerent.cms.idl.EtherL2Media.sMcastReportInfo;
import cerent.cms.idl.EtherL2Media.sRepAdminVlan;
import cerent.cms.idl.EtherL2Media.sRepSegmentAttributes;
import cerent.cms.idl.EtherL2Media.sVlanCondReportInfo;
import cerent.cms.idl.EtherL2Media.sVlanCrossInfoData;
import cerent.cms.idl.EtherL2Media.sVlanFuncItem;
import cerent.cms.idl.EtherL2Media.xBoardBusy;
import cerent.cms.idl.EtherL2Media.xCFMCommandFailed;
import cerent.cms.idl.EtherL2Media.xMgetReqExpiredTimeout;
import cerent.cms.idl.EtherL2Media.xMgetReqInProgress;
import cerent.cms.idl.EtherL2Media.xMgetReqProtocolError;
import cerent.cms.idl.EtherL2Media.xWrongParameters;
import cerent.cms.idl.EtherMedia.General;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.BoardBusyError;
import cerent.cms.model.CFMCommandFailed;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChGrpPortModel;
import cerent.cms.model.DomainProfileInfoFactory;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IDomainProfileInfo;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILearnedAddress;
import cerent.cms.model.IMAProfileInfo;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.LearnedAddress;
import cerent.cms.model.MAProfileInfoFactory;
import cerent.cms.model.MEPInfo;
import cerent.cms.model.MEPInfoFactory;
import cerent.cms.model.MIPInfo;
import cerent.cms.model.MIPInfoFactory;
import cerent.cms.model.MgetReqExpiredTimeout;
import cerent.cms.model.MgetReqInProgress;
import cerent.cms.model.MgetReqProtocolError;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.RepSegmentAttribute;
import cerent.cms.model.VlanInfo;
import cerent.cms.model.VlanInfoFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongParameters;
import cerent.cms.model.XPL2ChannelGroupManager;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.xpl2.XPL2QinQProvPane;
import cerent.util.ByteArrayUtil;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.omg.CORBA.UserException;

public class XPL2ModuleModel
extends DwdmModuleModel
implements IXPL2ModuleModel {
    private FrpInfo frpInfo = new FrpInfo("XPL2ModuleModel.FrpInfo");
    private VlanDb vlanDb = new VlanDb("XPL2ModuleModel.VlanDb");
    private ActualMultiCastInfo actualMultiCastInfo;
    private MvrInfo mvrInfo = new MvrInfo("XPL2ModuleModel.MvrInfo");
    private ActualVlanConditions actualVlanCond;
    private LearnedMacInfo learnedMacInfo;
    private RepSegmentAttributesList repSegmentList;
    private RepAdminVlan repAdminVlan;
    private RepL2If repIf;
    private CardCFMStat cardCFMStat;
    private CardCCTimer cardCCTimer;
    private DomainProfile domainProfile;
    private MAProfile maProfile;
    private MIPConfig mipConfig;
    private MEPConfig mepConfig;
    private CFMCommand cfmCommand;
    private CCDBCommand ccdbCommand;
    private XPL2ChannelGroupManager chGrpMng;
    private CFMConditions cfmCond;
    private CrcInfo crcInfo;
    private ProtectionOpmode protOpMode;
    private boolean neSupportsCrcConfig;

    public XPL2ModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(XPL2ModuleModel.class));
        this.actualMultiCastInfo = new ActualMultiCastInfo(nodeModelDelegate, "XPL2ModuleModel.ActualMultiCastInfo");
        this.actualVlanCond = new ActualVlanConditions(nodeModelDelegate, "XPL2ModudelModel.ActualVlanConditions");
        this.learnedMacInfo = new LearnedMacInfo("XPL2ModuleModel.LearnedMacInfo");
        this.chGrpMng = new XPL2ChannelGroupManager(nodeModelDelegate, n, eEqType2);
        this.repSegmentList = new RepSegmentAttributesList("XPL2ModudelModel.RepSegmentAttributesList");
        this.repAdminVlan = new RepAdminVlan("XPL2ModudelModel.RepAdminVlan");
        this.cardCFMStat = new CardCFMStat(nodeModelDelegate, "XPL2ModuleModel.CardCFMStatus");
        this.cardCCTimer = new CardCCTimer(nodeModelDelegate, "XPL2ModuleModel.CardCCTimer");
        this.domainProfile = new DomainProfile(nodeModelDelegate, "XPL2ModuleModel.DomainProfile");
        this.maProfile = new MAProfile(nodeModelDelegate, "XPL2ModuleModel.MAProfile");
        this.mipConfig = new MIPConfig(nodeModelDelegate, "XPL2ModuleModel.MIPConfig");
        this.mepConfig = new MEPConfig(nodeModelDelegate, "XPL2ModuleModel.MEPConfig");
        this.cfmCommand = new CFMCommand(nodeModelDelegate, "XPL2ModuleModel.CFMCommand");
        this.ccdbCommand = new CCDBCommand(nodeModelDelegate, "XPL2ModuleModel.CCDBCommand");
        this.repIf = new RepL2If(nodeModelDelegate, "XPL2ModuleModel.RepL2If");
        this.cfmCond = new CFMConditions(nodeModelDelegate, "XPL2ModuleModel.CFMConditions");
        this.crcInfo = new CrcInfo("XPL2ModuleModel.CrcInfo");
        this.protOpMode = new ProtectionOpmode("XPL2ModuleModel.ProtectionOpmode");
        this.neSupportsCrcConfig = false;
        String string = nodeModelDelegate.getSwVersion();
        if (string.compareTo("09.21") > 0) {
            this.neSupportsCrcConfig = true;
        }
    }

    protected EtherEOAM getEtherEOAMRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherEOAMRef();
    }

    @Override
    public String getEqLabel() {
        String string;
        block3: {
            string = super.getEqLabel();
            try {
                String string2;
                int n = this.getSlot();
                ArrayList arrayList = this.getNodeModel().getMfgData(this.getShelfId());
                if (n > 0 && (string2 = (String)arrayList.get(n - 1)) != null && string2.indexOf("XPE") != -1) {
                    string = string + "E";
                }
            }
            catch (Exception exception) {
                this.db.fine("Caught " + exception + " while trying to determine XPE");
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string == null ? " " : string;
    }

    @Override
    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            switch (eEqType2.value()) {
                case 167: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                case 168: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                case 316: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                case 329: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new ChGrpPortModel[0]);
                    break;
                }
                case 32: 
                case 34: 
                case 68: 
                case 69: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]);
                    break;
                }
                default: {
                    portModelArray = super.getPortModels(eEqType2);
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public PortModel[] getXPL2EtherPorts() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2EtherPorts(): entry");
        }
        PortModel[] portModelArray = this.getPortModels(eEqType.FE_PORT);
        PortModel[] portModelArray2 = this.getPortModels(eEqType.ONE_GE_PORT);
        PortModel[] portModelArray3 = this.getPortModels(eEqType.TEN_GE_PORT);
        PortModel[] portModelArray4 = new PortModel[portModelArray.length + portModelArray2.length + portModelArray3.length];
        System.arraycopy(portModelArray, 0, portModelArray4, 0, portModelArray.length);
        System.arraycopy(portModelArray2, 0, portModelArray4, portModelArray.length, portModelArray2.length);
        System.arraycopy(portModelArray3, 0, portModelArray4, portModelArray.length + portModelArray2.length, portModelArray3.length);
        Arrays.sort(portModelArray4, new PortComparator());
        return portModelArray4;
    }

    @Override
    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray = null;
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            interfaceModelArray = super.getLineModels(null);
        } else {
            if (eEqType2.equals(eEqType.DWDM_TRUNK_PORT)) {
                portModelArray = this.getPortModels(eEqType2);
                interfaceModelArray = new DwdmTrkLineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (DwdmTrkLineModel)portModelArray[i].getInterfaceModel();
                }
                return interfaceModelArray;
            }
            if (eEqType2.equals(eEqType.DWDM_CLIENT_PORT)) {
                portModelArray = this.getPortModels(eEqType2);
                interfaceModelArray = new DwdmCliLineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (DwdmCliLineModel)portModelArray[i].getInterfaceModel();
                }
                return interfaceModelArray;
            }
            if (eEqType2.equals(eEqType.XP_GE_LINE_CARD) || eEqType2.equals(eEqType.XP_10GE_LINE_CARD)) {
                EtherLineModel[] etherLineModelArray = XPL2ModuleModel.getEtherLineModels(this.getDwdmLineModels());
                interfaceModelArray = new XPL2LineModel[etherLineModelArray.length];
                System.arraycopy(etherLineModelArray, 0, interfaceModelArray, 0, etherLineModelArray.length);
                return interfaceModelArray;
            }
            if (eEqType2.equals(eEqType.CHGRP_PORT)) {
                portModelArray = this.getPortModels(eEqType2);
                interfaceModelArray = new XPL2ChannelGroupModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (XPL2ChannelGroupModel)portModelArray[i].getInterfaceModel();
                }
                return interfaceModelArray;
            }
            if (eEqType2.equals(eEqType.DS1_VT_MAPPED) || eEqType2.equals(eEqType.E1_PORT) || eEqType2.equals(eEqType.DS3) || eEqType2.equals(eEqType.E3_PORT)) {
                portModelArray = this.getPortModels(eEqType2);
                if (portModelArray != null) {
                    interfaceModelArray = new Ds123LineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
                    }
                    return interfaceModelArray;
                }
            } else {
                interfaceModelArray = super.getLineModels(eEqType2);
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    public XPL2Layer2LineModel[] getXPL2UNILinesAndChGrps() {
        int n;
        ArrayList<XPL2Layer2LineModel> arrayList;
        block16: {
            if (this.db.on()) {
                this.db.println("XPL2ModuleModel.getXPLayer2UNILines(): entry");
            }
            XPL2Layer2LineModel[] xPL2Layer2LineModelArray = this.getXPL2Layer2EtherLines();
            arrayList = new ArrayList<XPL2Layer2LineModel>();
            XPL2ChannelGroupModel[] xPL2ChannelGroupModelArray = this.getChannelGroupModels();
            for (n = 0; n < xPL2ChannelGroupModelArray.length; ++n) {
                try {
                    if (xPL2ChannelGroupModelArray[n].isNNI()) continue;
                    arrayList.add(xPL2ChannelGroupModelArray[n]);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                    continue;
                }
                catch (InvalidOperation invalidOperation) {
                    invalidOperation.printStackTrace();
                }
            }
            n = arrayList.size();
            if (this.db.on()) {
                this.db.println("Added " + n + "Channel groups");
            }
            for (int i = 0; i < xPL2Layer2LineModelArray.length; ++i) {
                try {
                    if (xPL2Layer2LineModelArray[i].isNNI()) continue;
                    arrayList.add(xPL2Layer2LineModelArray[i]);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                    continue;
                }
                catch (InvalidOperation invalidOperation) {
                    invalidOperation.printStackTrace();
                }
            }
            InterfaceModel interfaceModel = null;
            try {
                for (int i = 0; i < xPL2ChannelGroupModelArray.length; ++i) {
                    int[] nArray = xPL2ChannelGroupModelArray[i].getPortList();
                    for (int j = 0; j < nArray.length; ++j) {
                        interfaceModel = this.node.getIfModels().getInterfaceModel(nArray[j]);
                        if (!arrayList.contains(interfaceModel)) continue;
                        if (this.db.on()) {
                            this.db.println("port " + interfaceModel.getPort().getPortString() + " belongs to a CHGRP" + " remove it.");
                        }
                        arrayList.remove(interfaceModel);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block16;
                this.db.println("Exception in retrieving port from if " + exception);
            }
        }
        if (this.db.on()) {
            this.db.println("Added " + (arrayList.size() - n) + " UNI lines");
        }
        return arrayList.toArray(new XPL2Layer2LineModel[0]);
    }

    public XPL2LineModel[] getXPL2UNILines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2UNILines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                sBasicL2Info sBasicL2Info2 = xPL2LineModelArray[i].getEtherBasicL2Info();
                if (sBasicL2Info2 == null || xPL2LineModelArray[i].getEtherBasicL2Info().niMode != eNiValue.UNI_MODE) continue;
                arrayList.add(xPL2LineModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                invalidOperation.printStackTrace();
            }
        }
        return arrayList.toArray(new XPL2LineModel[0]);
    }

    public Pane getQinQPlugin(TabbedView tabbedView, IXPLLayer2LineModel iXPLLayer2LineModel, short s, QinQSettings qinQSettings) {
        return new XPL2QinQProvPane("QinQ", tabbedView, this, iXPLLayer2LineModel, s, qinQSettings);
    }

    public Pane getQinQPlugin(TabbedView tabbedView, short s, short s2, QinQSettings qinQSettings) {
        return null;
    }

    public XPL2LineModel[] getXPL2NNITrunkLines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2NNITrunkLines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                sBasicL2Info sBasicL2Info2 = xPL2LineModelArray[i].getEtherBasicL2Info();
                if (sBasicL2Info2 == null || xPL2LineModelArray[i].getEtherBasicL2Info().niMode != eNiValue.NNI_MODE || !xPL2LineModelArray[i].isTrunk()) continue;
                arrayList.add(xPL2LineModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                invalidOperation.printStackTrace();
            }
        }
        return arrayList.toArray(new XPL2LineModel[0]);
    }

    public IVlanInfo[] getVlanDb() {
        try {
            sVlanFuncItem[] sVlanFuncItemArray = (sVlanFuncItem[])this.vlanDb.get();
            IVlanInfo[] iVlanInfoArray = VlanInfoFactory.getIVlanInfoArray(sVlanFuncItemArray);
            if (this.db.on()) {
                this.db.println("vlan db for: " + this);
                for (IVlanInfo iVlanInfo : iVlanInfoArray) {
                    this.db.println("  " + iVlanInfo);
                }
            }
            return iVlanInfoArray;
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureNotSupported(xFeatureUnsupported2.getMessage());
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanDb", userException);
        }
    }

    public IVlanInfo[] getCVlanDb() {
        XPL2Layer2LineModel[] xPL2Layer2LineModelArray;
        ArrayList<VlanInfo> arrayList = new ArrayList<VlanInfo>();
        VlanInfo vlanInfo = null;
        sVlanCrossInfoData[] sVlanCrossInfoDataArray = null;
        for (XPL2Layer2LineModel xPL2Layer2LineModel : xPL2Layer2LineModelArray = this.getXPL2Layer2EtherLines()) {
            try {
                sVlanCrossInfoDataArray = xPL2Layer2LineModel.getVlanCrossInfoList();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            for (sVlanCrossInfoData sVlanCrossInfoData2 : sVlanCrossInfoDataArray) {
                if (sVlanCrossInfoData2.rule != eVlanOperator.VLAN_ADD || sVlanCrossInfoData2.cVlan.first != sVlanCrossInfoData2.cVlan.last || sVlanCrossInfoData2.cVlan.first == 0) continue;
                vlanInfo = new VlanInfo(sVlanCrossInfoData2.cVlan.first, sVlanCrossInfoData2.cVlan.first + "");
                arrayList.add(vlanInfo);
            }
        }
        return arrayList.toArray(new IVlanInfo[0]);
    }

    public sVlanFuncItem[] getVlanDbItems() {
        try {
            sVlanFuncItem[] sVlanFuncItemArray = (sVlanFuncItem[])this.vlanDb.get();
            return sVlanFuncItemArray;
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureNotSupported(xFeatureUnsupported2.getMessage());
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanDbItems", userException);
        }
    }

    public void setVlanDbItems(sVlanFuncItem[] sVlanFuncItemArray) throws EMCProvisionError, FeatureUnsupported, NoSuchEquipment {
        try {
            this.vlanDb.set(sVlanFuncItemArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setVlanDbItems", userException);
        }
    }

    public void setVlanDb(IVlanInfo[] iVlanInfoArray) throws EMCProvisionError, FeatureUnsupported, NoSuchEquipment {
        try {
            if (this.db.on()) {
                this.db.println("set vlan db for: " + this);
                for (IVlanInfo iVlanInfo : iVlanInfoArray) {
                    this.db.println("  " + iVlanInfo);
                }
            }
            this.vlanDb.set(VlanInfoFactory.getSvlanFuncItemArray(iVlanInfoArray));
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setVlanDb", userException);
        }
    }

    public sMcastReportInfo[] getVlanMultiCastInfoList(sVlanRangeInfo[] sVlanRangeInfoArray) throws AbstractCmsIOException, NoSuchInterface, WrongInterfaceType {
        try {
            return (sMcastReportInfo[])this.actualMultiCastInfo.get(sVlanRangeInfoArray);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanMultiCastInfoList", userException);
        }
    }

    public ILearnedAddress[] getLearnedMacInfo(sVlanRangeInfo[] sVlanRangeInfoArray, eMultiGetProtocolStates eMultiGetProtocolStates2, int n) throws WrongParameters, EMCProvisionError, NotSupportedOnEquipment, MgetReqInProgress, MgetReqExpiredTimeout, MgetReqProtocolError, NoSuchEquipment, BoardBusyError {
        try {
            Object[] objectArray = new Object[]{sVlanRangeInfoArray, eMultiGetProtocolStates2, new Integer(n)};
            byte[] byArray = null;
            byte[] byArray2 = null;
            byArray = (byte[])this.learnedMacInfo.get(objectArray);
            if (this.db.on()) {
                this.db.println("compressedBytes.length = " + byArray.length);
            }
            if (eMultiGetProtocolStates2 == eMultiGetProtocolStates.MGET_GET_STOP) {
                return null;
            }
            try {
                byArray2 = XPL2ModuleModel.uncompressByteArray(byArray);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ILearnedAddress[] iLearnedAddressArray = null;
            boolean bl = true;
            if (byArray2[0] == eMultiGetProtocolStates.MGET_RSP_ERROR.value() || byArray2[0] == eMultiGetProtocolStates.MGET_RSP_END.value()) {
                bl = false;
            }
            if (this.db.on()) {
                this.db.println("continueRequest = " + bl + " - decompressedData[0] = " + byArray2[0]);
            }
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
            if (this.db.on()) {
                this.db.println("decompressedData.length = " + byArray2.length);
            }
            iLearnedAddressArray = XPL2ModuleModel.decode(this.divideArrayInToken(byArray2));
            if (this.db.on()) {
                this.db.println("Number of LearnedAddress found:  " + iLearnedAddressArray.length);
            }
            if (!bl && iLearnedAddressArray.length > 0) {
                iLearnedAddressArray[iLearnedAddressArray.length - 1].setLastAddress(true);
            }
            return iLearnedAddressArray;
        }
        catch (xWrongParameters xWrongParameters2) {
            throw new WrongParameters((UserException)xWrongParameters2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xMgetReqInProgress xMgetReqInProgress2) {
            throw new MgetReqInProgress((UserException)xMgetReqInProgress2);
        }
        catch (xMgetReqExpiredTimeout xMgetReqExpiredTimeout2) {
            throw new MgetReqExpiredTimeout((UserException)xMgetReqExpiredTimeout2);
        }
        catch (xMgetReqProtocolError xMgetReqProtocolError2) {
            throw new MgetReqProtocolError((UserException)xMgetReqProtocolError2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xBoardBusy xBoardBusy2) {
            throw new BoardBusyError((UserException)xBoardBusy2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLearnedMacInfo", userException);
        }
    }

    public void clearLearnedAddress() throws NotSupportedOnEquipment, MgetReqInProgress, NoSuchEquipment {
        try {
            this.learnedMacInfo.set(new Integer(this.entityIndex));
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xMgetReqInProgress xMgetReqInProgress2) {
            throw new MgetReqInProgress((UserException)xMgetReqInProgress2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearLearnedAddress", userException);
        }
    }

    public boolean isInL2Mode() {
        eCardOperMode eCardOperMode2 = this.getCardOperMode();
        return eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH || eCardOperMode2 == eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH;
    }

    public boolean isInMxpMode() {
        return !this.isInL2Mode() && this.getEqType() == 272;
    }

    public boolean isInTxpMode() {
        return !this.isInL2Mode() && this.getEqType() == 271;
    }

    public XPL2Layer2LineModel[] getXPL2NNILinesAndChGrps() {
        int n;
        ArrayList<XPL2Layer2LineModel> arrayList;
        block16: {
            if (this.db.on()) {
                this.db.println("XPL2ModuleModel.getXPLayer2NNILines(): entry");
            }
            XPL2Layer2LineModel[] xPL2Layer2LineModelArray = this.getXPL2Layer2EtherLines();
            arrayList = new ArrayList<XPL2Layer2LineModel>();
            XPL2ChannelGroupModel[] xPL2ChannelGroupModelArray = this.getChannelGroupModels();
            for (n = 0; n < xPL2ChannelGroupModelArray.length; ++n) {
                try {
                    if (!xPL2ChannelGroupModelArray[n].isNNI()) continue;
                    arrayList.add(xPL2ChannelGroupModelArray[n]);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                    continue;
                }
                catch (InvalidOperation invalidOperation) {
                    invalidOperation.printStackTrace();
                }
            }
            n = arrayList.size();
            if (this.db.on()) {
                this.db.println("Added " + n + " Channel Groups");
            }
            for (int i = 0; i < xPL2Layer2LineModelArray.length; ++i) {
                try {
                    if (!xPL2Layer2LineModelArray[i].isNNI()) continue;
                    arrayList.add(xPL2Layer2LineModelArray[i]);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                    continue;
                }
                catch (InvalidOperation invalidOperation) {
                    invalidOperation.printStackTrace();
                }
            }
            InterfaceModel interfaceModel = null;
            try {
                for (int i = 0; i < xPL2ChannelGroupModelArray.length; ++i) {
                    int[] nArray = xPL2ChannelGroupModelArray[i].getPortList();
                    for (int j = 0; j < nArray.length; ++j) {
                        interfaceModel = this.node.getIfModels().getInterfaceModel(nArray[j]);
                        if (!arrayList.contains(interfaceModel)) continue;
                        if (this.db.on()) {
                            this.db.println("port " + interfaceModel.getPort().getPortString() + " belongs to a CHGRP" + " remove it.");
                        }
                        arrayList.remove(interfaceModel);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block16;
                this.db.println("Exception in retrieving port from if " + exception);
            }
        }
        if (this.db.on()) {
            this.db.println("Added " + (arrayList.size() - n) + " NNI lines");
        }
        return arrayList.toArray(new XPL2Layer2LineModel[0]);
    }

    public XPL2LineModel[] getXPL2NNILines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2NNILines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            try {
                sBasicL2Info sBasicL2Info2 = xPL2LineModelArray[i].getEtherBasicL2Info();
                if (sBasicL2Info2 == null || xPL2LineModelArray[i].getEtherBasicL2Info().niMode != eNiValue.NNI_MODE) continue;
                arrayList.add(xPL2LineModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                invalidOperation.printStackTrace();
            }
        }
        return arrayList.toArray(new XPL2LineModel[0]);
    }

    public XPL2LineModel[] getXPL2EtherLines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2EtherLines(): entry");
        }
        return (XPL2LineModel[])this.getLineModels(this.getEqTypeEnum());
    }

    public XPL2ChannelGroupModel[] getChannelGroupModels() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2ChGrpLineModel(): entry");
        }
        return (XPL2ChannelGroupModel[])this.getLineModels(eEqType.CHGRP_PORT);
    }

    public ChGrpPortModel[] getChannelGroupPorts() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getChannelGroupPorts(): entry");
        }
        return (ChGrpPortModel[])this.getPortModels(eEqType.CHGRP_PORT);
    }

    public XPL2Layer2LineModel[] getXPL2Layer2EtherLines() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2Layer2EtherLines(): entry");
        }
        ArrayList<XPL2Layer2LineModel> arrayList = new ArrayList<XPL2Layer2LineModel>();
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        XPL2Layer2LineModel xPL2Layer2LineModel = null;
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            xPL2Layer2LineModel = xPL2LineModelArray[i].getLayer2LineModel();
            if (xPL2Layer2LineModel == null) continue;
            arrayList.add(xPL2Layer2LineModel);
        }
        return arrayList.toArray(new XPL2Layer2LineModel[0]);
    }

    public XPL2Layer2LineModel getXPL2Layer2EtherLines(int n) {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2Layer2EtherLines(): entry");
        }
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            if (xPL2LineModelArray[i].getFirstLowerLayerModels().getIndex() != n) continue;
            return xPL2LineModelArray[i].getLayer2LineModel();
        }
        return null;
    }

    public XPL2ChannelGroupManager getChGrpManager() {
        return this.chGrpMng;
    }

    public Integer[] getXPL2Layer2EtherLineIndices() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.getXPL2Layer2EtherLineIndices(): entry");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        XPL2Layer2LineModel xPL2Layer2LineModel = null;
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            xPL2Layer2LineModel = xPL2LineModelArray[i].getLayer2LineModel();
            if (xPL2Layer2LineModel == null) continue;
            arrayList.add(new Integer(xPL2Layer2LineModel.getIndex()));
        }
        return arrayList.toArray(new Integer[0]);
    }

    public InterfaceModel[] getXPL2PdhLines(eEqType eEqType2) {
        return this.getLineModels(eEqType2);
    }

    @Override
    public IRmonModel[] getRmonModels() {
        int n;
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        XPL2ChannelGroupModel[] xPL2ChannelGroupModelArray = this.getChannelGroupModels();
        ArrayList<IRmonModel> arrayList = new ArrayList<IRmonModel>();
        for (n = 0; n < xPL2ChannelGroupModelArray.length; ++n) {
            arrayList.add(xPL2ChannelGroupModelArray[n].getRmonModel());
        }
        for (n = 0; n < xPL2LineModelArray.length; ++n) {
            arrayList.add(xPL2LineModelArray[n].getRmonModel());
        }
        return arrayList.toArray(new IRmonModel[0]);
    }

    public sFrpInfo getFrpInfo() {
        try {
            return (sFrpInfo)this.frpInfo.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getFrpInfo", userException);
        }
    }

    public sCrcInfo getCrcInfo() {
        try {
            return (sCrcInfo)this.crcInfo.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getCrcInfo", userException);
        }
    }

    public eProtectionInterOPMode getProtOpMode() {
        try {
            return (eProtectionInterOPMode)this.protOpMode.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getProtOpMode", userException);
        }
    }

    public void setFrpInfo(sFrpInfo sFrpInfo2) throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            this.frpInfo.set(sFrpInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setCardFrpInfo", userException);
        }
    }

    public void setCrcInfo(sCrcInfo sCrcInfo2) throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            this.crcInfo.set(sCrcInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setCrcInfo", userException);
        }
    }

    public void setoProtOpMode(eProtectionInterOPMode eProtectionInterOPMode2) throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            this.protOpMode.set(eProtectionInterOPMode2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setoProtOpMode", userException);
        }
    }

    public sMcastInfo getMvrInfo() {
        try {
            return (sMcastInfo)this.mvrInfo.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getMvrInfo", userException);
        }
    }

    public void setMvrInfo(sMcastInfo sMcastInfo2) throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            this.mvrInfo.set(sMcastInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setMvrInfo", userException);
        }
    }

    public sVlanCondReportInfo[] getActualVlanConditions(int n) throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sVlanCondReportInfo[])this.actualVlanCond.get(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSide", userException);
        }
    }

    public sCFMCondReportInfo[] getActualMEPDownConditions(int n, String string, int n2) throws NoSuchInterface, WrongInterfaceType {
        String string2 = new String("getActualMEPDownConditions");
        try {
            return (sCFMCondReportInfo[])this.cfmCond.get(new Object[]{string2, new Integer(n), string, new Integer(n2)});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualMEPDownConditions", userException);
        }
    }

    public sCFMCondReportInfo[] getActualFwdLoopConditions(int n, String string, int n2) throws NoSuchInterface, WrongInterfaceType {
        String string2 = new String("getActualFwdLoopConditions");
        try {
            return (sCFMCondReportInfo[])this.cfmCond.get(new Object[]{string2, new Integer(n), string, new Integer(n2)});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualMEPDownConditions", userException);
        }
    }

    public sCFMCondReportInfo[] getActualCfgErrConditions(int n, String string, int n2) throws NoSuchInterface, WrongInterfaceType {
        String string2 = new String("getActualCfgErrConditions");
        try {
            return (sCFMCondReportInfo[])this.cfmCond.get(new Object[]{string2, new Integer(n), string, new Integer(n2)});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualCfgErrConditions", userException);
        }
    }

    public sCFMIICondReportInfo[] getActualCrossConnectedConditions(int n, String string, int n2) throws NoSuchInterface, WrongInterfaceType {
        String string2 = new String("getActualCrossConnectedConditions");
        try {
            return (sCFMIICondReportInfo[])this.cfmCond.get(new Object[]{string2, new Integer(n), string, new Integer(n2)});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualCrossConnectedConditions", userException);
        }
    }

    public sRepSegmentAttributes[] getRepSegmentList() {
        try {
            return (sRepSegmentAttributes[])this.repSegmentList.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getRepSegmentList", userException);
        }
    }

    public RepSegmentAttribute[] getRepSegmentAttributesList() {
        sRepSegmentAttributes[] sRepSegmentAttributesArray = this.getRepSegmentList();
        RepSegmentAttribute[] repSegmentAttributeArray = new RepSegmentAttribute[sRepSegmentAttributesArray.length];
        for (int i = 0; i < sRepSegmentAttributesArray.length; ++i) {
            repSegmentAttributeArray[i] = new RepSegmentAttribute(sRepSegmentAttributesArray[i]);
        }
        return repSegmentAttributeArray;
    }

    public sRepAdminVlan getRepAdminVlan() throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            return (sRepAdminVlan)this.repAdminVlan.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAdminVlan", userException);
        }
    }

    public void setRepAdminVlan(sRepAdminVlan sRepAdminVlan2) throws ProvisionError, NotSupportedOnEquipment, NoSuchEquipment {
        try {
            this.repAdminVlan.set(sRepAdminVlan2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setAdminVlan", userException);
        }
    }

    public int[] getAvailableL2IfForRep() {
        Object object;
        try {
            object = this.repIf.getValue();
        }
        catch (UserException userException) {
            throw this.doUnknown("getAvailableL2IfForRep", userException);
        }
        return (int[])object;
    }

    public boolean isInMapperMode() {
        int n = this.getEqType();
        return n == 271 || n == 272;
    }

    public boolean isXPE() {
        int n = this.getEqType();
        if (n == 271 || n == 272) {
            sMfgData_2_01 sMfgData_2_012 = this.getMfgData();
            return sMfgData_2_012.name != null && sMfgData_2_012.firmwareVersion != null && (sMfgData_2_012.name.indexOf("XPE-GE") != -1 || sMfgData_2_012.name.indexOf("XPE-10GE") != -1);
        }
        return false;
    }

    @Override
    public String toString() {
        return "XPL2" + super.toString();
    }

    protected General getEtherMediaRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherMediaRef();
    }

    protected cerent.cms.idl.EtherL2Media.General getEtherL2Ref() {
        return this.getNodeModelDelegate().getIorRepository().getEtherL2Ref();
    }

    protected EtherL2Module getEtherL2ModuleRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherL2ModuleRef();
    }

    @Override
    boolean isPortNumUnique(int n) {
        return false;
    }

    @Override
    public boolean isComboModule() {
        return true;
    }

    @Override
    public boolean supportsClearPM() {
        return true;
    }

    public boolean isL2Switch() {
        return this.getCardOperMode() == eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH || this.getCardOperMode() == eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH;
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.updateLocal(): entry");
        }
        this.frpInfo.update();
        this.mipConfig.update();
        this.mepConfig.update();
        this.crcInfo.update();
        this.protOpMode.update();
        super.updateLocal();
        this.setChanged();
        if (this.db.on()) {
            this.db.println("XPL2ModuleModel.updateLocal(): exit");
        }
    }

    @Override
    public void dispose() {
        this.frpInfo.dispose();
        this.mipConfig.dispose();
        this.mepConfig.dispose();
        this.crcInfo.dispose();
        this.protOpMode.dispose();
        super.dispose();
    }

    @Override
    protected boolean needNotify() {
        return true;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    public boolean isFrpMasterCard() {
        sFrpInfo sFrpInfo2 = this.getFrpInfo();
        return sFrpInfo2.frpRole == eCardFrpRole.FRP_MASTER_CARD;
    }

    public boolean isFrpEnabled() {
        sFrpInfo sFrpInfo2 = this.getFrpInfo();
        return sFrpInfo2.frpState != eCardFrpState.FRP_DISABLED;
    }

    private ArrayList<byte[]> divideArrayInToken(byte[] byArray) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray2 = null;
        for (int i = 0; i < byArray.length; i += 12) {
            byArray2 = new byte[12];
            int n = i;
            for (int j = 0; j < 12; ++j) {
                byArray2[j] = byArray[n];
                ++n;
            }
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static LearnedAddress[] decode(ArrayList<byte[]> arrayList) {
        byte[] byArray = new byte[6];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[4];
        int n = 0;
        LearnedAddress[] learnedAddressArray = new LearnedAddress[arrayList.size()];
        for (byte[] byArray4 : arrayList) {
            byArray = new byte[6];
            byArray2 = new byte[2];
            byArray3 = new byte[4];
            System.arraycopy(byArray4, 0, byArray, 0, 6);
            System.arraycopy(byArray4, 6, byArray2, 0, 2);
            System.arraycopy(byArray4, 8, byArray3, 0, 4);
            short s = ByteArrayUtil.toShort(byArray2);
            int n2 = ByteArrayUtil.toInt(byArray3);
            learnedAddressArray[n] = new LearnedAddress();
            learnedAddressArray[n].setMacAddress(byArray);
            learnedAddressArray[n].setVlanId(s);
            learnedAddressArray[n].setIfIndex(n2);
            ++n;
        }
        return learnedAddressArray;
    }

    private static byte[] uncompressByteArray(byte[] byArray) throws Exception {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byte[] byArray2 = new byte[1024];
        while (!inflater.finished()) {
            try {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            catch (DataFormatException dataFormatException) {}
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return byArray3;
    }

    public eCCTimer getCardCCTimer() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (eCCTimer)this.cardCCTimer.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCardCFMStatus", userException);
        }
    }

    public void setCardCCTimer(eCCTimer eCCTimer2) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError {
        try {
            this.cardCCTimer.set(eCCTimer2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getCardCFMStatus", userException);
        }
    }

    public boolean getCardCFMStatus() throws NoSuchInterface, WrongInterfaceType, ProvisionError, UserException {
        try {
            return (Boolean)this.cardCFMStat.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCardCFMStatus", userException);
        }
    }

    public void setCardCFMStatus(boolean bl) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError, UserException {
        Boolean bl2 = new Boolean(bl);
        try {
            this.cardCFMStat.set(bl);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public void createMaintenanceDomain(IDomainProfileInfo iDomainProfileInfo) throws EMCProvisionError {
        sMaintenanceDomain sMaintenanceDomain2 = DomainProfileInfoFactory.getMaintenanceDomain(iDomainProfileInfo);
        String string = new String("createMaintenanceDomain");
        try {
            this.domainProfile.set(new Object[]{string, sMaintenanceDomain2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public void createMaintenanceDomain(sMaintenanceDomain sMaintenanceDomain2) throws EMCProvisionError {
        String string = new String("createMaintenanceDomain");
        try {
            this.domainProfile.set(new Object[]{string, sMaintenanceDomain2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public void addMAProfile(IMAProfileInfo iMAProfileInfo) throws EMCProvisionError {
        sMAProfile sMAProfile2 = MAProfileInfoFactory.getMAProfile(iMAProfileInfo);
        String string = new String("addMAProfile");
        try {
            this.maProfile.set(new Object[]{string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public void addMAProfile(sMAProfile sMAProfile2) throws EMCProvisionError {
        String string = new String("addMAProfile");
        try {
            this.maProfile.set(new Object[]{string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public void removeMaintenanceDomain(IDomainProfileInfo iDomainProfileInfo) throws EMCProvisionError {
        sMaintenanceDomain sMaintenanceDomain2 = DomainProfileInfoFactory.getMaintenanceDomain(iDomainProfileInfo);
        String string = new String("removeMaintenanceDomain");
        try {
            this.domainProfile.set(new Object[]{string, sMaintenanceDomain2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "removeMaintenanceDomain", userException);
        }
    }

    public void clearMaintenanceDomain(sMaintenanceDomain sMaintenanceDomain2) throws EMCProvisionError {
        String string = new String("removeMaintenanceDomain");
        try {
            this.domainProfile.set(new Object[]{string, sMaintenanceDomain2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "removeMaintenanceDomain", userException);
        }
    }

    public void removeMAProfile(IMAProfileInfo iMAProfileInfo) throws EMCProvisionError {
        sMAProfile sMAProfile2 = MAProfileInfoFactory.getMAProfile(iMAProfileInfo);
        String string = new String("removeMAProfile");
        try {
            this.maProfile.set(new Object[]{string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "removeMAProfile", userException);
        }
    }

    public void clearMAProfile(sMAProfile sMAProfile2) throws EMCProvisionError {
        String string = new String("removeMAProfile");
        try {
            this.maProfile.set(new Object[]{string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "clearMAProfile", userException);
        }
    }

    public void attachMAProfile(String string, IMAProfileInfo iMAProfileInfo) throws EMCProvisionError {
        String string2 = new String("attachMAProfile");
        sMAProfile sMAProfile2 = MAProfileInfoFactory.getMAProfile(iMAProfileInfo);
        try {
            this.domainProfile.set(new Object[]{string2, string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "attachMAProfile", userException);
        }
    }

    public void attachMAProfile(String string, sMAProfile sMAProfile2) throws EMCProvisionError {
        String string2 = new String("attachMAProfile");
        try {
            this.domainProfile.set(new Object[]{string2, string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "attachMAProfile", userException);
        }
    }

    public void detachMAProfile(String string, IMAProfileInfo iMAProfileInfo) throws EMCProvisionError {
        String string2 = new String("detachMAProfile");
        sMAProfile sMAProfile2 = MAProfileInfoFactory.getMAProfile(iMAProfileInfo);
        try {
            this.domainProfile.set(new Object[]{string2, string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "detachMAProfile", userException);
        }
    }

    public void detachMAProfile(String string, sMAProfile sMAProfile2) throws EMCProvisionError {
        String string2 = new String("detachMAProfile");
        try {
            this.domainProfile.set(new Object[]{string2, string, sMAProfile2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "detachMAProfile", userException);
        }
    }

    public void detachAllMAProfiles(String string) throws EMCProvisionError {
        String string2 = new String("detachAllMAProfiles");
        try {
            this.domainProfile.set(new Object[]{string2, string});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "detachAllMAProfiles", userException);
        }
    }

    public void modifyMAProfile(IMAProfileInfo iMAProfileInfo, IMAProfileInfo iMAProfileInfo2) throws EMCProvisionError {
        sMAProfile sMAProfile2 = MAProfileInfoFactory.getMAProfile(iMAProfileInfo);
        sMAProfile sMAProfile3 = MAProfileInfoFactory.getMAProfile(iMAProfileInfo2);
        String string = new String("modifyMAProfile");
        try {
            this.maProfile.set(new Object[]{string, sMAProfile2, sMAProfile3});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "modifyMAProfile", userException);
        }
    }

    public void modifyMAProfile(sMAProfile sMAProfile2, sMAProfile sMAProfile3) throws EMCProvisionError {
        String string = new String("modifyMAProfile");
        try {
            this.maProfile.set(new Object[]{string, sMAProfile2, sMAProfile3});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "modifyMAProfile", userException);
        }
    }

    public IDomainProfileInfo[] getMaintenanceDomains() throws ProvisionError {
        try {
            sMaintenanceDomain[] sMaintenanceDomainArray = (sMaintenanceDomain[])this.domainProfile.get();
            IDomainProfileInfo[] iDomainProfileInfoArray = DomainProfileInfoFactory.getDomainProfileInfoArray(sMaintenanceDomainArray);
            return iDomainProfileInfoArray;
        }
        catch (xProvisionError xProvisionError2) {
            new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMaintenanceDomains()", userException);
        }
        return null;
    }

    public sMaintenanceDomain[] getTheMaintenanceDomains() throws ProvisionError {
        try {
            sMaintenanceDomain[] sMaintenanceDomainArray = (sMaintenanceDomain[])this.domainProfile.get();
            return sMaintenanceDomainArray;
        }
        catch (xProvisionError xProvisionError2) {
            new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTheMaintenanceDomains()", userException);
        }
        return null;
    }

    public IMAProfileInfo[] getAllMAProfiles() throws ProvisionError {
        try {
            sMAProfile[] sMAProfileArray = (sMAProfile[])this.maProfile.get();
            IMAProfileInfo[] iMAProfileInfoArray = MAProfileInfoFactory.getMAProfileInfoArray(sMAProfileArray);
            return iMAProfileInfoArray;
        }
        catch (xProvisionError xProvisionError2) {
            new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAllMAProfiles()", userException);
        }
        return null;
    }

    public sMAProfile[] getMAProfiles() throws ProvisionError {
        try {
            sMAProfile[] sMAProfileArray = (sMAProfile[])this.maProfile.get();
            return sMAProfileArray;
        }
        catch (xProvisionError xProvisionError2) {
            new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAllMAProfiles()", userException);
        }
        return null;
    }

    public IMAProfileInfo[] getMAFromDomain(String string) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            sMAProfile[] sMAProfileArray = (sMAProfile[])this.maProfile.get(new Object[]{string});
            IMAProfileInfo[] iMAProfileInfoArray = MAProfileInfoFactory.getMAProfileInfoArray(sMAProfileArray);
            return iMAProfileInfoArray;
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMaintenanceDomains()", userException);
        }
    }

    public sMAProfile[] getMAProfileFromDomain(String string) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            sMAProfile[] sMAProfileArray = (sMAProfile[])this.maProfile.get(new Object[]{string});
            return sMAProfileArray;
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMAProfileFromDomain()", userException);
        }
    }

    public MIPInfo[] getMIPS() throws NoSuchInterface, WrongInterfaceType {
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        try {
            sMIP[] sMIPArray = (sMIP[])this.mipConfig.get();
            return MIPInfoFactory.getMIPModels(sMIPArray, this);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMIPS()", userException);
        }
    }

    public MEPInfo[] getMEPS() throws NoSuchInterface, WrongInterfaceType {
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        try {
            sMEP[] sMEPArray = (sMEP[])this.mepConfig.get();
            return MEPInfoFactory.getMEPModels(sMEPArray, this);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMEPS()", userException);
        }
    }

    public Object getIdForCommand() throws EMCProvisionError, NoSuchEquipment {
        try {
            return this.cfmCommand.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            userException.printStackTrace();
            return null;
        }
    }

    public Integer getIdForCFMCommand() throws EMCProvisionError, NoSuchEquipment {
        try {
            return (Integer)this.cfmCommand.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            userException.printStackTrace();
            return null;
        }
    }

    public void setCFMCommand(sCfmCmdReqInfo sCfmCmdReqInfo2) throws CFMCommandFailed, EMCProvisionError, NoSuchEquipment {
        try {
            this.cfmCommand.set(new Object[]{sCfmCmdReqInfo2});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (xCFMCommandFailed xCFMCommandFailed2) {
            throw new CFMCommandFailed((UserException)xCFMCommandFailed2);
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public sCfmCmdRspInfo getCFMCommandRsp(int n) throws EMCProvisionError, NoSuchEquipment {
        try {
            return (sCfmCmdRspInfo)this.cfmCommand.get(new Object[]{new Integer(n)});
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            userException.printStackTrace();
            return null;
        }
    }

    public void cancelCFMCommand() throws EMCProvisionError {
        try {
            this.cfmCommand.set();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public void clearMEPMIPCCDB() throws NoSuchInterface, WrongInterfaceType {
        String string = new String("clearMEPMIPCCDB");
        try {
            this.ccdbCommand.set(new Object[]{string});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearMEPMIPCCDB()", userException);
        }
    }

    public void clearMEPStats() throws NoSuchInterface, WrongInterfaceType {
        String string = new String("clearMEPStats");
        try {
            this.ccdbCommand.set(new Object[]{string});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearMEPStats()", userException);
        }
    }

    public sMEPCCDB[] getMEPCCDB(String string, sVlanRangeInfo[] sVlanRangeInfoArray) throws NoSuchInterface, WrongInterfaceType {
        try {
            String string2 = new String("getMEPCCDB");
            return (sMEPCCDB[])this.ccdbCommand.get(new Object[]{string2, this.entityIndex, string, sVlanRangeInfoArray});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMEPCCDB()", userException);
        }
    }

    public sMIPCCDB[] getMIPCCDB(int n, sVlanRangeInfo[] sVlanRangeInfoArray) throws NoSuchInterface, WrongInterfaceType {
        try {
            String string = new String("getMIPCCDB");
            return (sMIPCCDB[])this.ccdbCommand.get(new Object[]{string, new Integer(this.entityIndex), new Integer(n), sVlanRangeInfoArray});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMIPCCDB()", userException);
        }
    }

    public sMEPStats[] getMEPStats(String string, sVlanRangeInfo[] sVlanRangeInfoArray) throws NoSuchInterface, WrongInterfaceType {
        try {
            String string2 = new String("getMEPStats");
            return (sMEPStats[])this.ccdbCommand.get(new Object[]{string2, this.entityIndex, string, sVlanRangeInfoArray});
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMEPStats()", userException);
        }
    }

    public boolean hasEthMiTopLines() {
        boolean bl = false;
        XPL2LineModel[] xPL2LineModelArray = this.getXPL2EtherLines();
        for (int i = 0; i < xPL2LineModelArray.length; ++i) {
            if (!xPL2LineModelArray[i].isMiTopLine()) continue;
            bl = true;
            return bl;
        }
        return bl;
    }

    private class ActualMultiCastInfo
    extends NonCachedValue {
        public ActualMultiCastInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            Object[] objectArray = (Object[])object;
            sVlanRangeInfo[] sVlanRangeInfoArray = (sVlanRangeInfo[])objectArray;
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getActualMcastInfo(XPL2ModuleModel.this.entityIndex, sVlanRangeInfoArray);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }
    }

    public class ActualVlanConditions
    extends NonCachedValue {
        public ActualVlanConditions(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return ((XPL2ModuleModel)XPL2ModuleModel.this.getModuleModel()).getEtherL2Ref().getActualVlanConditions((Integer)object);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }
    }

    private class CCDBCommand
    extends NonCachedValue {
        public CCDBCommand(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            if (string.equalsIgnoreCase("clearMEPMIPCCDB")) {
                XPL2ModuleModel.this.getEtherEOAMRef().clearMEPMIPCCDB(XPL2ModuleModel.this.entityIndex);
            } else if (string.equalsIgnoreCase("clearMEPStats")) {
                XPL2ModuleModel.this.getEtherEOAMRef().clearMEPStats(XPL2ModuleModel.this.entityIndex);
            }
        }

        @Override
        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            if (string.equalsIgnoreCase("getMEPCCDB")) {
                String string2 = (String)objectArray[2];
                sVlanRangeInfo[] sVlanRangeInfoArray = (sVlanRangeInfo[])objectArray[3];
                return XPL2ModuleModel.this.getEtherEOAMRef().getMEPCCDB((Integer)objectArray[1], string2, sVlanRangeInfoArray);
            }
            if (string.equalsIgnoreCase("getMIPCCDB")) {
                Integer n = (Integer)objectArray[2];
                sVlanRangeInfo[] sVlanRangeInfoArray = (sVlanRangeInfo[])objectArray[3];
                return XPL2ModuleModel.this.getEtherEOAMRef().getMIPCCDB((Integer)objectArray[1], (short)n.intValue(), sVlanRangeInfoArray);
            }
            if (string.equalsIgnoreCase("getMEPStats")) {
                String string3 = (String)objectArray[2];
                sVlanRangeInfo[] sVlanRangeInfoArray = (sVlanRangeInfo[])objectArray[3];
                return XPL2ModuleModel.this.getEtherEOAMRef().getMEPStats((Integer)objectArray[1], string3, sVlanRangeInfoArray);
            }
            return null;
        }
    }

    private class CFMCommand
    extends NonCachedValue {
        public CFMCommand(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        protected void setValue(Object object) throws xCFMCommandFailed, xProvisionError, xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            XPL2ModuleModel.this.getEtherEOAMRef().setCfmCmdRequest(XPL2ModuleModel.this.entityIndex, (sCfmCmdReqInfo)objectArray[0]);
        }

        @Override
        protected void setValue() throws xProvisionError, xNoSuchEquipment {
            XPL2ModuleModel.this.getEtherEOAMRef().cancelCfmCmdReq(XPL2ModuleModel.this.entityIndex);
        }

        @Override
        protected Object getValue(Object object) throws xProvisionError, xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            return XPL2ModuleModel.this.getEtherEOAMRef().getCfmCmdResponse(XPL2ModuleModel.this.entityIndex, (short)((Integer)objectArray[0]).intValue());
        }

        @Override
        protected Object getValue() throws xProvisionError, xNoSuchEquipment {
            return new Integer(XPL2ModuleModel.this.getEtherEOAMRef().getIdForCommand(XPL2ModuleModel.this.entityIndex));
        }
    }

    public class CFMConditions
    extends NonCachedValue {
        public CFMConditions(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            if (string.equalsIgnoreCase("getActualMEPDownConditions")) {
                return ((XPL2ModuleModel)XPL2ModuleModel.this.getModuleModel()).getEtherEOAMRef().getActualMEPDownConditions((Integer)objectArray[1], (String)objectArray[2], (short)((Integer)objectArray[3]).intValue());
            }
            if (string.equalsIgnoreCase("getActualCfgErrConditions")) {
                return ((XPL2ModuleModel)XPL2ModuleModel.this.getModuleModel()).getEtherEOAMRef().getActualCfgErrConditions((Integer)objectArray[1], (String)objectArray[2], (short)((Integer)objectArray[3]).intValue());
            }
            if (string.equalsIgnoreCase("getActualFwdLoopConditions")) {
                return ((XPL2ModuleModel)XPL2ModuleModel.this.getModuleModel()).getEtherEOAMRef().getActualFwdLoopConditions((Integer)objectArray[1], (String)objectArray[2], (short)((Integer)objectArray[3]).intValue());
            }
            if (string.equalsIgnoreCase("getActualCrossConnectedConditions")) {
                return ((XPL2ModuleModel)XPL2ModuleModel.this.getModuleModel()).getEtherEOAMRef().getActualCrossConnectedConditions((Integer)objectArray[1], (String)objectArray[2], (short)((Integer)objectArray[3]).intValue());
            }
            return null;
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }
    }

    private class CardCCTimer
    extends NonCachedValue {
        public CardCCTimer(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        public Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xProvisionError, UserException {
            return XPL2ModuleModel.this.getEtherEOAMRef().getCardCCTimer(XPL2ModuleModel.this.getEntityIndex());
        }

        @Override
        public void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xProvisionError, UserException {
            XPL2ModuleModel.this.getEtherEOAMRef().setCardCCTimer(XPL2ModuleModel.this.getEntityIndex(), (eCCTimer)object);
        }
    }

    private class CardCFMStat
    extends NonCachedValue {
        public CardCFMStat(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        public Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xProvisionError, UserException {
            return new Boolean(XPL2ModuleModel.this.getEtherEOAMRef().getCardCFMStatus(XPL2ModuleModel.this.getEntityIndex()));
        }

        @Override
        public void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xProvisionError, UserException {
            XPL2ModuleModel.this.getEtherEOAMRef().setCardCFMStatus(XPL2ModuleModel.this.getEntityIndex(), (Boolean)object);
        }
    }

    private class CrcInfo
    extends CachedValue {
        public CrcInfo(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xNotSupportedOnEquipment, xWrongEquipmentType {
            if (XPL2ModuleModel.this.neSupportsCrcConfig) {
                XPL2ModuleModel.this.getEtherL2ModuleRef().setCrcInfo(XPL2ModuleModel.this.entityIndex, (sCrcInfo)object);
            }
        }

        @Override
        protected Object getValue() throws xNotSupportedOnEquipment, xWrongEquipmentType, xNoSuchEquipment {
            if (XPL2ModuleModel.this.neSupportsCrcConfig) {
                return XPL2ModuleModel.this.getEtherL2ModuleRef().getCrcInfo(XPL2ModuleModel.this.entityIndex);
            }
            return new sCrcInfo();
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }
    }

    private class DomainProfile
    extends NonCachedValue {
        public DomainProfile(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        protected void setValue(Object object) throws xProvisionError {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            if (string.equalsIgnoreCase("createMaintenanceDomain")) {
                XPL2ModuleModel.this.getEtherEOAMRef().createMaintenanceDomain(XPL2ModuleModel.this.entityIndex, (sMaintenanceDomain)objectArray[1]);
            } else if (string.equalsIgnoreCase("removeMaintenanceDomain")) {
                XPL2ModuleModel.this.getEtherEOAMRef().removeMaintenanceDomain(XPL2ModuleModel.this.entityIndex, (sMaintenanceDomain)objectArray[1]);
            } else if (string.equalsIgnoreCase("attachMAProfile")) {
                XPL2ModuleModel.this.getEtherEOAMRef().attachMAProfile(XPL2ModuleModel.this.entityIndex, (String)objectArray[1], (sMAProfile)objectArray[2]);
            } else if (string.equalsIgnoreCase("detachMAProfile")) {
                XPL2ModuleModel.this.getEtherEOAMRef().detachMAProfile(XPL2ModuleModel.this.entityIndex, (String)objectArray[1], (sMAProfile)objectArray[2]);
            } else if (string.equalsIgnoreCase("detachAllMAProfiles")) {
                XPL2ModuleModel.this.getEtherEOAMRef().detachAllMAProfiles(XPL2ModuleModel.this.entityIndex, (sMaintenanceDomain)objectArray[1]);
            }
        }

        @Override
        protected Object getValue() throws xProvisionError {
            return XPL2ModuleModel.this.getEtherEOAMRef().getAllMaintananceDomain(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class FrpInfo
    extends CachedValue {
        public FrpInfo(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xNotSupportedOnEquipment, xWrongEquipmentType {
            XPL2ModuleModel.this.getEtherL2ModuleRef().setFrpInfo(XPL2ModuleModel.this.entityIndex, (sFrpInfo)object);
        }

        @Override
        protected Object getValue() throws xNotSupportedOnEquipment, xWrongEquipmentType, xNoSuchEquipment {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getFrpInfo(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class LearnedMacInfo
    extends NonCachedValue {
        public LearnedMacInfo(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected Object getValue(Object object) throws xMgetReqInProgress, xMgetReqExpiredTimeout, xMgetReqProtocolError, xWrongParameters, xNotSupportedOnEquipment, xNoSuchEquipment, xBoardBusy {
            Object[] objectArray = (Object[])object;
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getCompressedLearnedMacInfo(XPL2ModuleModel.this.entityIndex, (sVlanRangeInfo[])objectArray[0], (eMultiGetProtocolStates)objectArray[1], (Integer)objectArray[2]);
        }

        @Override
        protected void setValue(Object object) throws xMgetReqInProgress, xNoSuchEquipment, xNotSupportedOnEquipment {
            XPL2ModuleModel.this.getEtherL2ModuleRef().clearLearnedMacInfo(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class MAProfile
    extends NonCachedValue {
        public MAProfile(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xProvisionError {
            Object[] objectArray = (Object[])object;
            return XPL2ModuleModel.this.getEtherEOAMRef().getMAFromDomain((String)objectArray[0], XPL2ModuleModel.this.entityIndex);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            if (string.equalsIgnoreCase("addMAProfile")) {
                XPL2ModuleModel.this.getEtherEOAMRef().addMAProfile(XPL2ModuleModel.this.entityIndex, (sMAProfile)objectArray[1]);
            } else if (string.equalsIgnoreCase("removeMAProfile")) {
                XPL2ModuleModel.this.getEtherEOAMRef().removeMAProfile(XPL2ModuleModel.this.entityIndex, (sMAProfile)objectArray[1]);
            } else if (string.equalsIgnoreCase("modifyMAProfile")) {
                XPL2ModuleModel.this.getEtherEOAMRef().modifyMAProfile(XPL2ModuleModel.this.entityIndex, (sMAProfile)objectArray[1], (sMAProfile)objectArray[2]);
            }
        }

        @Override
        protected Object getValue() throws xProvisionError {
            return XPL2ModuleModel.this.getEtherEOAMRef().getAllMAProfiles(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class MEPConfig
    extends CachedValue {
        public MEPConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2ModuleModel.this.getEtherEOAMRef().getMEPS(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class MIPConfig
    extends CachedValue {
        public MIPConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2ModuleModel.this.getEtherEOAMRef().getMIPS(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class MvrInfo
    extends NonCachedValue {
        public MvrInfo(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xNotSupportedOnEquipment, xWrongEquipmentType {
            XPL2ModuleModel.this.getEtherL2ModuleRef().setMCastInfo(XPL2ModuleModel.this.entityIndex, (sMcastInfo)object);
        }

        @Override
        protected Object getValue() throws xNotSupportedOnEquipment, xWrongEquipmentType, xNoSuchEquipment {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getMCastInfo(XPL2ModuleModel.this.entityIndex);
        }
    }

    class PortComparator
    implements Comparator<IEntityModel> {
        PortComparator() {
        }

        @Override
        public int compare(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            return ComparisonUtil.compare((int)iEntityModel.getEntityIndex(), (int)iEntityModel2.getEntityIndex());
        }
    }

    private class ProtectionOpmode
    extends CachedValue {
        public ProtectionOpmode(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xNotSupportedOnEquipment, xWrongEquipmentType {
            if (XPL2ModuleModel.this.neSupportsCrcConfig) {
                XPL2ModuleModel.this.getEtherL2ModuleRef().setProtOpMode(XPL2ModuleModel.this.entityIndex, (eProtectionInterOPMode)object);
            }
        }

        @Override
        protected Object getValue() throws xNotSupportedOnEquipment, xWrongEquipmentType, xNoSuchEquipment {
            if (XPL2ModuleModel.this.neSupportsCrcConfig) {
                return XPL2ModuleModel.this.getEtherL2ModuleRef().getProtOpMode(XPL2ModuleModel.this.entityIndex);
            }
            return eProtectionInterOPMode.PROT_OP_UNKNOWN;
        }

        public Object outer() {
            return XPL2ModuleModel.this;
        }
    }

    private class RepAdminVlan
    extends NonCachedValue {
        public RepAdminVlan(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xNotSupportedOnEquipment, xWrongEquipmentType, xNoSuchEquipment {
            XPL2ModuleModel.this.getEtherL2ModuleRef().setRepAdminVlan(XPL2ModuleModel.this.entityIndex, (sRepAdminVlan)object);
        }

        @Override
        protected Object getValue() throws xNotSupportedOnEquipment, xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getRepAdminVlan(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class RepL2If
    extends NonCachedValue {
        public RepL2If(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2ModuleModel.this.getEtherL2Ref().getAvialableL2IfForRep(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class RepSegmentAttributesList
    extends NonCachedValue {
        public RepSegmentAttributesList(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected Object getValue() throws xProvisionError, xNoSuchEquipment, xWrongEquipmentType {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getRepSegmentsOnSlot(XPL2ModuleModel.this.entityIndex);
        }
    }

    private class VlanDb
    extends NonCachedValue {
        public VlanDb(String string) {
            super(XPL2ModuleModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, xNoSuchEquipment, xFeatureUnsupported, xWrongEquipmentType {
            XPL2ModuleModel.this.getEtherL2ModuleRef().setVlanDb(XPL2ModuleModel.this.entityIndex, (sVlanFuncItem[])object);
        }

        @Override
        protected Object getValue() throws xFeatureUnsupported, xWrongEquipmentType, xNoSuchEquipment {
            return XPL2ModuleModel.this.getEtherL2ModuleRef().getVlanDb(XPL2ModuleModel.this.entityIndex);
        }
    }
}

