/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.enumeration;

import cerent.cms.idl.Circuits.eCircuitSize;
import cerent.cms.idl.Epos.eCppFailAction;
import cerent.cms.idl.Epos.eCppProtState;
import cerent.cms.idl.EtherMedia.eCardFpgaMode;
import cerent.cms.idl.EtherMedia.eConcatType;
import cerent.cms.idl.EtherMedia.eEncapCrcType;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.eLcasType;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.model.Attribute;
import cerent.cms.model.enumeration.AbstractEnumStrings;
import java.util.TreeMap;

public class EtherEnumStrings
extends AbstractEnumStrings {
    public static int[] ML2_ETHER_SPEED = new int[]{0, 1, 3};
    public static int[] ONE_GIG_ETHER_SPEED = new int[]{0, 1, 2, 3};
    public static int[] ML2_ENCAP_CRC = new int[]{0, 2};
    public static int[] ML2_FLOW_CONTROL = new int[]{1, 2, 0, 3};
    public static int[] ML2_GIGE_FLOW_CONTROL = new int[]{0, 4, 3};
    public static int[] POS_FRAMING_NO_X86 = new int[]{0, 1};
    public static int[] POS_FRAMING_MIN = new int[]{0, 1};
    public static int[] CONCAT_TYPE = new int[]{1, 2};
    public static int[] VCAT_MODE = new int[]{1, 2, 3};
    public static int[] ADM_POS_FRAMING = new int[]{0, 1};
    public static int[] ADM_POS_CRC_GFP = new int[]{0, 2};
    public static int[] ADM_POS_CRC_LEX = new int[]{1, 2};
    public static int[] ADM_POS_CRC = new int[]{0, 1, 2};

    private static void createMap(Class clazz) {
        if (clazz == eEncapCrcType.class) {
            EtherEnumStrings.getEncapCrcType(clazz);
        } else if (clazz == ePosFramingType.class) {
            EtherEnumStrings.getPosFramingType(clazz);
        } else if (clazz == eEtherDuplex.class) {
            EtherEnumStrings.getEtherDuplex(clazz);
        } else if (clazz == eEtherSpeed.class) {
            EtherEnumStrings.getEtherSpeed(clazz);
        } else if (clazz == eFlowControlNegotiated.class) {
            EtherEnumStrings.getFlowControlNegotiated(clazz);
        } else if (clazz == eCardFpgaMode.class) {
            EtherEnumStrings.getFpgaMode(clazz);
        } else if (clazz == eCircuitSize.class) {
            EtherEnumStrings.getCircuitSize(clazz);
        } else if (clazz == eConcatType.class) {
            EtherEnumStrings.getConcatType(clazz);
        } else if (clazz == eLcasType.class) {
            EtherEnumStrings.getVcatMode(clazz);
        } else if (clazz == eCppProtState.class) {
            EtherEnumStrings.getCppProtectState(clazz);
        } else if (clazz == eCppFailAction.class) {
            EtherEnumStrings.getFailAction(eCppFailAction.class);
        }
    }

    private static void getEncapCrcType(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "none");
        EtherEnumStrings.putAttribute(treeMap, 1, "16-Bit");
        EtherEnumStrings.putAttribute(treeMap, 2, "32-Bit");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getPosFramingType(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "GFP-F");
        EtherEnumStrings.putAttribute(treeMap, 1, "HDLC");
        EtherEnumStrings.putAttribute(treeMap, 2, "X.86");
        EtherEnumStrings.putAttribute(treeMap, 3, "GFP-NOCRC");
        EtherEnumStrings.putAttribute(treeMap, 4, "802.17 RPR");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getEtherDuplex(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "Full");
        EtherEnumStrings.putAttribute(treeMap, 1, "Half");
        EtherEnumStrings.putAttribute(treeMap, 2, "Auto");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getEtherSpeed(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "10 Mbps");
        EtherEnumStrings.putAttribute(treeMap, 1, "100 Mbps");
        EtherEnumStrings.putAttribute(treeMap, 2, "1000 Mbps");
        EtherEnumStrings.putAttribute(treeMap, 3, "Auto");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getFlowControlNegotiated(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 1, "Asymmetric");
        EtherEnumStrings.putAttribute(treeMap, 2, "Asymmetric Local");
        EtherEnumStrings.putAttribute(treeMap, 0, "None");
        EtherEnumStrings.putAttribute(treeMap, 4, "Pass Through");
        EtherEnumStrings.putAttribute(treeMap, 3, "Symmetric");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getFpgaMode(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 1, "HDLC");
        EtherEnumStrings.putAttribute(treeMap, 2, "GFP-F");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getCircuitSize(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "VT_1.5");
        EtherEnumStrings.putAttribute(treeMap, 30, "VT_2");
        EtherEnumStrings.putAttribute(treeMap, 1, "STS_1");
        EtherEnumStrings.putAttribute(treeMap, 2, "STS_3c");
        EtherEnumStrings.putAttribute(treeMap, 3, "STS_6c");
        EtherEnumStrings.putAttribute(treeMap, 7, "STS_9c");
        EtherEnumStrings.putAttribute(treeMap, 4, "STS_12c");
        EtherEnumStrings.putAttribute(treeMap, 27, "STS_18c");
        EtherEnumStrings.putAttribute(treeMap, 8, "STS_24c");
        EtherEnumStrings.putAttribute(treeMap, 25, "STS_36c");
        EtherEnumStrings.putAttribute(treeMap, 5, "STS_48c");
        EtherEnumStrings.putAttribute(treeMap, 32, "STS_96c");
        EtherEnumStrings.putAttribute(treeMap, 6, "STS_192c");
        EtherEnumStrings.putAttribute(treeMap, 9, "VC_11");
        EtherEnumStrings.putAttribute(treeMap, 10, "VC_12");
        EtherEnumStrings.putAttribute(treeMap, 11, "VC_3");
        EtherEnumStrings.putAttribute(treeMap, 12, "VC_4");
        EtherEnumStrings.putAttribute(treeMap, 13, "VC_4_2c");
        EtherEnumStrings.putAttribute(treeMap, 14, "VC_4_3c");
        EtherEnumStrings.putAttribute(treeMap, 15, "VC_4_4c");
        EtherEnumStrings.putAttribute(treeMap, 28, "VC_4_6c");
        EtherEnumStrings.putAttribute(treeMap, 16, "VC_4_8c");
        EtherEnumStrings.putAttribute(treeMap, 26, "VC_4_12c");
        EtherEnumStrings.putAttribute(treeMap, 17, "VC_4_16c");
        EtherEnumStrings.putAttribute(treeMap, 33, "VC_4_32c");
        EtherEnumStrings.putAttribute(treeMap, 18, "VC_4_64c");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getConcatType(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 1, "CCAT");
        EtherEnumStrings.putAttribute(treeMap, 2, "VCAT");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getVcatMode(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 1, "NON_LCAS");
        EtherEnumStrings.putAttribute(treeMap, 3, "SW_LCAS");
        EtherEnumStrings.putAttribute(treeMap, 2, "LCAS");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getCppProtectState(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 0, "ACTIVE");
        EtherEnumStrings.putAttribute(treeMap, 1, "STANDBY");
        EtherEnumStrings.putAttribute(treeMap, 2, "DOWN");
        EtherEnumStrings.putAttribute(treeMap, 3, "UNPROTECTED");
        attributeMap.put(clazz.getName(), treeMap);
    }

    private static void getFailAction(Class clazz) {
        TreeMap treeMap = new TreeMap();
        EtherEnumStrings.putAttribute(treeMap, 1, "GROUP SWITCH");
        EtherEnumStrings.putAttribute(treeMap, 0, "PORT SWITCH");
        attributeMap.put(clazz.getName(), treeMap);
    }

    public static Attribute[] get(Class clazz) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getAttributeArray(clazz);
    }

    public static Attribute[] get(Class clazz, int[] nArray) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getFilteredAttributeArray(clazz, nArray);
    }

    public static Attribute[] get(Class clazz, int[] nArray, boolean bl) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getFilteredAttributeArray(clazz, nArray, bl);
    }

    public static Attribute get(Class clazz, int n) {
        if (!attributeMap.containsKey(clazz.getName())) {
            EtherEnumStrings.createMap(clazz);
        }
        return EtherEnumStrings.getAttribute(clazz, n);
    }

    public static String getString(Class clazz, int n) {
        return EtherEnumStrings.get(clazz, n).getKey();
    }
}

