/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.idl.Common.eReversionMode;
import cerent.cms.idl.Node.Defaults;
import cerent.cms.idl.Node.xNoSuchDefault;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.nedefaults.DefaultsElement;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.SDebug;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.UserException;

public class ClientDefaultsCachedValues
extends NonCachedValue {
    private Map defaultValueCache = new HashMap();
    private NodeModelDelegate nmd;
    private SDebug db;

    ClientDefaultsCachedValues(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        super(nodeModelDelegate);
        this.nmd = nodeModelDelegate;
        this.db = sDebug;
    }

    @Override
    protected void setValue(Object object) throws UserException {
        Object[] objectArray = (Object[])object;
        this.getNodeDefaultsRef().setClientDefault((String)objectArray[0], (String)objectArray[1]);
    }

    @Override
    protected Object getValue(Object object) throws xNoSuchDefault, xProvisionError {
        return this.getNodeDefaultsRef().getClientDefault((String)object);
    }

    private String cache(String string, String string2) {
        if (this.defaultValueCache == null) {
            this.defaultValueCache = new HashMap();
        }
        this.defaultValueCache.put(string, string2);
        return string2;
    }

    private String helpGetInitialClientDefaultValue(String string, String string2) throws NoSuchDefault {
        String string3;
        block3: {
            string3 = "-1";
            DefaultsElement defaultsElement = this.nmd.getDefaultsManager().getElement(string, string2);
            try {
                if (defaultsElement != null && defaultsElement.isDisplacedProperty()) {
                    this.db.info("helpGetInitialClientDefaultValue(): " + defaultsElement.getFullName() + " result is >>" + defaultsElement.getValue() + "<<");
                    string3 = defaultsElement.isNumericallyEnumerated() ? Integer.toString(defaultsElement.getEnumValue()) : defaultsElement.getValue();
                    break block3;
                }
                this.db.severe("helpGetInitialClientDefaultValue(): no such client default: " + string2);
                throw new NoSuchDefault();
            }
            catch (Exception exception) {
                this.db.severe("helpGetInitialClientDefaultValue(): unexpected exception " + string2 + " " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        return string3;
    }

    private String getInitialClientDefaultValue(String string) throws NoSuchDefault {
        String string2 = "-1";
        try {
            string2 = this.helpGetInitialClientDefaultValue("CTC", string);
        }
        catch (NoSuchDefault noSuchDefault) {
            this.db.info("getInitialClientDefaultValue(): trying node defaults on " + string);
            string2 = this.helpGetInitialClientDefaultValue("NodeDefaults", string);
        }
        return string2;
    }

    private String getClientDefaultValue(String string) throws NoSuchDefault {
        this.db.info("getClientDefaultValue(): " + string);
        String string2 = "";
        try {
            string2 = this.getNonCached(string);
            this.db.info("getClientDefaultValue(): " + string + " is a cached client default");
        }
        catch (NoSuchDefault noSuchDefault) {
            this.db.info("getClientDefaultValue(): no NE override: " + noSuchDefault.toString());
            try {
                string2 = this.getInitialClientDefaultValue(string);
                this.db.info("getClientDefaultValue(): " + string + " is a non-cached client default");
            }
            catch (NoSuchDefault noSuchDefault2) {
                this.db.severe("getClientDefaultValue() initial ctcNsd: " + noSuchDefault2.toString());
                throw noSuchDefault2;
            }
            catch (Exception exception) {
                this.db.severe("getClientDefaultValue(): unexpected exception " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        catch (Exception exception) {
            this.db.severe("getClientDefaultValue(): unexpected exception " + string2 + " " + exception.toString() + " using preferences");
            throw new NoSuchDefault();
        }
        this.cache(string, string2);
        return string2;
    }

    private String getNodeDefaultValue(String string) throws NoSuchDefault {
        String string2;
        block27: {
            string2 = "-1";
            try {
                NeDefaultsModel neDefaultsModel = this.nmd.getNeDefaultsModel();
                if (string.equals("NODE.circuits.upsr.AllowUpsrOverOnePlusOne") || string.equals("NODE.circuits.sncp.AllowSncpOverOnePlusOne")) {
                    string2 = this.cache(string, "" + neDefaultsModel.allowUpsrOverOnePlusOne());
                    break block27;
                }
                if (string.equals("NODE.circuits.SendPDIP")) {
                    string2 = "" + this.nmd.getSendPDIP();
                    break block27;
                }
                if (string.equals("NODE.circuits.State")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefaultCircuitAdminState().value());
                    break block27;
                }
                if (string.equals("NODE.circuits.upsr.STS_SFBER")) {
                    string2 = "" + this.nmd.getUpsrSfBerLevel(2);
                    break block27;
                }
                if (string.equals("NODE.circuits.upsr.STS_SDBER")) {
                    string2 = "" + this.nmd.getUpsrSdBerLevel(2);
                    break block27;
                }
                if (string.equals("NODE.circuits.upsr.VT_SFBER")) {
                    string2 = "" + this.nmd.getUpsrSfBerLevel(1);
                    break block27;
                }
                if (string.equals("NODE.circuits.upsr.VT_SDBER")) {
                    string2 = "" + this.nmd.getUpsrSdBerLevel(1);
                    break block27;
                }
                if (string.equals("NODE.circuits.upsr.Revertive")) {
                    string2 = "" + this.nmd.getUpsrReversion().getReversionMode();
                    break block27;
                }
                if (string.equals("NODE.circuits.upsr.ReversionTime")) {
                    string2 = "" + this.nmd.getUpsrReversion().getReversionTime();
                    break block27;
                }
                if (string.equals("NODE.circuits.upsr.SwitchOnPDIP")) {
                    string2 = "" + this.nmd.getUpsrSwitchOnPdip();
                    break block27;
                }
                if (string.equals("NODE.protection.1+1.BidirectionalSwitching")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefOnePlusOneBidir());
                    break block27;
                }
                if (string.equals("NODE.protection.1+1.Revertive")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefOnePlusOneRev().reversionMode.equals(eReversionMode.REVERTIVE_BEHAVIOR));
                    break block27;
                }
                if (string.equals("NODE.protection.1+1.ReversionTime")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefOnePlusOneRev().reversionTime);
                    break block27;
                }
                if (string.equals("NODE.protection.1+1.RecoveryGuardTimer")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefRecoveryGuardTimer().value());
                    break block27;
                }
                if (string.equals("NODE.protection.1+1.VerifyGuardTimer")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefVerifyGuardTimer().value());
                    break block27;
                }
                if (string.equals("NODE.protection.1+1.DetectionGuardTimer")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefDetectionGuardTimer().value());
                    break block27;
                }
                if (string.equals("NODE.protection.blsr.RingRevertive")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefBlsrRingRev().reversionMode.equals(eReversionMode.REVERTIVE_BEHAVIOR));
                    break block27;
                }
                if (string.equals("NODE.protection.blsr.RingReversionTime")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefBlsrRingRev().reversionTime);
                    break block27;
                }
                if (string.equals("NODE.protection.blsr.SpanRevertive")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefBlsrSpanRev().reversionMode.equals(eReversionMode.REVERTIVE_BEHAVIOR));
                    break block27;
                }
                if (string.equals("NODE.protection.blsr.SpanReversionTime")) {
                    string2 = "" + neDefaultsModel.getDefBlsrSpanRev().reversionTime;
                    break block27;
                }
                if (string.equals("NODE.protection.ycable.BidirectionalSwitching")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefYCableBidir());
                    break block27;
                }
                if (string.equals("NODE.protection.ycable.Revertive")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefYCableRev().reversionMode.equals(eReversionMode.REVERTIVE_BEHAVIOR));
                    break block27;
                }
                if (string.equals("NODE.protection.ycable.ReversionTime")) {
                    string2 = this.cache(string, "" + neDefaultsModel.getDefYCableRev().reversionTime);
                    break block27;
                }
                this.db.info(string + " is not a legacy node default");
                throw new NoSuchDefault();
            }
            catch (NoSuchDefault noSuchDefault) {
                throw noSuchDefault;
            }
            catch (Exception exception) {
                if (this.db.isInfoEnabled()) {
                    this.db.info("getNodeDefaultValue(): " + exception.toString());
                    SDebug.printStackTrace((Throwable)exception);
                }
                throw new NoSuchDefault();
            }
        }
        this.db.info("getNodeDefaultValue(): returning " + string2 + " for " + string);
        return string2;
    }

    private Defaults getNodeDefaultsRef() {
        return this.nmd.getIorRepository().getNodeDefaultsRef();
    }

    protected synchronized String get(String string) throws NoSuchDefault {
        this.db.info("getDefaultValue(): " + string);
        String string2 = null;
        if (this.defaultValueCache != null) {
            string2 = (String)this.defaultValueCache.get(string);
        }
        this.db.info("get(): value from cache " + string2);
        if (string2 == null) {
            string2 = "";
            try {
                string2 = this.getNodeDefaultValue(string);
                this.db.info("get(): value from node defaults " + string2);
            }
            catch (NoSuchDefault noSuchDefault) {
                string2 = this.getClientDefaultValue(string);
                this.db.info("get(): value from client defaults " + string2);
            }
        }
        this.db.info("get(): final value " + string2);
        return string2;
    }

    protected String getNonCached(String string) throws NoSuchDefault, EMCProvisionError {
        try {
            return (String)super.get(string);
        }
        catch (xNoSuchDefault xNoSuchDefault2) {
            throw new NoSuchDefault();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, string, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            this.db.severe("getNonCached(): What happened here? " + (Object)((Object)userException));
            throw new NoSuchDefault();
        }
    }

    protected synchronized void clear() {
        if (this.defaultValueCache != null) {
            this.db.fine("clearing default values cache");
            this.defaultValueCache.clear();
        }
    }

    @Override
    public synchronized void set(Object object) throws UserException {
        super.set(object);
        this.clear();
    }
}

