/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eReversionMode;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Ds123Media.eClockSource;
import cerent.cms.idl.Ds123Media.eDs1Mapping;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eClientOpticsVariant;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.eDwdmLineType;
import cerent.cms.idl.Dwdm.eDwdmOduTransparency;
import cerent.cms.idl.Dwdm.eDwdmOverClock;
import cerent.cms.idl.Dwdm.eDwdmPathMonitoring;
import cerent.cms.idl.Dwdm.eDwdmProactiveProtection;
import cerent.cms.idl.Dwdm.eMappingType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.eRevertThreshold;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.eTriggerThreshold;
import cerent.cms.idl.Dwdm.eTrunkOpticsVariant;
import cerent.cms.idl.Dwdm.s8B10BPmThresholds;
import cerent.cms.idl.Dwdm.sFECPmThresholds;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sOTNThresholds;
import cerent.cms.idl.Dwdm.sProactiveProtectionConfig;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.ePortToVtMappingMode;
import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherMedia.eBucketSize;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sCE1000EtherLineAdminInfo;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.EtherMedia.sML2MapperEtherLineAdminInfo;
import cerent.cms.idl.EtherMedia.sML2PosPortAdminInfo;
import cerent.cms.idl.FCMedia.eFCMediaType;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.Lmp.eWdmRoleType;
import cerent.cms.idl.Lmp.sProductConfigAttrs;
import cerent.cms.idl.Node.eChassisVoltageType;
import cerent.cms.idl.Node.sPwrMonVoltage;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Optics.eWvlDriftMode;
import cerent.cms.idl.Security.eAccessMechanism;
import cerent.cms.idl.Security.eSerialPortId;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.idl.SonetMedia.sPhysicalThresholds;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.idl.SonetMedia.sVtThresholds;
import cerent.cms.idl.SonetTopology.eDetectionGuardTimer;
import cerent.cms.idl.SonetTopology.eRecoveryGuardTimer;
import cerent.cms.idl.SonetTopology.eVerifyGuardTimer;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsFacility;
import cerent.cms.idl.Synchronization.eBitsLBO;
import cerent.cms.idl.Synchronization.eCableType;
import cerent.cms.idl.Synchronization.eResQualityLevel;
import cerent.cms.idl.Synchronization.eSsmGen;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.eTimingSystem;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.idl.Synchronization.sSyncConfig;
import cerent.cms.model.AccessMechanism;
import cerent.cms.model.AccessState;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.CtcTimeZoneFactory;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.LcdIpSetting;
import cerent.cms.model.LmpModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.ProxyXlator;
import cerent.cms.model.RadiusServer;
import cerent.cms.model.RadiusServerModel;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.nedefaults.DefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.cms.model.nedefaults.IDefaultsValue;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.AbstractHoNum;
import cerent.util.InetUtil;
import cerent.util.NetworkMapUtil;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultsTree {
    private NodeModelDelegate nmd;
    private SDebug db;
    private String password = null;
    private NeDefaultsModel neDefaultsModel;
    private Map pendingApplications;
    private String cardName;
    private final Map eqTypeNameTypeMap;
    private final Map eqTypeTypeNameMap;
    private Map<String, eReach> reachMap;
    private String errorStr = null;
    private static final String[] SECURITY_LEVELS = new String[]{"Retrieve", "Maintenance", "Provisioning", "Superuser"};
    private static final String[] RECOVERY_GUARD_TIMERS = new String[]{"0", "0.05", "0.1", "0.5", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static final String[] VERIFY_GUARD_TIMERS = new String[]{"0.5", "1"};
    private static final String[] DETECTION_GUARD_TIMERS = new String[]{"0", "0.05", "0.1", "0.5", "1", "2", "3", "4", "5"};
    private static final short DSN_STS_SIZE = 1;
    private static final double SCALE_FACTOR = -1000.0;
    public static final String NOT_SUPPORTED = "(NOT SUPPORTED)";

    public DefaultsTree(NodeModelDelegate nodeModelDelegate, HashMap hashMap, HashMap hashMap2) {
        this.nmd = nodeModelDelegate;
        this.eqTypeNameTypeMap = hashMap;
        this.eqTypeTypeNameMap = hashMap2;
        this.reachMap = null;
    }

    public void init() {
        this.db = this.nmd.getDefaultsManager().getDebug().getChildDebug("WalkTree");
        this.neDefaultsModel = this.nmd.getNeDefaultsModel();
        if (this.db.isInfoEnabled()) {
            this.db.info("Effective NeDefaultsModel class is " + this.neDefaultsModel.getClass().getName() + " from " + this.nmd.getClass().getName());
        }
        this.pendingApplications = new HashMap();
    }

    public void dispose() {
        if (this.pendingApplications != null) {
            this.pendingApplications.clear();
            this.pendingApplications = null;
        }
        this.neDefaultsModel = null;
        if (this.db != null) {
            this.db.dispose();
            this.db = null;
        }
    }

    public NeDefaultsModel getNeDefaultsModel() {
        return this.neDefaultsModel;
    }

    private int findIndex(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private boolean isSameName(String string, String string2) {
        int n = 0;
        int n2 = 0;
        n2 = string2.indexOf(".");
        if (n2 == -1) {
            n2 = string2.length() - 1;
        }
        return string.startsWith(string2.substring(n, n2));
    }

    private String trimParentName(String string) {
        if (string.length() != 0) {
            return string.substring(string.indexOf(".") + 1, string.length());
        }
        return "";
    }

    public String getErrorString() {
        return this.errorStr;
    }

    private String[] getHoursMins(String string) {
        String[] stringArray = new String[2];
        if (string == null || string == "") {
            this.db.severe("firstlevel:anystring was null or empty");
            stringArray[0] = null;
            stringArray[1] = null;
        } else {
            int n = string.indexOf(":");
            if (n < 0) {
                if (this.db.isFineEnabled()) {
                    this.db.fine("firstlevel:Hit End of Line....str = " + string);
                }
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
                if (this.db.isFineEnabled()) {
                    this.db.fine("firstlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
                }
            }
        }
        return stringArray;
    }

    private String[] getMinsSecs(String string) {
        return this.getHoursMins(string);
    }

    private boolean stringToBool(String string) {
        return string.equals("TRUE");
    }

    private String boolToString(boolean bl) {
        String string = "FALSE";
        if (bl) {
            string = "TRUE";
        }
        return string;
    }

    private short stringToSoakTime(String string) {
        String[] stringArray = this.getHoursMins(string);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        short s = (short)(n * 4 + n2 / 15);
        return s;
    }

    private String soakTimeToString(short s) {
        int n = s / 4;
        int n2 = s % 4 * 15;
        String string = "";
        String string2 = "";
        string = n < 10 ? "0" + String.valueOf(n) : String.valueOf(n);
        string2 = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        String string3 = string + ":" + string2;
        return string3;
    }

    private String lockoutDurationToString(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = "";
        String string2 = "";
        String string3 = "";
        if (n2 < 10) {
            string3 = "0";
        }
        string = string3 + String.valueOf(n2);
        string3 = "";
        if (n3 < 10) {
            string3 = "0";
        }
        string2 = string3 + String.valueOf(n3);
        return string + ":" + string2;
    }

    private int stringToLockoutDuration(String string) {
        String[] stringArray = this.getMinsSecs(string);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        return n * 60 + n2;
    }

    private int stringToIdleUserTimeout(String string) {
        String[] stringArray = this.getHoursMins(string);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = n * 60 + n2;
        return n3;
    }

    private String idleUserTimeoutToString(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = "";
        String string2 = "";
        string = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        string2 = n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3);
        String string3 = string + ":" + string2;
        return string3;
    }

    private void makeClean(IDefaultsNode[] iDefaultsNodeArray) {
        if (iDefaultsNodeArray != null) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                if (!(iDefaultsNodeArray[i] instanceof IDefaultsElement)) continue;
                ((IDefaultsElement)iDefaultsNodeArray[i]).makeClean();
            }
        }
    }

    private void handleLineSyncConfig(eEqType eEqType2, eEqType eEqType3, eTimingSystem eTimingSystem2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (iDefaultsNodeArray != null && iDefaultsNodeArray.length > 0) {
            if (this.db.isFineEnabled()) {
                this.db.fine("handleLineSyncConfig(): with " + iDefaultsNodeArray.length);
            }
            boolean bl2 = false;
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string2 = iDefaultsNodeArray[i].getName();
                if (string.length() != 0 && !this.isSameName(string2, string)) continue;
                this.db.fine("handleLineSyncConfig(): " + string2);
                if (string2.equalsIgnoreCase("sonet") || string2.equalsIgnoreCase("sdh")) {
                    this.handleLineSyncConfig(eEqType2, eEqType3, string2.equalsIgnoreCase("sonet") ? eTimingSystem.SONET_TIMING : eTimingSystem.SDH_TIMING, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (this.nmd.getPlatform().is600() || this.nmd.getPlatform().is600SDH()) {
                    eTimingSystem2 = eTimingSystem.SONET_TIMING;
                }
                sLineSyncConfig sLineSyncConfig2 = this.neDefaultsModel.getDefLineSyncConfig(eEqType2, eEqType3, eTimingSystem2);
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string3 = iDefaultsElement.getValue();
                if (this.db.isFineEnabled()) {
                    this.db.fine("handleLineSyncConfig: processing " + string2);
                }
                bl2 |= iDefaultsElement.isDirty();
                if (string2.equals("SyncMsgIn")) {
                    if (bl) {
                        sLineSyncConfig2.syncMessageIn = iDefaultsElement.getEnumValue() == 1;
                    } else {
                        iDefaultsElement.initEnumValue(sLineSyncConfig2.syncMessageIn ? 1 : 0);
                    }
                } else if (string2.equals("SendDoNotUse")) {
                    if (bl) {
                        sLineSyncConfig2.sendDoNotUse = this.stringToBool(string3);
                    } else {
                        iDefaultsElement.initValue(this.boolToString(sLineSyncConfig2.sendDoNotUse));
                    }
                } else if (string2.equals("AdminSSMIn")) {
                    if (bl) {
                        sLineSyncConfig2.adminSSM = this.getQualityLevel(string3);
                    } else {
                        iDefaultsElement.initEnumPass1();
                        iDefaultsElement.initValue(this.getStringFromQualityLevel(sLineSyncConfig2.adminSSM));
                    }
                } else if (string2.equals("Send<FF>DoNotUse")) {
                    if (bl) {
                        sLineSyncConfig2.sendDoNotUseFF = this.stringToBool(string3);
                    } else {
                        iDefaultsElement.initEnumValue(sLineSyncConfig2.sendDoNotUseFF ? 1 : 0);
                    }
                } else {
                    this.db.severe("handleLineSyncConfig: unknown name: " + string2);
                }
                if (!bl || !bl2) continue;
                this.neDefaultsModel.setDefLineSyncConfig(eEqType2, eEqType3, eTimingSystem2, sLineSyncConfig2);
                this.makeClean(iDefaultsNodeArray);
            }
        } else if (this.db.isInfoEnabled()) {
            this.db.info("No line sync config on " + this.getNameFromEqType(eEqType2) + " " + this.getNameFromEqType(eEqType3));
        }
    }

    private void setDsnConfigToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sConfig sConfig2 = this.neDefaultsModel.getDefConfig(eEqType2, eEqType3);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("LineType")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.lineType = eLineType.from_int(iDefaultsElement.getEnumValue());
                continue;
            }
            if (string.equals("LineCoding")) {
                bl |= iDefaultsElement.isDirty();
                if (string2.equals("B8ZS")) {
                    sConfig2.lineCoding = eLineCoding.B8ZS;
                    continue;
                }
                if (string2.equals("AMI")) {
                    sConfig2.lineCoding = eLineCoding.AMI;
                    continue;
                }
                if (string2.equals("HDB3")) {
                    sConfig2.lineCoding = eLineCoding.HDB3;
                    continue;
                }
                sConfig2.lineCoding = eLineCoding.B3ZS;
                continue;
            }
            if (string.equals("LineLength")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.lineLength = iDefaultsElement.getEnumValue();
                continue;
            }
            if (string.equals("FdlMode")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.fdlModeMask = iDefaultsElement.getEnumValue();
                continue;
            }
            this.db.severe("setDsnConfigToNodeValues: Unknown config value " + string);
        }
        if (bl) {
            this.neDefaultsModel.setDefConfig(eEqType2, eEqType3, sConfig2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private sLineThresholds helpSetLinePmToNodeVals(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sLineThresholds sLineThresholds2 = new sLineThresholds(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sLineThresholds2.cv = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sLineThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sLineThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sLineThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sLineThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC")) {
                sLineThresholds2.psc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD")) {
                sLineThresholds2.psd = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC-W")) {
                sLineThresholds2.pscw = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD-W")) {
                sLineThresholds2.psdw = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC-S")) {
                sLineThresholds2.pscs = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD-S")) {
                sLineThresholds2.psds = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSC-R")) {
                sLineThresholds2.pscr = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PSD-R")) {
                sLineThresholds2.psdr = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sLineThresholds2.bbe = n;
                continue;
            }
            this.db.severe("helpSetLinePmToNodeVals: Unknown line pm parm " + iDefaultsElement.getName());
        }
        if (!bl) {
            sLineThresholds2 = null;
        }
        return sLineThresholds2;
    }

    private void setLinePmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.helpSetLinePmToNodeVals(iDefaultsNodeArray);
        if (sLineThresholds2 != null) {
            this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, bl, eIntervalType2, sLineThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setLinePmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.helpSetLinePmToNodeVals(iDefaultsNodeArray);
        if (sLineThresholds2 != null) {
            this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2, sLineThresholds2);
        }
    }

    private void setLinePmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.helpSetLinePmToNodeVals(iDefaultsNodeArray);
        if (sLineThresholds2 != null) {
            this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2, sLineThresholds2);
        }
    }

    private void setLinePmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        sLineThresholds sLineThresholds2 = this.helpSetLinePmToNodeVals(iDefaultsNodeArray);
        if (sLineThresholds2 != null) {
            if (bl2) {
                this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, bl, eIntervalType2, sLineThresholds2);
            } else {
                this.neDefaultsModel.setDefLineThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2, sLineThresholds2);
            }
        }
    }

    private sSectionThresholds helpSetSectionPmToNodeVals(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sSectionThresholds sSectionThresholds2 = new sSectionThresholds(0, 0, 0, 0, 0, 0);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getValue();
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sSectionThresholds2.cv = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sSectionThresholds2.es = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sSectionThresholds2.ses = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("SEFS") || iDefaultsElement.getName().equals("OFS")) {
                sSectionThresholds2.sefs = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sSectionThresholds2.uas = Integer.parseInt(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sSectionThresholds2.bbe = Integer.parseInt(string);
                continue;
            }
            this.db.severe("setSectionPmToNodeVals: Unknown line pm parm " + iDefaultsElement.getName());
        }
        if (!bl) {
            sSectionThresholds2 = null;
        }
        return sSectionThresholds2;
    }

    private void setSectionPmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.helpSetSectionPmToNodeVals(iDefaultsNodeArray);
        if (sSectionThresholds2 != null) {
            this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, bl, eIntervalType2, sSectionThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setSectionPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.helpSetSectionPmToNodeVals(iDefaultsNodeArray);
        if (sSectionThresholds2 != null) {
            this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2, sSectionThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setSectionPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.helpSetSectionPmToNodeVals(iDefaultsNodeArray);
        if (sSectionThresholds2 != null) {
            this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2, sSectionThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setSectionPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.helpSetSectionPmToNodeVals(iDefaultsNodeArray);
        if (sSectionThresholds2 != null) {
            if (bl2) {
                this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, bl, eIntervalType2, sSectionThresholds2);
            } else {
                this.neDefaultsModel.setDefSectionThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2, sSectionThresholds2);
            }
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void set8B10BPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, eIntervalType eIntervalType2) throws Exception {
        s8B10BPmThresholds s8B10BPmThresholds2 = new s8B10BPmThresholds(0L, 0L, 0L, 0L, 0L, 0L);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getValue();
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("validPackets")) {
                s8B10BPmThresholds2.validPkts = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("invalidPackets")) {
                s8B10BPmThresholds2.invalidPkts = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("codeGroupViolations")) {
                s8B10BPmThresholds2.codeViol = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("idleOrderedSets")) {
                s8B10BPmThresholds2.idleSets = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("nonIdleOrderedSets")) {
                s8B10BPmThresholds2.nonIdleSets = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("dataCodeGroups")) {
                s8B10BPmThresholds2.dataSets = Long.parseLong(string);
                continue;
            }
            this.db.severe("set8B10BPmToNodeVals: Unknown line pm parm " + iDefaultsElement.getName());
        }
        if (bl) {
            this.neDefaultsModel.setDef8B10BPmThr(eEqType2, eEqType3, eDataRate2, eIntervalType2, s8B10BPmThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setVtPathPmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sVtThresholds sVtThresholds2 = new sVtThresholds(0, 0, 0, 0, 0, 0);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl2 |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sVtThresholds2.cv = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sVtThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sVtThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sVtThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sVtThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sVtThresholds2.bbe = n;
                continue;
            }
            this.db.severe("setVtPathPmToNodeVals: Unknown vt pm parm " + iDefaultsElement.getName());
        }
        if (bl2) {
            this.neDefaultsModel.setDefVtThr(eEqType2, eEqType3, bl, eIntervalType2, sVtThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setStsPathPmToNodeVals(eEqType eEqType2, eEqType eEqType3, short s, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sPathThresholds sPathThresholds2 = new sPathThresholds(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (this.db.isFineEnabled()) {
                this.db.fine("setStsPathPmToNodeVals() " + iDefaultsNodeArray[i].getFullName());
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl2 |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                sPathThresholds2.cv = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("ES")) {
                sPathThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sPathThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sPathThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sPathThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sPathThresholds2.bbe = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PPJC-PDET")) {
                sPathThresholds2.pjpIn = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PPJC-PGEN")) {
                sPathThresholds2.pjpOut = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("NPJC-PDET")) {
                sPathThresholds2.pjnIn = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("NPJC-PGEN")) {
                sPathThresholds2.pjnOut = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PJCDIFF")) {
                sPathThresholds2.pjDiff = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PJCS-PGEN")) {
                sPathThresholds2.pjOutSec = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("PJCS-PDET")) {
                sPathThresholds2.pjInSec = n;
                continue;
            }
            this.db.severe("setStsPathPmToNodeVals: Unknown sts pm parm " + iDefaultsElement.getName());
        }
        if (bl2) {
            this.neDefaultsModel.setDefPathThrCmn(eEqType2, eEqType3, s, bl, eIntervalType2, sPathThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setOtnPmToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws Exception {
        sOTNThresholds sOTNThresholds2 = new sOTNThresholds(0, 0, 0, 0, 0);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            int n = Integer.parseInt(iDefaultsElement.getValue());
            bl2 |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("ES")) {
                sOTNThresholds2.es = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("SES")) {
                sOTNThresholds2.ses = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("UAS")) {
                sOTNThresholds2.uas = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("FC")) {
                sOTNThresholds2.fc = n;
                continue;
            }
            if (iDefaultsElement.getName().equals("BBE")) {
                sOTNThresholds2.bbe = n;
                continue;
            }
            this.db.severe("setOtnPmToNodeVals: Unknown otn pm parm " + iDefaultsElement.getName() + " " + iDefaultsElement.getValue());
        }
        if (bl2) {
            this.neDefaultsModel.setDefOtnThr(eEqType2, eEqType3, bl, eIntervalType2, eMonitorType2, sOTNThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setFecPmToNodeVals(eEqType eEqType2, eEqType eEqType3, eIntervalType eIntervalType2, eDwdmFecMode eDwdmFecMode2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sFECPmThresholds sFECPmThresholds2 = new sFECPmThresholds(0L, 0L, 0L, 0L, 0L);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getValue();
            bl |= iDefaultsElement.isDirty();
            if (iDefaultsElement.getName().equals("BitErrorsCorrected")) {
                sFECPmThresholds2.bitErrCor = Long.parseLong(string);
                continue;
            }
            if (iDefaultsElement.getName().equals("UncorrectableWords")) {
                sFECPmThresholds2.uncorWords = Long.parseLong(string);
                continue;
            }
            this.db.severe("setFecPmToNodeVals: Unknown fec pm parm " + iDefaultsElement.getName());
        }
        if (bl) {
            this.neDefaultsModel.setDefFecThr(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2, sFECPmThresholds2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private sLaserThresholds helpSetOpticalThresholdsToNodeVals(IDefaultsNode[] iDefaultsNodeArray, sLaserThresholds sLaserThresholds2) throws Exception {
        return this.helpSetOpticalThresholdsToNodeVals(iDefaultsNodeArray, sLaserThresholds2, 400.0);
    }

    private sLaserThresholds helpSetOpticalThresholdsToNodeVals(IDefaultsNode[] iDefaultsNodeArray, sLaserThresholds sLaserThresholds2, double d) throws Exception {
        sLaserThresholds sLaserThresholds3 = sLaserThresholds2;
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            float f = Float.parseFloat(string2);
            if (this.db.isFineEnabled()) {
                this.db.fine("Setting " + string + " from " + string2 + " i.e. " + f);
            }
            bl |= iDefaultsElement.isDirty();
            if (string.equals("LowTxPower")) {
                sLaserThresholds3.txPower.low = Math.round((float)((double)f * 10.0 + 400.0));
                continue;
            }
            if (string.equals("LowRxPower")) {
                sLaserThresholds3.rxPower.low = Math.round((float)((double)f * 10.0 + d));
                continue;
            }
            if (string.equals("HighTxPower")) {
                sLaserThresholds3.txPower.high = Math.round((float)((double)f * 10.0 + 400.0));
                continue;
            }
            if (string.equals("HighRxPower")) {
                sLaserThresholds3.rxPower.high = Math.round((float)((double)f * 10.0 + d));
                continue;
            }
            if (string.equals("HighLaserBias")) {
                sLaserThresholds3.laserBias.high = Math.round((float)((double)f * 10.0));
                continue;
            }
            this.db.severe("helpSetOpticalThresholdsToNodeVals: Unknown laser thresholds parm " + iDefaultsElement.getName());
        }
        if (bl) {
            if (this.db.isFineEnabled()) {
                this.db.fine("Setting optical thresholds:");
                this.db.fine("txPower:     low=" + sLaserThresholds3.txPower.low + " high=" + sLaserThresholds3.txPower.high);
                this.db.fine("rxPower:     low=" + sLaserThresholds3.rxPower.low + " high=" + sLaserThresholds3.rxPower.high);
                this.db.fine("laserBias:   high=" + sLaserThresholds3.laserBias.high);
            }
            return sLaserThresholds3;
        }
        return null;
    }

    private void setTrunkOpticalThresholdsToNodeVals(eEqType eEqType2, eReach eReach2, eDwdmFecMode eDwdmFecMode2, eTrunkOpticsVariant eTrunkOpticsVariant2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefTrunkOpticsThr(eEqType2, eReach2, eDwdmFecMode2, eTrunkOpticsVariant2, eIntervalType2);
        sLaserThresholds sLaserThresholds3 = this.helpSetOpticalThresholdsToNodeVals(iDefaultsNodeArray, sLaserThresholds2);
        if (sLaserThresholds3 != null) {
            this.neDefaultsModel.setDefTrunkOpticsThr(eEqType2, eReach2, eDwdmFecMode2, eTrunkOpticsVariant2, eIntervalType2, sLaserThresholds3);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setClientOpticalThresholdsToNodeVals(eEqType eEqType2, eEqType eEqType3, eClientOpticsVariant eClientOpticsVariant2, eReach eReach2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.db.info("setClientOpticalThresholdsToNodeVals: thresholdBuckets size " + iDefaultsNodeArray.length);
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefClientOpticsThr(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2);
        sLaserThresholds sLaserThresholds3 = null;
        sLaserThresholds3 = eEqType.TNC_UTS_CARD == eEqType2 ? this.helpSetOpticalThresholdsToNodeVals(iDefaultsNodeArray, sLaserThresholds2, 500.0) : this.helpSetOpticalThresholdsToNodeVals(iDefaultsNodeArray, sLaserThresholds2);
        if (sLaserThresholds3 != null) {
            this.neDefaultsModel.setDefClientOpticsThr(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2, sLaserThresholds3);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private boolean setDistExtensionConfigToNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            short s;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            bl |= iDefaultsElement.isDirty();
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("Enabled")) {
                sFCLineAdminInfo2.portDistanceExtension = s = this.stringToBool(string2);
                continue;
            }
            if (string.equals("Fastswitch")) {
                sFCLineAdminInfo2.fastSwitch = s = this.stringToBool(string2);
                continue;
            }
            if (string.equals("AutoDetect")) {
                sFCLineAdminInfo2.creditAutoDetect = s = this.stringToBool(string2);
                continue;
            }
            if (string.equals("NumCredits")) {
                sFCLineAdminInfo2.numCredits = s = Short.parseShort(string2);
                continue;
            }
            if (string.equals("AutoadjustGFPBufferThreshold")) {
                s = (short)(this.stringToBool(string2) ? 1 : 0);
                sFCLineAdminInfo2.gfpBufferAutoThreshold = s;
                continue;
            }
            if (string.equals("NumGFPBuffers")) {
                sFCLineAdminInfo2.gfpNumBuffers = s = Short.parseShort(string2);
                continue;
            }
            this.db.severe("setDistExtConfigToNodeValues: Unknown config value " + string);
        }
        return bl;
    }

    private boolean setEnhancedFcFiconConfigToNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            short s;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            bl |= iDefaultsElement.isDirty();
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("IngressIdleFiltering")) {
                sFCLineAdminInfo2.ingressFiltering = s = this.stringToBool(string2);
                continue;
            }
            if (string.equals("MaxFrameSize")) {
                sFCLineAdminInfo2.maxFrameSize = s = Short.parseShort(string2);
                continue;
            }
            this.db.severe("setEnhancedFcFiconConfigToNodeValues: Unknown config value " + string);
        }
        return bl;
    }

    private void setFcmrConfigToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, IDefaultsNode[] iDefaultsNodeArray2) throws Exception {
        eCardOperMode eCardOperMode2 = null;
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            if (string.equals("Mode")) {
                eCardOperMode2 = eCardOperMode.from_int(iDefaultsElement.getEnumValue());
                bl = iDefaultsElement.isDirty();
                continue;
            }
            this.db.severe("setFcmrConfigToNodeVals(): unknown " + string);
        }
        this.setFcmrConfigToNodeVals(eEqType2, eEqType3, eCardOperMode2, iDefaultsNodeArray2, bl);
    }

    private void setFcmrConfigToNodeVals(eEqType eEqType2, eEqType eEqType3, eCardOperMode eCardOperMode2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        sFCLineAdminInfo sFCLineAdminInfo2 = this.neDefaultsModel.getDefFcmrConfig(eEqType2, eEqType3);
        if (sFCLineAdminInfo2.portLoopback != eLoopback.NO_LOOPBACK) {
            bl = true;
            sFCLineAdminInfo2.portLoopback = eLoopback.NO_LOOPBACK;
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            int n;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("distanceExtension")) {
                bl |= this.setDistExtensionConfigToNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string.equals("enhancedFibreChannelFicon")) {
                bl |= this.setEnhancedFcFiconConfigToNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            bl |= iDefaultsElement.isDirty();
            if (string.equals("State") || string.equals("AdminState")) {
                n = iDefaultsElement.getEnumValue();
                sFCLineAdminInfo2.portState = eAdminState.from_int(n);
                continue;
            }
            if (string.equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, true);
                continue;
            }
            if (string.equals("MediaType")) {
                n = iDefaultsElement.getEnumValue();
                sFCLineAdminInfo2.portMediaType = eFCMediaType.from_int(n);
                continue;
            }
            if (string.equals("DistanceExtensionVsLinkRecovery")) {
                n = iDefaultsElement.getEnumValue();
                sFCLineAdminInfo2.portDistanceExtension = n == 1;
                sFCLineAdminInfo2.portLinkRecovery = n == 2;
                continue;
            }
            this.db.severe("setFcmrConfigToNodeValues: Unknown config value " + string);
        }
        if (bl) {
            this.neDefaultsModel.setDefFcmrConfig(eEqType2, eEqType3, eCardOperMode2, sFCLineAdminInfo2);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void handleCardMode(eEqType eEqType2, IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        if (bl) {
            this.setCardMode(eEqType2, iDefaultsNode.getChildren());
        } else {
            this.getCardMode(eEqType2, iDefaultsNode.getChildren());
        }
    }

    private void getCardMode(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        eCardOperMode eCardOperMode2 = this.neDefaultsModel.getDefCardOperMode(eEqType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            if (!string.equals("Mode")) continue;
            iDefaultsElement.initEnumValue(eCardOperMode2.value());
        }
    }

    private void setCardMode(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eCardOperMode eCardOperMode2 = null;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            if (!string.equals("Mode")) continue;
            eCardOperMode2 = eCardOperMode.from_int(iDefaultsElement.getEnumValue());
            if (!iDefaultsElement.isDirty()) continue;
            this.neDefaultsModel.setDefCardOperMode(eEqType2, eCardOperMode2);
            iDefaultsElement.makeClean();
        }
    }

    private void helpApplyDwdmPmByDataRate(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.info("helpApplyToDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDataRate eDataRate2 = null;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("oc3") || string.equals("stm1")) {
                eDataRate2 = eDataRate.OC3;
            } else if (string.equals("oc12") || string.equals("stm4")) {
                eDataRate2 = eDataRate.OC12;
            } else if (string.equals("oc48") || string.equals("stm16")) {
                eDataRate2 = eDataRate.OC48;
            } else if (string.equals("oc192") || string.equals("stm64")) {
                eDataRate2 = eDataRate.OC192;
            } else if (string.equals("1gethernet")) {
                eDataRate2 = eDataRate.ONE_GE;
            } else if (string.equals("1gfiberchannel")) {
                eDataRate2 = eDataRate.ONE_GFC;
            } else if (string.equals("1gficon")) {
                eDataRate2 = eDataRate.ONE_GFICON;
            } else if (string.equals("2gfiberchannel")) {
                eDataRate2 = eDataRate.TWO_GFC;
            } else if (string.equals("2gficon")) {
                eDataRate2 = eDataRate.TWO_GFICON;
            } else {
                this.db.severe("Unexpected data rate " + string);
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    IDefaultsNode[] iDefaultsNodeArray4;
                    boolean bl = true;
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl = false;
                    } else if (iDefaultsNodeArray3[k].getName().equals("15min")) {
                        eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    } else if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    if (string2.equals("8b10b")) {
                        iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                        this.set8B10BPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray4, eIntervalType2);
                        continue;
                    }
                    iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string2.equals("line") || string2.equals("ms")) {
                            this.setLinePmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        if (string2.equals("section") || string2.equals("rs")) {
                            this.setSectionPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        this.db.severe("helpApplyToDwdmPm: couldn't set to node vals for " + eEqType2 + " " + eDataRate2 + " " + iDefaultsNodeArray5.length + " " + bl + " " + eIntervalType2);
                    }
                }
            }
        }
    }

    private void helpApplyDwdmPmByLineType(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("helpApplyToDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDwdmLineType eDwdmLineType2 = eDwdmLineType.DWDM_CLIENT;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("trunk")) {
                eDwdmLineType2 = eDwdmLineType.DWDM_TRUNK;
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    boolean bl = true;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl = false;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string2.equals("line") || string2.equals("ms")) {
                            this.setLinePmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        if (string2.equals("section") || string2.equals("rs")) {
                            this.setSectionPmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl, eIntervalType2);
                            continue;
                        }
                        this.db.severe("helpApplyToDwdmPm: couldn't set to node vals for " + eEqType2 + " " + eDwdmLineType2 + " " + iDefaultsNodeArray5.length + " " + bl + " " + eIntervalType2);
                    }
                }
            }
        }
    }

    private void applyToNodeCircuits(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("upsr") || string2.equals("sncp")) {
                object = iDefaultsNodeArray[i].getChildren();
                sRevertiveBehavior sRevertiveBehavior2 = new sRevertiveBehavior();
                for (int j = 0; j < ((IDefaultsNode[])object).length; ++j) {
                    boolean bl2;
                    DefaultsElement defaultsElement = (DefaultsElement)object[j];
                    String string3 = defaultsElement.getName();
                    if (string3.equals("Revertive")) {
                        bl |= defaultsElement.isDirty();
                        string = defaultsElement.getValue();
                        sRevertiveBehavior2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string3.equals("ReversionTime")) {
                        bl |= defaultsElement.isDirty();
                        string = defaultsElement.getValue();
                        sRevertiveBehavior2.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    if (!defaultsElement.isDirty()) continue;
                    if (string3.equals("STS_SFBER") || string3.equals("HO_SFBER")) {
                        bl2 = (short)defaultsElement.getEnumValue();
                        this.nmd.setUpsrSfBerLevel(2, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("STS_SDBER") || string3.equals("HO_SDBER")) {
                        bl2 = (short)defaultsElement.getEnumValue();
                        this.nmd.setUpsrSdBerLevel(2, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("VT_SFBER") || string3.equals("LO_SFBER")) {
                        bl2 = (short)defaultsElement.getEnumValue();
                        this.nmd.setUpsrSfBerLevel(1, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("VT_SDBER") || string3.equals("LO_SDBER")) {
                        bl2 = (short)defaultsElement.getEnumValue();
                        this.nmd.setUpsrSdBerLevel(1, (short)(bl2 ? 1 : 0));
                    } else if (string3.equals("SwitchOnPDIP")) {
                        string = defaultsElement.getValue();
                        bl2 = this.stringToBool(string);
                        this.nmd.setUpsrSwitchOnPdip(bl2);
                    } else if (string3.equals("AllowUpsrOverOnePlusOne") || string3.equals("AllowSncpOverOnePlusOne")) {
                        this.neDefaultsModel.handleAllowUpsrOverOnePlusOne(defaultsElement, true);
                    } else if (defaultsElement.isDisplacedProperty()) {
                        this.handleTreelessDefaults(defaultsElement, true);
                    } else {
                        this.db.severe("applyNodeCircuits: unknown " + string3);
                    }
                    defaultsElement.makeClean();
                }
                if (!bl) continue;
                this.nmd.setUpsrReversion(RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior2));
                this.makeClean((IDefaultsNode[])object);
                continue;
            }
            if (string2.equals("State") || string2.equals("AdminState")) {
                object = (IDefaultsElement)iDefaultsNodeArray[i];
                if (!object.isDirty()) continue;
                eAdminState eAdminState2 = eAdminState.from_int(object.getEnumValue());
                this.neDefaultsModel.setDefaultCircuitAdminState(eAdminState2);
                object.makeClean();
                continue;
            }
            if (string2.equals("SendPDIP")) {
                object = (IDefaultsElement)iDefaultsNodeArray[i];
                if (!object.isDirty()) continue;
                boolean bl3 = this.stringToBool(object.getValue());
                this.nmd.setSendPDIP(bl3);
                object.makeClean();
                continue;
            }
            this.db.severe("Unknown node circuit " + string2);
        }
    }

    private void applyToNodeProtection(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            boolean bl;
            Object object;
            IDefaultsNode[] iDefaultsNodeArray2;
            boolean bl2;
            String string = "";
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("1+1") || string2.equals("lmsp")) {
                bl2 = false;
                sRevertiveBehavior sRevertiveBehavior2 = this.neDefaultsModel.getDefOnePlusOneRev();
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    object = (IDefaultsNode[])iDefaultsNodeArray2[j];
                    String string3 = object.getName();
                    string = object.getValue();
                    if (string3.equals("BidirectionalSwitching")) {
                        if (!object.isDirty()) continue;
                        bl = this.stringToBool(string);
                        this.neDefaultsModel.setDefOnePlusOneBidir(bl);
                        object.makeClean();
                        continue;
                    }
                    if (string3.equals("Revertive")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string3.equals("ReversionTime")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior2.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    if (string3.equals("RecoveryGuardTimer")) {
                        if (!object.isDirty()) continue;
                        eRecoveryGuardTimer eRecoveryGuardTimer2 = eRecoveryGuardTimer.from_int(this.findIndex(RECOVERY_GUARD_TIMERS, string));
                        this.neDefaultsModel.setDefRecoveryGuardTimer(eRecoveryGuardTimer2);
                        object.makeClean();
                        continue;
                    }
                    if (string3.equals("VerifyGuardTimer")) {
                        if (!object.isDirty()) continue;
                        eVerifyGuardTimer eVerifyGuardTimer2 = eVerifyGuardTimer.from_int(this.findIndex(VERIFY_GUARD_TIMERS, string));
                        this.neDefaultsModel.setDefVerifyGuardTimer(eVerifyGuardTimer2);
                        object.makeClean();
                        continue;
                    }
                    if (string3.equals("DetectionGuardTimer")) {
                        if (!object.isDirty()) continue;
                        eDetectionGuardTimer eDetectionGuardTimer2 = eDetectionGuardTimer.from_int(this.findIndex(DETECTION_GUARD_TIMERS, string));
                        this.neDefaultsModel.setDefDetectionGuardTimer(eDetectionGuardTimer2);
                        object.makeClean();
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown 1+1 item " + string3);
                }
                if (!bl2) continue;
                this.neDefaultsModel.setDefOnePlusOneRev(sRevertiveBehavior2);
                this.makeClean(iDefaultsNodeArray2);
                continue;
            }
            if (string2.startsWith("ycable")) {
                bl2 = false;
                sRevertiveBehavior sRevertiveBehavior3 = this.neDefaultsModel.getDefYCableRev();
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    object = (IDefaultsElement)iDefaultsNodeArray2[j];
                    String string4 = object.getName();
                    string = object.getValue();
                    if (string4.equals("BidirectionalSwitching")) {
                        if (!object.isDirty()) continue;
                        bl = this.stringToBool(string);
                        this.neDefaultsModel.setDefYCableBidir(bl);
                        object.makeClean();
                        continue;
                    }
                    if (string4.equals("Revertive")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior3.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior3.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string4.equals("ReversionTime")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior3.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown ycable item " + string4);
                }
                if (!bl2) continue;
                this.neDefaultsModel.setDefYCableRev(sRevertiveBehavior3);
                this.makeClean(iDefaultsNodeArray2);
                continue;
            }
            if (string2.startsWith("splitter")) {
                bl2 = false;
                sRevertiveBehavior sRevertiveBehavior4 = this.neDefaultsModel.getDefSplittRev();
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    object = (IDefaultsElement)iDefaultsNodeArray2[j];
                    String string5 = object.getName();
                    string = object.getValue();
                    if (string5.equals("Revertive")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior4.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior4.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string5.equals("ReversionTime")) {
                        bl2 |= object.isDirty();
                        sRevertiveBehavior4.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown ycable item " + string5);
                }
                if (!bl2) continue;
                this.neDefaultsModel.setDefSplittRev(sRevertiveBehavior4);
                this.makeClean(iDefaultsNodeArray2);
                continue;
            }
            if (string2.equals("blsr") || string2.equals("msspr")) {
                bl2 = false;
                boolean bl3 = false;
                iDefaultsNodeArray2 = this.neDefaultsModel.getDefBlsrRingRev();
                sRevertiveBehavior sRevertiveBehavior5 = this.neDefaultsModel.getDefBlsrSpanRev();
                object = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < ((Object)object).length; ++j) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)object[j];
                    String string6 = iDefaultsElement.getName();
                    string = iDefaultsElement.getValue();
                    if (string6.equals("RingRevertive")) {
                        bl2 |= iDefaultsElement.isDirty();
                        iDefaultsNodeArray2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (string.equals("TRUE")) {
                            iDefaultsNodeArray2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        }
                        this.neDefaultsModel.setDefBlsrRingRev((sRevertiveBehavior)iDefaultsNodeArray2);
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    if (string6.equals("RingReversionTime")) {
                        bl2 |= iDefaultsElement.isDirty();
                        iDefaultsNodeArray2.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    if (string6.equals("SpanRevertive")) {
                        bl3 |= iDefaultsElement.isDirty();
                        sRevertiveBehavior5.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        if (!string.equals("TRUE")) continue;
                        sRevertiveBehavior5.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    if (string6.equals("SpanReversionTime")) {
                        bl3 |= iDefaultsElement.isDirty();
                        sRevertiveBehavior5.reversionTime = (int)(Float.parseFloat(string) * 60.0f);
                        continue;
                    }
                    this.db.severe("applyToNodeProtection:unknown 1+1 item " + string6);
                }
                if (bl2) {
                    this.neDefaultsModel.setDefBlsrRingRev((sRevertiveBehavior)iDefaultsNodeArray2);
                }
                if (bl3) {
                    this.neDefaultsModel.setDefBlsrSpanRev(sRevertiveBehavior5);
                }
                this.makeClean((IDefaultsNode[])object);
                continue;
            }
            this.db.severe("applyToNodeProtection:unknown prot type " + string2);
        }
    }

    private String getStringFromQualityLevel(eQualityLevel eQualityLevel2) {
        String string = "UNKNOWN";
        switch (eQualityLevel2.value()) {
            case 0: {
                string = "PRS";
                break;
            }
            case 1: {
                string = "STU";
                break;
            }
            case 2: {
                string = "ST2";
                break;
            }
            case 3: {
                string = "TNC";
                break;
            }
            case 4: {
                string = "ST3E";
                break;
            }
            case 5: {
                string = "ST3";
                break;
            }
            case 6: {
                string = "SMC";
                break;
            }
            case 7: {
                string = "ST4";
                break;
            }
            case 8: {
                string = "DUS";
                break;
            }
            case 9: {
                string = "RES";
                break;
            }
            case 10: {
                string = "G811";
                break;
            }
            case 11: {
                string = "STU";
                break;
            }
            case 12: {
                string = "G812T";
                break;
            }
            case 13: {
                string = "G812L";
                break;
            }
            case 14: {
                string = "SETS";
                break;
            }
            case 15: {
                string = "DUS";
                break;
            }
            case 17: {
                string = "RES";
                break;
            }
        }
        return string;
    }

    private String getStringFromSaBit(eSaBit eSaBit2) {
        String string = "UNKNOWN";
        switch (eSaBit2.value()) {
            case 0: {
                string = "4";
                break;
            }
            case 1: {
                string = "5";
                break;
            }
            case 2: {
                string = "6";
                break;
            }
            case 3: {
                string = "7";
                break;
            }
            case 4: {
                string = "8";
                break;
            }
            case 5: {
                string = "N/A";
                break;
            }
        }
        return string;
    }

    private eQualityLevel getQualityLevel(String string) {
        eQualityLevel eQualityLevel2 = eQualityLevel.PRS;
        if (string.equals("PRS")) {
            eQualityLevel2 = eQualityLevel.PRS;
        } else if (string.equals("STU")) {
            eQualityLevel2 = this.nmd.provides(Feature.SDH) ? eQualityLevel.STU_SDH : eQualityLevel.STU;
        } else if (string.equals("ST2")) {
            eQualityLevel2 = eQualityLevel.ST2;
        } else if (string.equals("TNC")) {
            eQualityLevel2 = eQualityLevel.TNC;
        } else if (string.equals("ST3E")) {
            eQualityLevel2 = eQualityLevel.ST3E;
        } else if (string.equals("ST3")) {
            eQualityLevel2 = eQualityLevel.ST3;
        } else if (string.equals("SMC")) {
            eQualityLevel2 = eQualityLevel.SMC;
        } else if (string.equals("ST4")) {
            eQualityLevel2 = eQualityLevel.ST4;
        } else if (string.equals("DUS")) {
            eQualityLevel2 = this.nmd.provides(Feature.SDH) ? eQualityLevel.DUS_SDH : eQualityLevel.DUS;
        } else if (string.equals("RES")) {
            eQualityLevel2 = eQualityLevel.RES;
        } else if (string.equals("G811")) {
            eQualityLevel2 = eQualityLevel.G811;
        } else if (string.equals("G812T")) {
            eQualityLevel2 = eQualityLevel.G812T;
        } else if (string.equals("G812L")) {
            eQualityLevel2 = eQualityLevel.G812L;
        } else if (string.equals("SETS")) {
            eQualityLevel2 = eQualityLevel.SETS;
        } else if (string.equals("RES")) {
            eQualityLevel2 = this.nmd.provides(Feature.SDH) ? eQualityLevel.RES_SDH : eQualityLevel.RES;
        }
        return eQualityLevel2;
    }

    private eSaBit getSabit(String string) {
        eSaBit eSaBit2 = eSaBit.SA4;
        if (string.equals("4")) {
            eSaBit2 = eSaBit.SA4;
        } else if (string.equals("5")) {
            eSaBit2 = eSaBit.SA5;
        } else if (string.equals("6")) {
            eSaBit2 = eSaBit.SA6;
        } else if (string.equals("7")) {
            eSaBit2 = eSaBit.SA7;
        } else if (string.equals("8")) {
            eSaBit2 = eSaBit.SA8;
        } else if (string.equals("N/A")) {
            eSaBit2 = eSaBit.SA_NONE;
        }
        return eSaBit2;
    }

    private eCableType getCableType(String string) {
        eCableType eCableType2 = eCableType.PAUSE_75_OHM;
        if (string.equals("120 ohm")) {
            eCableType2 = eCableType.PAUSE_120_OHM;
        } else if (string.equals("75 ohm")) {
            eCableType2 = eCableType.PAUSE_75_OHM;
        } else if (string.equals("100 ohm")) {
            eCableType2 = eCableType.PAUSE_100_OHM;
        }
        return eCableType2;
    }

    private void helpHandleTimingGeneral(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        Object object;
        Object object2;
        IChassisModel iChassisModel = this.nmd.getNcChassis();
        SynchronizationModel synchronizationModel = iChassisModel.getSyncModel();
        eTimingSystem eTimingSystem2 = synchronizationModel.getTimingStandard();
        sSyncConfig sSyncConfig2 = synchronizationModel.getConfig();
        sRevertiveBehavior sRevertiveBehavior2 = sSyncConfig2.reversion;
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            object2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !((String)object2).equalsIgnoreCase(string)) continue;
            bl2 |= iDefaultsElement.isDirty();
            if (((String)object2).equals("TimingStandard")) {
                if (bl) {
                    this.helpSetTimingStandard(eTimingSystem.from_int(iDefaultsElement.getEnumValue()));
                    iDefaultsElement.makeClean();
                    continue;
                }
                iDefaultsElement.initEnumValue(eTimingSystem2.value());
                continue;
            }
            if (((String)object2).equals("Revertive")) {
                if (bl) {
                    object = iDefaultsElement.getValue();
                    if (((String)object).equals("FALSE")) {
                        sRevertiveBehavior2.reversionMode = eReversionMode.NON_REVERTIVE_BEHAVIOR;
                        continue;
                    }
                    sRevertiveBehavior2.reversionMode = eReversionMode.REVERTIVE_BEHAVIOR;
                    continue;
                }
                object = this.boolToString(sRevertiveBehavior2.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR);
                iDefaultsElement.initValue((String)object);
                continue;
            }
            if (((String)object2).equals("ReversionTime")) {
                if (bl) {
                    object = iDefaultsElement.getValue();
                    sRevertiveBehavior2.reversionTime = (int)(Float.parseFloat((String)object) * 60.0f);
                    continue;
                }
                object = String.valueOf((double)sRevertiveBehavior2.reversionTime / 60.0);
                iDefaultsElement.initValue((String)object);
                continue;
            }
            if (((String)object2).equals("QualityOfRES")) {
                if (bl) {
                    sSyncConfig2.interpretResAs = eResQualityLevel.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.getSiblingElement("SSMMessageSet").initEnumValue(sSyncConfig2.ssmGeneration.value());
                iDefaultsElement.initEnumValue(sSyncConfig2.interpretResAs.value());
                continue;
            }
            if (((String)object2).equals("SSMMessageSet")) {
                if (bl) {
                    sSyncConfig2.ssmGeneration = eSsmGen.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sSyncConfig2.ssmGeneration.value());
                continue;
            }
            if (((String)object2).equals("Mode")) {
                object = "UNKNOWN";
                if (bl) {
                    object = iDefaultsElement.getValue();
                    if (((String)object).equals("External")) {
                        sSyncConfig2.timingMode = eTimingMode.EXT_TIME;
                        continue;
                    }
                    if (((String)object).equals("Mixed")) {
                        sSyncConfig2.timingMode = eTimingMode.MIXED_TIME;
                        continue;
                    }
                    if (((String)object).equals("Line")) {
                        sSyncConfig2.timingMode = eTimingMode.LINE_TIME;
                        continue;
                    }
                    this.db.severe("unknown mode " + sSyncConfig2.timingMode.value());
                    continue;
                }
                if (sSyncConfig2.timingMode == eTimingMode.EXT_TIME) {
                    object = "External";
                } else if (sSyncConfig2.timingMode == eTimingMode.MIXED_TIME) {
                    object = "Mixed";
                } else if (sSyncConfig2.timingMode == eTimingMode.LINE_TIME) {
                    object = "Line";
                } else {
                    this.db.severe("unknown mode " + sSyncConfig2.timingMode.value());
                }
                iDefaultsElement.initValue((String)object);
                continue;
            }
            this.db.severe("handleNodeTiming: unknown general element= " + (String)object2);
        }
        if (bl && bl2) {
            IEntityModel[] iEntityModelArray = this.nmd.getChassisModels();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                object2 = (IChassisModel)iEntityModelArray[i];
                object = object2.getSyncModel();
                ((SynchronizationModel)object).setConfig(sSyncConfig2);
            }
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void helpSetTimingStandard(eTimingSystem eTimingSystem2) throws Exception {
        IEntityModel[] iEntityModelArray = this.nmd.getChassisModels();
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            IChassisModel iChassisModel = (IChassisModel)iEntityModelArray[i];
            SynchronizationModel synchronizationModel = iChassisModel.getSyncModel();
            synchronizationModel.setTimingStandard(eTimingSystem2);
        }
    }

    private void helpHandleSntpServers(IIpAddr[] iIpAddrArray) throws Exception {
        sIpAddr[] sIpAddrArray = this.nmd.getSntpHosts();
        if (iIpAddrArray[0] != null) {
            sIpAddrArray[0] = IpAddrFactory.getIpAddr(iIpAddrArray[0]);
        }
        if (iIpAddrArray[1] != null) {
            sIpAddrArray[1] = IpAddrFactory.getIpAddr(iIpAddrArray[1]);
        }
        this.nmd.setSntpHost(sIpAddrArray);
    }

    private void helpHandleBits(IDefaultsNode[] iDefaultsNodeArray, eBits eBits2, boolean bl, String string) throws Exception {
        Object object;
        Object object2;
        boolean bl2 = false;
        IChassisModel iChassisModel = this.nmd.getNcChassis();
        SynchronizationModel synchronizationModel = iChassisModel.getSyncModel();
        sBitsConfig sBitsConfig2 = synchronizationModel.getBitsConfig(eBits2);
        sBitsConfig sBitsConfig3 = synchronizationModel.getBitsConfig(eBits2);
        sSyncConfig sSyncConfig2 = synchronizationModel.getConfig();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            object2 = iDefaultsElement.getName();
            if (string.length() != 0 && !((String)object2).equalsIgnoreCase(string)) continue;
            bl2 |= iDefaultsElement.isDirty();
            if (((String)object2).equals("FacilityType")) {
                if (bl) {
                    sBitsConfig2.facilityType = eBitsFacility.from_int(iDefaultsElement.getEnumValue());
                    this.setBitsSyncMessageIn(sBitsConfig3, sBitsConfig2);
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.facilityType.value());
                continue;
            }
            if (((String)object2).equals("FacilityTypeOut")) {
                if (bl) {
                    sBitsConfig2.facilityTypeBitsOut = eBitsFacility.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.facilityTypeBitsOut.value());
                continue;
            }
            if (((String)object2).equals("State") || ((String)object2).equals("AdminState")) {
                if (bl) {
                    sBitsConfig2.adminState = eAdminState.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.adminState.value());
                continue;
            }
            if (((String)object2).equals("StateOut")) {
                if (bl) {
                    sBitsConfig2.adminStateBitsOut = eAdminState.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.adminStateBitsOut.value());
                continue;
            }
            if (((String)object2).equals("Framing")) {
                if (bl) {
                    sBitsConfig2.framing = eLineType.from_int(iDefaultsElement.getEnumValue());
                    this.setBitsSyncMessageIn(sBitsConfig3, sBitsConfig2);
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.framing.value());
                continue;
            }
            if (((String)object2).equals("FramingOut")) {
                if (bl) {
                    sBitsConfig2.framingBitsOut = eLineType.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.framingBitsOut.value());
                continue;
            }
            if (((String)object2).equals("Coding")) {
                if (bl) {
                    sBitsConfig2.coding = eLineCoding.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.coding.value());
                continue;
            }
            if (((String)object2).equals("CodingOut")) {
                if (bl) {
                    sBitsConfig2.codingBitsOut = eLineCoding.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.codingBitsOut.value());
                continue;
            }
            if (((String)object2).equals("AdminSSMIn")) {
                if (bl) {
                    sBitsConfig2.assumedQuality = eQualityLevel.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.assumedQuality.value());
                continue;
            }
            if (((String)object2).equals("AISThreshold")) {
                if (bl) {
                    sBitsConfig2.aisThreshold = eQualityLevel.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.aisThreshold.value());
                continue;
            }
            if (((String)object2).equals("LBO")) {
                if (bl) {
                    sBitsConfig2.bitsLBO = eBitsLBO.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.bitsLBO.value());
                continue;
            }
            if (((String)object2).equals("SaBit") || ((String)object2).equals("Sa bit")) {
                if (bl) {
                    sBitsConfig2.saBit = eSaBit.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sBitsConfig2.saBit.value());
                continue;
            }
            if (((String)object2).equals("CableType")) {
                if (bl) {
                    sBitsConfig2.cableSelection = this.getCableType(iDefaultsElement.getValue());
                    continue;
                }
                object = this.getStringFromCableType(sBitsConfig2.cableSelection);
                iDefaultsElement.initValue((String)object);
                continue;
            }
            if (((String)object2).equals("SSMMessageSet")) {
                if (bl) {
                    sSyncConfig2.ssmGeneration = eSsmGen.from_int(iDefaultsElement.getEnumValue());
                    continue;
                }
                iDefaultsElement.initEnumValue(sSyncConfig2.ssmGeneration.value());
                continue;
            }
            this.db.severe("helpHandleBits(): unknown bits " + (String)object2);
        }
        if (bl && bl2) {
            IEntityModel[] iEntityModelArray = this.nmd.getChassisModels();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                object2 = (IChassisModel)iEntityModelArray[i];
                object = object2.getSyncModel();
                ((SynchronizationModel)object).setBitsConfig(eBits2, sBitsConfig2);
            }
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void setBitsSyncMessageIn(sBitsConfig sBitsConfig2, sBitsConfig sBitsConfig3) {
        if (sBitsConfig3.facilityType == eBitsFacility.BITS_64K) {
            sBitsConfig3.syncMessageIn = false;
        } else if (sBitsConfig2.framing != sBitsConfig3.framing) {
            switch (sBitsConfig3.framing.value()) {
                case 0: 
                case 2: 
                case 4: {
                    sBitsConfig3.syncMessageIn = true;
                    break;
                }
                case 1: 
                case 3: 
                case 16: 
                case 17: {
                    sBitsConfig3.syncMessageIn = false;
                    break;
                }
                default: {
                    this.db.severe("Unknown framing value " + sBitsConfig3.framing.value());
                }
            }
        }
    }

    private void applyNodeIPSettings(IDefaultsElement iDefaultsElement) throws Exception {
        String string = iDefaultsElement.getName();
        String string2 = iDefaultsElement.getValue();
        if (string.equals("CtcIpDisplaySuppression")) {
            if (iDefaultsElement.isDirty()) {
                this.nmd.setCtcIpDisplaySuppression(true, this.stringToBool(string2));
                iDefaultsElement.makeClean();
            }
        } else if (string.equals("LcdSetting")) {
            if (iDefaultsElement.isDirty()) {
                String string3 = string2;
                for (int i = 0; i < LcdIpSetting.LCD_IP_SETTING.length; ++i) {
                    if (!LcdIpSetting.LCD_IP_SETTING[i].equals(string3)) continue;
                    this.nmd.setLcdIpSetting(i, true);
                    break;
                }
                iDefaultsElement.makeClean();
            }
        } else {
            this.db.severe("applyNodeIpSettings: unknown general element= " + string);
        }
    }

    private void applyToNodeSoftware(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            boolean bl;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            boolean bl2 = bl = iDefaultsElement.getEnumValue() == 1;
            if (string.equals("AllowDelayedUpgrades")) {
                if (iDefaultsElement.isDirty()) {
                    this.neDefaultsModel.setAllowDelayedUpgrades(bl);
                }
            } else if (string.equals("DefaultDelayedUpgrades")) {
                if (iDefaultsElement.isDirty()) {
                    this.neDefaultsModel.setDefaultDelayedUpgrades(bl);
                }
            } else {
                this.db.severe("applyToNodeSoftware: unknown software element= " + string);
            }
            iDefaultsElement.makeClean();
        }
    }

    private void helpApplyTimeZoneAndUseDST(IDefaultsElement iDefaultsElement, IDefaultsElement iDefaultsElement2) {
        Object object;
        boolean bl;
        boolean bl2 = false;
        CtcTimeZone ctcTimeZone = this.nmd.getCtcTimeZone();
        boolean bl3 = bl = !ctcTimeZone.isDSTDisabled();
        if (iDefaultsElement != null && iDefaultsElement.isDirty()) {
            bl2 = true;
            object = this.nmd.getCtcTimeZoneFactory();
            String string = iDefaultsElement.getValue();
            for (int i = 0; i < ((CtcTimeZoneFactory)object).getNumberofTimeZones(); ++i) {
                CtcTimeZone ctcTimeZone2 = ((CtcTimeZoneFactory)object).getCtcTimeZone(i);
                if (!string.equals(ctcTimeZone2.toString())) continue;
                ctcTimeZone = ctcTimeZone2;
            }
        }
        if (iDefaultsElement2 != null && iDefaultsElement2.isDirty()) {
            bl2 = true;
            object = iDefaultsElement2.getValue();
            bl = this.stringToBool((String)object);
        }
        if (bl2) {
            this.nmd.setTimeZone(ctcTimeZone, bl);
            this.nmd.setCtcTimeZone(ctcTimeZone);
            if (iDefaultsElement != null) {
                iDefaultsElement.makeClean();
            }
            if (iDefaultsElement2 != null) {
                iDefaultsElement2.makeClean();
            }
        }
    }

    private void applyToNodeGeneral(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        IDefaultsElement iDefaultsElement = null;
        IDefaultsElement iDefaultsElement2 = null;
        IIpAddr[] iIpAddrArray = new IIpAddr[]{null, null};
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement3 = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement3.getName();
            if (string.equals("RaiseConditionOnEmptySlot")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setRaiseConditionOnEmptySlot(this.stringToBool(iDefaultsElement3.getValue()));
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("ReportLoopbackConditionsOnOOS-MTPorts") || string.equals("ReportLoopbackConditionsOnLocked,MaintenancePorts")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setShowLoopbackAlarmsOnPortsUndergoingMaintenance(iDefaultsElement3.getEnumValue() == 1);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("AutoPM")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setAutoPM(iDefaultsElement3.getEnumValue() == 1);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("mvAirFilterBasedFanEnable")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setAirFilter(iDefaultsElement3.getEnumValue() == 1);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("AllowServiceAffectingPortChangeToDisabled")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setForceToOosDsbldStateChange(iDefaultsElement3.getEnumValue() == 1);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("SDPBER")) {
                if (!iDefaultsElement3.isDirty()) continue;
                short s = (short)iDefaultsElement3.getEnumValue();
                this.neDefaultsModel.setAisvOnSdpBerLevel(s);
                iDefaultsElement3.makeClean();
                continue;
            }
            String string2 = iDefaultsElement3.getValue();
            if (string.equals("DefaultsDescription")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setDefDescription(string2);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("TimeZone")) {
                iDefaultsElement = iDefaultsElement3;
                continue;
            }
            if (string.equals("UseDST")) {
                iDefaultsElement2 = iDefaultsElement3;
                continue;
            }
            if (string.equals("NtpSntpServer")) {
                if (!iDefaultsElement3.isDirty()) continue;
                iIpAddrArray[0] = InetUtil.makeIpAddr(string2);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("BackupNtpSntpServer")) {
                if (!iDefaultsElement3.isDirty()) continue;
                iIpAddrArray[1] = InetUtil.makeIpAddr(string2);
                iDefaultsElement3.makeClean();
                continue;
            }
            if (string.equals("InsertAISVOnSDP")) {
                if (!iDefaultsElement3.isDirty()) continue;
                this.neDefaultsModel.setAisvOnSdp(this.stringToBool(string2));
                iDefaultsElement3.makeClean();
                continue;
            }
            this.db.severe("applyToNodeGeneral: unknown general element= " + string);
        }
        this.helpApplyTimeZoneAndUseDST(iDefaultsElement, iDefaultsElement2);
        this.helpHandleSntpServers(iIpAddrArray);
    }

    private void applyToNodePowerMonitor(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        sPwrMonVoltage sPwrMonVoltage2 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V48);
        sPwrMonVoltage sPwrMonVoltage3 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V60);
        sPwrMonVoltage sPwrMonVoltage4 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.MIXED);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("ELWBATVG_48V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.ex_low_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("ELWBATVG")) {
                if (!iDefaultsElement.isDirty()) continue;
                if (this.nmd.getPlatform().is600SDH()) {
                    sPwrMonVoltage4.ex_low_voltage = this.convertVoltage(string2);
                    bl3 = true;
                    continue;
                }
                sPwrMonVoltage2.ex_low_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("LWBATVG")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.low_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("HIBATVG")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.high_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("EHIBATVG_48V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage2.ex_high_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("EHIBATVG")) {
                if (!iDefaultsElement.isDirty()) continue;
                if (this.nmd.getPlatform().is600SDH()) {
                    sPwrMonVoltage4.ex_high_voltage = this.convertVoltage(string2);
                    bl3 = true;
                    continue;
                }
                sPwrMonVoltage2.ex_high_voltage = this.convertVoltage(string2);
                bl = true;
                continue;
            }
            if (string.equals("ELWBATVG_60V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage3.ex_low_voltage = this.convertVoltage(string2);
                bl2 = true;
                continue;
            }
            if (string.equals("EHIBATVG_60V")) {
                if (!iDefaultsElement.isDirty()) continue;
                sPwrMonVoltage3.ex_high_voltage = this.convertVoltage(string2);
                bl2 = true;
                continue;
            }
            this.db.severe("unknown power monitor element: " + string);
        }
        if (bl) {
            this.neDefaultsModel.setDefPowerMonitor(sPwrMonVoltage2);
        }
        if (bl2) {
            this.neDefaultsModel.setDefPowerMonitor(sPwrMonVoltage3);
        }
        if (bl3) {
            this.neDefaultsModel.setDefPowerMonitor(sPwrMonVoltage4);
        }
        this.makeClean(iDefaultsNodeArray);
    }

    private int convertVoltage(String string) {
        int n = (int)(Double.parseDouble(string) * -1000.0);
        return n;
    }

    private String convertVoltage(int n) {
        String string = Double.toString((double)n / -1000.0);
        return string;
    }

    private void applyPendingApplications() throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("applyPendingApplications: size = " + this.pendingApplications.size());
        }
        if (this.pendingApplications.size() > 0) {
            int n;
            Object object;
            Object object2;
            Object object3;
            IDefaultsElement iDefaultsElement3 = (IDefaultsElement)this.pendingApplications.get("LANAccess");
            if (iDefaultsElement3 != null && iDefaultsElement3.getName().equals("LANAccess") && iDefaultsElement3.isDirty()) {
                object3 = iDefaultsElement3.getValue();
                object2 = (SecurityModel)this.nmd.getSecurityModel();
                ((SecurityModel)object2).setLANAccess(LANAccessMode.from_string((String)object3));
            }
            object3 = this.nmd.getIpConfig();
            object2 = this.nmd.getSecureIpConfig();
            boolean bl = object2.isSecureMode();
            boolean bl2 = object2.isPermanentSecureMode();
            boolean bl3 = false;
            iDefaultsElement3 = (IDefaultsElement)this.pendingApplications.get("IIOPListenerPort");
            if (iDefaultsElement3 != null && iDefaultsElement3.getName().equals("IIOPListenerPort")) {
                if (iDefaultsElement3.isDirty()) {
                    object = iDefaultsElement3.getValue();
                    n = Integer.parseInt((String)object);
                    if (n > Short.MAX_VALUE) {
                        n -= 65536;
                    }
                    object3.setIiopPort((short)n);
                    bl3 = true;
                }
            } else if (iDefaultsElement3 != null) {
                this.db.severe("Pending mismatch: " + iDefaultsElement3.getName());
            }
            if ((iDefaultsElement3 = (IDefaultsElement)this.pendingApplications.get("SecureModeOn")) != null && iDefaultsElement3.getName().equals("SecureModeOn") && iDefaultsElement3.isDirty()) {
                boolean bl4;
                if (bl2) {
                    throw new Exception(" The secure mode is locked and cannot be changed.");
                }
                boolean bl5 = this.stringToBool(iDefaultsElement3.getValue());
                IDefaultsElement iDefaultsElement2 = (IDefaultsElement)this.pendingApplications.get("SecureModeLocked");
                boolean bl6 = bl4 = iDefaultsElement2 == null ? bl2 : this.stringToBool(iDefaultsElement2.getValue());
                if (bl5 != bl) {
                    object2.setMode(bl5);
                }
                if (bl5) {
                    short s;
                    IIpAddr iIpAddr;
                    String string;
                    block39: {
                        String string2;
                        String string3;
                        block38: {
                            string3 = "10.10.0.1";
                            string = "24";
                            if (bl4) {
                                object2.setSecureMode(bl4);
                            }
                            object = object3.getIpAddress();
                            n = object3.getNetMaskPrefixLength();
                            try {
                                string2 = "NODE.security.dataComm.DefaultTCCEthernetIP";
                                string3 = this.neDefaultsModel.getClientDefault(string2);
                            }
                            catch (NoSuchDefault noSuchDefault) {
                                if (!this.db.isFineEnabled()) break block38;
                                this.db.fine("No Such Default" + (Object)((Object)noSuchDefault));
                            }
                        }
                        try {
                            iIpAddr = InetUtil.makeIpAddr(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (this.db.isFineEnabled()) {
                                this.db.fine("Invalid IP Address" + numberFormatException);
                            }
                            throw new Exception("The IP address is invalid.");
                        }
                        try {
                            string2 = "NODE.security.dataComm.DefaultTCCEthernetIPNetmask";
                            string = this.neDefaultsModel.getClientDefault(string2);
                        }
                        catch (NoSuchDefault noSuchDefault) {
                            if (!this.db.isFineEnabled()) break block39;
                            this.db.fine("No Such Default" + (Object)((Object)noSuchDefault));
                        }
                    }
                    try {
                        s = Short.parseShort(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.db.isFineEnabled()) {
                            this.db.fine("Invalid IP Netmask" + numberFormatException);
                        }
                        throw new Exception("The IP netmask is invalid.");
                    }
                    String string4 = ProxyXlator.getProxyStringOrStatus(this.nmd);
                    if (!string4.equals("GNE") && !string4.equals("ENE")) {
                        ProxyXlator.setProxy(this.nmd, 2);
                    }
                    object2.setIpAddress((IIpAddr)object);
                    object2.setNetMaskPrefixLength((short)n);
                    object3.setIpAddress(iIpAddr);
                    object3.setNetMaskPrefixLength(s);
                } else {
                    object = object2.getIpAddress();
                    n = object2.getNetMaskPrefixLength();
                    object3.setIpAddress((IIpAddr)object);
                    object3.setNetMaskPrefixLength((short)n);
                }
                bl3 = false;
                this.nmd.setSecureIpConfig((IIpConfig)object3, (ISecureIpConfig)object2);
            } else if (iDefaultsElement3 != null) {
                this.db.severe("Pending mismatch: " + iDefaultsElement3.getName() + " dirty: " + iDefaultsElement3.isDirty());
            }
            iDefaultsElement3 = (IDefaultsElement)this.pendingApplications.get("GatewaySettings");
            if (iDefaultsElement3 != null && iDefaultsElement3.getName().equals("GatewaySettings") && iDefaultsElement3.isDirty()) {
                object = iDefaultsElement3.getValue();
                if (!((String)object).equals("LeaveAsIs")) {
                    if (this.nmd.isSecureMode() && (((String)object).equals("ProxyOnlyNode") || ((String)object).equals("None"))) {
                        iDefaultsElement3.makeClean();
                        throw new Exception("When in secure mode, the node must be configured as a GNE or an ENE.");
                    }
                    ProxyXlator.setProxy(this.nmd, (String)object);
                    object = ProxyXlator.getProxyStringOrStatus(this.nmd);
                    iDefaultsElement3.setComment("As is: " + (String)object);
                }
                iDefaultsElement3.makeClean();
            } else if (iDefaultsElement3 != null) {
                this.db.severe("Pending mismatch: " + iDefaultsElement3.getName() + " dirty: " + iDefaultsElement3.isDirty());
            }
            if (bl3) {
                if (bl) {
                    this.nmd.setSecureIpConfig((IIpConfig)object3, (ISecureIpConfig)object2);
                } else {
                    try {
                        this.nmd.setIpConfig((IIpConfig)object3);
                    }
                    catch (xProvisionError xProvisionError2) {
                        throw new Exception("Invalid IP config");
                    }
                }
            }
            for (IDefaultsElement iDefaultsElement3 : this.pendingApplications.values()) {
                iDefaultsElement3.makeClean();
            }
            this.pendingApplications.clear();
        }
    }

    private void applyToNodeTop(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("applyToNodeTop: children size = " + iDefaultsNodeArray.length);
        }
        boolean bl = true;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode = iDefaultsNodeArray[i];
            String string = iDefaultsNode.getName();
            if (!iDefaultsNode.isDirty()) {
                if (!this.db.isInfoEnabled()) continue;
                this.db.info(string + " is clean... continuing...");
                continue;
            }
            if (string.equals("general")) {
                this.applyToNodeGeneral(iDefaultsNode.getChildren());
                continue;
            }
            if (string.equals("lmp")) {
                this.handleNodeLmp(iDefaultsNode.getChildren(), bl, "");
                continue;
            }
            if (string.equals("osi")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string.equals("powerMonitor")) {
                this.applyToNodePowerMonitor(iDefaultsNode.getChildren());
                continue;
            }
            if (string.equals("network")) {
                this.handleNodeNetwork(iDefaultsNode.getChildren(), bl, "");
                continue;
            }
            if (string.equals("security")) {
                this.handleNodeSecurity(iDefaultsNode.getChildren(), bl, "");
                continue;
            }
            if (string.equals("timing")) {
                this.handleNodeTiming(iDefaultsNode.getChildren(), bl, "");
                continue;
            }
            if (string.equals("protection")) {
                this.applyToNodeProtection(iDefaultsNode.getChildren());
                continue;
            }
            if (string.equals("circuits")) {
                this.applyToNodeCircuits(iDefaultsNode.getChildren());
                continue;
            }
            if (string.equals("software")) {
                this.applyToNodeSoftware(iDefaultsNode.getChildren());
                continue;
            }
            this.db.severe("Unknown general level " + string);
        }
        this.applyPendingApplications();
    }

    public void setPassword(String string) {
        this.password = string;
    }

    protected eEqType getEqTypeFromName(String string) throws Exception {
        if (string.equals("UNASSIGNED")) {
            return eEqType.UNPROVISIONED;
        }
        if (string.equals("PPM (1 Port)")) {
            return eEqType.PPM_1_PORT;
        }
        return (eEqType)this.eqTypeNameTypeMap.get(string);
    }

    protected String getNameFromEqType(eEqType eEqType2) {
        if (eEqType2.equals(eEqType.UNPROVISIONED)) {
            return "UNASSIGNED";
        }
        if (eEqType2.equals(eEqType.PPM_1_PORT)) {
            return "PPM (1 Port)";
        }
        return (String)this.eqTypeTypeNameMap.get(eEqType2);
    }

    private void getDsnConfigFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("getDsnConfigFromNodeVals " + iDefaultsNodeArray.length);
        }
        sConfig sConfig2 = this.neDefaultsModel.getDefConfig(eEqType2, eEqType3);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsNodeArray[i].getName();
            String string2 = "";
            if (string.equals("LineType")) {
                iDefaultsElement.initEnumValue(sConfig2.lineType.value());
                continue;
            }
            if (string.equals("LineCoding")) {
                string2 = sConfig2.lineCoding == eLineCoding.B8ZS ? "B8ZS" : (sConfig2.lineCoding == eLineCoding.AMI ? "AMI" : (sConfig2.lineCoding == eLineCoding.HDB3 ? "HDB3" : "B3ZS"));
                iDefaultsElement.initValue(string2);
                continue;
            }
            if (string.equals("LineLength")) {
                int n = 0;
                if (eEqType3 == eEqType.DS1_VT_MAPPED) {
                    n = 655;
                    if (sConfig2.lineLength >= 0 && sConfig2.lineLength < 132) {
                        n = 131;
                    } else if (sConfig2.lineLength >= 132 && sConfig2.lineLength < 263) {
                        n = 262;
                    } else if (sConfig2.lineLength >= 263 && sConfig2.lineLength < 394) {
                        n = 393;
                    } else if (sConfig2.lineLength >= 394 && sConfig2.lineLength < 525) {
                        n = 524;
                    }
                } else {
                    n = 450;
                    if (sConfig2.lineLength >= 0 && sConfig2.lineLength < 226) {
                        n = 225;
                    }
                }
                iDefaultsElement.initEnumValue(n);
                continue;
            }
            if (string.equals("FdlMode")) {
                iDefaultsElement.initEnumValue(sConfig2.fdlModeMask);
                continue;
            }
            this.db.severe("Unknown config value " + string);
            string2 = "UNKNOWN";
        }
    }

    private void handleDsnPm(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, String string, boolean bl, eThresholdType eThresholdType2, boolean bl2) throws Exception {
        IDefaultsValue[] iDefaultsValueArray = new IDefaultsValue[iDefaultsNodeArray.length];
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            iDefaultsValueArray[i] = (IDefaultsValue)((Object)iDefaultsNodeArray[i]);
        }
        if (string.equals("line") || string.equals("ms")) {
            this.neDefaultsModel.handlePmThr(iDefaultsValueArray, bl2);
            return;
        }
        if (string.equals("path") || string.equals("pbitpath") || string.equals("ds1path")) {
            if (!(eEqType2 != eEqType.DS3XM_LINE_CARD && eEqType2 != eEqType.DS3XM12_LINE_CARD || string.equals("path"))) {
                this.neDefaultsModel.handleDs3xmPmPathThr(iDefaultsValueArray, bl2);
            } else {
                this.neDefaultsModel.handlePmPathThr(iDefaultsValueArray, bl2);
            }
            this.neDefaultsModel.handleNetworkPmPathThr(iDefaultsValueArray, bl2);
        } else if (string.equals("cpbitpath")) {
            this.neDefaultsModel.handlePmCPBitThr(iDefaultsValueArray, bl2);
        } else {
            this.db.severe("Error in getDsnPmToNodeVals....could not get Thresholds!!!" + string);
        }
    }

    void helpGetLinePmVals(sLineThresholds sLineThresholds2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sLineThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sLineThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sLineThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sLineThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sLineThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("PSC")) {
                string = String.valueOf(sLineThresholds2.psc);
            } else if (iDefaultsElement.getName().equals("PSD")) {
                string = String.valueOf(sLineThresholds2.psd);
            } else if (iDefaultsElement.getName().equals("PSC-W")) {
                string = String.valueOf(sLineThresholds2.pscw);
            } else if (iDefaultsElement.getName().equals("PSD-W")) {
                string = String.valueOf(sLineThresholds2.psdw);
            } else if (iDefaultsElement.getName().equals("PSC-S")) {
                string = String.valueOf(sLineThresholds2.pscs);
            } else if (iDefaultsElement.getName().equals("PSD-S")) {
                string = String.valueOf(sLineThresholds2.psds);
            } else if (iDefaultsElement.getName().equals("PSC-R")) {
                string = String.valueOf(sLineThresholds2.pscr);
            } else if (iDefaultsElement.getName().equals("PSD-R")) {
                string = String.valueOf(sLineThresholds2.psdr);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sLineThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("helpGetLinePmVals: Unknown line pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getLinePmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, bl, eIntervalType2);
        this.helpGetLinePmVals(sLineThresholds2, iDefaultsNodeArray);
    }

    private void getLinePmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2);
        this.helpGetLinePmVals(sLineThresholds2, iDefaultsNodeArray);
    }

    private void getLinePmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sLineThresholds sLineThresholds2 = this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
        this.helpGetLinePmVals(sLineThresholds2, iDefaultsNodeArray);
    }

    private void getLinePmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        sLineThresholds sLineThresholds2 = null;
        sLineThresholds2 = bl2 ? this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, bl, eIntervalType2) : this.neDefaultsModel.getDefLineThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
        this.helpGetLinePmVals(sLineThresholds2, iDefaultsNodeArray);
    }

    void helpGetSectionPmVals(sSectionThresholds sSectionThresholds2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sSectionThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sSectionThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sSectionThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("SEFS") || iDefaultsElement.getName().equals("OFS")) {
                string = String.valueOf(sSectionThresholds2.sefs);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sSectionThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sSectionThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("getSectionPmToNodeVals: Unknown section pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getSectionPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, bl, eIntervalType2);
        this.helpGetSectionPmVals(sSectionThresholds2, iDefaultsNodeArray);
    }

    private void getSectionPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, eDataRate2, bl, eIntervalType2);
        this.helpGetSectionPmVals(sSectionThresholds2, iDefaultsNodeArray);
    }

    private void getSectionPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sSectionThresholds sSectionThresholds2 = this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
        this.helpGetSectionPmVals(sSectionThresholds2, iDefaultsNodeArray);
    }

    private void getSectionPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDwdmLineType eDwdmLineType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        sSectionThresholds sSectionThresholds2 = null;
        sSectionThresholds2 = bl2 ? this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, bl, eIntervalType2) : this.neDefaultsModel.getDefSectionThr(eEqType2, eEqType3, eDwdmLineType2, bl, eIntervalType2);
        this.helpGetSectionPmVals(sSectionThresholds2, iDefaultsNodeArray);
    }

    private void get8B10BPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eDataRate eDataRate2, IDefaultsNode[] iDefaultsNodeArray, eIntervalType eIntervalType2) throws Exception {
        s8B10BPmThresholds s8B10BPmThresholds2 = this.neDefaultsModel.getDef8B10BPmThr(eEqType2, eEqType3, eDataRate2, eIntervalType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("validPackets")) {
                string = String.valueOf(s8B10BPmThresholds2.validPkts);
            } else if (iDefaultsElement.getName().equals("invalidPackets")) {
                string = String.valueOf(s8B10BPmThresholds2.invalidPkts);
            } else if (iDefaultsElement.getName().equals("codeGroupViolations")) {
                string = String.valueOf(s8B10BPmThresholds2.codeViol);
            } else if (iDefaultsElement.getName().equals("idleOrderedSets")) {
                string = String.valueOf(s8B10BPmThresholds2.idleSets);
            } else if (iDefaultsElement.getName().equals("nonIdleOrderedSets")) {
                string = String.valueOf(s8B10BPmThresholds2.nonIdleSets);
            } else if (iDefaultsElement.getName().equals("dataCodeGroups")) {
                string = String.valueOf(s8B10BPmThresholds2.dataSets);
            } else {
                string = String.valueOf("88");
                this.db.severe("get8B10BPmToNodeVals: Unknown pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getVtPathPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sVtThresholds sVtThresholds2 = this.neDefaultsModel.getDefVtThr(eEqType2, eEqType3, bl, eIntervalType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sVtThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sVtThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sVtThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sVtThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sVtThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sVtThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("getVtPathPmToNodeVals: Unknown vt pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getStsPathPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, short s, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2) throws Exception {
        sPathThresholds sPathThresholds2 = this.neDefaultsModel.getDefPathThrCmn(eEqType2, eEqType3, s, bl, eIntervalType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (this.db.isFineEnabled()) {
                this.db.fine("getStsPathPmFromNodeVals() " + iDefaultsNodeArray[i].getFullName());
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("CV") || iDefaultsElement.getName().equals("EB")) {
                string = String.valueOf(sPathThresholds2.cv);
            } else if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sPathThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sPathThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sPathThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sPathThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sPathThresholds2.bbe);
            } else if (iDefaultsElement.getName().equals("PPJC-PDET")) {
                string = String.valueOf(sPathThresholds2.pjpIn);
            } else if (iDefaultsElement.getName().equals("PPJC-PGEN")) {
                string = String.valueOf(sPathThresholds2.pjpOut);
            } else if (iDefaultsElement.getName().equals("NPJC-PDET")) {
                string = String.valueOf(sPathThresholds2.pjnIn);
            } else if (iDefaultsElement.getName().equals("NPJC-PGEN")) {
                string = String.valueOf(sPathThresholds2.pjnOut);
            } else if (iDefaultsElement.getName().equals("PJCDIFF")) {
                string = String.valueOf(sPathThresholds2.pjDiff);
            } else if (iDefaultsElement.getName().equals("PJCS-PDET")) {
                string = String.valueOf(sPathThresholds2.pjInSec);
            } else if (iDefaultsElement.getName().equals("PJCS-PGEN")) {
                string = String.valueOf(sPathThresholds2.pjOutSec);
            } else {
                string = String.valueOf("88");
                this.db.severe("getStsPathPmFromNodeVals: Unknown sts pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getOtnPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws Exception {
        sOTNThresholds sOTNThresholds2 = this.neDefaultsModel.getDefOtnThr(eEqType2, eEqType3, bl, eIntervalType2, eMonitorType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("ES")) {
                string = String.valueOf(sOTNThresholds2.es);
            } else if (iDefaultsElement.getName().equals("SES")) {
                string = String.valueOf(sOTNThresholds2.ses);
            } else if (iDefaultsElement.getName().equals("UAS")) {
                string = String.valueOf(sOTNThresholds2.uas);
            } else if (iDefaultsElement.getName().equals("FC")) {
                string = String.valueOf(sOTNThresholds2.fc);
            } else if (iDefaultsElement.getName().equals("BBE")) {
                string = String.valueOf(sOTNThresholds2.bbe);
            } else {
                string = String.valueOf("88");
                this.db.severe("getOtnPmFromNodeVals: Unknown otn pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void getFecPmFromNodeVals(eEqType eEqType2, eEqType eEqType3, eIntervalType eIntervalType2, eDwdmFecMode eDwdmFecMode2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sFECPmThresholds sFECPmThresholds2 = this.neDefaultsModel.getDefFecThr(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            if (iDefaultsElement.getName().equals("BitErrorsCorrected")) {
                string = String.valueOf(sFECPmThresholds2.bitErrCor);
            } else if (iDefaultsElement.getName().equals("UncorrectableWords")) {
                string = String.valueOf(sFECPmThresholds2.uncorWords);
            } else {
                string = String.valueOf("88");
                this.db.severe("getFecPmFromNodeVals: Unknown fec pm parm " + iDefaultsElement.getName());
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void helpGetOpticalThresholdsFromNodeVals(sLaserThresholds sLaserThresholds2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        this.helpGetOpticalThresholdsFromNodeVals(sLaserThresholds2, iDefaultsNodeArray, 400);
    }

    private void helpGetOpticalThresholdsFromNodeVals(sLaserThresholds sLaserThresholds2, IDefaultsNode[] iDefaultsNodeArray, int n) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("helpGetOpticalThreshodsFromNodeVals: sLaserThresholds \n\ttxPower.high     = " + sLaserThresholds2.txPower.high + "\n" + "\ttxPower.low      = " + sLaserThresholds2.txPower.low + "\n" + "\trxPower.high     = " + sLaserThresholds2.rxPower.high + "\n" + "\ttxPower.low      = " + sLaserThresholds2.rxPower.low + "\n" + "\tlaserBias.high   = " + sLaserThresholds2.laserBias.high + "\n" + "\tlaserBias.low    = " + sLaserThresholds2.laserBias.low + "\n" + "\txcvrVoltage.high = " + sLaserThresholds2.xcvrVoltage.high + "\n" + "\txcvrVoltage.low  = " + sLaserThresholds2.xcvrVoltage.low + "\n" + "\tlaserTemp.high   = " + sLaserThresholds2.laserTemp.high + "\n" + "\tlaserTemp.low    = " + sLaserThresholds2.laserTemp.low + "\n");
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = "";
            float f = 0.0f;
            int n2 = 0;
            int n3 = 10;
            if (iDefaultsElement.getName().equals("LowTxPower")) {
                f = sLaserThresholds2.txPower.low;
                n2 = 400;
            } else if (iDefaultsElement.getName().equals("LowRxPower")) {
                f = sLaserThresholds2.rxPower.low;
                n2 = n;
            } else if (iDefaultsElement.getName().equals("HighTxPower")) {
                f = sLaserThresholds2.txPower.high;
                n2 = 400;
            } else if (iDefaultsElement.getName().equals("HighRxPower")) {
                f = sLaserThresholds2.rxPower.high;
                n2 = n;
            } else if (iDefaultsElement.getName().equals("HighLaserBias")) {
                f = sLaserThresholds2.laserBias.high;
            } else {
                f = 88.0f;
                n3 = 1;
                this.db.severe("helpGetOpticalThresholdFromNodeVals: Unknown sLaserThresholds parm " + iDefaultsElement.getName());
            }
            string = String.valueOf((f - (float)n2) / (float)n3);
            iDefaultsElement.initValue(string);
        }
    }

    private void getClientOpticalThresholdsFromNodeVals(eEqType eEqType2, eEqType eEqType3, eClientOpticsVariant eClientOpticsVariant2, eReach eReach2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("getOpticalAlarmThresholdsFromNodeVals " + iDefaultsNodeArray.length);
        }
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefClientOpticsThr(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2);
        if (eEqType.TNC_UTS_CARD == eEqType2) {
            this.helpGetOpticalThresholdsFromNodeVals(sLaserThresholds2, iDefaultsNodeArray, 500);
        } else {
            this.helpGetOpticalThresholdsFromNodeVals(sLaserThresholds2, iDefaultsNodeArray);
        }
    }

    private void getTrunkOpticalThresholdsFromNodeVals(eEqType eEqType2, eReach eReach2, eDwdmFecMode eDwdmFecMode2, eTrunkOpticsVariant eTrunkOpticsVariant2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("getOpticalThresholdsFromNodeVals" + iDefaultsNodeArray.length);
        }
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefTrunkOpticsThr(eEqType2, eReach2, eDwdmFecMode2, eTrunkOpticsVariant2, eIntervalType2);
        this.helpGetOpticalThresholdsFromNodeVals(sLaserThresholds2, iDefaultsNodeArray);
    }

    private void helpHandleAdminState(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eAdminState eAdminState2 = eAdminState.from_int(n);
                this.neDefaultsModel.setDefAdminState(eEqType2, eEqType3, eAdminState2);
                iDefaultsElement.makeClean();
            }
        } else {
            eAdminState eAdminState3 = this.neDefaultsModel.getDefAdminState(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eAdminState3.value());
        }
    }

    private void helpHandleSoakTime(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                short s = this.stringToSoakTime(string);
                this.neDefaultsModel.setDefAinsSoakTime(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefAinsSoakTime(eEqType2, eEqType3);
            String string = this.soakTimeToString(s);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleLITimer(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                short s = Short.parseShort(string);
                this.neDefaultsModel.setDefLITimer(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefLITimer(eEqType2, eEqType3);
            String string = String.valueOf(s);
            iDefaultsElement.initValue(string);
        }
    }

    private void handlePreServiceAlarmSuppress(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                boolean bl2 = string.equals("TRUE");
                this.neDefaultsModel.setDefPreServiceAlarmSuppress(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefPreServiceAlarmSuppress(eEqType2, eEqType3);
            String string = bl3 ? "TRUE" : "FALSE";
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleOperatingMode(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                eCardOperMode eCardOperMode2 = eCardOperMode.from_int(iDefaultsElement.getEnumValue());
                this.neDefaultsModel.setDefCardOperMode(eEqType2, eCardOperMode2);
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(this.neDefaultsModel.getDefCardOperMode(eEqType2).value());
        }
    }

    private void helpHandlePortToVtMappingMode(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                ePortToVtMappingMode ePortToVtMappingMode2 = ePortToVtMappingMode.from_int(iDefaultsElement.getEnumValue());
                this.neDefaultsModel.setDefPortToVtMappingMode(eEqType2, ePortToVtMappingMode2);
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(this.neDefaultsModel.getDefPortToVtMappingMode(eEqType2).value());
        }
    }

    private void helpHandleAlsMode(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eALSMode eALSMode2 = eALSMode.from_int(n);
                this.neDefaultsModel.setDefAlsMode(eEqType2, eEqType3, eALSMode2);
                iDefaultsElement.makeClean();
            }
        } else {
            eALSMode eALSMode3 = this.neDefaultsModel.getDefAlsMode(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eALSMode3.value());
        }
    }

    private void helpHandleAlsRecoveryPulseInterval(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                short s = Short.parseShort(string);
                this.neDefaultsModel.setDefAlsRecoveryInterval(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefAlsRecoveryInterval(eEqType2, eEqType3);
            String string = String.valueOf(new Short(s));
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleAlsRecoveryPulseDuration(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                Float f = new Float(Float.parseFloat(string) * 10.0f);
                short s = f.shortValue();
                this.neDefaultsModel.setDefAlsRecoveryPulseWidth(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefAlsRecoveryPulseWidth(eEqType2, eEqType3);
            String string = String.valueOf(new Float((double)s / 10.0));
            iDefaultsElement.initEnumPass1();
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleLoopbackAis(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl, eLoopback eLoopback2) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                boolean bl2 = this.stringToBool(iDefaultsElement.getValue());
                this.neDefaultsModel.setDefLoopbackAis(eEqType2, eEqType3, eLoopback2, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefLoopbackAis(eEqType2, eEqType3, eLoopback2);
            iDefaultsElement.initValue(this.boolToString(bl3));
        }
    }

    private void helpHandleAisOnFacilityLoopback(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        this.helpHandleLoopbackAis(eEqType2, eEqType3, iDefaultsElement, bl, eLoopback.LINE_LOOPBACK);
    }

    private void helpHandleAisOnTerminalLoopback(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        this.helpHandleLoopbackAis(eEqType2, eEqType3, iDefaultsElement, bl, eLoopback.INWARD_LOOPBACK);
    }

    private void helpHandleMappingType(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eMappingType eMappingType2 = eMappingType.from_int(n);
                this.neDefaultsModel.setDefMappingType(eEqType2, eMappingType2);
                iDefaultsElement.makeClean();
            }
        } else {
            eMappingType eMappingType3 = this.neDefaultsModel.getDefMappingType(eEqType2);
            iDefaultsElement.initEnumValue(eMappingType3.value());
        }
    }

    private void helpHandleSfBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareSfBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareSfBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDsnSfBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareDSnSfBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareDSnSfBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleSdBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareSdBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareSdBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDsnSdBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefDeclareDSnSdBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefDeclareDSnSdBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDs1RetimingEnabled(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                boolean bl2 = this.stringToBool(string);
                this.neDefaultsModel.setDefDs1RetimingEnabled(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefDs1RetimingEnabled(eEqType2, eEqType3);
            String string = this.boolToString(bl3);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleDs1AisvEnabled(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                boolean bl2 = iDefaultsElement.getEnumValue() == 1;
                this.neDefaultsModel.setDefDs1AisvEnabled(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefDs1AisvEnabled(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(bl3 ? 1 : 0);
        }
    }

    private void helpHandleDs1AisOnLofEnabled(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                boolean bl2 = iDefaultsElement.getEnumValue() == 1;
                this.neDefaultsModel.setDefDs1AisOnLofEnabled(eEqType2, eEqType3, bl2);
                iDefaultsElement.makeClean();
            }
        } else {
            boolean bl3 = this.neDefaultsModel.getDefDs1AisOnLofEnabled(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(bl3 ? 1 : 0);
        }
    }

    private void helpHandleLineSdBerLevel(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                short s = (short)iDefaultsElement.getEnumValue();
                this.neDefaultsModel.setDefLineSdBerLevel(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefLineSdBerLevel(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(s);
        }
    }

    private void helpHandleDs1Mapping(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eDs1Mapping eDs1Mapping2 = eDs1Mapping.from_int(n);
                this.neDefaultsModel.setDefDs1Mapping(eEqType2, eEqType3, eDs1Mapping2);
                iDefaultsElement.makeClean();
            }
        } else {
            eDs1Mapping eDs1Mapping3 = this.neDefaultsModel.getDefDs1Mapping(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eDs1Mapping3.value());
        }
    }

    private void helpHandleE1SaBit(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                eSaBit eSaBit2 = eSaBit.from_int(iDefaultsElement.getEnumValue());
                this.neDefaultsModel.setDefE1SaBit(eEqType2, eEqType3, eSaBit2);
                iDefaultsElement.makeClean();
            }
        } else {
            eSaBit eSaBit3 = this.neDefaultsModel.getDefE1SaBit(eEqType2, eEqType3);
            iDefaultsElement.initEnumValue(eSaBit3.value());
        }
    }

    private void helpHandleLineLength(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                int n2 = 1;
                if (this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3) < 0) {
                    n2 = -1;
                }
                this.neDefaultsModel.setDefLineBuildout(eEqType2, eEqType3, n * n2);
                iDefaultsElement.makeClean();
            }
        } else {
            int n = this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3);
            int n3 = 450;
            if (n > -226 && n < 226) {
                n3 = 225;
            }
            iDefaultsElement.initEnumValue(n3);
        }
    }

    private void helpHandlePJStsMon(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, int n, boolean bl) throws Exception {
        eEqType eEqType4 = eEqType3 = eEqType3 == eEqType.DWDM_TRUNK_PORT ? eEqType.OC192_PORT : eEqType3;
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                short s = Short.parseShort(string);
                if (n == 1) {
                    s = (short)AbstractHoNum.Vc4Num2Sts((int)s);
                }
                this.neDefaultsModel.setDefPointerSts(eEqType2, eEqType3, s);
                iDefaultsElement.makeClean();
            }
        } else {
            short s = this.neDefaultsModel.getDefPointerSts(eEqType2, eEqType3);
            if (n == 1) {
                s = (short)AbstractHoNum.StsNum2Vc4((int)s);
            }
            String string = String.valueOf(s);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleRxEqualization(eEqType eEqType2, eEqType eEqType3, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = 1;
                int n2 = this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3);
                String string = iDefaultsElement.getValue();
                if (string.equals("TRUE") && n2 < 0 || string.equals("FALSE") && n2 > 0) {
                    n = -1;
                }
                this.neDefaultsModel.setDefLineBuildout(eEqType2, eEqType3, n2 * n);
                iDefaultsElement.makeClean();
            }
        } else {
            int n = this.neDefaultsModel.getDefLineBuildout(eEqType2, eEqType3);
            String string = this.boolToString(n >= 0);
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleDsnPm(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, String string, boolean bl, eThresholdType eThresholdType2, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        if (string.equals("line") || string.equals("path") || string.equals("pbitpath") || string.equals("cpbitpath") || string.equals("ds1path") || string.equals("ds1network")) {
            this.handleDsnPm(eEqType2, eEqType3, iDefaultsNodeArray, string, bl, eThresholdType2, bl2);
        } else if (string.equals("vt") || string.equals("vclo")) {
            if (bl2) {
                this.setVtPathPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getVtPathPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("sts") || string.equals("vc4")) {
            if (bl2) {
                this.setStsPathPmToNodeVals(eEqType2, eEqType3, (short)1, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getStsPathPmFromNodeVals(eEqType2, eEqType3, (short)1, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else {
            this.db.severe("helpHandleDSnPm: couldnt set/get node vals for " + string);
        }
    }

    private void handleDSnPm(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleDSnPm: dsnPmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            string = this.trimParentName(string);
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                boolean bl2 = true;
                String string3 = iDefaultsNodeArray2[j].getName();
                if (string.length() != 0 && !this.isSameName(string3, string)) continue;
                if (string3.equals("farend")) {
                    bl2 = false;
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                string = this.trimParentName(string);
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    eThresholdType eThresholdType2 = eThresholdType.THRESHOLD_15_MIN;
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    String string4 = iDefaultsNodeArray3[k].getName();
                    if (string.length() != 0 && !this.isSameName(string4, string)) continue;
                    if (string4.equals("1day")) {
                        eThresholdType2 = eThresholdType.THRESHOLD_1_DAY;
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    this.helpHandleDsnPm(eEqType2, eEqType3, iDefaultsNodeArray4, string2, bl2, eThresholdType2, eIntervalType2, bl);
                }
            }
        }
    }

    private void handleDSnConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        Object object;
        Object object2;
        int n;
        if (this.db.isFineEnabled()) {
            this.db.fine("handleDSnConfig: dsnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (n = 0; n < iDefaultsNodeArray.length; ++n) {
            object2 = iDefaultsNodeArray[n].getName();
            if (string.length() != 0 && !this.isSameName((String)object2, string)) continue;
            if (((String)object2).equals("sonet") || ((String)object2).equals("sdh")) {
                arrayList3.add(iDefaultsNodeArray[n]);
                continue;
            }
            object = (DefaultsElement)iDefaultsNodeArray[n];
            if (((String)object2).equals("State") || ((String)object2).equals("AdminState")) {
                arrayList2.add(object);
                continue;
            }
            if (((String)object2).equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("FeInhibitLpbk")) {
                this.neDefaultsModel.handleInhibitFELoopback((IDefaultsValue)object, bl);
                continue;
            }
            if (((String)object2).equals("FeInhibitBackplaneLpbk")) {
                this.neDefaultsModel.handleInhibitFEBackplaneLoopback((IDefaultsValue)object, bl);
                continue;
            }
            if (((String)object2).equals("SFBER")) {
                this.helpHandleDsnSfBerLevel(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SDBER")) {
                this.helpHandleDsnSdBerLevel(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SyncMsgIn")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("SendDoNotUse")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("RetimingEnabled")) {
                this.helpHandleDs1RetimingEnabled(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SendAISVOnDefects")) {
                this.helpHandleDs1AisvEnabled(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("TreatLOFAsDefect")) {
                this.helpHandleDs1AisOnLofEnabled(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SendAISOnFacilityLoopback")) {
                this.helpHandleAisOnFacilityLoopback(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("SendAISOnTerminalLoopback")) {
                this.helpHandleAisOnTerminalLoopback(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("AdminSSMIn")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("ProvidesSyncFromCard")) {
                arrayList3.add(object);
                continue;
            }
            if (((String)object2).equals("Ds1Mapping")) {
                arrayList2.add(object);
                continue;
            }
            if (((String)object2).equals("SaBit")) {
                this.helpHandleE1SaBit(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("OperatingMode")) {
                this.helpHandleOperatingMode(eEqType2, (IDefaultsElement)object, bl);
                continue;
            }
            if (((String)object2).equals("PortToVtMappingMode")) {
                arrayList2.add(object);
                continue;
            }
            arrayList.add(object);
        }
        if (this.db.isFineEnabled()) {
            this.db.fine("DsnConfig timing " + arrayList3.size());
            this.db.fine("DsnConfig remaining " + arrayList.size());
        }
        if (bl) {
            this.setDsnConfigToNodeVals(eEqType2, eEqType3, arrayList.toArray(new IDefaultsNode[0]));
        } else {
            this.getDsnConfigFromNodeVals(eEqType2, eEqType3, arrayList.toArray(new IDefaultsNode[0]));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            object2 = (IDefaultsElement)arrayList2.get(n);
            object = object2.getName();
            if (((String)object).equals("State") || ((String)object).equals("AdminState")) {
                this.helpHandleAdminState(eEqType2, eEqType3, (IDefaultsElement)object2, bl);
                continue;
            }
            if (((String)object).equals("Ds1Mapping")) {
                this.helpHandleDs1Mapping(eEqType2, eEqType3, (IDefaultsElement)object2, bl);
                continue;
            }
            if (((String)object).equals("PortToVtMappingMode")) {
                this.helpHandlePortToVtMappingMode(eEqType2, (IDefaultsElement)object2, bl);
                continue;
            }
            this.db.severe("handleDSnConfig: Shouldnt be here...." + (String)object);
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, this.nmd.getNcChassis().getSyncModel().getTimingStandard(), arrayList3.toArray(new IDefaultsNode[0]), bl, string);
    }

    private void handleDSn(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDSn: dsnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("pmthresholds")) {
                this.handleDSnPm(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("config")) {
                this.handleDSnConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("ds1config")) {
                this.handleDSnConfig(eEqType2, eEqType.DS1_VT_MAPPED, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("handleDSn: Shouldnt be here...." + string2);
        }
    }

    private void helpHandleOCnAlarmPhysicalThresholds(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, eIntervalType eIntervalType2, boolean bl) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.fine("helpHandleOCnAlarmPhysicalThresholds: ocnElems size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        sPhysicalThresholds sPhysicalThresholds2 = new sPhysicalThresholds(0, 0, 0, 0, 0, 0);
        if (bl) {
            boolean bl2 = false;
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string = iDefaultsNodeArray[i].getName();
                String string2 = ((IDefaultsElement)iDefaultsNodeArray[i]).getValue();
                int n = Integer.parseInt(string2);
                if (iDefaultsNodeArray[i].isDirty()) {
                    bl2 = true;
                }
                if (string.equals("OPT-HIGH")) {
                    sPhysicalThresholds2.optHigh = n;
                    continue;
                }
                if (string.equals("OPR-HIGH")) {
                    sPhysicalThresholds2.oprHigh = n;
                    continue;
                }
                if (string.equals("LBC-HIGH")) {
                    sPhysicalThresholds2.lbcHigh = n;
                    continue;
                }
                if (string.equals("OPT-LOW")) {
                    sPhysicalThresholds2.optLow = n;
                    continue;
                }
                if (string.equals("OPR-LOW")) {
                    sPhysicalThresholds2.oprLow = n;
                    continue;
                }
                if (string.equals("LBC-LOW")) {
                    sPhysicalThresholds2.lbcLow = n;
                    continue;
                }
                this.db.severe("helpHandleOCnAlarmPhysicalThresholds: Unknown name " + string);
            }
            if (bl2) {
                if (eIntervalType2 == null) {
                    this.neDefaultsModel.setDefPhysicalAlmThresholds(eEqType2, eEqType3, sPhysicalThresholds2);
                } else {
                    this.neDefaultsModel.setDefPhysicalPmThresholds(eEqType2, eEqType3, eIntervalType2, sPhysicalThresholds2);
                }
                this.makeClean(iDefaultsNodeArray);
            }
        } else {
            sPhysicalThresholds2 = eIntervalType2 == null ? this.neDefaultsModel.getDefPhysicalAlmThresholds(eEqType2, eEqType3) : this.neDefaultsModel.getDefPhysicalPmThresholds(eEqType2, eEqType3, eIntervalType2);
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string = iDefaultsNodeArray[i].getName();
                int n = 0;
                if (string.equals("OPT-HIGH")) {
                    n = sPhysicalThresholds2.optHigh;
                } else if (string.equals("OPR-HIGH")) {
                    n = sPhysicalThresholds2.oprHigh;
                } else if (string.equals("LBC-HIGH")) {
                    n = sPhysicalThresholds2.lbcHigh;
                } else if (string.equals("OPT-LOW")) {
                    n = sPhysicalThresholds2.optLow;
                } else if (string.equals("OPR-LOW")) {
                    n = sPhysicalThresholds2.oprLow;
                } else if (string.equals("LBC-LOW")) {
                    n = sPhysicalThresholds2.lbcLow;
                } else {
                    this.db.severe("helpHandleOCnAlarmPhysicalThresholds: Unknown name " + string);
                }
                ((IDefaultsElement)iDefaultsNodeArray[i]).initValue(String.valueOf(n));
            }
        }
    }

    private void helpHandleOCnPm(String string, eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, eIntervalType eIntervalType2, boolean bl2) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("helpHandleOCnPm: ocnPmElems size = " + iDefaultsNodeArray.length + ", applying " + bl2);
        }
        if (string.equals("line") || string.equals("ms")) {
            if (bl2) {
                this.setLinePmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getLinePmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("section") || string.equals("rs")) {
            if (bl2) {
                this.setSectionPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getSectionPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("sts") || string.equals("sts1") || string.equals("path") || string.startsWith("sts3c") || string.startsWith("sts12c") || string.equals("sts192c")) {
            int n = 1;
            n = string.equals("sts1") || string.equals("sts") || string.equals("path") ? 1 : (string.startsWith("sts3c") ? 3 : 12);
            if (bl2) {
                this.setStsPathPmToNodeVals(eEqType2, eEqType3, (short)n, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getStsPathPmFromNodeVals(eEqType2, eEqType3, (short)n, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else if (string.equals("vt") || string.equals("vclo")) {
            if (bl2) {
                this.setVtPathPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            } else {
                this.getVtPathPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray, bl, eIntervalType2);
            }
        } else {
            this.db.severe("helpHandleOCnPm: unexpected name " + string);
        }
    }

    private void getDistExtensionConfigFromNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !string2.equalsIgnoreCase(string)) continue;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string3 = "";
            if (string2.equals("Enabled")) {
                string3 = this.boolToString(sFCLineAdminInfo2.portDistanceExtension);
                iDefaultsElement.initValue(string3);
                continue;
            }
            if (string2.equals("Fastswitch")) {
                string3 = this.boolToString(sFCLineAdminInfo2.fastSwitch);
                iDefaultsElement.initValue(string3);
                continue;
            }
            if (string2.equals("AutoDetect")) {
                string3 = this.boolToString(sFCLineAdminInfo2.creditAutoDetect);
                iDefaultsElement.initValue(string3);
                continue;
            }
            if (string2.equals("NumCredits")) {
                string3 = Short.toString(sFCLineAdminInfo2.numCredits);
                iDefaultsElement.initValue(string3);
                continue;
            }
            if (string2.equals("AutoadjustGFPBufferThreshold")) {
                string3 = this.boolToString(sFCLineAdminInfo2.gfpBufferAutoThreshold);
                iDefaultsElement.initValue(string3);
                continue;
            }
            if (string2.equals("NumGFPBuffers")) {
                string3 = Short.toString(sFCLineAdminInfo2.gfpNumBuffers);
                iDefaultsElement.initValue(string3);
                continue;
            }
            this.db.severe("Unknown config value " + string2);
            string3 = "UNKNOWN";
            iDefaultsElement.initValue(string3);
        }
    }

    private void getEnhancedFcFiconConfigFromNodeVals(sFCLineAdminInfo sFCLineAdminInfo2, IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !string2.equalsIgnoreCase(string)) continue;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string3 = "";
            if (string2.equals("IngressIdleFiltering")) {
                string3 = this.boolToString(sFCLineAdminInfo2.ingressFiltering);
                iDefaultsElement.initValue(string3);
                continue;
            }
            if (string2.equals("MaxFrameSize")) {
                string3 = Short.toString(sFCLineAdminInfo2.maxFrameSize);
                iDefaultsElement.initValue(string3);
                continue;
            }
            this.db.severe("Unknown config value " + string2);
            string3 = "UNKNOWN";
            iDefaultsElement.initValue(string3);
        }
    }

    private void getFcmrConfigFromNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        sFCLineAdminInfo sFCLineAdminInfo2 = null;
        sFCLineAdminInfo2 = this.neDefaultsModel.getDefFcmrConfig(eEqType2, eEqType3);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("distanceExtension")) {
                this.getDistExtensionConfigFromNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            if (string2.equals("enhancedFibreChannelFicon")) {
                this.getEnhancedFcFiconConfigFromNodeVals(sFCLineAdminInfo2, iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            if (string2.equals("State") || string2.equals("AdminState")) {
                iDefaultsElement.initEnumValue(sFCLineAdminInfo2.portState.value());
                continue;
            }
            if (string2.equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, false);
                continue;
            }
            if (string2.equals("MediaType")) {
                iDefaultsElement.initEnumValue(sFCLineAdminInfo2.portMediaType.value());
                continue;
            }
            if (string2.equals("DistanceExtensionVsLinkRecovery")) {
                int n = 0;
                if (sFCLineAdminInfo2.portDistanceExtension) {
                    n = 1;
                } else if (sFCLineAdminInfo2.portLinkRecovery) {
                    n = 2;
                }
                iDefaultsElement.initEnumValue(n);
                continue;
            }
            this.db.severe("getFcmrConfigFromNodeVals(): unknown  " + string2);
        }
    }

    private void handleFcmr(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleFcmr: fcmrNodes size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string) || !string2.equals("config")) continue;
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            String string3 = this.trimParentName(string);
            IDefaultsNode iDefaultsNode = null;
            IDefaultsNode iDefaultsNode2 = null;
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string4 = iDefaultsNodeArray2[j].getName();
                if (string.length() != 0 && !this.isSameName(string4, string3)) continue;
                if (string4.equals("card")) {
                    if (bl) {
                        iDefaultsNode = iDefaultsNodeArray2[j];
                        continue;
                    }
                    this.getCardMode(eEqType2, iDefaultsNodeArray2[j].getChildren());
                    continue;
                }
                if (string4.equals("port")) {
                    if (bl) {
                        iDefaultsNode2 = iDefaultsNodeArray2[j];
                        continue;
                    }
                    this.getFcmrConfigFromNodeVals(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNodeArray2[j].getChildren(), this.trimParentName(string3));
                    continue;
                }
                this.db.severe("handleFcmr(): Unknown name " + string4);
            }
            if (!bl) continue;
            this.setFcmrConfigToNodeVals(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode.getChildren(), iDefaultsNode2.getChildren());
        }
    }

    private void helpHandleMlIos(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            if (string2.equals("consolePortAccess")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    this.neDefaultsModel.setDefIosConsolePortAccess(eEqType2, this.stringToBool(iDefaultsElement.getValue()));
                    iDefaultsElement.makeClean();
                    continue;
                }
                string = this.boolToString(this.neDefaultsModel.getDefIosConsolePortAccess(eEqType2));
                iDefaultsElement.initValue(string);
                continue;
            }
            if (string2.equals("radiusServerAccess")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    this.neDefaultsModel.setDefIosRadiusRelayAccess(eEqType2, this.stringToBool(iDefaultsElement.getValue()));
                    iDefaultsElement.makeClean();
                    continue;
                }
                string = this.boolToString(this.neDefaultsModel.getDefIosRadiusRelayAccess(eEqType2));
                iDefaultsElement.initValue(string);
                continue;
            }
            this.db.severe("helpHandleMlIos(): unknown name " + string2);
        }
    }

    private void handleRanSvc(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleRanSvc: ranSvcNodes size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("ios")) {
                this.helpHandleMlIos(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleRanSvc: unknown elem" + string);
        }
    }

    private void handleMl(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleMl: mlNodes size = " + iDefaultsNodeArray.length);
        }
        eEqType eEqType3 = this.getPortTypeForCard(eEqType2);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("config")) {
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    IDefaultsElement iDefaultsElement;
                    String string3 = iDefaultsNodeArray2[j].getName();
                    this.db.fine("handleMl: childName = " + string3 + " child = " + iDefaultsNodeArray2);
                    if (string3.equals("card")) {
                        this.handleCardMode(eEqType2, iDefaultsNodeArray2[j], bl);
                        continue;
                    }
                    if (string3.equals("PreServiceAlarmSuppression")) {
                        iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                        this.handlePreServiceAlarmSuppress(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string3.equals("SoakTime")) {
                        iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                        this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleMl: unknown config" + string3);
                }
                continue;
            }
            if (string2.equals("ios")) {
                this.helpHandleMlIos(eEqType2, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleMl: unknown elem" + string2);
        }
    }

    private void handleML2Mapper(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleML2Mapper: nodes size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            int n;
            Object object2;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            eEqType eEqType3 = eEqType.L1P_ETHER_PORT;
            if (string2.equals("config")) {
                eEqType3 = eEqType.L1P_ETHER_PORT;
                object2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < ((IDefaultsNode[])object2).length; ++n) {
                    if (object2[n].getName().equals("card")) {
                        this.handleCardMode(eEqType2, object2[n], bl);
                        continue;
                    }
                    object = (IDefaultsElement)object2[n];
                    String string3 = object.getName();
                    if (string3.equals("State") || string3.equals("AdminState")) {
                        this.helpHandleAdminState(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                        continue;
                    }
                    if (string3.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType3, (IDefaultsElement)object, bl);
                        continue;
                    }
                    this.db.severe("unknown ml2 mapper elem " + string3);
                }
                continue;
            }
            if (string2.equals("posPortConfig")) {
                eEqType3 = eEqType.L1P_POS_PORT;
                continue;
            }
            if (string2.equals("etherPortConfig")) {
                eEqType3 = eEqType.L1P_ETHER_PORT;
                object2 = this.neDefaultsModel.getDefML2MapperEtherLineAdminInfo(eEqType2, eEqType3);
                n = 0;
                object = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < ((Object)object).length; ++j) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)object[j];
                    String string4 = iDefaultsElement.getName();
                    if (string4.equals("802-1Q-VlanCoS")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object2.vlanCosThreshold = Short.parseShort(iDefaultsElement.getValue());
                            continue;
                        }
                        iDefaultsElement.initValue(Short.toString(object2.vlanCosThreshold));
                        continue;
                    }
                    if (string4.equals("IP-ToS")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object2.ipTosThreshold = Short.parseShort(iDefaultsElement.getValue());
                            continue;
                        }
                        iDefaultsElement.initValue(Short.toString(object2.ipTosThreshold));
                        continue;
                    }
                    if (string4.equals("EnableFlowControl")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object2.flowControlEnabled = this.stringToBool(iDefaultsElement.getValue());
                            continue;
                        }
                        iDefaultsElement.initValue(String.valueOf(object2.flowControlEnabled));
                        continue;
                    }
                    if (string4.equals("LinkDuplex")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object2.linkDuplex = eEtherDuplex.from_int(iDefaultsElement.getEnumValue());
                            continue;
                        }
                        iDefaultsElement.initEnumValue(object2.linkDuplex.value());
                        continue;
                    }
                    if (string4.equals("LinkSpeed")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            object2.linkSpeed = eEtherSpeed.from_int(iDefaultsElement.getEnumValue());
                            continue;
                        }
                        iDefaultsElement.initEnumValue(object2.linkSpeed.value());
                        continue;
                    }
                    if (string4.equals("liTimer")) {
                        if (bl) {
                            n |= iDefaultsElement.isDirty();
                            String string5 = iDefaultsElement.getValue();
                            short s = Short.parseShort(string5);
                            this.neDefaultsModel.setDefLITimer(eEqType2, eEqType3, s);
                            continue;
                        }
                        short s = this.neDefaultsModel.getDefLITimer(eEqType2, eEqType3);
                        String string6 = String.valueOf(s);
                        iDefaultsElement.initValue(string6);
                        continue;
                    }
                    this.db.severe("unknown ml2 config mapper name " + string4);
                }
                if (!bl || n == 0) continue;
                this.neDefaultsModel.setDefML2MapperEtherLineAdminInfo(eEqType2, eEqType3, (sML2MapperEtherLineAdminInfo)object2);
                n = 0;
                this.makeClean((IDefaultsNode[])object);
                continue;
            }
            this.db.severe("unknown ml2 mapper port type " + string2);
        }
    }

    private void handleCE1000(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleCE1000: nodes size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2;
            Object object;
            int n;
            Object object2;
            String string3 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string3, string)) continue;
            eEqType eEqType3 = eEqType.CE_1000_ETHER_PORT;
            if (string3.equals("config")) {
                object2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < ((IDefaultsNode[])object2).length; ++n) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)object2[n];
                    String string4 = iDefaultsElement.getName();
                    if (string4.equals("State")) {
                        this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string4.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("unknown ml2 mapper elem " + string4);
                }
                continue;
            }
            if (string3.equals("posPortConfig")) {
                eEqType3 = eEqType.CE_1000_POS_PORT;
                object2 = this.neDefaultsModel.getDefCE1000PosPortAdminInfo(eEqType2, eEqType3);
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                    object = iDefaultsElement.getName();
                    string2 = iDefaultsElement.getValue();
                    if (!((String)object).equals("FramingType")) continue;
                    if (bl) {
                        if (string2.equals("HDLC")) {
                            object2.framingType = ePosFramingType.HDLC;
                        } else if (string2.equals("GFP-F")) {
                            object2.framingType = ePosFramingType.GFP_F;
                        } else {
                            this.db.severe("Unknown CE1000 POS framing type " + string2);
                            object2.framingType = ePosFramingType.HDLC;
                        }
                        this.neDefaultsModel.setDefCE1000PosPortAdminInfo(eEqType2, eEqType3, (sML2PosPortAdminInfo)object2);
                        this.makeClean(iDefaultsNodeArray2);
                        continue;
                    }
                    if (object2.framingType == ePosFramingType.HDLC) {
                        iDefaultsElement.initValue("HDLC");
                        continue;
                    }
                    if (object2.framingType == ePosFramingType.GFP_F) {
                        iDefaultsElement.initValue("GFP-F");
                        continue;
                    }
                    this.db.severe("Unknown CE1000 POS framing type " + string2);
                    iDefaultsElement.initValue("HDLC");
                }
                continue;
            }
            if (string3.equals("etherPortConfig")) {
                eEqType3 = eEqType.CE_1000_ETHER_PORT;
                object2 = this.neDefaultsModel.getDefCE1000EtherLineAdminInfo(eEqType2, eEqType3);
                n = 0;
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray3.length; ++j) {
                    String string5;
                    object = (IDefaultsElement)iDefaultsNodeArray3[j];
                    string2 = object.getName();
                    String string6 = object.getValue();
                    if (string2.equals("FlowControl")) {
                        if (bl) {
                            object2.flowControl = string6.equals("Pass Through") ? eFlowControlNegotiated.PASS_THROUGH_FLOW_CONTROL : (string6.equals("Symmetric") ? eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL : eFlowControlNegotiated.NO_FLOW_CONTROL);
                            n = 1;
                            continue;
                        }
                        if (object2.flowControl == eFlowControlNegotiated.PASS_THROUGH_FLOW_CONTROL) {
                            object.initValue("Pass Through");
                            continue;
                        }
                        if (object2.flowControl == eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL) {
                            object.initValue("Symmetric");
                            continue;
                        }
                        object.initValue("None");
                        continue;
                    }
                    if (string2.equals("AutoNegotiation")) {
                        if (bl) {
                            object2.negotiation = this.stringToBool(string6);
                            n = 1;
                            continue;
                        }
                        object.initValue(this.boolToString(object2.negotiation));
                        continue;
                    }
                    if (string2.equals("liTimer")) {
                        if (bl) {
                            string5 = object.getValue();
                            short s = Short.parseShort(string5);
                            this.neDefaultsModel.setDefLITimer(eEqType2, eEqType3, s);
                            continue;
                        }
                        short s = this.neDefaultsModel.getDefLITimer(eEqType2, eEqType3);
                        String string7 = String.valueOf(s);
                        object.initValue(string7);
                        continue;
                    }
                    if (!string2.equals("MTU")) continue;
                    if (bl) {
                        object2.maxFrameSize = Integer.parseInt(string6);
                        n = 1;
                        continue;
                    }
                    string5 = String.valueOf(object2.maxFrameSize);
                    object.initValue(string5);
                }
                if (!bl || n == 0) continue;
                this.neDefaultsModel.setDefCE1000EtherLineAdminInfo(eEqType2, eEqType3, (sCE1000EtherLineAdminInfo)object2);
                n = 0;
                this.makeClean(iDefaultsNodeArray3);
                continue;
            }
            this.db.severe("unknown CE1000 port type " + string3);
        }
    }

    private void handleEtherConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("config")) {
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    String string3 = iDefaultsNodeArray2[j].getName();
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                    if (this.db.isFineEnabled()) {
                        this.db.fine("handleEtherConfig(): " + string3);
                    }
                    if (string3.equals("State") || string3.equals("AdminState")) {
                        this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string3.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("unknown MRC ETHER childName " + string3);
                }
                continue;
            }
            this.db.severe("unknown ASAP ETHER name " + string2);
        }
    }

    private void handleG1000(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode = iDefaultsNodeArray[i];
            String string2 = iDefaultsNode.getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (this.db.isFineEnabled()) {
                this.db.fine("handleG1000(): " + string2);
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNode.getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                String string3 = iDefaultsElement.getName();
                if (this.db.isFineEnabled()) {
                    this.db.fine("handleG1000(): " + string2 + "." + string3);
                }
                if (string3.equals("State") || string3.equals("AdminState")) {
                    this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                    continue;
                }
                if (string3.equals("AINSSoakTime")) {
                    this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                    continue;
                }
                if (string3.equals("liTimer")) {
                    this.helpHandleLITimer(eEqType2, eEqType3, iDefaultsElement, bl);
                    continue;
                }
                this.db.severe("unknown g1000 name " + string3);
            }
        }
    }

    private void handleCtx(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (this.db.isFineEnabled()) {
                this.db.fine("handleCtx() " + string2 + " " + (this.getEqTypeFromName(string2) == null ? -1 : this.getEqTypeFromName(string2).value()));
            }
            if (string2.startsWith("DS") || string2.startsWith("E1") || string2.startsWith("E3")) {
                this.handleDSn(eEqType2, this.getEqTypeFromName(string2), iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.startsWith("OC") || string2.startsWith("EC") || string2.startsWith("ST")) {
                this.handleOCn(eEqType2, this.getEqTypeFromName(string2), iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("Wideband") || string2.equals("Broadband") || string2.equals("PPM")) {
                this.handleMutablePorts(eEqType2, iDefaultsNodeArray[i], bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("config")) {
                this.handleDSnConfig(eEqType2, eEqType.DS1_VT_MAPPED, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("handleCtx(): Unknown name " + string2);
        }
    }

    private void handleOCnPhysicalThresholds(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleOCnPhysicalThresholds: ocnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("warning")) {
                this.handleOCnWarningPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string2.equals("alarm")) {
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                this.helpHandleOCnAlarmPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray2, null, bl);
                continue;
            }
            this.db.severe("Unexpected data: " + string2);
        }
    }

    private void handleOCnWarningPhysicalThresholds(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleOCnWaringPhysicalThresholds: ocnNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            eIntervalType eIntervalType2 = null;
            if (string.equals("15min")) {
                eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
            } else if (string.equals("1day")) {
                eIntervalType2 = eIntervalType.INTERVAL_DAY;
            } else if (!string.equals("alarm")) {
                this.db.severe("Unexpected data: " + string);
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            this.helpHandleOCnAlarmPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray2, eIntervalType2, bl);
        }
    }

    private void handleOCnPm(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleOCnPm: ocnPmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            string = this.trimParentName(string);
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                boolean bl2 = true;
                String string3 = iDefaultsNodeArray2[j].getName();
                if (string.length() != 0 && !this.isSameName(string3, string)) continue;
                if (string3.equals("farend")) {
                    bl2 = false;
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                string = this.trimParentName(string);
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    String string4 = iDefaultsNodeArray3[k].getName();
                    if (string.length() != 0 && !this.isSameName(string4, string)) continue;
                    if (string4.equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    this.helpHandleOCnPm(string2, eEqType2, eEqType3, iDefaultsNodeArray4, bl2, eIntervalType2, bl);
                }
            }
        }
    }

    private void handleOCnConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleOCnConfig: ocnNodes size = " + iDefaultsNodeArray.length + " Eq " + (eEqType2 == null ? -1 : eEqType2.value()) + " " + (eEqType3 == null ? -1 : eEqType3.value()) + ", applying " + bl);
        }
        ArrayList<IDefaultsNode> arrayList = new ArrayList<IDefaultsNode>();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement;
            String string2;
            int n;
            IDefaultsNode[] iDefaultsNodeArray2;
            String string3 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string3, string)) continue;
            if (string3.equals("line")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string2 = iDefaultsNodeArray2[n].getName();
                    if (string2.equalsIgnoreCase("sonet") || string2.equalsIgnoreCase("sdh")) {
                        arrayList.add(iDefaultsNodeArray2[n]);
                        continue;
                    }
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string2.equals("SFBER")) {
                        this.helpHandleSfBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("SDBER")) {
                        this.helpHandleSdBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("State") || string2.equals("AdminState")) {
                        this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("SyncMsgIn")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string2.equals("AdminSSMIn")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string2.equals("Send<FF>DoNotUse")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string2.equals("SendDoNotUse")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string2.equals("LineLength")) {
                        this.helpHandleLineLength(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("PJStsMon#")) {
                        this.helpHandlePJStsMon(eEqType2, eEqType3, iDefaultsElement, 0, bl);
                        continue;
                    }
                    if (string2.equals("PJVC3Mon#")) {
                        this.helpHandlePJStsMon(eEqType2, eEqType3, iDefaultsElement, 2, bl);
                        continue;
                    }
                    if (string2.equals("PJVC4Mon#")) {
                        this.helpHandlePJStsMon(eEqType2, eEqType3, iDefaultsElement, 1, bl);
                        continue;
                    }
                    if (string2.equals("RxEqualization")) {
                        this.helpHandleRxEqualization(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("AlsRecoveryPulseInterval")) {
                        this.helpHandleAlsRecoveryPulseInterval(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("AlsRecoveryPulseDuration")) {
                        this.helpHandleAlsRecoveryPulseDuration(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("SendAISOnFacilityLoopback")) {
                        this.helpHandleAisOnFacilityLoopback(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string2.equals("SendAISOnTerminalLoopback")) {
                        this.helpHandleAisOnTerminalLoopback(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleOCnConfig(): Unknown line config value " + string3);
                }
                continue;
            }
            if (string3.equals("sts") || string3.equals("vc4")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string2 = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (DefaultsElement)iDefaultsNodeArray2[n];
                    if (string2.equals("IPPMEnabled")) {
                        this.neDefaultsModel.handleIPPMEnabled((IDefaultsValue)((Object)iDefaultsElement), bl);
                        continue;
                    }
                    this.db.severe("Unknown sts/vc4 config value " + string3);
                }
                continue;
            }
            if (string3.equals("vclo") || string3.equals("vt")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string2 = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (DefaultsElement)iDefaultsNodeArray2[n];
                    if (string2.equals("IPPMEnabled")) {
                        this.neDefaultsModel.handleVtIPPMEnabled((IDefaultsValue)((Object)iDefaultsElement), bl);
                        continue;
                    }
                    this.db.severe("Unknown vt/vclo config value " + string3);
                }
                continue;
            }
            if (string3.equals("card")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                eEqType3 = eEqType.OTS_PORT;
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string2 = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string2.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleOCnConfig(): Unknown line config value >>" + string2 + "<< on " + iDefaultsElement.getFullName());
                }
                continue;
            }
            this.db.severe("Unknown config value " + string3);
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, this.nmd.getNcChassis().getSyncModel().getTimingStandard(), arrayList.toArray(new IDefaultsNode[arrayList.size()]), bl, this.trimParentName(string));
    }

    private void handleTNC(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("pmthresholds")) {
                this.handleOCnPm(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("config")) {
                this.handleTNCConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (!string2.equals("opticalthresholds")) continue;
            this.handleDwdmClientOpticalThresholdsPort(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
        }
    }

    private void handleTNCConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleOCnConfig: ocnNodes size = " + iDefaultsNodeArray.length + " Eq " + (eEqType2 == null ? -1 : eEqType2.value()) + " " + (eEqType3 == null ? -1 : eEqType3.value()) + ", applying " + bl);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement;
            String string2;
            int n;
            IDefaultsNode[] iDefaultsNodeArray2;
            String string3 = iDefaultsNodeArray[i].getName();
            if (string3.equals("oc3") || string3.equals("stm1")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                eEqType3 = eEqType.OC3_PORT;
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string2 = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string2.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleOCnConfig(): Unknown line config value >>" + string2 + "<< on " + iDefaultsElement.getFullName());
                }
                continue;
            }
            if (string3.equals("fe")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                eEqType3 = eEqType.FE_PORT;
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string2 = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string2.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleOCnConfig(): Unknown line config value >>" + string2 + "<< on " + iDefaultsElement.getFullName());
                }
                continue;
            }
            if (string3.equals("ge")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                eEqType3 = eEqType.ONE_GE_PORT;
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    string2 = iDefaultsNodeArray2[n].getName();
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    if (string2.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    this.db.severe("handleOCnConfig(): Unknown line config value >>" + string2 + "<< on " + iDefaultsElement.getFullName());
                }
                continue;
            }
            this.db.severe("Unknown config value " + string3);
        }
    }

    private void handleOCn(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleOCn: ocnNodes size = " + iDefaultsNodeArray.length + " Eq " + (eEqType2 == null ? -1 : eEqType2.value()) + " " + (eEqType3 == null ? -1 : eEqType3.value()) + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("physicalthresholds")) {
                this.handleOCnPhysicalThresholds(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("pmthresholds")) {
                this.handleOCnPm(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("config")) {
                this.handleOCnConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("handleOCn: Shouldnt be here...." + string2);
        }
    }

    private void helpHandleDwdmPmByDataRate(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("helpHandleDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length + ". applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDataRate eDataRate2 = null;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("oc3") || string2.equals("stm1")) {
                eDataRate2 = eDataRate.OC3;
            } else if (string2.equals("oc12") || string2.equals("stm4")) {
                eDataRate2 = eDataRate.OC12;
            } else if (string2.equals("oc48") || string2.equals("stm16")) {
                eDataRate2 = eDataRate.OC48;
            } else if (string2.equals("oc192") || string2.equals("stm64")) {
                eDataRate2 = eDataRate.OC192;
            } else if (string2.equals("1gethernet")) {
                eDataRate2 = eDataRate.ONE_GE;
            } else if (string2.equals("1gfiberchannel")) {
                eDataRate2 = eDataRate.ONE_GFC;
            } else if (string2.equals("1gficon")) {
                eDataRate2 = eDataRate.ONE_GFICON;
            } else if (string2.equals("2gfiberchannel")) {
                eDataRate2 = eDataRate.TWO_GFC;
            } else if (string2.equals("2gficon")) {
                eDataRate2 = eDataRate.TWO_GFICON;
            } else {
                this.db.severe("Unexpected data rate " + string2);
            }
            if (this.db.isFineEnabled()) {
                this.db.fine("helpHandleDwdmPm: " + string2);
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string3 = iDefaultsNodeArray2[j].getName();
                if (this.db.isFineEnabled()) {
                    this.db.fine("helpHandleDwdmPm: child1 " + string3 + " size = " + iDefaultsNodeArray2.length);
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    IDefaultsNode[] iDefaultsNodeArray4;
                    boolean bl2 = true;
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl2 = false;
                    } else if (iDefaultsNodeArray3[k].getName().equals("15min")) {
                        eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    } else if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    if (this.db.isFineEnabled()) {
                        this.db.fine("helpHandleDwdmPm: child2 " + iDefaultsNodeArray3[k].getName() + " size = " + iDefaultsNodeArray3.length);
                    }
                    if (string3.equals("8b10b")) {
                        iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                        if (bl) {
                            this.set8B10BPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray4, eIntervalType2);
                            continue;
                        }
                        this.get8B10BPmFromNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray4, eIntervalType2);
                        continue;
                    }
                    iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        if (this.db.isFineEnabled()) {
                            this.db.fine("helpHandleDwdmPm: child3 " + iDefaultsNodeArray4[i2].getName() + " size = " + iDefaultsNodeArray4.length);
                        }
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string3.equals("line") || string3.equals("ms")) {
                            if (this.db.isFineEnabled()) {
                                this.db.fine("helpHandleDwdmPm: provisioning line");
                            }
                            if (bl) {
                                this.setLinePmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                                continue;
                            }
                            this.getLinePmFromNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                            continue;
                        }
                        if (string3.equals("section") || string3.equals("rs")) {
                            if (this.db.isFineEnabled()) {
                                this.db.fine("helpHandleDwdmPm: provisioning section");
                            }
                            if (bl) {
                                this.setSectionPmToNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                                continue;
                            }
                            this.getSectionPmFromNodeVals(eEqType2, eEqType3, eDataRate2, iDefaultsNodeArray5, bl2, eIntervalType2);
                            continue;
                        }
                        this.db.severe("helpHandleDwdmPm: couldn't set from node vals for " + eDataRate2 + " " + string3 + ": eq " + eEqType2.value() + " port type " + eEqType3.value() + " buckets " + iDefaultsNodeArray5.length + " end " + bl2 + " int " + eIntervalType2.value());
                    }
                }
            }
        }
    }

    private void helpHandleDwdmPmByLineType(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("helpHandleDwdmPm: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eDwdmLineType eDwdmLineType2 = eDwdmLineType.DWDM_CLIENT;
            eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("trunk") || string2.equals("sonet") || string2.equals("sdh") || eEqType2 == eEqType.XP_4_10G_LINE_CARD) {
                eDwdmLineType2 = eDwdmLineType.DWDM_TRUNK;
                eEqType3 = eEqType.DWDM_TRUNK_PORT;
            }
            if (string2.equals("wis")) {
                bl2 = true;
                eEqType3 = eEqType.OC192_PORT;
            }
            if (this.db.isFineEnabled()) {
                this.db.fine("helpHandleDwdmPm: " + string2 + " port type= " + eEqType3.value());
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string3 = iDefaultsNodeArray2[j].getName();
                if (this.db.isFineEnabled()) {
                    this.db.fine("helpHandleDwdmPm: child1 " + string3 + " size = " + iDefaultsNodeArray2.length);
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    boolean bl3 = true;
                    if (iDefaultsNodeArray3[k].getName().equals("farend")) {
                        bl3 = false;
                    }
                    if (this.db.isFineEnabled()) {
                        this.db.fine("helpHandleDwdmPm: child2 " + iDefaultsNodeArray3[k].getName() + " size = " + iDefaultsNodeArray3.length);
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    for (int i2 = 0; i2 < iDefaultsNodeArray4.length; ++i2) {
                        eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                        if (iDefaultsNodeArray4[i2].getName().equals("1day")) {
                            eIntervalType2 = eIntervalType.INTERVAL_DAY;
                        }
                        if (this.db.isFineEnabled()) {
                            this.db.fine("helpHandleDwdmPm: child3 " + iDefaultsNodeArray4[i2].getName() + " size = " + iDefaultsNodeArray4.length);
                        }
                        IDefaultsNode[] iDefaultsNodeArray5 = iDefaultsNodeArray4[i2].getChildren();
                        if (string3.equals("line") || string3.equals("ms")) {
                            if (this.db.isFineEnabled()) {
                                this.db.fine("helpHandleDwdmPm: provisioning line");
                            }
                            if (bl) {
                                this.setLinePmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl3, eIntervalType2, bl2);
                                continue;
                            }
                            this.getLinePmFromNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl3, eIntervalType2, bl2);
                            continue;
                        }
                        if (string3.equals("section") || string3.equals("rs")) {
                            if (this.db.isFineEnabled()) {
                                this.db.fine("helpHandleDwdmPm: provisioning section");
                            }
                            if (bl) {
                                this.setSectionPmToNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl3, eIntervalType2, bl2);
                                continue;
                            }
                            this.getSectionPmFromNodeVals(eEqType2, eEqType3, eDwdmLineType2, iDefaultsNodeArray5, bl3, eIntervalType2, bl2);
                            continue;
                        }
                        if (string3.equals("sts") || string3.equals("sts1") || string3.equals("path") || string3.startsWith("sts3c") || string3.startsWith("sts12c")) {
                            eEqType eEqType4;
                            int n = 1;
                            eEqType eEqType5 = eEqType4 = eEqType2 == eEqType.ADM_10G_LINE_CARD ? eEqType.OC192_PORT : eEqType3;
                            n = string3.equals("sts1") || string3.equals("sts") || string3.equals("path") ? 1 : (string3.startsWith("sts3c") ? 3 : 12);
                            if (bl) {
                                this.setStsPathPmToNodeVals(eEqType2, eEqType4, (short)n, iDefaultsNodeArray5, bl3, eIntervalType2);
                                continue;
                            }
                            this.getStsPathPmFromNodeVals(eEqType2, eEqType4, (short)n, iDefaultsNodeArray5, bl3, eIntervalType2);
                            continue;
                        }
                        this.db.severe("helpHandleDwdmPm: couldn't set from node vals for " + string2 + " " + string3 + ": eq " + eEqType2.value() + " port type " + eEqType3.value() + " buckets " + iDefaultsNodeArray5.length + " end " + bl3 + " int " + eIntervalType2.value());
                    }
                }
            }
        }
    }

    private void handleDwdmPm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (eEqType2 == eEqType.TXP_MR_2_5G_LINE_CARD || eEqType2 == eEqType.TXPP_MR_2_5G_LINE_CARD) {
            this.helpHandleDwdmPmByDataRate(eEqType2, iDefaultsNodeArray, bl, string);
        } else if (eEqType2 == eEqType.TXP_MR_10G_LINE_CARD || eEqType2 == eEqType.MXP_2_5G_10G_LINE_CARD || eEqType2 == eEqType.TXP_MR_10E_LINE_CARD || eEqType2 == eEqType.MXP_2_5G_10E_LINE_CARD || eEqType2 == eEqType.TXP_MR_10EX_LINE_CARD || eEqType2 == eEqType.TXPP_MR_10EX_LINE_CARD || eEqType2 == eEqType.MXP_2_5G_10X_LINE_CARD || eEqType2 == eEqType.MXP_MR_10DME_LINE_CARD || eEqType2 == eEqType.MXP_MR_10DMEX_LINE_CARD || eEqType2 == eEqType.MXP_MR_2_5G_LINE_CARD || eEqType2 == eEqType.XT_40G_LINE_CARD || eEqType2 == eEqType.MXPP_MR_2_5G_LINE_CARD || eEqType2 == eEqType.XT_40E_LINE_CARD) {
            this.helpHandleDwdmPmByLineType(eEqType2, iDefaultsNodeArray, bl, string);
        } else if (eEqType2 == eEqType.XP_4_10G_LINE_CARD || eEqType2 == eEqType.XM_40G_LINE_CARD || eEqType2 == eEqType.XM_40G_CE_LINE_CARD) {
            this.helpHandleDwdmPathPm(eEqType2, iDefaultsNodeArray, bl, string);
        } else {
            this.db.severe("Unexpected nXp card type " + this.getNameFromEqType(eEqType2));
        }
    }

    private void handleDwdmOtnThresholds(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.info("handleDwdmOtnThresholds: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        eEqType eEqType3 = eEqType.DWDM_TRUNK_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (string.length() != 0 && !this.isSameName(iDefaultsNodeArray[i].getName(), string)) continue;
            eMonitorType eMonitorType2 = eMonitorType.MON_SECTION;
            if (iDefaultsNodeArray[i].getName().equals("pm")) {
                eMonitorType2 = eMonitorType.MON_PATH;
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                boolean bl2 = true;
                if (iDefaultsNodeArray2[j].getName().equals("farend")) {
                    bl2 = false;
                }
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                    if (iDefaultsNodeArray3[k].getName().equals("1day")) {
                        eIntervalType2 = eIntervalType.INTERVAL_DAY;
                    }
                    IDefaultsNode[] iDefaultsNodeArray4 = iDefaultsNodeArray3[k].getChildren();
                    if (bl) {
                        this.setOtnPmToNodeVals(eEqType2, eEqType3, iDefaultsNodeArray4, bl2, eIntervalType2, eMonitorType2);
                        continue;
                    }
                    this.getOtnPmFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray4, bl2, eIntervalType2, eMonitorType2);
                }
            }
        }
    }

    private void helpHandleDwdmFecThresholds(eEqType eEqType2, eEqType eEqType3, eDwdmFecMode eDwdmFecMode2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (string.length() != 0 && !this.isSameName(iDefaultsNodeArray[i].getName(), string)) continue;
            String string2 = iDefaultsNodeArray[i].getName();
            if (this.db.isFineEnabled()) {
                this.db.fine("Getting FEC interval of " + string2);
            }
            eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
            if (string2.equals("1day")) {
                eIntervalType2 = eIntervalType.INTERVAL_DAY;
            }
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            if (bl) {
                this.setFecPmToNodeVals(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2, iDefaultsNodeArray2);
                continue;
            }
            this.getFecPmFromNodeVals(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2, iDefaultsNodeArray2);
        }
    }

    private void handleDwdmFecThresholds(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDwdmFecThresholds: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        eEqType eEqType3 = eEqType.OC192_PORT;
        if (eEqType2 == eEqType.XP_10GE_LINE_CARD || eEqType2 == eEqType.XP_GE_LINE_CARD) {
            eEqType3 = eEqType.TEN_GE_PORT;
        } else if (eEqType2 == eEqType.XT_40G_LINE_CARD || eEqType2 == eEqType.XM_40G_LINE_CARD || eEqType2 == eEqType.XM_40G_CE_LINE_CARD || eEqType2 == eEqType.XT_40E_LINE_CARD) {
            eEqType3 = eEqType.OC768_PORT;
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (string.length() != 0 && !this.isSameName(iDefaultsNodeArray[i].getName(), string)) continue;
            eDwdmFecMode eDwdmFecMode2 = eDwdmFecMode.STANDARD_FEC;
            String string2 = iDefaultsNodeArray[i].getName();
            IDefaultsNode[] iDefaultsNodeArray2 = new IDefaultsNode[]{iDefaultsNodeArray[i]};
            if (this.db.isFineEnabled()) {
                this.db.fine("handleDwdmFecThresholds: " + string2);
            }
            if (string2.equals("oc3") || string2.equals("stm1")) {
                eEqType3 = eEqType.OC3_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("oc12") || string2.equals("stm4")) {
                eEqType3 = eEqType.OC12_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("oc48") || string2.equals("stm16")) {
                eEqType3 = eEqType.OC48_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("1gethernet")) {
                eEqType3 = eEqType.ONE_GE_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("1gfiberchannel")) {
                eEqType3 = eEqType.FC1G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("1gficon")) {
                eEqType3 = eEqType.FICON1G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("2gfiberchannel")) {
                eEqType3 = eEqType.FC2G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("2gficon")) {
                eEqType3 = eEqType.FICON2G_PORT;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("standard")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            } else if (string2.equals("enhanced")) {
                eDwdmFecMode2 = eDwdmFecMode.ENHANCED_FEC;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            }
            this.helpHandleDwdmFecThresholds(eEqType2, eEqType3, eDwdmFecMode2, iDefaultsNodeArray2, bl, this.trimParentName(string));
        }
    }

    private void handleDwdmFRRParameters(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDwdmFRRParameters: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            this.db.info("handleDwdmFRRParameters: " + string2);
            if (string2.equals("standardfec")) {
                this.helpHandleDwdmFRRconfig(eEqType2, eDwdmFecMode.STANDARD_FEC, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (!string2.equals("enhancedfec")) continue;
            this.helpHandleDwdmFRRconfig(eEqType2, eDwdmFecMode.ENHANCED_FEC, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
        }
    }

    private void handleDwdmOtn(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDwdmOtn: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("otnLines")) {
                this.helpHandleDwdmOtnLineConfig(eEqType2, string2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("g709thresholds")) {
                this.handleDwdmOtnThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("fecthresholds")) {
                this.handleDwdmFecThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("proactiveProtectionRegen")) {
                this.handleDwdmFRRParameters(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("handleDwdmOtn: unknown level " + string2);
        }
    }

    private void helpHandleDwdmOtnLineTrunkConfig(eEqType eEqType2, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        eEqType eEqType3 = eEqType.DWDM_TRUNK_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            this.db.info("helpHandleDwdmOtnLineTrunkConfig: " + string2);
            if (string2.equals("G709OTN")) {
                if (bl) continue;
                boolean bl2 = this.neDefaultsModel.getDefG709OTN(eEqType2, eEqType3);
                ((IDefaultsElement)iDefaultsNodeArray[i]).initEnumValue(bl2 ? 1 : 0);
                continue;
            }
            if (string2.equals("FEC")) {
                if (bl) continue;
                eDwdmFecMode eDwdmFecMode2 = this.neDefaultsModel.getDefFecMode(eEqType2, eEqType3);
                ((IDefaultsElement)iDefaultsNodeArray[i]).initEnumValue(eDwdmFecMode2.value());
                continue;
            }
            if (string2.equals("SDBER")) {
                this.helpHandleLineSdBerLevel(eEqType2, eEqType3, (IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string2.equals("AsynchSynchMapping")) {
                this.helpHandleMappingType(eEqType2, (IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            this.db.severe("Unknown " + string + " otnLineTrunk config value " + string2);
        }
    }

    private void helpHandleDwdmOtnLineClientConfig(eEqType eEqType2, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        eEqType eEqType3 = eEqType.OTU2_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            this.db.info("helpHandleDwdmOtnLineClientConfig: " + string2);
            if (string2.equals("FEC")) {
                if (!bl) {
                    eDwdmFecMode eDwdmFecMode2 = this.neDefaultsModel.getDefFecMode(eEqType2, eEqType3);
                    ((IDefaultsElement)iDefaultsNodeArray[i]).initEnumValue(eDwdmFecMode2.value());
                    continue;
                }
                if (!((IDefaultsElement)iDefaultsNodeArray[i]).isDirty()) continue;
                int n = ((IDefaultsElement)iDefaultsNodeArray[i]).getEnumValue();
                eDwdmFecMode eDwdmFecMode3 = eDwdmFecMode.from_int(n);
                this.neDefaultsModel.setDefG709OTN(eEqType2, eEqType.OTU2_PORT, eEqType.from_int(279), true, eDwdmFecMode3);
                continue;
            }
            if (string2.equals("SDBER")) {
                this.helpHandleLineSdBerLevel(eEqType2, eEqType3, (IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            this.db.severe("Unknown " + string + " otnLineClient config value " + string2);
        }
    }

    private void handleDwdmOpticalThresholds(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDwdmOpticalThresholds: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            boolean bl2 = false;
            if (string2.equals("client")) {
                this.handleDwdmClientOpticalThresholdsPort(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("trunk")) {
                if (iDefaultsNodeArray[i].getChildren()[0].getName().equals("oc192") || iDefaultsNodeArray[i].getChildren()[0].getName().equals("stm64") || iDefaultsNodeArray[i].getChildren()[0].getName().equals("10gethernet")) {
                    this.handlePluggableTrunkOpticalThresholdsPort(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                this.handleDwdmTrunkOpticalThresholds2rFec(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, bl2, this.trimParentName(string));
                continue;
            }
            if (string2.equals("interlink")) {
                bl2 = true;
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                String string3 = string;
                if (iDefaultsNodeArray2[0].getName().equals("oc192") || iDefaultsNodeArray2[0].getName().equals("stm64")) {
                    iDefaultsNodeArray2 = iDefaultsNodeArray2[0].getChildren();
                    string3 = this.trimParentName(string);
                }
                this.handleDwdmTrunkOpticalThresholds2rFec(eEqType2, iDefaultsNodeArray2, bl, bl2, this.trimParentName(string3));
                continue;
            }
            throw new Exception("handleDwdmOpticalThresholds: bad line type " + string2);
        }
    }

    private eReach getOpticalReach(String string) throws Exception {
        eReach eReach2;
        if (this.reachMap == null) {
            this.reachMap = new HashMap<String, eReach>();
            this.reachMap.put("sr", eReach.SR);
            this.reachMap.put("sr1", eReach.SR_1);
            this.reachMap.put("sr2", eReach.SR_2);
            this.reachMap.put("sr3", eReach.SR_3);
            this.reachMap.put("sr5", eReach.SR_5);
            this.reachMap.put("ir1", eReach.IR_1);
            this.reachMap.put("ir2", eReach.IR_2);
            this.reachMap.put("ir3", eReach.IR_3);
            this.reachMap.put("ir5", eReach.IR_5);
            this.reachMap.put("lr", eReach.LR);
            this.reachMap.put("lr1", eReach.LR_1);
            this.reachMap.put("lr2", eReach.LR_2);
            this.reachMap.put("lr3", eReach.LR_3);
            this.reachMap.put("lr5", eReach.LR_5);
            this.reachMap.put("p1l1", eReach.P1L1);
            this.reachMap.put("v2", eReach.V2);
            this.reachMap.put("v3", eReach.V3);
            this.reachMap.put("i1", eReach.I1);
            this.reachMap.put("i2", eReach.I2);
            this.reachMap.put("i3", eReach.I3);
            this.reachMap.put("i5", eReach.I5);
            this.reachMap.put("s1", eReach.S1);
            this.reachMap.put("s2", eReach.S2);
            this.reachMap.put("s3", eReach.S3);
            this.reachMap.put("s5", eReach.S5);
            this.reachMap.put("l1", eReach.L1);
            this.reachMap.put("l2", eReach.L2);
            this.reachMap.put("l3", eReach.L3);
            this.reachMap.put("l5", eReach.L5);
            this.reachMap.put("sx", eReach.SX);
            this.reachMap.put("lx", eReach.LX);
            this.reachMap.put("cx", eReach.CX);
            this.reachMap.put("t", eReach.T);
            this.reachMap.put("dx", eReach.DX);
            this.reachMap.put("hx", eReach.HX);
            this.reachMap.put("zx", eReach.ZX);
            this.reachMap.put("vx", eReach.VX);
            this.reachMap.put("ew", eReach.EW);
            this.reachMap.put("lw", eReach.LW);
            this.reachMap.put("sw", eReach.SW);
            this.reachMap.put("lrm", eReach.LRM);
            this.reachMap.put("er", eReach.ER);
            this.reachMap.put("sm", eReach.SM);
            this.reachMap.put("mm", eReach.MM);
            this.reachMap.put("mx", eReach.MX);
            this.reachMap.put("zr", eReach.ZR);
            this.reachMap.put("cwdm", eReach.CWDM);
            this.reachMap.put("dwdm", eReach.DWDM);
            this.reachMap.put("vsr", eReach.VSR);
            this.reachMap.put("cwdm40km", eReach.CWDM_40km);
            this.reachMap.put("ulh", eReach.ULH);
        }
        if ((eReach2 = this.reachMap.get(string)) == null) {
            eReach2 = eReach.REACH_UNKNOWN;
            this.db.info("DefaultsTree.getOpticalReach: Reach string = " + string + ", setting to REACH_UNKNOWN");
        }
        return eReach2;
    }

    private eIntervalType getOpticalInterval(String string) throws Exception {
        eIntervalType eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
        if (string.equals("15min")) {
            eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
        } else if (string.equals("1day")) {
            eIntervalType2 = eIntervalType.INTERVAL_DAY;
        } else if (string.equals("alarm")) {
            eIntervalType2 = eIntervalType.INTERVAL_VARIABLE;
        } else {
            throw new Exception("DefaultsTree.getOpticalInterval: The interval string " + string + " is invalid.");
        }
        return eIntervalType2;
    }

    private void handleDwdmClientOpticalThresholdsInterval(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, eEqType eEqType3, eClientOpticsVariant eClientOpticsVariant2, eReach eReach2, boolean bl) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDwdmClientOpticalThresholdsInterval: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eIntervalType eIntervalType2 = this.getOpticalInterval(iDefaultsNodeArray[i].getName());
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            if (this.db.isInfoEnabled()) {
                this.db.info(" \n eqpt  = " + eEqType2.value() + " portType = " + eEqType3 + " thrVar = " + eClientOpticsVariant2.value() + " reach = " + eReach2.value() + " inType = " + eIntervalType2.value() + " thresholdBuckets = " + iDefaultsNodeArray2 + " applying = " + bl);
            }
            if (bl) {
                this.setClientOpticalThresholdsToNodeVals(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2, iDefaultsNodeArray2);
                continue;
            }
            this.getClientOpticalThresholdsFromNodeVals(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2, iDefaultsNodeArray2);
        }
    }

    private void handleDwdmClientOpticalThresholdsCdwdm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, eEqType eEqType3, boolean bl, String string) throws Exception {
        this.db.info("handleDwdmClientOpticalThresholdsCdwdm: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        eClientOpticsVariant eClientOpticsVariant2 = eClientOpticsVariant.DEFAULT_CLIENT_OPTICS;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            boolean bl2;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            this.db.info("handleDwdmClientOpticalThresholdsCdwdm: thrVar or reach = " + string2);
            boolean bl3 = bl2 = eEqType2 == eEqType.XM_40G_CE_LINE_CARD || eEqType2 == eEqType.XM_40G_LINE_CARD || eEqType2 == eEqType.XT_40G_LINE_CARD || eEqType2 == eEqType.XT_40E_LINE_CARD;
            if (string2.equals("cwdm") && eEqType2 != eEqType.XP_GE_LINE_CARD || string2.equals("dwdm") || bl2 && string2.equals("cwdm40km")) {
                this.handleDwdmClientOpticalThresholdsReach(eEqType2, iDefaultsNodeArray[i], eEqType3, eClientOpticsVariant2, bl);
                continue;
            }
            eReach eReach2 = this.getOpticalReach(string2);
            if (eReach2 == eReach.REACH_UNKNOWN) {
                this.db.severe("handleDwdmClientOpticalThresholdsCdwdm: bad reach = " + string2 + " on " + iDefaultsNodeArray[i].getFullName());
                continue;
            }
            this.handleDwdmClientOpticalThresholdsInterval(eEqType2, iDefaultsNodeArray[i].getChildren(), eEqType3, eClientOpticsVariant2, eReach2, bl);
        }
    }

    private void handlePluggableTrunkOpticalThresholdsCdwdm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        this.db.info("handlePluggableTrunkOpticalThresholdsCdwdm: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            this.db.info("handlePluggableTrunkOpticalThresholdsCdwdm: thrVar or reach = " + string2);
            eReach eReach2 = this.getOpticalReach(string2);
            if (eReach2 == eReach.REACH_UNKNOWN) {
                this.db.severe("handlePluggableTrunkOpticalThresholdsReach: bad reach = " + string2 + " on " + iDefaultsNodeArray[i].getFullName());
                continue;
            }
            eTrunkOpticsVariant eTrunkOpticsVariant2 = eTrunkOpticsVariant.DEFAULT_TRUNK_OPTICS;
            this.handlePluggableTrunkOpticalThreshold2rFec(eEqType2, iDefaultsNodeArray[i].getChildren(), eTrunkOpticsVariant2, eReach2, bl, this.trimParentName(string));
        }
    }

    private void handlePluggableTrunkOpticalThreshold2rFec(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, eTrunkOpticsVariant eTrunkOpticsVariant2, eReach eReach2, boolean bl, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            eDwdmFecMode eDwdmFecMode2 = this.getFecMode(string2);
            this.db.info("handlePluggableTrunkOpticalThresholdsCdwdm: fecMode = " + string2);
            this.handlePluggableTrunkOpticalThresholdsInterval(eEqType2, iDefaultsNodeArray[i].getChildren(), eTrunkOpticsVariant2, eReach2, eDwdmFecMode2, bl, this.trimParentName(string));
        }
    }

    private void handlePluggableTrunkOpticalThresholdsInterval(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, eTrunkOpticsVariant eTrunkOpticsVariant2, eReach eReach2, eDwdmFecMode eDwdmFecMode2, boolean bl, String string) throws Exception {
        this.db.info("handlePluggableTrunkOpticalThresholdsInterval: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            if (string.length() != 0 && !this.isSameName(iDefaultsNodeArray[i].getName(), string)) continue;
            eIntervalType eIntervalType2 = this.getOpticalInterval(iDefaultsNodeArray[i].getName());
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            if (bl) {
                this.setTrunkOpticalThresholdsToNodeVals(eEqType2, eReach2, eDwdmFecMode2, eTrunkOpticsVariant2, eIntervalType2, iDefaultsNodeArray2);
                continue;
            }
            this.getTrunkOpticalThresholdsFromNodeVals(eEqType2, eReach2, eDwdmFecMode2, eTrunkOpticsVariant2, eIntervalType2, iDefaultsNodeArray2);
        }
    }

    private void handleDwdmClientOpticalThresholdsReach(eEqType eEqType2, IDefaultsNode iDefaultsNode, eEqType eEqType3, eClientOpticsVariant eClientOpticsVariant2, boolean bl) throws Exception {
        this.db.info("handleDwdmClientOpticalThresholdsReach: , applying " + bl);
        eReach eReach2 = this.getOpticalReach(iDefaultsNode.getName());
        if (eReach2 == eReach.REACH_UNKNOWN) {
            this.db.severe("handleDwdmClientOpticalThresholdsReach: bad reach = " + iDefaultsNode.getName() + " on " + iDefaultsNode.getFullName());
        } else if (!(eEqType3 != eEqType.OTU2_PORT && eEqType3 != eEqType.OTU3_PORT || eReach2 != eReach.DWDM && eReach2 != eReach.CWDM_40km)) {
            IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string = iDefaultsNodeArray[i].getName();
                eDwdmFecMode eDwdmFecMode2 = this.getFecMode(string);
                this.handleClientOpticalThresholdsIntervalFec(eEqType2, iDefaultsNodeArray[i].getChildren(), eEqType3, eClientOpticsVariant2, eReach2, eDwdmFecMode2, bl);
            }
        } else {
            this.handleDwdmClientOpticalThresholdsInterval(eEqType2, iDefaultsNode.getChildren(), eEqType3, eClientOpticsVariant2, eReach2, bl);
        }
    }

    private void handleClientOpticalThresholdsIntervalFec(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, eEqType eEqType3, eClientOpticsVariant eClientOpticsVariant2, eReach eReach2, eDwdmFecMode eDwdmFecMode2, boolean bl) throws Exception {
        this.db.info("handleClientOpticalThresholdsIntervalFec: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            eIntervalType eIntervalType2 = this.getOpticalInterval(iDefaultsNodeArray[i].getName());
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            if (bl) {
                this.setClientOpticalThresholdsToNodeVals(eEqType2, eEqType3, eReach2, eDwdmFecMode2, eClientOpticsVariant2, eIntervalType2, iDefaultsNodeArray2);
                continue;
            }
            this.getClientOpticalThresholdsFromNodeVals(eEqType2, eEqType3, eReach2, eDwdmFecMode2, eClientOpticsVariant2, eIntervalType2, iDefaultsNodeArray2);
        }
    }

    private void getClientOpticalThresholdsFromNodeVals(eEqType eEqType2, eEqType eEqType3, eReach eReach2, eDwdmFecMode eDwdmFecMode2, eClientOpticsVariant eClientOpticsVariant2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("getClientOpticalThresholdsFromNodeVals" + iDefaultsNodeArray.length);
        }
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefClientOpticsThrFEC(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eDwdmFecMode2, eIntervalType2);
        this.helpGetOpticalThresholdsFromNodeVals(sLaserThresholds2, iDefaultsNodeArray);
    }

    private void setClientOpticalThresholdsToNodeVals(eEqType eEqType2, eEqType eEqType3, eReach eReach2, eDwdmFecMode eDwdmFecMode2, eClientOpticsVariant eClientOpticsVariant2, eIntervalType eIntervalType2, IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        sLaserThresholds sLaserThresholds2 = this.neDefaultsModel.getDefClientOpticsThrFEC(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eDwdmFecMode2, eIntervalType2);
        sLaserThresholds sLaserThresholds3 = this.helpSetOpticalThresholdsToNodeVals(iDefaultsNodeArray, sLaserThresholds2);
        if (sLaserThresholds3 != null) {
            this.neDefaultsModel.setDefClientOpticsThrFEC(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eDwdmFecMode2, eIntervalType2, sLaserThresholds3);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private eDwdmFecMode getFecMode(String string) {
        eDwdmFecMode eDwdmFecMode2 = eDwdmFecMode.DISABLE_FEC;
        eDwdmFecMode2 = string.equals("standardfec") ? eDwdmFecMode.STANDARD_FEC : (string.equals("enhancedfec") ? eDwdmFecMode.ENHANCED_FEC : (string.equals("disabledfec") ? eDwdmFecMode.DISABLE_FEC : eDwdmFecMode.DISABLE_FEC));
        return eDwdmFecMode2;
    }

    private void handleDwdmClientOpticalThresholdsPort(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        this.db.info("handleDwdmClientOpticalThresholdsPort: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = (eEqType)this.neDefaultsModel.lookup(string2);
            if (eEqType3 == null) {
                eEqType3 = eEqType.INVALID;
                throw new Exception("handleDwdmClientOpticalThresholdsPort: bad port type " + string2);
            }
            this.db.info("handleDwdmClientOpticalThresholdsPort: portStr = " + string2 + ": portType = " + this.getNameFromEqType(eEqType3));
            this.handleDwdmClientOpticalThresholdsCdwdm(eEqType2, iDefaultsNodeArray[i].getChildren(), eEqType3, bl, this.trimParentName(string));
        }
    }

    private void handlePluggableTrunkOpticalThresholdsPort(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        this.db.info("handlePluggableTrunkOpticalThresholdsPort: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            eEqType eEqType3 = eEqType.INVALID;
            this.db.info("handlePluggableTrunkOpticalThresholdsPort: portStr = " + string2 + ": portType = " + this.getNameFromEqType(eEqType3));
            this.handlePluggableTrunkOpticalThresholdsCdwdm(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
        }
    }

    private void handleDwdmTrunkOpticalThresholds2rFec(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, boolean bl2, String string) throws Exception {
        this.db.info("handleDwdmTrunkOpticalThresholds2RFec: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        eTrunkOpticsVariant eTrunkOpticsVariant2 = eTrunkOpticsVariant.DEFAULT_TRUNK_OPTICS;
        eDwdmFecMode eDwdmFecMode2 = eDwdmFecMode.DISABLE_FEC;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            this.db.info("handleDwdmTrunkOpticalThresholds2RFec:  name " + string2);
            if (string2.equals("2r")) {
                eTrunkOpticsVariant2 = eTrunkOpticsVariant.IS_2R;
                eDwdmFecMode2 = eDwdmFecMode.DISABLE_FEC;
                this.handlePluggableTrunkOpticalThresholdsInterval(eEqType2, iDefaultsNodeArray[i].getChildren(), eTrunkOpticsVariant2, eReach.REACH_AUTOPROV, eDwdmFecMode2, bl, this.trimParentName(string));
                continue;
            }
            eTrunkOpticsVariant2 = bl2 ? eTrunkOpticsVariant.IS_INTERLINK : eTrunkOpticsVariant.DEFAULT_TRUNK_OPTICS;
            if (iDefaultsNodeArray[i].getName().equals("sr1") || iDefaultsNodeArray[i].getName().equals("i1") || iDefaultsNodeArray[i].getName().equals("lr") || iDefaultsNodeArray[i].getName().equals("sr")) {
                eReach eReach2 = this.getOpticalReach(iDefaultsNodeArray[i].getName());
                IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                String string3 = this.trimParentName(string);
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    String string4 = iDefaultsNodeArray2[j].getName();
                    if (string.length() != 0 && !this.isSameName(string4, string3)) continue;
                    eDwdmFecMode2 = this.getFecMode(string4);
                    this.handlePluggableTrunkOpticalThresholdsInterval(eEqType2, iDefaultsNodeArray2[j].getChildren(), eTrunkOpticsVariant2, eReach2, eDwdmFecMode2, bl, this.trimParentName(string3));
                }
                continue;
            }
            eDwdmFecMode2 = this.getFecMode(string2);
            this.handlePluggableTrunkOpticalThresholdsInterval(eEqType2, iDefaultsNodeArray[i].getChildren(), eTrunkOpticsVariant2, eReach.REACH_AUTOPROV, eDwdmFecMode2, bl, this.trimParentName(string));
        }
    }

    private void helpHandleODUkOHMode(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eDwdmPathMonitoring eDwdmPathMonitoring2 = eDwdmPathMonitoring.from_int(n);
                this.neDefaultsModel.setDefODUkMode(eEqType2, eDwdmPathMonitoring2);
                iDefaultsElement.makeClean();
            }
        } else {
            eDwdmPathMonitoring eDwdmPathMonitoring3 = this.neDefaultsModel.getDefODUkMode(eEqType2);
            iDefaultsElement.initEnumValue(eDwdmPathMonitoring3.value());
        }
    }

    private void helpHandleODUTransparency(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eDwdmOduTransparency eDwdmOduTransparency2 = eDwdmOduTransparency.from_int(n);
                this.neDefaultsModel.setDefODUTransparency(eEqType2, eDwdmOduTransparency2);
                iDefaultsElement.makeClean();
            }
        } else {
            eDwdmOduTransparency eDwdmOduTransparency3 = this.neDefaultsModel.getDefODUTransparency(eEqType2);
            iDefaultsElement.initEnumValue(eDwdmOduTransparency3.value());
        }
    }

    private void helpHandleOverclock(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eDwdmOverClock eDwdmOverClock2 = eDwdmOverClock.from_int(n);
                this.neDefaultsModel.setDefOverclock(eEqType2, eDwdmOverClock2);
                iDefaultsElement.makeClean();
            }
        } else {
            eDwdmOverClock eDwdmOverClock3 = this.neDefaultsModel.getDefOverclock(eEqType2);
            iDefaultsElement.initEnumValue(eDwdmOverClock3.value());
        }
    }

    private void helpHandleEnableFRR(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eDwdmProactiveProtection eDwdmProactiveProtection2 = eDwdmProactiveProtection.from_int(n);
                this.neDefaultsModel.setDefProactiveProtection(eEqType2, eDwdmProactiveProtection2);
                iDefaultsElement.makeClean();
            }
        } else {
            eDwdmProactiveProtection eDwdmProactiveProtection3 = this.neDefaultsModel.getDefProactiveProtection(eEqType2);
            iDefaultsElement.initEnumValue(eDwdmProactiveProtection3.value());
        }
    }

    private void helpGetTermMode(eEqType eEqType2, IDefaultsElement iDefaultsElement) throws Exception {
        eTermMode eTermMode2 = this.neDefaultsModel.getDefTermMode(eEqType2);
        iDefaultsElement.initEnumValue(eTermMode2.value());
    }

    private void helpGetAisSquelchMode(eEqType eEqType2, IDefaultsElement iDefaultsElement) throws Exception {
        eAisSquelchMode eAisSquelchMode2 = this.neDefaultsModel.getDefAisSquelchMode(eEqType2);
        iDefaultsElement.initEnumValue(eAisSquelchMode2.value());
    }

    private void helpSetTermModeAndAisSquelchMode(eEqType eEqType2, IDefaultsElement iDefaultsElement, IDefaultsElement iDefaultsElement2) throws Exception {
        boolean bl = false;
        eTermMode eTermMode2 = null;
        eAisSquelchMode eAisSquelchMode2 = null;
        if (iDefaultsElement == null) {
            eTermMode2 = eTermMode.TERM_TRANSPARENT;
        } else {
            if (iDefaultsElement.isDirty()) {
                bl = true;
            }
            eTermMode2 = eTermMode.from_int(iDefaultsElement.getEnumValue());
        }
        if (iDefaultsElement2 == null) {
            eAisSquelchMode2 = eAisSquelchMode.MODE_DISABLE;
        } else {
            if (iDefaultsElement2.isDirty()) {
                bl = true;
            }
            eAisSquelchMode2 = eAisSquelchMode.from_int(iDefaultsElement2.getEnumValue());
        }
        if (bl) {
            if (this.db.isFineEnabled()) {
                this.db.fine("Setting  termMode " + eTermMode2.value() + " aisSquelchMode " + eAisSquelchMode2.value());
            }
            this.neDefaultsModel.setDefDwdmCardConfig(eEqType2, eTermMode2, eAisSquelchMode2);
            if (iDefaultsElement != null) {
                iDefaultsElement.makeClean();
            }
            if (iDefaultsElement2 != null) {
                iDefaultsElement2.makeClean();
            }
        }
    }

    private void helpHandleDwdmLineConfig(eEqType eEqType2, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string2) throws Exception {
        eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
        if (string.equals("trunk")) {
            eEqType3 = eEqType.DWDM_TRUNK_PORT;
        } else if (string.equals("interlink")) {
            eEqType3 = eEqType.INTERLINK_TRUNK_PORT;
        } else if (string.equals("wis")) {
            eEqType3 = eEqType.OC192_PORT;
        }
        if (eEqType2 == eEqType.XP_4_10G_LINE_CARD) {
            eEqType3 = eEqType.DWDM_TRUNK_PORT;
        }
        ArrayList<IDefaultsNode> arrayList = new ArrayList<IDefaultsNode>();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            String string3;
            String string4 = iDefaultsNodeArray[i].getName();
            if (string2.length() != 0 && !this.isSameName(string4, string2)) continue;
            if (this.db.isInfoEnabled()) {
                this.db.info("helpHandleDwdmLineConfig: " + string + " " + string4);
            }
            if (string4.equalsIgnoreCase("sonet") || string4.equalsIgnoreCase("sdh")) {
                arrayList.add(iDefaultsNodeArray[i]);
                continue;
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            if (string4.equals("ppmPortAssignment") || string4.equals("ppmSlotAssignment") || string4.equals("mrPortAssignment")) {
                if (eEqType2 == eEqType.XM_40G_LINE_CARD || eEqType2 == eEqType.XM_40G_CE_LINE_CARD || eEqType2 == eEqType.XT_40G_LINE_CARD || eEqType2 == eEqType.XT_40E_LINE_CARD) {
                    if (((DefaultsElement)iDefaultsElement).getCousinElement("//.trunk.Overclock").isDirty()) continue;
                    this.handleConfigurableDwdmPorts(eEqType2, iDefaultsElement, bl);
                    continue;
                }
                this.handleConfigurableDwdmPorts(eEqType2, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("State") || string4.equals("AdminState")) {
                this.helpHandleAdminState(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("AINSSoakTime")) {
                this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("ODUkOHMode") && (this.cardName.equals("TXP-MR-10EX") || this.cardName.equals("TXPP-MR-10EX"))) {
                this.helpHandleODUkOHMode(eEqType2, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("OduTransparency")) {
                this.helpHandleODUTransparency(eEqType2, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("Overclock")) {
                string3 = "client.ppmPortAssignment";
                if (eEqType2 == eEqType.XT_40G_LINE_CARD || eEqType2 == eEqType.XT_40E_LINE_CARD) {
                    string3 = "client.mrPortAssignment";
                }
                if (((DefaultsElement)iDefaultsElement).getCousinElement("//." + string3).isDirty()) {
                    object = ((DefaultsElement)iDefaultsElement).getCousinElement("//." + string3);
                    String string5 = object.getValue();
                    object.setValue("UNASSIGNED");
                    this.handleConfigurableDwdmPorts(eEqType2, (IDefaultsNode)object, bl);
                    this.helpHandleOverclock(eEqType2, iDefaultsElement, bl);
                    object.setValue(string5);
                    this.handleConfigurableDwdmPorts(eEqType2, (IDefaultsNode)object, bl);
                    continue;
                }
                this.helpHandleOverclock(eEqType2, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("ProactiveProtectionRegen")) {
                this.helpHandleEnableFRR(eEqType2, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("TerminationMode")) {
                if (!bl) {
                    this.helpGetTermMode(eEqType2, iDefaultsElement);
                    continue;
                }
                this.helpSetTermModeAndAisSquelchMode(eEqType2, iDefaultsElement, iDefaultsElement.getSiblingElement("AisSquelchMode"));
                continue;
            }
            if (string4.equals("AisSquelchMode")) {
                if (bl) {
                    this.helpSetTermModeAndAisSquelchMode(eEqType2, iDefaultsElement.getSiblingElement("TerminationMode"), iDefaultsElement);
                    continue;
                }
                this.helpGetAisSquelchMode(eEqType2, iDefaultsElement);
                continue;
            }
            if (string4.equals("SFBER")) {
                this.helpHandleSfBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("SDBER")) {
                this.helpHandleSdBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("AlsMode")) {
                this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("AlsRecoveryPulseInterval")) {
                this.helpHandleAlsRecoveryPulseInterval(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("AlsRecoveryPulseDuration")) {
                this.helpHandleAlsRecoveryPulseDuration(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string4.equals("SyncMsgIn")) {
                arrayList.add(iDefaultsElement);
                continue;
            }
            if (string4.equals("SendDoNotUse")) {
                arrayList.add(iDefaultsElement);
                continue;
            }
            if (string4.equals("PJStsMon#") || string4.equals("PJVC3Mon#") || string4.equals("PJVC4Mon#")) {
                string3 = iDefaultsElement.getName();
                Object object2 = object = eEqType3 == eEqType.DWDM_TRUNK_PORT ? eEqType.OC192_PORT : eEqType3;
                if (string3.equals("PJStsMon#")) {
                    this.helpHandlePJStsMon(eEqType2, (eEqType)object, iDefaultsElement, 0, bl);
                    continue;
                }
                if (string4.equals("PJVC3Mon#")) {
                    this.helpHandlePJStsMon(eEqType2, (eEqType)object, iDefaultsElement, 2, bl);
                    continue;
                }
                if (string4.equals("PJVC4Mon#")) {
                    this.helpHandlePJStsMon(eEqType2, (eEqType)object, iDefaultsElement, 1, bl);
                    continue;
                }
                this.db.severe("Unknown sts/vc4 config value" + string);
                continue;
            }
            if (string4.equals("IPPMEnabled")) {
                string3 = iDefaultsElement.getName();
                if (string3.equals("IPPMEnabled")) {
                    object = (DefaultsElement)iDefaultsElement;
                    this.neDefaultsModel.handleIPPMEnabled((IDefaultsValue)object, bl);
                    continue;
                }
                this.db.severe("Unknown sts/vc4 config value" + string);
                continue;
            }
            this.db.severe("helpHandleDwdmLineConfig(): Unknown line config value >>" + string4 + "<< on " + iDefaultsElement.getFullName());
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, this.nmd.getNcChassis().getSyncModel().getTimingStandard(), arrayList.toArray(new IDefaultsNode[0]), bl, string2);
    }

    private void helpHandleWlDrift(eEqType eEqType2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                int n = iDefaultsElement.getEnumValue();
                eWvlDriftMode eWvlDriftMode2 = eWvlDriftMode.from_int(n);
                this.neDefaultsModel.setDefWvlDriftMode(eEqType2, eWvlDriftMode2);
                iDefaultsElement.makeClean();
            }
        } else {
            eWvlDriftMode eWvlDriftMode3 = this.neDefaultsModel.getDefWvlDriftMode(eEqType2);
            iDefaultsElement.initEnumValue(eWvlDriftMode3.value());
        }
    }

    private void helpHandleOptConfig(eEqType eEqType2, eEqType eEqType3, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            this.db.info("helpHandleOptConfig: " + string + " " + string2);
            if (string2.equals("AlsMode")) {
                this.helpHandleAlsMode(eEqType2, eEqType3, iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("WavelengthDrift")) {
                this.helpHandleWlDrift(eEqType2, iDefaultsElement, bl);
                continue;
            }
            this.db.severe("helpHandleOptLineConfig(): Unknown line config value >>" + string2 + "<< on " + iDefaultsElement.getFullName());
        }
    }

    private void helpHandleDwdmOtnLineConfig(eEqType eEqType2, String string, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string2) throws Exception {
        eEqType eEqType3 = eEqType.DWDM_TRUNK_PORT;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string3 = iDefaultsNodeArray[i].getName();
            if (string2.length() != 0 && !string.equalsIgnoreCase(string2)) continue;
            if (this.db.isInfoEnabled()) {
                this.db.info("helpHandleDwdmOtnLineConfig: " + string3);
            }
            if (string3.equals("G709OTN")) {
                if (!bl) {
                    boolean bl2 = this.neDefaultsModel.getDefG709OTN(eEqType2, eEqType3);
                    ((IDefaultsElement)iDefaultsNodeArray[i]).initEnumValue(bl2 ? 1 : 0);
                    continue;
                }
                this.handleConfigurableDwdmPorts(eEqType2, iDefaultsNodeArray[i], true);
                continue;
            }
            if (string3.equals("FEC")) {
                if (!bl) {
                    eDwdmFecMode eDwdmFecMode2 = this.neDefaultsModel.getDefFecMode(eEqType2, eEqType3);
                    ((IDefaultsElement)iDefaultsNodeArray[i]).initEnumValue(eDwdmFecMode2.value());
                    continue;
                }
                this.handleConfigurableDwdmPorts(eEqType2, iDefaultsNodeArray[i], true);
                continue;
            }
            if (string3.equals("SDBER")) {
                this.helpHandleLineSdBerLevel(eEqType2, eEqType3, (IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string3.equals("AsynchSynchMapping")) {
                this.helpHandleMappingType(eEqType2, (IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string3.equals("trunk") && (this.cardName.equals("TXPP-MR-10EX") || this.cardName.equals("TXP-MR-10EX"))) {
                this.helpHandleDwdmOtnLineTrunkConfig(eEqType2, string, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            if (string3.equals("client") && (this.cardName.equals("TXPP-MR-10EX") || this.cardName.equals("TXP-MR-10EX"))) {
                this.helpHandleDwdmOtnLineClientConfig(eEqType2, string, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("Unknown " + string + " otnLines config value " + string3);
        }
    }

    private void helpHandleDwdmFRRconfig(eEqType eEqType2, eDwdmFecMode eDwdmFecMode2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = true;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            sProactiveProtectionConfig sProactiveProtectionConfig2;
            String string2 = iDefaultsNodeArray[i].getName();
            this.db.info("helpHandleDwdmFRRconfig: " + string2);
            if (string2.equals("TriggerThreshold")) {
                if (!bl) {
                    sProactiveProtectionConfig2 = this.neDefaultsModel.getDefFRRConfig(eEqType2, eDwdmFecMode2);
                    ((IDefaultsElement)iDefaultsNodeArray[i]).initEnumValue(sProactiveProtectionConfig2.triggerThreshold.value());
                    continue;
                }
                if (((IDefaultsElement)iDefaultsNodeArray[i]).isDirty()) {
                    bl2 = true;
                }
                n = ((IDefaultsElement)iDefaultsNodeArray[i]).getEnumValue();
                continue;
            }
            if (string2.equals("RevertThreshold")) {
                if (!bl) {
                    sProactiveProtectionConfig2 = this.neDefaultsModel.getDefFRRConfig(eEqType2, eDwdmFecMode2);
                    ((IDefaultsElement)iDefaultsNodeArray[i]).initEnumValue(sProactiveProtectionConfig2.revertThreshold.value());
                    continue;
                }
                if (((IDefaultsElement)iDefaultsNodeArray[i]).isDirty()) {
                    bl2 = true;
                }
                n2 = ((IDefaultsElement)iDefaultsNodeArray[i]).getEnumValue();
                continue;
            }
            if (string2.equals("TriggerWindow")) {
                if (!bl) {
                    sProactiveProtectionConfig2 = this.neDefaultsModel.getDefFRRConfig(eEqType2, eDwdmFecMode2);
                    ((IDefaultsElement)iDefaultsNodeArray[i]).initValue(String.valueOf(sProactiveProtectionConfig2.triggerWindow));
                    continue;
                }
                if (((IDefaultsElement)iDefaultsNodeArray[i]).isDirty()) {
                    bl2 = true;
                }
                n3 = Integer.parseInt(((IDefaultsElement)iDefaultsNodeArray[i]).getValue());
                continue;
            }
            if (!string2.equals("RevertWindow")) continue;
            if (!bl) {
                sProactiveProtectionConfig2 = this.neDefaultsModel.getDefFRRConfig(eEqType2, eDwdmFecMode2);
                ((IDefaultsElement)iDefaultsNodeArray[i]).initValue(String.valueOf(sProactiveProtectionConfig2.revertWindow));
                continue;
            }
            if (((IDefaultsElement)iDefaultsNodeArray[i]).isDirty()) {
                bl2 = true;
            }
            n4 = Integer.parseInt(((IDefaultsElement)iDefaultsNodeArray[i]).getValue());
        }
        if (bl && bl2) {
            sProactiveProtectionConfig sProactiveProtectionConfig3 = new sProactiveProtectionConfig();
            sProactiveProtectionConfig3.triggerThreshold = eTriggerThreshold.from_int(n);
            sProactiveProtectionConfig3.revertThreshold = eRevertThreshold.from_int(n2);
            sProactiveProtectionConfig3.triggerWindow = n3;
            sProactiveProtectionConfig3.revertWindow = n4;
            this.neDefaultsModel.setDefFRRConfig(eEqType2, eDwdmFecMode2, sProactiveProtectionConfig3);
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                if (!((IDefaultsElement)iDefaultsNodeArray[i]).isDirty()) continue;
                ((IDefaultsElement)iDefaultsNodeArray[i]).makeClean();
            }
        }
    }

    private void handleDwdmConfig(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDwdmConfig: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        ArrayList<IDefaultsElement> arrayList = new ArrayList<IDefaultsElement>();
        eEqType eEqType3 = eEqType.DWDM_CLIENT_PORT;
        IDefaultsNode iDefaultsNode = null;
        IDefaultsNode iDefaultsNode2 = null;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode[] iDefaultsNodeArray2;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("fc")) {
                if (bl) {
                    iDefaultsNode2 = iDefaultsNodeArray[i];
                    continue;
                }
                this.getFcmrConfigFromNodeVals(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            if (string2.equals("card")) {
                if (bl) {
                    iDefaultsNode = iDefaultsNodeArray[i];
                    continue;
                }
                this.getCardMode(eEqType2, iDefaultsNodeArray[i].getChildren());
                continue;
            }
            if (string2.equals("client") || string2.equals("trunk") || string2.equals("interlink") || string2.equals("port") || string2.equals("wis")) {
                this.helpHandleDwdmLineConfig(eEqType2, string2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("ppmSlotAssignment")) {
                iDefaultsNodeArray2 = (IDefaultsNode[])iDefaultsNodeArray[i];
                this.handleConfigurableDwdmPorts(eEqType2, (IDefaultsNode)iDefaultsNodeArray2, bl);
                continue;
            }
            if (string2.equals("payload") || string2.equals("sonet") || string2.equals("sdh")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    String string3 = iDefaultsNodeArray2[j].getName();
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[j];
                    if (string3.equals("SFBER")) {
                        this.helpHandleSfBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string3.equals("SDBER")) {
                        this.helpHandleSdBerLevel(eEqType2, eEqType3, iDefaultsElement, bl);
                        continue;
                    }
                    if (string3.equals("SyncMsgIn")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    if (string3.equals("SendDoNotUse")) {
                        arrayList.add(iDefaultsElement);
                        continue;
                    }
                    this.db.severe("handleDwdmConfig(): Unknown payload/sonet/trunk config value " + string2 + " " + string3);
                }
                continue;
            }
            this.db.severe("Unknown dwdm config value " + string2);
        }
        if (bl && iDefaultsNode != null && iDefaultsNode2 != null) {
            this.setFcmrConfigToNodeVals(eEqType2, eEqType3, iDefaultsNode.getChildren(), iDefaultsNode2.getChildren());
        }
        this.handleLineSyncConfig(eEqType2, eEqType3, this.nmd.getNcChassis().getSyncModel().getTimingStandard(), arrayList.toArray(new IDefaultsNode[0]), bl, string);
    }

    private void handleDwdm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleDwdm: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (this.db.isFineEnabled()) {
                this.db.fine("handleDwdm: name = " + string2);
            }
            if (string2.equals("pmthresholds")) {
                this.handleDwdmPm(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("otn")) {
                this.handleDwdmOtn(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("opticalthresholds")) {
                this.handleDwdmOpticalThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("config")) {
                this.handleDwdmConfig(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("handleDwdm: Shouldnt be here....");
        }
    }

    private void handleADM(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleADM: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (this.db.isFineEnabled()) {
                this.db.fine("handleADM: name = " + string2);
            }
            if (string2.equals("pmthresholds")) {
                this.handleAdmPm(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("otn")) {
                this.handleDwdmOtn(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("opticalthresholds")) {
                this.handleDwdmOpticalThresholds(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("config")) {
                boolean bl2 = false;
                for (int j = 0; j < iDefaultsNodeArray[i].getChildren().length; ++j) {
                    if (iDefaultsNodeArray[i].getChildren()[j].getName().equals("oc3") || iDefaultsNodeArray[i].getChildren()[j].getName().equals("oc12") || iDefaultsNodeArray[i].getChildren()[j].getName().equals("oc48") || iDefaultsNodeArray[i].getChildren()[j].getName().equals("stm1") || iDefaultsNodeArray[i].getChildren()[j].getName().equals("stm4") || iDefaultsNodeArray[i].getChildren()[j].getName().equals("stm16")) {
                        bl2 = true;
                    }
                    if (bl2) {
                        this.handleADMConfig(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                        bl2 = false;
                        continue;
                    }
                    this.handleDwdmConfig(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                }
                continue;
            }
            if (string2.equals("etherPortConfig")) {
                this.handleADMEtherPortConfig(eEqType2, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("handleADM: Shouldnt be here....");
        }
    }

    private void handleAdmPm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleAdmPm: mrcNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        block4: for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = this.getAdmPortTypeFromName(string2);
            if (this.db.isFineEnabled()) {
                this.db.fine("handleAdmPm: port eEqType= " + eEqType3.value());
            }
            switch (eEqType3.value()) {
                case 28: 
                case 29: 
                case 30: {
                    this.handleOCnPm(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                    continue block4;
                }
                case 123: {
                    IDefaultsNode[] iDefaultsNodeArray2 = new IDefaultsNode[]{iDefaultsNodeArray[i]};
                    this.helpHandleDwdmPmByLineType(eEqType2, iDefaultsNodeArray2, bl, string);
                    continue block4;
                }
                default: {
                    this.db.severe("handleAdmPm: unknown port eEqType= " + eEqType3.value());
                }
            }
        }
    }

    private void helpHandleDwdmPathPm(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleOtu2Pm: pmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode[] iDefaultsNodeArray2;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("sts192c") || string2.equals("path")) {
                iDefaultsNodeArray2 = new IDefaultsNode[]{iDefaultsNodeArray[i]};
                if (string2.equals("sts192c")) {
                    this.handleOCnPm(eEqType2, this.getEqTypeFromName("OC192-PORT"), iDefaultsNodeArray2, bl, this.trimParentName(string));
                    continue;
                }
                this.handleOCnPm(eEqType2, this.getEqTypeFromName("STM64-PORT"), iDefaultsNodeArray2, bl, this.trimParentName(string));
                continue;
            }
            iDefaultsNodeArray2 = new IDefaultsNode[]{iDefaultsNodeArray[i]};
            this.helpHandleDwdmPmByLineType(eEqType2, iDefaultsNodeArray2, bl, string);
        }
    }

    private void handleADMConfig(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleADMConfig: mrcNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        block3: for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            eEqType eEqType3 = this.getAdmPortTypeFromName(string2);
            if (this.db.isFineEnabled()) {
                this.db.fine("handleADMConfig: port eEqType= " + eEqType3.value());
            }
            switch (eEqType3.value()) {
                case 28: 
                case 29: 
                case 30: {
                    this.handleOCnConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                    continue block3;
                }
                default: {
                    this.db.severe("handleADMConfig: unknown port eEqType= " + eEqType3.value());
                }
            }
        }
    }

    private eEqType getAdmPortTypeFromName(String string) {
        eEqType eEqType2 = eEqType.INVALID;
        if (string.equals("oc3") || string.equals("stm1")) {
            eEqType2 = eEqType.OC3_PORT;
        } else if (string.equals("oc12") || string.equals("stm4")) {
            eEqType2 = eEqType.OC12_PORT;
        } else if (string.equals("oc48") || string.equals("stm16")) {
            eEqType2 = eEqType.OC48_PORT;
        } else if (string.equals("trunk")) {
            eEqType2 = eEqType.DWDM_TRUNK_PORT;
        } else {
            this.db.severe("getMrcPortTypeFromName: unexpected port eEqType= " + eEqType2.value());
        }
        return eEqType2;
    }

    private void handleADMEtherPortConfig(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        eEqType eEqType3 = eEqType.ONE_GE_PORT;
        sL1Info sL1Info2 = this.neDefaultsModel.getDefXPGEL1EtherInfo(eEqType2, eEqType3);
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            String string3 = iDefaultsElement.getValue();
            if (string2.equals("AutoNegotiation")) {
                if (bl) {
                    if (string3.equals("1000 Mbps")) {
                        sL1Info2.speed = eEtherSpeed.ETHER_SPEED_1000;
                    } else if (string3.equals("Auto")) {
                        sL1Info2.speed = eEtherSpeed.ETHER_SPEED_AUTO;
                    }
                    bl2 = true;
                    continue;
                }
                if (sL1Info2.speed == eEtherSpeed.ETHER_SPEED_1000) {
                    iDefaultsElement.initValue("1000 Mbps");
                    continue;
                }
                if (sL1Info2.speed != eEtherSpeed.ETHER_SPEED_AUTO) continue;
                iDefaultsElement.initValue("Auto");
                continue;
            }
            if (string2.equals("MTU")) {
                if (bl) {
                    sL1Info2.mtu = string3.equals("Jumbo") ? 9216 : Integer.parseInt(string3);
                    bl2 = true;
                    continue;
                }
                if (sL1Info2.mtu == 9216) {
                    iDefaultsElement.initValue("Jumbo");
                    continue;
                }
                String string4 = String.valueOf(sL1Info2.mtu);
                iDefaultsElement.initValue(string4);
                continue;
            }
            if (!string2.equals("AINSSoakTime")) continue;
            this.helpHandleSoakTime(eEqType2, eEqType3, iDefaultsElement, bl);
        }
        if (bl && bl2) {
            this.neDefaultsModel.setDefXPGEL1EtherInfo(eEqType2, eEqType3, sL1Info2);
            bl2 = false;
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void handleOptConfig(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleOptConfig: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("card")) {
                this.helpHandleOptConfig(eEqType2, eEqType3, string, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("Unknown dwdm config value " + string);
        }
    }

    private void handleOpt(eEqType eEqType2, eEqType eEqType3, IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        this.db.info("handleOpt: dwdmNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            this.db.info("handleOpt: name = " + string);
            if (string.equals("config")) {
                this.handleOptConfig(eEqType2, eEqType3, iDefaultsNodeArray[i].getChildren(), bl);
                continue;
            }
            this.db.severe("handleOpt: Shouldnt be here....");
        }
    }

    private void handleMrc(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleMrc: mrcNodes size = " + iDefaultsNodeArray.length + ", applying " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("ETHER-PORT")) {
                this.handleEtherConfig(eEqType2, this.getEqTypeFromName(string2), iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.handleOCn(eEqType2, this.getEqTypeFromName(string2), iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
        }
    }

    private void handleMutablePorts(eEqType eEqType2, IDefaultsNode iDefaultsNode, boolean bl, String string) throws Exception {
        String string2 = iDefaultsNode.getName();
        if (this.db.isInfoEnabled()) {
            this.db.info("handleMutablePorts " + string2);
        }
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string3 = iDefaultsElement.getName();
            String string4 = iDefaultsElement.getValue();
            eEqType eEqType3 = eEqType.INVALID;
            if (string2.equals("PPM")) {
                if (string3.equals("slotAssignment")) {
                    eEqType3 = eEqType.PPM_SLOT;
                } else if (string3.equals("portAssignment")) {
                    eEqType3 = eEqType.PPM_1_PORT;
                } else {
                    this.db.severe("Unknown pluggable container name " + string2 + " " + string3);
                }
            } else if (string2.equals("Wideband")) {
                eEqType3 = eEqType.WBE_SLOT;
            } else if (string2.equals("Broadband")) {
                eEqType3 = eEqType.BBE_SLOT;
            } else if (string2.equals("MR")) {
                eEqType3 = eEqType.MR_SLOT;
            } else {
                this.db.severe("Unknown pluggable container name " + string2 + " " + string3);
            }
            eEqType eEqType4 = eEqType.INVALID;
            if (bl) {
                if (iDefaultsElement.isDirty()) {
                    eEqType4 = this.getEqTypeFromName(string4);
                    this.neDefaultsModel.setDefPluggableEqType(eEqType2, eEqType3, eEqType4);
                    iDefaultsElement.makeClean();
                }
            } else {
                eEqType4 = this.neDefaultsModel.getDefPluggableEqType(eEqType2, eEqType3);
                string4 = this.getNameFromEqType(eEqType4);
                iDefaultsElement.initValue(string4);
            }
            if (!this.db.isInfoEnabled()) continue;
            this.db.info("Mutable equipment type on " + this.getNameFromEqType(eEqType2) + " " + eEqType2.value() + " " + string2 + " " + eEqType4.value() + " " + string3 + " is " + string4);
        }
    }

    private void handleConfigurableDwdmPorts(eEqType eEqType2, IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        Object object;
        DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNode;
        String string = defaultsElement.getName();
        if (this.db.isInfoEnabled()) {
            this.db.info("handleConfigurableDwdmPorts " + string);
        }
        eEqType eEqType3 = eEqType.INVALID;
        boolean bl2 = false;
        if (string.equals("ppmPortAssignment")) {
            eEqType3 = eEqType.PPM_1_PORT;
            bl2 = true;
            if (eEqType2.equals(eEqType.ADM_10G_LINE_CARD)) {
                object = iDefaultsNode.getParent().getName();
                if (((String)object).equals("trunk")) {
                    eEqType3 = eEqType.DWDM_TRUNK_PORT;
                    bl2 = false;
                } else if (((String)object).equals("interlink")) {
                    eEqType3 = eEqType.INTERLINK_TRUNK_PORT;
                    bl2 = false;
                } else {
                    this.db.severe("unknown ADM container " + (String)object);
                }
            }
            if (eEqType2.equals(eEqType.XP_GE_LINE_CARD)) {
                eEqType3 = eEqType.DWDM_CLIENT_PORT;
                bl2 = false;
            }
        } else if (string.equals("ppmSlotAssignment")) {
            eEqType3 = eEqType.PPM_SLOT;
            if (eEqType2.equals(eEqType.XP_GE_LINE_CARD)) {
                eEqType3 = eEqType.DWDM_CLIENT_PORT;
                bl2 = false;
            }
        } else if (string.equals("mrPortAssignment")) {
            eEqType3 = eEqType.MR_SLOT;
            bl2 = true;
        } else if (string.equals("G709OTN") || string.equals("FEC")) {
            eEqType3 = eEqType2.equals(eEqType.ADM_10G_LINE_CARD) ? eEqType.DWDM_TRUNK_PORT : eEqType.PPM_1_PORT;
            bl2 = true;
        } else {
            this.db.severe("Unknown pluggable container name " + string + " " + string);
        }
        object = eEqType.INVALID;
        if (bl) {
            IDefaultsElement iDefaultsElement;
            IDefaultsElement iDefaultsElement2;
            int n;
            if ((eEqType2.equals(eEqType.XP_10GE_LINE_CARD) || eEqType2.equals(eEqType.XP_GE_LINE_CARD)) && bl2) {
                object = this.neDefaultsModel.getDefPluggableEqType(eEqType2, eEqType.DWDM_TRUNK_PORT);
            } else if (eEqType2.equals(eEqType.ADM_10G_LINE_CARD) && bl2) {
                object = this.neDefaultsModel.getDefPluggableEqType(eEqType2, eEqType3);
            } else {
                n = defaultsElement.getEnumValue();
                object = eEqType.from_int(n);
            }
            if (eEqType2 == eEqType.TXP_MR_10EX_LINE_CARD || eEqType2 == eEqType.TXPP_MR_10EX_LINE_CARD) {
                iDefaultsElement2 = defaultsElement.getCousinElement("//.//.otn.otnLines.trunk.G709OTN");
                iDefaultsElement = defaultsElement.getCousinElement("//.//.otn.otnLines.trunk.FEC");
            } else if (eEqType2 == eEqType.XP_10GE_LINE_CARD || eEqType2 == eEqType.XP_GE_LINE_CARD || eEqType2 == eEqType.ADM_10G_LINE_CARD) {
                if (string.equals("G709OTN")) {
                    iDefaultsElement2 = defaultsElement;
                    iDefaultsElement = defaultsElement.getSiblingElement("FEC");
                } else if (string.equals("FEC")) {
                    iDefaultsElement2 = defaultsElement.getSiblingElement("G709OTN");
                    iDefaultsElement = defaultsElement;
                } else {
                    iDefaultsElement2 = defaultsElement.getCousinElement("//.//.otn.otnLines.G709OTN");
                    iDefaultsElement = defaultsElement.getCousinElement("//.//.otn.otnLines.FEC");
                }
            } else {
                iDefaultsElement2 = defaultsElement.getCousinElement("//.//.otn.otnLines.G709OTN");
                iDefaultsElement = defaultsElement.getCousinElement("//.//.otn.otnLines.FEC");
            }
            if (!bl2 || iDefaultsElement2 == null || iDefaultsElement == null) {
                if (defaultsElement.isDirty()) {
                    this.neDefaultsModel.setDefPluggableEqType(eEqType2, eEqType3, (eEqType)object);
                    defaultsElement.makeClean();
                }
            } else if (defaultsElement.isDirty() || iDefaultsElement2.isDirty() || iDefaultsElement.isDirty()) {
                n = iDefaultsElement2.getEnumValue();
                boolean bl3 = n == 1;
                n = iDefaultsElement.getEnumValue();
                eDwdmFecMode eDwdmFecMode2 = eDwdmFecMode.from_int(n);
                if (eEqType2 != eEqType.XP_10GE_LINE_CARD && eEqType2 != eEqType.XP_GE_LINE_CARD) {
                    this.neDefaultsModel.setDefG709OTN(eEqType2, eEqType3, (eEqType)object, bl3, eDwdmFecMode2);
                }
                this.neDefaultsModel.setDefG709OTN(eEqType2, eEqType.DWDM_TRUNK_PORT, (eEqType)object, bl3, eDwdmFecMode2);
                defaultsElement.makeClean();
                iDefaultsElement2.makeClean();
                iDefaultsElement.makeClean();
            }
        } else {
            if (eEqType2 == eEqType.XP_GE_LINE_CARD && (string.equals("ppmPortAssignment") || string.equals("ppmSlotAssignment"))) {
                eEqType3 = eEqType.DWDM_CLIENT_PORT;
            }
            object = this.neDefaultsModel.getDefPluggableEqType(eEqType2, eEqType3);
            defaultsElement.initEnumValue(((eEqType)object).value());
        }
        if (this.db.isInfoEnabled()) {
            this.db.info("Configurable equipment type on " + this.getNameFromEqType(eEqType2) + " " + eEqType2.value() + ((eEqType)object).value() + " " + string + " is " + defaultsElement.getEnumValue());
        }
    }

    private void handleNodeCircuits(IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            String string2 = "";
            String string3 = iDefaultsNodeArray[i].getName();
            if (string3.equals("upsr") || string3.equals("sncp")) {
                object = iDefaultsNodeArray[i].getChildren();
                for (int j = 0; j < ((IDefaultsNode[])object).length; ++j) {
                    String string4 = object[j].getName();
                    DefaultsElement defaultsElement = (DefaultsElement)object[j];
                    if (string4.equals("Revertive") || string4.equals("ReversionTime")) {
                        IRevertiveBehavior iRevertiveBehavior = this.nmd.getUpsrReversion();
                        sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior);
                        string2 = string4.equals("Revertive") ? this.boolToString(sRevertiveBehavior2.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (string4.equals("ReversionTime") ? String.valueOf((double)sRevertiveBehavior2.reversionTime / 60.0) : "UNKNOWN");
                        defaultsElement.initValue(string2);
                        continue;
                    }
                    if (string4.equals("STS_SFBER") || string4.equals("HO_SFBER")) {
                        short s = this.nmd.getUpsrSfBerLevel(2);
                        defaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string4.equals("STS_SDBER") || string4.equals("HO_SDBER")) {
                        short s = this.nmd.getUpsrSdBerLevel(2);
                        defaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string4.equals("VT_SFBER") || string4.equals("LO_SFBER")) {
                        short s = this.nmd.getUpsrSfBerLevel(1);
                        defaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string4.equals("VT_SDBER") || string4.equals("LO_SDBER")) {
                        short s = this.nmd.getUpsrSdBerLevel(1);
                        defaultsElement.initEnumValue(s);
                        continue;
                    }
                    if (string4.equals("SwitchOnPDIP")) {
                        boolean bl = this.nmd.getUpsrSwitchOnPdip();
                        string2 = this.boolToString(bl);
                        defaultsElement.initValue(string2);
                        continue;
                    }
                    if (string4.equals("AllowUpsrOverOnePlusOne") || string4.equals("AllowSncpOverOnePlusOne")) {
                        this.neDefaultsModel.handleAllowUpsrOverOnePlusOne(defaultsElement, false);
                        continue;
                    }
                    if (defaultsElement.isDisplacedProperty()) {
                        this.handleTreelessDefaults(defaultsElement, false);
                        continue;
                    }
                    this.db.severe("Unknown node circuit upsr/sncp " + string3);
                }
                continue;
            }
            if (string3.equals("State") || string3.equals("AdminState")) {
                object = (IDefaultsElement)iDefaultsNodeArray[i];
                object.initEnumValue(this.neDefaultsModel.getDefaultCircuitAdminState().value());
                continue;
            }
            if (string3.equals("SendPDIP")) {
                ((IDefaultsElement)iDefaultsNodeArray[i]).initValue(this.boolToString(this.nmd.getSendPDIP()));
                continue;
            }
            this.db.severe("Unknown node circuit " + string3);
        }
    }

    private void handleNodeProtection(IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            Object object;
            Object object2;
            int n;
            String string2 = "";
            String string3 = iDefaultsNodeArray[i].getName();
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            if (string3.equals("1+1") || string3.equals("lmsp")) {
                boolean bl = this.neDefaultsModel.getDefOnePlusOneBidir();
                sRevertiveBehavior sRevertiveBehavior2 = this.neDefaultsModel.getDefOnePlusOneRev();
                if (sRevertiveBehavior2 == null) {
                    throw new Exception("The 1+1 revertive behavior is null.");
                }
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    object2 = iDefaultsNodeArray2[n].getName();
                    if (((String)object2).equals("BidirectionalSwitching")) {
                        string2 = this.boolToString(bl);
                    } else if (((String)object2).equals("Revertive")) {
                        string2 = this.boolToString(sRevertiveBehavior2.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR);
                    } else if (((String)object2).equals("ReversionTime")) {
                        string2 = String.valueOf((double)sRevertiveBehavior2.reversionTime / 60.0);
                    } else if (((String)object2).equals("RecoveryGuardTimer")) {
                        object = this.neDefaultsModel.getDefRecoveryGuardTimer();
                        string2 = RECOVERY_GUARD_TIMERS[((eRecoveryGuardTimer)object).value()];
                    } else if (((String)object2).equals("VerifyGuardTimer")) {
                        object = this.neDefaultsModel.getDefVerifyGuardTimer();
                        string2 = VERIFY_GUARD_TIMERS[((eVerifyGuardTimer)object).value()];
                    } else if (((String)object2).equals("DetectionGuardTimer")) {
                        object = this.neDefaultsModel.getDefDetectionGuardTimer();
                        string2 = DETECTION_GUARD_TIMERS[((eDetectionGuardTimer)object).value()];
                    } else {
                        string2 = "UNKNOWN";
                    }
                    object = (IDefaultsElement)iDefaultsNodeArray2[n];
                    object.initValue(string2);
                }
                continue;
            }
            if (string3.equals("blsr") || string3.equals("msspr")) {
                sRevertiveBehavior sRevertiveBehavior3 = this.neDefaultsModel.getDefBlsrRingRev();
                sRevertiveBehavior sRevertiveBehavior4 = this.neDefaultsModel.getDefBlsrSpanRev();
                if (sRevertiveBehavior4 == null) {
                    throw new Exception("The BLSR span revertive behavior is null.");
                }
                if (sRevertiveBehavior3 == null) {
                    throw new Exception("The BLSR ring revertive behavior is null.");
                }
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    object2 = iDefaultsNodeArray2[n].getName();
                    string2 = ((String)object2).equals("SpanRevertive") ? this.boolToString(sRevertiveBehavior4.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (((String)object2).equals("SpanReversionTime") ? String.valueOf((double)sRevertiveBehavior4.reversionTime / 60.0) : (((String)object2).equals("RingRevertive") ? this.boolToString(sRevertiveBehavior3.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (((String)object2).equals("RingReversionTime") ? String.valueOf((double)sRevertiveBehavior3.reversionTime / 60.0) : "UNKNOWN")));
                    object = (IDefaultsElement)iDefaultsNodeArray2[n];
                    object.initValue(string2);
                }
                continue;
            }
            if (string3.startsWith("ycable")) {
                boolean bl = this.neDefaultsModel.getDefYCableBidir();
                sRevertiveBehavior sRevertiveBehavior5 = this.neDefaultsModel.getDefYCableRev();
                if (sRevertiveBehavior5 == null) {
                    throw new Exception("The Y-cable revertive behavior is null.");
                }
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    object2 = iDefaultsNodeArray2[n].getName();
                    string2 = ((String)object2).equals("BidirectionalSwitching") ? this.boolToString(bl) : (((String)object2).equals("Revertive") ? this.boolToString(sRevertiveBehavior5.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (((String)object2).equals("ReversionTime") ? String.valueOf((double)sRevertiveBehavior5.reversionTime / 60.0) : "UNKNOWN"));
                    object = (IDefaultsElement)iDefaultsNodeArray2[n];
                    object.initValue(string2);
                }
                continue;
            }
            if (string3.startsWith("splitter")) {
                sRevertiveBehavior sRevertiveBehavior6 = this.neDefaultsModel.getDefSplittRev();
                if (sRevertiveBehavior6 == null) {
                    throw new Exception("The splitter revertive behavior is null.");
                }
                for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                    String string4 = iDefaultsNodeArray2[j].getName();
                    string2 = string4.equals("Revertive") ? this.boolToString(sRevertiveBehavior6.reversionMode == eReversionMode.REVERTIVE_BEHAVIOR) : (string4.equals("ReversionTime") ? String.valueOf((double)sRevertiveBehavior6.reversionTime / 60.0) : "UNKNOWN");
                    object2 = (IDefaultsElement)iDefaultsNodeArray2[j];
                    object2.initValue(string2);
                }
                continue;
            }
            string2 = "UNKNOWN";
        }
    }

    private String getStringFromCableType(eCableType eCableType2) {
        String string = "UNKNOWN";
        switch (eCableType2.value()) {
            case 0: {
                string = "75 ohm";
                break;
            }
            case 1: {
                string = "120 ohm";
                break;
            }
            case 2: {
                string = "100 ohm";
                break;
            }
        }
        return string;
    }

    private void handleNodeTiming(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        IDefaultsNode iDefaultsNode = null;
        IDefaultsNode iDefaultsNode2 = null;
        IDefaultsNode iDefaultsNode3 = null;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (string2.equals("bits-1")) {
                iDefaultsNode2 = iDefaultsNodeArray[i];
                continue;
            }
            if (string2.equals("bits-2")) {
                iDefaultsNode3 = iDefaultsNodeArray[i];
                continue;
            }
            if (string2.equals("general")) {
                iDefaultsNode = iDefaultsNodeArray[i];
                continue;
            }
            this.db.severe("handleNodeTiming: unknown element= " + string2);
        }
        if (iDefaultsNode != null) {
            this.helpHandleTimingGeneral(iDefaultsNode.getChildren(), bl, this.trimParentName(string));
        }
        if (iDefaultsNode2 != null) {
            this.helpHandleBits(iDefaultsNode2.getChildren(), eBits.BITS_1, bl, this.trimParentName(string));
        }
        if (iDefaultsNode3 != null) {
            this.helpHandleBits(iDefaultsNode3.getChildren(), eBits.BITS_2, bl, this.trimParentName(string));
        }
    }

    private void helpHandleAccessState(eAccessMechanism eAccessMechanism2, IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                securityModel.setAccessState(AccessMechanism.from_int(eAccessMechanism2.value()), AccessState.from_int(iDefaultsElement.getEnumValue()));
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(securityModel.getAccessState(AccessMechanism.from_int(eAccessMechanism2.value())).intValue());
        }
    }

    private void helpHandleNodeSecurity(IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        String string = iDefaultsNode.getName();
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        if (string.equals("lanAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string2 = iDefaultsElement.getName();
                String string3 = iDefaultsElement.getValue();
                if (this.db.isFineEnabled()) {
                    this.db.fine("helpHandleNodeSecurity: " + string + " " + string2);
                }
                if (string2.equals("LANAccess")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        this.pendingApplications.put(string2, iDefaultsElement);
                        continue;
                    }
                    iDefaultsElement.initValue(securityModel.getLANAccess().toString());
                    continue;
                }
                if (string2.equals("RestoreTimeout")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setLANAccessTimeout(Integer.parseInt(string3));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityModel.getLANAccessTimeout()));
                    continue;
                }
                this.db.severe("Unknown security access " + string2);
            }
        } else if (string.equals("serialCraftAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string4 = iDefaultsElement.getName();
                String string5 = iDefaultsElement.getValue();
                if (this.db.isFineEnabled()) {
                    this.db.fine("helpHandleNodeSecurity: " + string + " " + string4);
                }
                if (string4.equals("EnableCraftPort") || string4.equals("EnableCraftPortA")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setSerialPortAccess(eSerialPortId.CRAFT_PORT_A, string5.equals("TRUE"));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(securityModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_A)));
                    continue;
                }
                if (string4.equals("EnableCraftPortB")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setSerialPortAccess(eSerialPortId.CRAFT_PORT_B, string5.equals("TRUE"));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(securityModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_B)));
                    continue;
                }
                this.db.severe("helpHandleNodeSecurity(): unknown security access " + string4);
            }
        } else if (string.equals("shellAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string6 = iDefaultsElement.getName();
                String string7 = iDefaultsElement.getValue();
                if (this.db.isFineEnabled()) {
                    this.db.fine("helpHandleNodeSecurity(): " + string + " " + string6);
                }
                if (string6.equals("EnableShellPassword")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        if (string7.equals("TRUE")) {
                            securityModel.setEnforceShellPasswordOn();
                        } else {
                            securityModel.setEnforceShellPasswordOff(this.password);
                        }
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(this.boolToString(securityModel.isEnforceShellPassword()));
                    continue;
                }
                if (string6.equals("TelnetPort")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setTelnetPort(Integer.parseInt(iDefaultsElement.getValue()));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityModel.getTelnetPort()));
                    continue;
                }
                if (string6.equals("AccessState")) {
                    this.helpHandleAccessState(eAccessMechanism.SHELL_ACCESS, iDefaultsElement, bl);
                    continue;
                }
                this.db.severe("helpHandleNodeSecurity(): unknown security shell access " + string6);
            }
        } else if (string.equals("pseudoIOSAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string8 = iDefaultsElement.getName();
                String string9 = iDefaultsElement.getValue();
                if (this.db.isFineEnabled()) {
                    this.db.fine("helpHandleNodeSecurity(): " + string + " " + string8);
                }
                if (string8.equals("Port")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setPCLIPort(Integer.parseInt(iDefaultsElement.getValue()));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityModel.getPCLIPort()));
                    continue;
                }
                if (string8.equals("SecurePort")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityModel.setPCLISecurePort(Integer.parseInt(iDefaultsElement.getValue()));
                        iDefaultsElement.makeClean();
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityModel.getPCLISecurePort()));
                    continue;
                }
                if (string8.equals("AccessState")) {
                    this.helpHandleAccessState(eAccessMechanism.PCLI_ACCESS, iDefaultsElement, bl);
                    continue;
                }
                this.db.severe("helpHandleNodeSecurity(): unknown security pcli access " + string8);
            }
        } else if (string.equals("tl1Access")) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[0];
            String string10 = iDefaultsElement.getName();
            if (string10.equals("AccessState")) {
                this.helpHandleAccessState(eAccessMechanism.TL1_ACCESS, iDefaultsElement, bl);
            } else {
                this.db.severe("helpHandleNodeSecurity(): Unknown security tl1 access " + string10);
            }
        } else if (string.equals("emsAccess")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string11 = iDefaultsElement.getName();
                if (string11.equals("AccessState")) {
                    this.helpHandleAccessState(eAccessMechanism.EMS_ACCESS, iDefaultsElement, bl);
                    continue;
                }
                if (string11.equals("IIOPListenerPort")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        this.pendingApplications.put(string11, iDefaultsElement);
                        continue;
                    }
                    int n = this.nmd.getIpConfig().getIiopPort();
                    if (n < 0) {
                        n += 65536;
                    }
                    iDefaultsElement.initValue(String.valueOf(n));
                    continue;
                }
                this.db.severe("helpHandleNodeSecurity(): unknown security ems access " + string11);
            }
        } else if (string.equals("snmpAccess")) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[0];
            String string12 = iDefaultsElement.getName();
            if (string12.equals("AccessState")) {
                this.helpHandleAccessState(eAccessMechanism.SNMP_ACCESS, iDefaultsElement, bl);
            } else {
                this.db.severe("helpHandleNodeSecurity(): unknown security snmp access " + string12);
            }
        } else if (string.equals("radiusServer")) {
            this.handleNodeNetworkSecurity(iDefaultsNode.getChildren(), bl);
        } else if (string.equals("radiusServerList")) {
            this.handleNodeRadiusServerList(iDefaultsNode.getChildren(), bl);
        } else if (string.equals("legalDisclaimer")) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[0];
            String string13 = iDefaultsElement.getValue();
            if (bl) {
                if (iDefaultsElement.isDirty()) {
                    ((SecurityModel)this.nmd.getSecurityModel()).setLegalDisclaimer(string13);
                    iDefaultsElement.makeClean();
                }
            } else {
                iDefaultsElement.initValue(((SecurityModel)this.nmd.getSecurityModel()).getLegalDisclaimer());
            }
        } else if (string.equals("grantPermission")) {
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                String string14 = iDefaultsElement.getName();
                if (this.db.isFineEnabled()) {
                    this.db.fine("helpHandleNodeSecurity(): " + string + " " + string14);
                }
                Operation operation = null;
                if (string14.equals("PMClearingPrivilege")) {
                    operation = Operation.CLEAR_PM;
                } else if (string14.equals("ActivateRevertSoftware")) {
                    operation = Operation.ACTIVATE_REVERT_SW;
                } else if (string14.equals("RetrieveAuditLog")) {
                    operation = Operation.RETRIEVE_AUDIT;
                } else if (string14.equals("RestoreDB")) {
                    operation = Operation.RESTORE_DB;
                } else {
                    this.db.severe("helpHandleNodeSecurity: unknown operation = " + string14);
                    continue;
                }
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityModel.setOperationPrivilege(operation, SecurityLevel.from_int((int)iDefaultsElement.getEnumValue()));
                    iDefaultsElement.makeClean();
                    continue;
                }
                iDefaultsElement.initEnumValue(securityModel.getOperationPrivilege(operation).value());
            }
        } else {
            this.db.severe("helpHandleNodeSecurity(): unknown " + string);
        }
    }

    private void helpHandleNodeSecureModeConfig(IDefaultsElement iDefaultsElement, String string) throws Exception {
        ISecureIpConfig iSecureIpConfig = this.nmd.getSecureIpConfig();
        String string2 = iDefaultsElement.getName();
        String string3 = "";
        if (this.db.isFineEnabled()) {
            this.db.fine("helpHandleNodeSecureModeConfig(): " + string2);
        }
        if (string2.equals("SecureModeOn")) {
            boolean bl = iSecureIpConfig.isSecureMode();
            string3 = this.boolToString(bl);
        } else if (string2.equals("SecureModeLocked")) {
            string3 = this.boolToString(iSecureIpConfig.isPermanentSecureMode());
        } else if (string2.equals("CtcBackplaneIpDisplaySuppression")) {
            string3 = this.boolToString(this.nmd.getCtcIpDisplaySuppression(false));
        } else if (string2.equals("LcdBackplaneIpSetting")) {
            int n = this.nmd.getLcdIpSetting(false);
            string3 = 0 <= n && n < LcdIpSetting.LCD_IP_SETTING.length ? LcdIpSetting.LCD_IP_SETTING[n] : LcdIpSetting.LCD_IP_SETTING[0];
        } else {
            string3 = "UNKNOWN";
            this.db.severe("helpHandleNodeSecureModeConfig: unknown element= " + string2);
        }
        iDefaultsElement.initEnumPass1();
        iDefaultsElement.initValue(string3);
    }

    private void handleNodeSecureModeConfig(IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("ctc")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], false);
                continue;
            }
            DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNodeArray[i];
            if (defaultsElement.isDisplacedProperty()) {
                this.handleTreelessDefaults(defaultsElement, false);
                continue;
            }
            if (string2.equals("isSecureModeSupportedOnControlCard")) {
                boolean bl = this.nmd.supportsSecureMode();
                defaultsElement.initEnumValue(bl ? 1 : 0);
                continue;
            }
            if (this.nmd.supportsSecureMode()) {
                this.helpHandleNodeSecureModeConfig(defaultsElement, string);
                continue;
            }
            this.db.severe(defaultsElement.getFullName() + " is " + NOT_SUPPORTED);
            defaultsElement.initValue(NOT_SUPPORTED);
        }
    }

    private void applyNodeSecureModeConfig(IDefaultsNode[] iDefaultsNodeArray) throws Exception {
        if (this.nmd.supportsSecureMode()) {
            boolean bl;
            IDefaultsElement iDefaultsElement = null;
            IDefaultsElement iDefaultsElement2 = null;
            for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                String string = iDefaultsNodeArray[i].getName();
                if (this.db.isFineEnabled()) {
                    this.db.fine("applyNodeSecureModeConfig(): " + string);
                }
                if (string.equals("ctc")) {
                    this.handleTreelessDefaults(iDefaultsNodeArray[i], true);
                    continue;
                }
                DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNodeArray[i];
                String string2 = defaultsElement.getValue();
                if (defaultsElement.isDisplacedProperty()) {
                    this.handleTreelessDefaults(defaultsElement, true);
                    continue;
                }
                if (string.equals("SecureModeOn")) {
                    iDefaultsElement = defaultsElement;
                    continue;
                }
                if (string.equals("SecureModeLocked")) {
                    iDefaultsElement2 = defaultsElement;
                    continue;
                }
                if (string.equals("CtcBackplaneIpDisplaySuppression")) {
                    if (!defaultsElement.isDirty()) continue;
                    this.nmd.setCtcIpDisplaySuppression(false, this.stringToBool(string2));
                    defaultsElement.makeClean();
                    continue;
                }
                if (string.equals("LcdBackplaneIpSetting")) {
                    if (!defaultsElement.isDirty()) continue;
                    this.nmd.setLcdIpSetting(defaultsElement.getEnumValue(), false);
                    defaultsElement.makeClean();
                    continue;
                }
                this.db.severe("applyNodeSecureModeConfig: unknown or uneditable " + defaultsElement.getName());
            }
            ISecureIpConfig iSecureIpConfig = this.nmd.getSecureIpConfig();
            boolean bl2 = iSecureIpConfig.isSecureMode();
            boolean bl3 = iSecureIpConfig.isPermanentSecureMode();
            if (iDefaultsElement != null && iDefaultsElement.isDirty() && this.stringToBool(iDefaultsElement.getValue()) != bl2) {
                if (bl3) {
                    throw new Exception(" The secure mode is locked and cannot be changed.");
                }
                this.pendingApplications.put(iDefaultsElement.getName(), iDefaultsElement);
                if (iDefaultsElement2 != null) {
                    this.pendingApplications.put(iDefaultsElement2.getName(), iDefaultsElement2);
                }
            } else if (iDefaultsElement2 != null && iDefaultsElement2.isDirty() && this.stringToBool(iDefaultsElement2.getValue()) != bl3 && (bl = this.stringToBool(iDefaultsElement2.getValue())) != bl3) {
                if (bl3) {
                    throw new Exception("If locked, secure mode cannot be unlocked.");
                }
                if (!bl2) {
                    throw new Exception("Secure mode must be enabled before it can be locked.");
                }
                this.nmd.makeSecurityPermanent();
                iDefaultsElement2.makeClean();
            }
        } else {
            this.db.severe("applyNodeSecureModeConfig:  dataComm not supported on this TCC (" + this.nmd.supportsSecureMode() + ")");
        }
    }

    private boolean helpHandlePasswordAgingPolicy(SecurityPolicy securityPolicy, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode[] iDefaultsNodeArray2;
            String string2 = iDefaultsNodeArray[i].getName();
            if (string2.equals("EnforcePasswordAging")) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
                iDefaultsNodeArray2 = iDefaultsElement.getValue();
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordExprPolicyEnabled(this.stringToBool((String)iDefaultsNodeArray2));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.boolToString(securityPolicy.isPasswordExprPolicyEnabled()));
                continue;
            }
            for (int j = 0; j < SECURITY_LEVELS.length; ++j) {
                if (!string2.equalsIgnoreCase(SECURITY_LEVELS[j])) continue;
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                int n = securityPolicy.getPasswordExprPeriod(j);
                int n2 = securityPolicy.getPasswordExprWarningPeriod(j);
                for (int k = 0; k < iDefaultsNodeArray2.length; ++k) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[k];
                    String string3 = iDefaultsElement.getName();
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        if (string3.equals("AgingPeriod")) {
                            n = Integer.parseInt(iDefaultsElement.getValue());
                        } else if (string3.equals("WarningPeriod")) {
                            n2 = Integer.parseInt(iDefaultsElement.getValue());
                        }
                        bl2 = true;
                        continue;
                    }
                    if (string3.equals("AgingPeriod")) {
                        iDefaultsElement.initValue(String.valueOf(n));
                        continue;
                    }
                    if (!string3.equals("WarningPeriod")) continue;
                    iDefaultsElement.initValue(String.valueOf(n2));
                }
                if (!bl || !bl2) continue;
                securityPolicy.setPasswordExprPolicy(j, n, n2);
            }
        }
        return bl2;
    }

    private boolean helpHandlePasswordChangePolicy(SecurityPolicy securityPolicy, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            String string3 = iDefaultsElement.getValue();
            if (string2.equals("CannotChangeNewPassword")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordFlippingPolicyEnabled(this.stringToBool(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.boolToString(securityPolicy.getPasswordFlippingPolicyEnabled()));
                continue;
            }
            if (string2.equals("CannotChangeNewPasswordForNDays")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordFlippingPolicyThreshold(Integer.parseInt(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getPasswordFlippingPolicyThreshold()));
                continue;
            }
            if (string2.equals("PreventReusingLastNPasswords")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setPasswordReuseThreshold(Integer.parseInt(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getPasswordReuseThreshold()));
                continue;
            }
            if (string2.equals("RequirePasswordChangeOnFirstLoginToNewAccount")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setForcePasswordChange(this.stringToBool(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.boolToString(securityPolicy.getForcePasswordChange()));
                continue;
            }
            if (!string2.equals("NewPasswordMustDifferFromOldByNCharacters")) continue;
            if (bl) {
                if (!iDefaultsElement.isDirty()) continue;
                securityPolicy.setMinChangedCharsInPwd(Short.parseShort(string3));
                bl2 = true;
                continue;
            }
            iDefaultsElement.initValue(String.valueOf(securityPolicy.getMinChangedCharsInPwd()));
        }
        return bl2;
    }

    private boolean helpHandlePasswordComplexityPolicy(SecurityPolicy securityPolicy, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            String string3 = iDefaultsElement.getValue();
            if (string2.equals("ReverseUserIdAllowed")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setReverseUserIdAllowed(this.stringToBool(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.boolToString(securityPolicy.getReverseUserIdAllowed()));
                continue;
            }
            if (string2.equals("MaximumLength")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setMaximumLength(Short.parseShort(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getMaximumLength()));
                continue;
            }
            if (string2.equals("MinimumLength")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setMinimumLength(Short.parseShort(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getMinimumLength()));
                continue;
            }
            if (string2.equals("IdenticalConsecutiveCharactersAllowed")) {
                short s = 0;
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    s = (short)iDefaultsElement.getEnumValue();
                    securityPolicy.setIdenticalConsecutiveCharactersAllowed(s);
                    bl2 = true;
                    continue;
                }
                s = securityPolicy.getIdenticalConsecutiveCharactersAllowed();
                iDefaultsElement.initEnumValue(s);
                continue;
            }
            if (!string2.equals("MinimumRequiredCharacters")) continue;
            if (bl) {
                if (!iDefaultsElement.isDirty()) continue;
                securityPolicy.setMinimumRequiredCharacters(iDefaultsElement.getEnumValue());
                bl2 = true;
                continue;
            }
            securityPolicy.getMinimumRequiredCharacters();
            iDefaultsElement.initEnumValue(securityPolicy.getMinimumRequiredCharacters());
        }
        return bl2;
    }

    private boolean helpHandleUserLockoutPolicy(SecurityPolicy securityPolicy, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            String string3 = iDefaultsElement.getValue();
            if (string2.equals("FailedLoginsAllowedBeforeLockout")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setLockoutThreshold(Integer.parseInt(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(String.valueOf(securityPolicy.getLockoutThreshold()));
                continue;
            }
            if (string2.equals("LockoutDuration")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    securityPolicy.setLockoutDuration(this.stringToLockoutDuration(string3));
                    bl2 = true;
                    continue;
                }
                iDefaultsElement.initValue(this.lockoutDurationToString(securityPolicy.getLockoutDuration()));
                continue;
            }
            if (!string2.equals("ManualUnlockBySuperuser")) continue;
            if (bl) {
                if (!iDefaultsElement.isDirty()) continue;
                securityPolicy.setManualUnlock(this.stringToBool(string3));
                bl2 = true;
                continue;
            }
            iDefaultsElement.initValue(this.boolToString(securityPolicy.isManualUnlock()));
        }
        return bl2;
    }

    private void helpHandleNodeSecurityPolicy(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        SecurityPolicy securityPolicy = (SecurityPolicy)securityModel.getSecurityPolicy();
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2;
            String string3;
            IDefaultsElement iDefaultsElement;
            int n;
            IDefaultsNode[] iDefaultsNodeArray2;
            String string4 = iDefaultsNodeArray[i].getName();
            if (this.db.isFineEnabled()) {
                this.db.fine("helpHandleNodeSecurityPolicy():" + string4);
            }
            if (string4.equals("idleUserTimeout")) {
                iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                    string3 = iDefaultsNodeArray2[n].getName();
                    string2 = iDefaultsElement.getValue();
                    for (int j = 0; j < SECURITY_LEVELS.length; ++j) {
                        if (!string3.equalsIgnoreCase(SECURITY_LEVELS[j])) continue;
                        if (bl) {
                            if (!iDefaultsElement.isDirty()) continue;
                            securityPolicy.setIdleTimeout(j, this.stringToIdleUserTimeout(string2));
                            bl2 = true;
                            continue;
                        }
                        iDefaultsElement.initValue(this.idleUserTimeoutToString(securityPolicy.getIdleTimeout(j)));
                    }
                }
                continue;
            }
            if (string4.equals("passwordAging")) {
                bl2 |= this.helpHandlePasswordAgingPolicy(securityPolicy, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string4.equals("passwordComplexity")) {
                bl2 |= this.helpHandlePasswordComplexityPolicy(securityPolicy, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string4.equals("passwordChange")) {
                bl2 |= this.helpHandlePasswordChangePolicy(securityPolicy, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string4.equals("userLockout")) {
                bl2 |= this.helpHandleUserLockoutPolicy(securityPolicy, iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (!string4.equals("other")) continue;
            iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (n = 0; n < iDefaultsNodeArray2.length; ++n) {
                iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray2[n];
                string3 = iDefaultsElement.getName();
                string2 = iDefaultsElement.getValue();
                if (string3.equals("DisableInactiveUser")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityPolicy.setDisableInactiveUserPolicyEnabled(iDefaultsElement.getEnumValue() == 1);
                        bl2 = true;
                        continue;
                    }
                    iDefaultsElement.initEnumValue(securityPolicy.getDisableInactiveUserPolicyEnabled() ? 1 : 0);
                    continue;
                }
                if (string3.equals("InactiveDuration")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityPolicy.setMaxInactiveDaysBeforeDisable(Integer.parseInt(iDefaultsElement.getValue()));
                        bl2 = true;
                        continue;
                    }
                    iDefaultsElement.initValue(String.valueOf(securityPolicy.getMaxInactiveDaysBeforeDisable()));
                    continue;
                }
                if (string3.equals("SingleSessionPerUser")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityPolicy.setSingleSessionPerUser(this.stringToBool(string2));
                        bl2 = true;
                        continue;
                    }
                    iDefaultsElement.initEnumPass1();
                    iDefaultsElement.initValue(this.boolToString(securityPolicy.isSingleSessionPerUser()));
                    continue;
                }
                if (string3.equals("PreventInactiveSuperuserDisable")) {
                    if (bl) {
                        if (!iDefaultsElement.isDirty()) continue;
                        securityPolicy.setPreventSuperUserDisabledPolicy(this.stringToBool(string2));
                        bl2 = true;
                        continue;
                    }
                    iDefaultsElement.initEnumPass1();
                    iDefaultsElement.initValue(this.boolToString(securityPolicy.getPreventSuperUserDisabledPolicy()));
                    continue;
                }
                if (this.db.isFineEnabled()) {
                    this.db.fine("Not a policy: passing off to node security");
                }
                this.helpHandleNodeSecurity(iDefaultsElement, bl);
            }
        }
        if (bl && bl2) {
            securityModel.setSecurityPolicy(securityPolicy);
            this.makeClean(iDefaultsNodeArray);
        }
    }

    private void handleNodeSecurity(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        ArrayList<IDefaultsNode> arrayList = new ArrayList<IDefaultsNode>();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (this.db.isFineEnabled()) {
                this.db.fine("handleNodeSecurity(): " + string2);
            }
            if (string2.equals("dataComm")) {
                if (bl) {
                    this.applyNodeSecureModeConfig(iDefaultsNodeArray[i].getChildren());
                    continue;
                }
                this.handleNodeSecureModeConfig(iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            if (string2.equals("idleUserTimeout") || string2.equals("passwordAging") || string2.equals("passwordComplexity") || string2.equals("passwordChange") || string2.equals("userLockout") || string2.equals("other")) {
                arrayList.add(iDefaultsNodeArray[i]);
                continue;
            }
            this.helpHandleNodeSecurity(iDefaultsNodeArray[i], bl);
        }
        if (arrayList.size() > 0) {
            this.helpHandleNodeSecurityPolicy(arrayList.toArray(new IDefaultsNode[arrayList.size()]), bl, this.trimParentName(string));
        }
    }

    private void handleNodeGeneral(IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IIpAddr[] iIpAddrArray;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            if (string.length() != 0 && !string2.equalsIgnoreCase(string)) continue;
            if (string2.equals("RaiseConditionOnEmptySlot")) {
                iDefaultsElement.initValue(this.boolToString(this.neDefaultsModel.getRaiseConditionOnEmptySlot()));
                continue;
            }
            if (string2.equals("ReportLoopbackConditionsOnOOS-MTPorts") || string2.equals("ReportLoopbackConditionsOnLocked,MaintenancePorts")) {
                iDefaultsElement.initEnumValue(this.neDefaultsModel.getShowLoopbackAlarmsOnPortsUndergoingMaintenance() ? 1 : 0);
                continue;
            }
            if (string2.equals("AutoPM")) {
                iDefaultsElement.initEnumValue(this.neDefaultsModel.getAutoPM() ? 1 : 0);
                continue;
            }
            if (string2.equals("mvAirFilterBasedFanEnable")) {
                iDefaultsElement.initEnumValue(this.neDefaultsModel.getAirFilter() ? 1 : 0);
                continue;
            }
            if (string2.equals("AllowServiceAffectingPortChangeToDisabled")) {
                iDefaultsElement.initEnumValue(this.neDefaultsModel.getForceToOosDsbldStateChange() ? 1 : 0);
                continue;
            }
            if (string2.equals("SDPBER")) {
                short s = this.neDefaultsModel.getAisvOnSdpBerLevel();
                iDefaultsElement.initEnumValue(s);
                continue;
            }
            String string3 = "";
            if (string2.equals("DefaultsDescription")) {
                string3 = this.neDefaultsModel.getDefDescription();
            } else if (string2.equals("TimeZone")) {
                string3 = this.nmd.getCtcTimeZone().toString();
            } else if (string2.equals("UseDST")) {
                string3 = this.boolToString(!this.nmd.getCtcTimeZone().isDSTDisabled());
            } else if (string2.equals("NtpSntpServer")) {
                iIpAddrArray = IpAddrFactory.getIIpAddrArray(this.nmd.getSntpHosts());
                string3 = InetUtil.makeDottedString(iIpAddrArray[0]);
            } else if (string2.equals("BackupNtpSntpServer")) {
                iIpAddrArray = IpAddrFactory.getIIpAddrArray(this.nmd.getSntpHosts());
                string3 = InetUtil.makeDottedString(iIpAddrArray[1]);
            } else if (string2.equals("InsertAISVOnSDP")) {
                string3 = this.boolToString(this.neDefaultsModel.getAisvOnSdp());
            } else {
                string3 = "UNKNOWN";
                this.db.severe("handleNodeGeneral: unknown general element= " + string2);
            }
            iDefaultsElement.initValue(string3);
        }
    }

    private void handleNodeSoftware(IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            boolean bl = false;
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            if (string2.equals("AllowDelayedUpgrades")) {
                bl = this.neDefaultsModel.getAllowDelayedUpgrades();
            } else if (string2.equals("DefaultDelayedUpgrades")) {
                bl = this.neDefaultsModel.getDefaultDelayedUpgrades();
            } else {
                this.db.severe("handleNodeSoftware: unknown software element= " + string2);
            }
            iDefaultsElement.initEnumValue(bl ? 1 : 0);
        }
    }

    private void handleTreelessDefaults(IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        if (iDefaultsNode != null) {
            IDefaultsNode[] iDefaultsNodeArray;
            if (this.db.isInfoEnabled()) {
                this.db.info("handleTreelessDefaults(): " + iDefaultsNode.getName());
            }
            if ((iDefaultsNodeArray = iDefaultsNode.getChildren()) == null || iDefaultsNodeArray.length == 0) {
                DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNode;
                if (defaultsElement.isDisplacedProperty()) {
                    this.handleClientDefaults(defaultsElement, bl);
                } else {
                    defaultsElement.handleChange(bl);
                }
            } else {
                for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                    this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                }
            }
        }
    }

    private void handleNodeIPSettings(IDefaultsElement iDefaultsElement) throws Exception {
        String string = "";
        String string2 = iDefaultsElement.getName();
        if (string2.equals("CtcIpDisplaySuppression")) {
            string = this.boolToString(this.nmd.getCtcIpDisplaySuppression(true));
        } else if (string2.equals("LcdSetting")) {
            int n = this.nmd.getLcdIpSetting(true);
            string = 0 <= n && n < LcdIpSetting.LCD_IP_SETTING.length ? LcdIpSetting.LCD_IP_SETTING[n] : LcdIpSetting.LCD_IP_SETTING[0];
        } else {
            string = "UNKNOWN";
            this.db.severe("handleNodeIPSettings: unknown general element= " + string2);
        }
        iDefaultsElement.initValue(string);
    }

    private void handleNodePowerMonitor(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = "";
            String string3 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !string3.equalsIgnoreCase(string)) continue;
            sPwrMonVoltage sPwrMonVoltage2 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V48);
            sPwrMonVoltage sPwrMonVoltage3 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.V60);
            sPwrMonVoltage sPwrMonVoltage4 = this.neDefaultsModel.getDefPowerMonitor(eChassisVoltageType.MIXED);
            if (string3.equals("ELWBATVG_48V")) {
                string2 = this.convertVoltage(sPwrMonVoltage2.ex_low_voltage);
            } else if (string3.equals("ELWBATVG")) {
                string2 = this.nmd.getPlatform().is600SDH() ? this.convertVoltage(sPwrMonVoltage4.ex_low_voltage) : this.convertVoltage(sPwrMonVoltage2.ex_low_voltage);
            } else if (string3.equals("LWBATVG")) {
                string2 = this.convertVoltage(sPwrMonVoltage2.low_voltage);
            } else if (string3.equals("HIBATVG")) {
                string2 = this.convertVoltage(sPwrMonVoltage2.high_voltage);
            } else if (string3.equals("EHIBATVG_48V")) {
                string2 = this.convertVoltage(sPwrMonVoltage2.ex_high_voltage);
            } else if (string3.equals("EHIBATVG")) {
                string2 = this.nmd.getPlatform().is600SDH() ? this.convertVoltage(sPwrMonVoltage4.ex_high_voltage) : this.convertVoltage(sPwrMonVoltage2.ex_high_voltage);
            } else if (string3.equals("ELWBATVG_60V")) {
                string2 = this.convertVoltage(sPwrMonVoltage3.ex_low_voltage);
            } else if (string3.equals("EHIBATVG_60V")) {
                string2 = this.convertVoltage(sPwrMonVoltage3.ex_high_voltage);
            } else {
                string2 = "UNKNOWN";
                this.db.severe("unknown power monitor element");
            }
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            iDefaultsElement.initValue(string2);
        }
    }

    private void helpHandleGatewaySettings(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (bl) {
            this.pendingApplications.put(iDefaultsElement.getName(), iDefaultsElement);
        } else {
            String string = ProxyXlator.getProxyStringOrStatus(this.nmd);
            iDefaultsElement.setComment("As is: " + string);
            if (!string.equals("None") && string.equals(ProxyXlator.getProxyStatus(this.nmd))) {
                string = "LeaveAsIs";
            }
            iDefaultsElement.initValue(string);
        }
    }

    private void helpHandleAlarmMissingBackplaneLAN(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        SecurityModel securityModel = (SecurityModel)this.nmd.getSecurityModel();
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string = iDefaultsElement.getValue();
                securityModel.setAlarmOnLostBackLanLink(this.stringToBool(string));
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initValue(this.boolToString(securityModel.getAlarmOnLostBackLanLink()));
        }
    }

    private void handleNodeNetworkGeneral(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleNodeNetworkGeneral: children size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !string2.equalsIgnoreCase(string)) continue;
            if (string2.equals("GatewaySettings")) {
                this.helpHandleGatewaySettings((IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string2.equals("AlarmMissingBackplaneLAN")) {
                this.helpHandleAlarmMissingBackplaneLAN((IDefaultsElement)iDefaultsNodeArray[i], bl);
                continue;
            }
            this.helpHandleNodeNetworkGeneralIPSettings((IDefaultsElement)iDefaultsNodeArray[i], bl);
        }
    }

    private void helpHandleAAAServerUseLocalDatabase(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        RadiusServerModel radiusServerModel = this.nmd.getRadiusServerModel();
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                radiusServerModel.setUseLocalDatabase(iDefaultsElement.getEnumValue() == 1);
                iDefaultsElement.makeClean();
            }
        } else {
            iDefaultsElement.initEnumValue(radiusServerModel.getUseLocalDatabase() ? 1 : 0);
        }
    }

    private void handleNodeNetworkSecurity(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        if (this.db.isFineEnabled()) {
            this.db.fine("handleNodeNetworkSecurity: children size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (string.equals("ctc")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                continue;
            }
            DefaultsElement defaultsElement = (DefaultsElement)iDefaultsNodeArray[i];
            if (defaultsElement.isDisplacedProperty()) {
                this.handleTreelessDefaults(defaultsElement, bl);
                continue;
            }
            if (string.equals("EnableNodeAsFinalAuthenticator")) {
                this.helpHandleAAAServerUseLocalDatabase(defaultsElement, bl);
                continue;
            }
            this.db.severe("Unknown network security " + string);
        }
    }

    private void handleNodeRadiusServerList(IDefaultsNode[] iDefaultsNodeArray, boolean bl) throws Exception {
        Object object;
        RadiusServer[] radiusServerArray = null;
        int n = 0;
        radiusServerArray = bl ? new RadiusServer[iDefaultsNodeArray.length] : RadiusServerModel.getInstance(this.nmd).getRadiusServerList();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string;
            object = iDefaultsNodeArray[i].getChildren();
            if (this.db.isFineEnabled()) {
                this.db.info("handleNodeRadiusServerList(): " + i + " " + iDefaultsNodeArray[i].getName());
            }
            String string2 = string = "UNPROVISIONED";
            String string3 = "1812";
            String string4 = "1813";
            String string5 = "";
            if (!bl && i < radiusServerArray.length) {
                string2 = InetUtil.makeDottedString(radiusServerArray[i].getIpAddr());
                string3 = String.valueOf(radiusServerArray[i].getAuthPort());
                string4 = String.valueOf(radiusServerArray[i].getAcctPort());
                string5 = new String(radiusServerArray[i].getSecret());
            }
            for (int j = 0; j < ((Object)object).length; ++j) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)object[j];
                String string6 = iDefaultsElement.getName();
                if (this.db.isFineEnabled()) {
                    this.db.info("handleNodeRadiusServerList(): " + iDefaultsElement.getName());
                }
                if (string6.equals("IPAddress")) {
                    if (bl) {
                        string2 = iDefaultsElement.getValue();
                        continue;
                    }
                    iDefaultsElement.initValue(string2);
                    continue;
                }
                if (string6.equals("SharedSecret")) {
                    if (bl) {
                        string5 = iDefaultsElement.getValue();
                        continue;
                    }
                    iDefaultsElement.initValue(string5);
                    continue;
                }
                if (string6.equals("AuthenticationPort")) {
                    if (bl) {
                        string3 = iDefaultsElement.getValue();
                        continue;
                    }
                    iDefaultsElement.initValue(string3);
                    continue;
                }
                if (!string6.equals("AccountingPort")) continue;
                if (bl) {
                    string4 = iDefaultsElement.getValue();
                    continue;
                }
                iDefaultsElement.initValue(string4);
            }
            if (bl && !string2.equals(string)) {
                radiusServerArray[n++] = new RadiusServer(InetUtil.makeIpAddr(string2), Short.parseShort(string3), Short.parseShort(string4), string5.getBytes());
                continue;
            }
            this.db.severe("nothing to do with " + string2 + " " + string3 + " " + string4 + " " + string5);
        }
        if (bl) {
            RadiusServer[] radiusServerArray2 = new RadiusServer[n];
            System.arraycopy(radiusServerArray, 0, radiusServerArray2, 0, n);
            object = RadiusServerModel.getInstance(this.nmd);
            ((RadiusServerModel)object).deleteRadiusServerList();
            ((RadiusServerModel)object).setRadiusServerList(radiusServerArray2);
        }
    }

    private void handleNodeNetwork(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleNodeNetwork: children size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (this.db.isFineEnabled()) {
                this.db.fine("handleNodeNetwork: " + string2);
            }
            if (string2.equals("general")) {
                this.handleNodeNetworkGeneral(iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("Unknown node network level " + string2);
        }
    }

    private void helpHandleNodeNetworkGeneralIPSettings(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        if (this.db.isInfoEnabled()) {
            this.db.info("handleNodeIPAddressSettings:");
        }
        if (bl) {
            this.applyNodeIPSettings(iDefaultsElement);
        } else {
            this.handleNodeIPSettings(iDefaultsElement);
        }
    }

    private void handleNodeTop(IDefaultsNode[] iDefaultsNodeArray, String string) throws Exception {
        boolean bl = false;
        if (this.db.isInfoEnabled()) {
            this.db.info("handleNodeTop: children size = " + iDefaultsNodeArray.length);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (this.db.isFineEnabled()) {
                this.db.fine("handleNodeTop: " + string2);
            }
            if (string2.equals("general")) {
                this.handleNodeGeneral(iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            if (string2.equals("lmp")) {
                this.handleNodeLmp(iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("osi")) {
                this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string2.equals("powerMonitor")) {
                this.handleNodePowerMonitor(iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("network")) {
                this.handleNodeNetwork(iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("security")) {
                this.handleNodeSecurity(iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("timing")) {
                this.handleNodeTiming(iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            if (string2.equals("protection")) {
                this.handleNodeProtection(iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            if (string2.equals("circuits")) {
                this.handleNodeCircuits(iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            if (string2.equals("software")) {
                this.handleNodeSoftware(iDefaultsNodeArray[i].getChildren(), this.trimParentName(string));
                continue;
            }
            if (string2.startsWith("XTCDS")) {
                this.handleDSn(eEqType.XTC_CARD, this.getEqTypeFromName(string2), iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.db.severe("Unknown general level " + string2);
        }
    }

    private void handleClientDefaults(IDefaultsElement iDefaultsElement, boolean bl) throws Exception {
        String string = iDefaultsElement.getFullName();
        if (this.db.isInfoEnabled()) {
            this.db.info("handleClientDefaults(): " + string);
        }
        if (bl) {
            if (iDefaultsElement.isDirty()) {
                String string2 = iDefaultsElement.isNumericallyEnumerated() ? String.valueOf(iDefaultsElement.getEnumValue()) : iDefaultsElement.getValue();
                this.neDefaultsModel.setClientDefault(string, string2);
                if (iDefaultsElement.getFullName().startsWith("CTC.")) {
                    this.notifyCtcDefaultsObservers(iDefaultsElement);
                }
                iDefaultsElement.makeClean();
            }
        } else {
            try {
                String string3 = this.neDefaultsModel.getClientDefault(string);
                if (iDefaultsElement.isNumericallyEnumerated()) {
                    iDefaultsElement.initEnumValue(Integer.parseInt(string3));
                } else {
                    iDefaultsElement.initValue(string3);
                }
            }
            catch (NoSuchDefault noSuchDefault) {
                iDefaultsElement.resetValue();
                if (this.db.isFineEnabled()) {
                    this.db.fine("No such default " + string + " " + (Object)((Object)noSuchDefault));
                }
            }
            catch (Exception exception) {
                this.db.severe("Can't retrieve the default for " + string + " " + exception);
            }
        }
    }

    private void notifyCtcDefaultsObservers(IDefaultsNode iDefaultsNode) {
        try {
            String string = iDefaultsNode.getFullName();
            if (string.equals("CTC.network.Map")) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNode;
                NetworkMapUtil.changeNetworkMap(iDefaultsElement.getValue());
            }
        }
        catch (Exception exception) {
            this.db.severe("notifyCtcDefaultsObservers(): " + exception.toString());
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void handleNode(IDefaultsNode iDefaultsNode, boolean bl, ArrayList arrayList, String string) throws Exception {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        if (this.db.isInfoEnabled()) {
            this.db.info("Starting handleNode on " + this.nmd.getName() + ", " + iDefaultsNodeArray.length + " children, applying? " + bl);
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode2 = iDefaultsNodeArray[i];
            String string2 = iDefaultsNode2.getName();
            if (string.length() != 0 && !this.isSameName(string2, string)) continue;
            if (bl && !iDefaultsNode2.isDirty()) {
                if (!this.db.isFineEnabled()) continue;
                this.db.fine(string2 + " is clean... continuing...");
                continue;
            }
            this.db.fine("Current name : " + string2);
            try {
                if (string2.startsWith("NODE")) {
                    if (bl) {
                        this.applyToNodeTop(iDefaultsNode2.getChildren());
                        continue;
                    }
                    this.handleNodeTop(iDefaultsNode2.getChildren(), this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("CTC")) {
                    this.handleTreelessDefaults(iDefaultsNode2, bl);
                    continue;
                }
                eEqType eEqType2 = this.getEqTypeFromName(string2);
                if (this.db.isFineEnabled()) {
                    this.db.fine("Current default port is " + this.getNameFromEqType(this.getPortTypeForCard(eEqType2)));
                }
                if (string2.startsWith("CTX") || string2.equals("DS3-EC1-48") || string2.equals("DS1-E1-56") || string2.equals("DS3-EC1-6") || string2.equals("DS1-28-DS3-EC1-3") || string2.equals("DS1-84-DS3-EC1-3") || string2.equals("E1-21-E3-DS3-3") || string2.equals("E1-63-E3-DS3-3")) {
                    this.handleCtx(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("DS") || string2.startsWith("E1") || string2.startsWith("E3")) {
                    this.handleDSn(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("XTCDS")) {
                    this.handleDSn(eEqType.XTC_CARD, this.getEqTypeFromName(string2), iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("EC") || string2.startsWith("OC") || string2.startsWith("ST") || string2.startsWith("OSC")) {
                    this.handleOCn(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("MXP") || string2.startsWith("40G-MXP") || string2.startsWith("40E-MXP") || string2.startsWith("TXP") || string2.startsWith("40G-TXP") || string2.startsWith("40E-TXP") || string2.startsWith("OTU2")) {
                    this.cardName = string2.toString();
                    this.handleDwdm(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("ADM")) {
                    this.handleADM(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("OPT") || string2.startsWith("SMR2")) {
                    this.handleOpt(eEqType2, eEqType.AOTS_PORT, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string2.startsWith("SMR1") || string2.startsWith("PSM") || string2.startsWith("WXC") || string2.startsWith("WSS")) {
                    this.handleOpt(eEqType2, eEqType.OTS_PORT, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string2.startsWith("ASAP") || string2.startsWith("MRC")) {
                    this.handleMrc(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("FC-MR")) {
                    this.handleFcmr(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.equals("RAN-SVC")) {
                    this.handleRanSvc(eEqType2, iDefaultsNode2.getChildren(), bl);
                    continue;
                }
                if (string2.startsWith("ML100") || string2.startsWith("ML-100") || string2.startsWith("ML-MR") || string2.equals("MS-ISC-100T")) {
                    this.handleMl(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.equals("CE-100T-8") || string2.equals("CE-MR")) {
                    this.handleML2Mapper(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.equals("CE-1000-4")) {
                    this.handleCE1000(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.startsWith("XP-")) {
                    this.handleXPGE(eEqType2, iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.equals("G1000")) {
                    this.handleG1000(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                if (string2.equals("TNC")) {
                    this.handleTNC(eEqType2, this.getPortTypeForCard(eEqType2), iDefaultsNode2.getChildren(), bl, this.trimParentName(string));
                    continue;
                }
                this.db.severe("Unknown card = " + string2);
                continue;
            }
            catch (Exception exception) {
                if (arrayList == null) {
                    throw exception;
                }
                arrayList.add(string2 + ": " + exception);
                if (!this.db.isSevereEnabled()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void resetSinglevalue(IDefaultsNode iDefaultsNode, String string) throws Exception {
        ArrayList arrayList = new ArrayList();
        this.handleNode(iDefaultsNode, false, arrayList, string);
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("Failed to load the following:\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + "\n");
            }
            throw new Exception(stringBuffer.toString());
        }
    }

    public void resetFromNode(IDefaultsNode iDefaultsNode) throws Exception {
        iDefaultsNode.resetDirty();
        this.pendingApplications.clear();
        ArrayList arrayList = new ArrayList();
        this.handleNode(iDefaultsNode, false, arrayList, "");
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("Failed to load the following:\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + "\n");
            }
            this.errorStr = stringBuffer.toString();
        }
    }

    public void applyToNode(IDefaultsNode iDefaultsNode) throws Exception {
        this.handleNode(iDefaultsNode, true, null, "");
    }

    private eEqType getPortTypeForCard(eEqType eEqType2) {
        eEqType eEqType3 = eEqType.INVALID;
        if (eEqType2 != null) {
            switch (eEqType2.value()) {
                case 4: {
                    eEqType3 = eEqType.DS1_VT_MAPPED;
                    break;
                }
                case 218: {
                    eEqType3 = eEqType.DS1_VT_MAPPED;
                    break;
                }
                case 6: {
                    eEqType3 = eEqType.DS3;
                    break;
                }
                case 185: {
                    eEqType3 = eEqType.DS3;
                    break;
                }
                case 57: {
                    eEqType3 = eEqType.DS3;
                    break;
                }
                case 66: {
                    eEqType3 = eEqType.DS3I_PORT;
                    break;
                }
                case 8: 
                case 145: {
                    eEqType3 = eEqType.DS3_TRANS_MUX;
                    break;
                }
                case 83: {
                    eEqType3 = eEqType.E1_PORT;
                    break;
                }
                case 108: {
                    eEqType3 = eEqType.E1_PORT;
                    break;
                }
                case 65: {
                    eEqType3 = eEqType.E3_PORT;
                    break;
                }
                case 12: {
                    eEqType3 = eEqType.EC1_PORT;
                    break;
                }
                case 9: 
                case 106: 
                case 124: 
                case 127: 
                case 128: {
                    eEqType3 = eEqType.OC3_PORT;
                    break;
                }
                case 10: 
                case 85: {
                    eEqType3 = eEqType.OC12_PORT;
                    break;
                }
                case 11: 
                case 87: 
                case 126: {
                    eEqType3 = eEqType.OC48_PORT;
                    break;
                }
                case 60: 
                case 86: 
                case 220: 
                case 251: {
                    eEqType3 = eEqType.OC192_PORT;
                    break;
                }
                case 113: {
                    eEqType3 = eEqType.STM1E_PORT;
                    break;
                }
                case 14: {
                    eEqType3 = eEqType.ETHER_10_100_T;
                    break;
                }
                case 15: {
                    eEqType3 = eEqType.ETHER_1000_F;
                    break;
                }
                case 52: {
                    eEqType3 = eEqType.VIC_ENCODER_PORT;
                    break;
                }
                case 62: {
                    eEqType3 = eEqType.ETHER_1000_HDGE;
                    break;
                }
                case 143: {
                    eEqType3 = eEqType.FCMR_PORT;
                    break;
                }
                case 102: 
                case 103: 
                case 221: 
                case 238: {
                    eEqType3 = eEqType.L2SC_ETHER_PORT;
                    break;
                }
                case 164: 
                case 285: {
                    eEqType3 = eEqType.L1P_ETHER_PORT;
                    break;
                }
                case 47: {
                    eEqType3 = eEqType.INVALID;
                    break;
                }
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 146: 
                case 157: 
                case 219: 
                case 253: 
                case 254: {
                    eEqType3 = eEqType.INVALID;
                    this.db.severe("getPortTypeForCard: port type ambiguous for eEqType= " + eEqType2.value());
                    break;
                }
                case 37: 
                case 53: 
                case 160: {
                    eEqType3 = eEqType.UNKNOWN;
                    this.db.severe("getPortTypeForCard: port type unknown for eEqType= " + eEqType2.value());
                    break;
                }
                case 330: {
                    eEqType3 = eEqType.OC3_PORT;
                    break;
                }
                default: {
                    this.db.severe("getPortTypeForCard: unknown/unsupported eEqType = " + eEqType2.value());
                }
            }
        }
        return eEqType3;
    }

    private String getStringFromBucketSize(eBucketSize eBucketSize2) {
        String string = "UNKNOWN";
        switch (eBucketSize2.value()) {
            case 1: {
                string = "4K";
                break;
            }
            case 2: {
                string = "8K";
                break;
            }
            case 3: {
                string = "16K";
                break;
            }
            case 4: {
                string = "32K";
                break;
            }
            case 5: {
                string = "64K";
                break;
            }
            case 6: {
                string = "128K";
                break;
            }
            case 7: {
                string = "256K";
                break;
            }
            case 8: {
                string = "512K";
                break;
            }
            case 9: {
                string = "1M";
                break;
            }
            case 10: {
                string = "2M";
                break;
            }
            case 11: {
                string = "4M";
                break;
            }
            case 12: {
                string = "8M";
                break;
            }
            case 13: {
                string = "16M";
                break;
            }
        }
        return string;
    }

    private int getBucketSizeFromString(String string) {
        if (string.equals("4K")) {
            return 1;
        }
        if (string.equals("8K")) {
            return 2;
        }
        if (string.equals("16K")) {
            return 3;
        }
        if (string.equals("32K")) {
            return 4;
        }
        if (string.equals("64K")) {
            return 5;
        }
        if (string.equals("128K")) {
            return 6;
        }
        if (string.equals("256K")) {
            return 7;
        }
        if (string.equals("512K")) {
            return 8;
        }
        if (string.equals("1M")) {
            return 9;
        }
        if (string.equals("2M")) {
            return 10;
        }
        if (string.equals("4M")) {
            return 11;
        }
        if (string.equals("8M")) {
            return 12;
        }
        if (string.equals("16M")) {
            return 13;
        }
        return -1;
    }

    private void handleXPGE(eEqType eEqType2, IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        this.db.fine("handleXPGE: nodes size = " + iDefaultsNodeArray.length + " applying? " + bl);
        IDefaultsNode[] iDefaultsNodeArray2 = new IDefaultsNode[iDefaultsNodeArray.length - 1];
        System.arraycopy(iDefaultsNodeArray, 1, iDefaultsNodeArray2, 0, iDefaultsNodeArray.length - 1);
        this.handleDwdm(eEqType2, iDefaultsNodeArray2, bl, string);
        IDefaultsNode iDefaultsNode = iDefaultsNodeArray[0];
        iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2;
            String string3;
            IDefaultsElement iDefaultsElement;
            int n;
            IDefaultsNode[] iDefaultsNodeArray3;
            boolean bl2;
            boolean bl3;
            sBasicL2Info sBasicL2Info2;
            sL1Info sL1Info2;
            eEqType eEqType3;
            String string4 = iDefaultsNodeArray[i].getName();
            if (string4.equals("card")) {
                this.handleCardMode(eEqType2, iDefaultsNodeArray[i], bl);
                continue;
            }
            if (string4.equals("client")) {
                eEqType3 = eEqType.DWDM_CLIENT_PORT;
                sL1Info2 = this.neDefaultsModel.getDefXPGEL1EtherInfo(eEqType2, eEqType3);
                sBasicL2Info2 = this.neDefaultsModel.getDefXPGEL2EtherInfo(eEqType2, eEqType3);
                bl3 = false;
                bl2 = false;
                iDefaultsNodeArray3 = iDefaultsNodeArray[i].getChildren();
                for (n = 0; n < iDefaultsNodeArray3.length; ++n) {
                    if (iDefaultsNodeArray3[n].getName().equals("DS1") || iDefaultsNodeArray3[n].getName().equals("E1") || iDefaultsNodeArray3[n].getName().equals("DS3") || iDefaultsNodeArray3[n].getName().equals("E3")) {
                        this.handleEthPdhDefaults(eEqType2, eEqType3, iDefaultsNodeArray3[n], bl);
                        continue;
                    }
                    iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray3[n];
                    string3 = iDefaultsElement.getName();
                    string2 = iDefaultsElement.getValue();
                    if (string3.equals("Speed")) {
                        if (bl) {
                            if (string2.equals("1000 Mbps")) {
                                sL1Info2.speed = eEtherSpeed.ETHER_SPEED_1000;
                            } else if (string2.equals("10000 Mbps")) {
                                sL1Info2.speed = eEtherSpeed.ETHER_SPEED_10000;
                            }
                            if (string2.equals("Auto")) {
                                sL1Info2.speed = eEtherSpeed.ETHER_SPEED_AUTO;
                            }
                            bl3 = true;
                        } else if (sL1Info2.speed == eEtherSpeed.ETHER_SPEED_1000) {
                            iDefaultsElement.initValue("1000 Mbps");
                        } else if (sL1Info2.speed == eEtherSpeed.ETHER_SPEED_10000) {
                            iDefaultsElement.initValue("10000 Mbps");
                        } else if (sL1Info2.speed == eEtherSpeed.ETHER_SPEED_AUTO) {
                            iDefaultsElement.initValue("Auto");
                        }
                    } else if (string3.equals("FlowControl")) {
                        if (bl) {
                            sL1Info2.flowControl = string2.equals("ON") ? eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL : eFlowControlNegotiated.NO_FLOW_CONTROL;
                            bl3 = true;
                        } else if (sL1Info2.flowControl == eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL) {
                            iDefaultsElement.initValue("ON");
                        } else {
                            iDefaultsElement.initValue("OFF");
                        }
                    } else if (string3.equals("CommittedInfoRate")) {
                        if (bl) {
                            sL1Info2.ingressQos.committedInfoRate = Short.parseShort(string2);
                            bl3 = true;
                        } else {
                            iDefaultsElement.initValue(String.valueOf(sL1Info2.ingressQos.committedInfoRate));
                        }
                    } else if (string3.equals("PeakInfoRate")) {
                        if (bl) {
                            sL1Info2.ingressQos.peakInfoRate = Short.parseShort(string2);
                            bl3 = true;
                        } else {
                            iDefaultsElement.initValue(String.valueOf(sL1Info2.ingressQos.peakInfoRate));
                        }
                    } else if (string3.equals("CommittedBurstSize")) {
                        if (bl) {
                            sL1Info2.ingressQos.committedBurstSize = eBucketSize.from_int(this.getBucketSizeFromString(string2));
                            bl3 = true;
                        } else {
                            iDefaultsElement.initValue(this.getStringFromBucketSize(sL1Info2.ingressQos.committedBurstSize));
                        }
                    } else if (string3.equals("ExcessBurstSize")) {
                        if (bl) {
                            sL1Info2.ingressQos.excOrPeakBurstSize = eBucketSize.from_int(this.getBucketSizeFromString(string2));
                            bl3 = true;
                        } else {
                            iDefaultsElement.initValue(this.getStringFromBucketSize(sL1Info2.ingressQos.excOrPeakBurstSize));
                        }
                    } else if (string3.equals("MTU")) {
                        if (bl) {
                            sL1Info2.mtu = Integer.parseInt(string2);
                            bl3 = true;
                        } else {
                            iDefaultsElement.initValue(String.valueOf(sL1Info2.mtu));
                        }
                    } else if (string3.equals("macLearningState")) {
                        if (bl) {
                            sBasicL2Info2.macLearningState = string2.equals("ON");
                            bl2 = true;
                        } else if (sBasicL2Info2.macLearningState) {
                            iDefaultsElement.initValue("ON");
                        } else {
                            iDefaultsElement.initValue("OFF");
                        }
                    } else if (string3.equals("niMode")) {
                        if (bl) {
                            sBasicL2Info2.niMode = string2.equals("NNI MODE") ? eNiValue.NNI_MODE : eNiValue.UNI_MODE;
                            bl2 = true;
                        } else if (sBasicL2Info2.niMode == eNiValue.NNI_MODE) {
                            iDefaultsElement.initValue("NNI MODE");
                        } else {
                            iDefaultsElement.initValue("UNI MODE");
                        }
                    } else if (string3.equals("sIngressCOS")) {
                        if (bl) {
                            sBasicL2Info2.sIngressCOS = string2.equals("Trust") ? Short.parseShort("8") : (string2.equals("CVLAN") ? Short.parseShort("9") : (string2.equals("DSCP") ? Short.parseShort("10") : Short.parseShort(string2)));
                            bl2 = true;
                        } else if (sBasicL2Info2.sIngressCOS == 8) {
                            iDefaultsElement.initValue("Trust");
                        } else if (sBasicL2Info2.sIngressCOS == 9) {
                            iDefaultsElement.initValue("CVLAN");
                        } else if (sBasicL2Info2.sIngressCOS == 10) {
                            iDefaultsElement.initValue("DSCP");
                        } else {
                            iDefaultsElement.initValue(Short.toString(sBasicL2Info2.sIngressCOS));
                        }
                    } else if (string3.equals("cEtherType")) {
                        if (bl) {
                            sBasicL2Info2.cEtherType = (short)Integer.parseInt(string2.toString(), 16);
                            bl2 = true;
                        } else {
                            iDefaultsElement.initValue(Integer.toHexString(sBasicL2Info2.cEtherType & 0xFFFF).toUpperCase());
                        }
                    } else if (string3.equals("sEtherType")) {
                        if (bl) {
                            sBasicL2Info2.sEtherType = (short)Integer.parseInt(string2.toString(), 16);
                            bl2 = true;
                        } else {
                            iDefaultsElement.initValue(Integer.toHexString(sBasicL2Info2.sEtherType & 0xFFFF).toUpperCase());
                        }
                    } else if (string3.equals("AlsMode")) {
                        this.helpHandleAlsMode(eEqType2, eEqType.DWDM_CLIENT_PORT, iDefaultsElement, bl);
                    } else if (string3.equals("AlsRecoveryPulseInterval")) {
                        this.helpHandleAlsRecoveryPulseInterval(eEqType2, eEqType.DWDM_CLIENT_PORT, iDefaultsElement, bl);
                    } else if (string3.equals("AlsRecoveryPulseDuration")) {
                        this.helpHandleAlsRecoveryPulseDuration(eEqType2, eEqType.DWDM_CLIENT_PORT, iDefaultsElement, bl);
                    } else if (string3.equals("AINSSoakTime")) {
                        this.helpHandleSoakTime(eEqType2, eEqType.DWDM_CLIENT_PORT, iDefaultsElement, bl);
                    } else if (string3.equals("ppmSlotAssignment") || string3.equals("ppmPortAssignment")) {
                        this.handleConfigurableDwdmPorts(eEqType2, iDefaultsElement, bl);
                    }
                    if (!bl) continue;
                    if (bl3) {
                        this.neDefaultsModel.setDefXPGEL1EtherInfo(eEqType2, eEqType3, sL1Info2);
                    }
                    if (bl2) {
                        this.neDefaultsModel.setDefXPGEL2EtherInfo(eEqType2, eEqType3, sBasicL2Info2);
                    }
                    if (!bl3 && !bl2) continue;
                    bl3 = false;
                    bl2 = false;
                    this.makeClean(iDefaultsNodeArray3);
                }
                continue;
            }
            if (!string4.equals("trunk")) continue;
            eEqType3 = eEqType.DWDM_TRUNK_PORT;
            sL1Info2 = this.neDefaultsModel.getDefXPGEL1EtherInfo(eEqType2, eEqType3);
            sBasicL2Info2 = this.neDefaultsModel.getDefXPGEL2EtherInfo(eEqType2, eEqType3);
            bl3 = false;
            bl2 = false;
            iDefaultsNodeArray3 = iDefaultsNodeArray[i].getChildren();
            for (n = 0; n < iDefaultsNodeArray3.length; ++n) {
                iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray3[n];
                string3 = iDefaultsElement.getName();
                string2 = iDefaultsElement.getValue();
                if (string3.equals("Speed")) {
                    if (bl) {
                        if (string2.equals("1000 Mbps")) {
                            sL1Info2.speed = eEtherSpeed.ETHER_SPEED_1000;
                        } else if (string2.equals("10000 Mbps")) {
                            sL1Info2.speed = eEtherSpeed.ETHER_SPEED_10000;
                        }
                        if (string2.equals("Auto")) {
                            sL1Info2.speed = eEtherSpeed.ETHER_SPEED_AUTO;
                        }
                        bl3 = true;
                    } else if (sL1Info2.speed == eEtherSpeed.ETHER_SPEED_1000) {
                        iDefaultsElement.initValue("1000 Mbps");
                    } else if (sL1Info2.speed == eEtherSpeed.ETHER_SPEED_10000) {
                        iDefaultsElement.initValue("10000 Mbps");
                    } else if (sL1Info2.speed == eEtherSpeed.ETHER_SPEED_AUTO) {
                        iDefaultsElement.initValue("Auto");
                    }
                } else if (string3.equals("FlowControl")) {
                    if (bl) {
                        sL1Info2.flowControl = string2.equals("ON") ? eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL : eFlowControlNegotiated.NO_FLOW_CONTROL;
                        bl3 = true;
                    } else if (sL1Info2.flowControl == eFlowControlNegotiated.SYMMETRIC_FLOW_CONTROL) {
                        iDefaultsElement.initValue("ON");
                    } else {
                        iDefaultsElement.initValue("OFF");
                    }
                } else if (string3.equals("CommittedInfoRate")) {
                    if (bl) {
                        sL1Info2.ingressQos.committedInfoRate = Short.parseShort(string2);
                        bl3 = true;
                    } else {
                        iDefaultsElement.initValue(String.valueOf(sL1Info2.ingressQos.committedInfoRate));
                    }
                } else if (string3.equals("PeakInfoRate")) {
                    if (bl) {
                        sL1Info2.ingressQos.peakInfoRate = Short.parseShort(string2);
                        bl3 = true;
                    } else {
                        iDefaultsElement.initValue(String.valueOf(sL1Info2.ingressQos.peakInfoRate));
                    }
                } else if (string3.equals("CommittedBurstSize")) {
                    if (bl) {
                        sL1Info2.ingressQos.committedBurstSize = eBucketSize.from_int(this.getBucketSizeFromString(string2));
                        bl3 = true;
                    } else {
                        iDefaultsElement.initValue(this.getStringFromBucketSize(sL1Info2.ingressQos.committedBurstSize));
                    }
                } else if (string3.equals("ExcessBurstSize")) {
                    if (bl) {
                        sL1Info2.ingressQos.excOrPeakBurstSize = eBucketSize.from_int(this.getBucketSizeFromString(string2));
                        bl3 = true;
                    } else {
                        iDefaultsElement.initValue(this.getStringFromBucketSize(sL1Info2.ingressQos.excOrPeakBurstSize));
                    }
                } else if (string3.equals("MTU")) {
                    if (bl) {
                        sL1Info2.mtu = Integer.parseInt(string2);
                        bl3 = true;
                    } else {
                        iDefaultsElement.initValue(String.valueOf(sL1Info2.mtu));
                    }
                } else if (string3.equals("macLearningState")) {
                    if (bl) {
                        sBasicL2Info2.macLearningState = string2.equals("ON");
                        bl2 = true;
                    } else if (sBasicL2Info2.macLearningState) {
                        iDefaultsElement.initValue("ON");
                    } else {
                        iDefaultsElement.initValue("OFF");
                    }
                } else if (string3.equals("niMode")) {
                    if (bl) {
                        sBasicL2Info2.niMode = string2.equals("NNI MODE") ? eNiValue.NNI_MODE : eNiValue.UNI_MODE;
                        bl2 = true;
                    } else if (sBasicL2Info2.niMode == eNiValue.NNI_MODE) {
                        iDefaultsElement.initValue("NNI MODE");
                    } else {
                        iDefaultsElement.initValue("UNI MODE");
                    }
                } else if (string3.equals("sIngressCOS")) {
                    if (bl) {
                        sBasicL2Info2.sIngressCOS = string2.equals("Trust") ? Short.parseShort("8") : (string2.equals("CVLAN") ? Short.parseShort("9") : Short.parseShort(string2));
                        bl2 = true;
                    } else if (sBasicL2Info2.sIngressCOS == 8) {
                        iDefaultsElement.initValue("Trust");
                    } else if (sBasicL2Info2.sIngressCOS == 9) {
                        iDefaultsElement.initValue("CVLAN");
                    } else {
                        iDefaultsElement.initValue(Short.toString(sBasicL2Info2.sIngressCOS));
                    }
                } else if (string3.equals("cEtherType")) {
                    if (bl) {
                        sBasicL2Info2.cEtherType = (short)Integer.parseInt(string2.toString(), 16);
                        bl2 = true;
                    } else {
                        iDefaultsElement.initValue(Integer.toHexString(sBasicL2Info2.cEtherType & 0xFFFF).toUpperCase());
                    }
                } else if (string3.equals("sEtherType")) {
                    if (bl) {
                        sBasicL2Info2.sEtherType = (short)Integer.parseInt(string2.toString(), 16);
                        bl2 = true;
                    } else {
                        iDefaultsElement.initValue(Integer.toHexString(sBasicL2Info2.sEtherType & 0xFFFF).toUpperCase());
                    }
                } else if (string3.equals("AlsMode")) {
                    this.helpHandleAlsMode(eEqType2, eEqType.DWDM_TRUNK_PORT, iDefaultsElement, bl);
                } else if (string3.equals("AlsRecoveryPulseInterval")) {
                    this.helpHandleAlsRecoveryPulseInterval(eEqType2, eEqType.DWDM_TRUNK_PORT, iDefaultsElement, bl);
                } else if (string3.equals("AlsRecoveryPulseDuration")) {
                    this.helpHandleAlsRecoveryPulseDuration(eEqType2, eEqType.DWDM_TRUNK_PORT, iDefaultsElement, bl);
                } else if (string3.equals("AINSSoakTime")) {
                    this.helpHandleSoakTime(eEqType2, eEqType.DWDM_TRUNK_PORT, iDefaultsElement, bl);
                }
                if (!bl) continue;
                if (bl3) {
                    this.neDefaultsModel.setDefXPGEL1EtherInfo(eEqType2, eEqType3, sL1Info2);
                }
                if (bl2) {
                    this.neDefaultsModel.setDefXPGEL2EtherInfo(eEqType2, eEqType3, sBasicL2Info2);
                }
                if (!bl3 && !bl2) continue;
                bl3 = false;
                bl2 = false;
                this.makeClean(iDefaultsNodeArray3);
            }
        }
    }

    private void handleNodeLmpGeneral(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        this.db.fine("handleNodeLmpGeneral: children size = " + iDefaultsNodeArray.length);
        LmpModel lmpModel = LmpModel.getInstance(this.nmd);
        sProductConfigAttrs sProductConfigAttrs2 = new sProductConfigAttrs(lmpModel.isEnabled(), lmpModel.isWdm(), lmpModel.getWdmRole(), lmpModel.getLocalNodeId());
        boolean bl2 = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string2 = iDefaultsElement.getName();
            if (string.length() != 0 && !string2.equalsIgnoreCase(string)) continue;
            if (string2.equals("Allowed")) {
                this.handleTreelessDefaults(iDefaultsElement, bl);
                continue;
            }
            if (string2.equals("Enabled")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    bl2 = true;
                    sProductConfigAttrs2.enabled = iDefaultsElement.getEnumValue() == 1;
                    continue;
                }
                iDefaultsElement.initEnumValue(sProductConfigAttrs2.enabled ? 1 : 0);
                continue;
            }
            if (string2.equals("LMP-WDM")) {
                if (bl) {
                    if (!iDefaultsElement.isDirty()) continue;
                    bl2 = true;
                    sProductConfigAttrs2.wdm = iDefaultsElement.getEnumValue() == 1;
                    continue;
                }
                iDefaultsElement.initEnumValue(sProductConfigAttrs2.wdm ? 1 : 0);
                continue;
            }
            if (!string2.equals("Role")) continue;
            if (bl) {
                if (!iDefaultsElement.isDirty()) continue;
                bl2 = true;
                sProductConfigAttrs2.wdm_role = eWdmRoleType.from_int(iDefaultsElement.getEnumValue());
                continue;
            }
            iDefaultsElement.initEnumValue(sProductConfigAttrs2.wdm_role.value());
        }
        if (bl && bl2) {
            lmpModel.set(sProductConfigAttrs2);
        }
    }

    private void handleNodeLmp(IDefaultsNode[] iDefaultsNodeArray, boolean bl, String string) throws Exception {
        this.db.fine("handleNodeLmp: children size = " + iDefaultsNodeArray.length);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string2 = iDefaultsNodeArray[i].getName();
            this.db.fine("handleNodeLmp: " + string2);
            if (string2.equals("general")) {
                this.handleNodeLmpGeneral(iDefaultsNodeArray[i].getChildren(), bl, this.trimParentName(string));
                continue;
            }
            this.handleTreelessDefaults(iDefaultsNodeArray[i], bl);
        }
    }

    private void handleEthPdhDefaults(eEqType eEqType2, eEqType eEqType3, IDefaultsNode iDefaultsNode, boolean bl) throws Exception {
        eEqType eEqType4 = eEqType.DS1_VT_MAPPED;
        if (iDefaultsNode.getName().equals("E1")) {
            eEqType4 = eEqType.E1_PORT;
        } else if (iDefaultsNode.getName().equals("DS3")) {
            eEqType4 = eEqType.DS3;
        } else if (iDefaultsNode.getName().equals("E3")) {
            eEqType4 = eEqType.E3_PORT;
        }
        if (bl) {
            this.setXPGEPdhConfigToNodeVals(eEqType2, eEqType4, iDefaultsNode);
        } else {
            this.getXPGEPdhConfigFrmNodeVals(eEqType2, eEqType4, iDefaultsNode);
        }
    }

    private void getXPGEPdhConfigFrmNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode iDefaultsNode) throws Exception {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        sConfig sConfig2 = this.neDefaultsModel.getDefConfig(eEqType2, eEqType3);
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("LineType")) {
                iDefaultsElement.initEnumValue(sConfig2.lineType.value());
                continue;
            }
            if (string.equals("LineCoding")) {
                string2 = sConfig2.lineCoding == eLineCoding.B8ZS ? "B8ZS" : (sConfig2.lineCoding == eLineCoding.AMI ? "AMI" : (sConfig2.lineCoding == eLineCoding.HDB3 ? "HDB3" : "B3ZS"));
                iDefaultsElement.initValue(string2);
                continue;
            }
            if (string.equals("LineLength")) {
                int n = 0;
                if (eEqType3 == eEqType.DS1_VT_MAPPED) {
                    n = 655;
                    if (sConfig2.lineLength >= 0 && sConfig2.lineLength < 134) {
                        n = 133;
                    } else if (sConfig2.lineLength >= 134 && sConfig2.lineLength < 267) {
                        n = 266;
                    } else if (sConfig2.lineLength >= 267 && sConfig2.lineLength < 400) {
                        n = 399;
                    } else if (sConfig2.lineLength >= 400 && sConfig2.lineLength < 534) {
                        n = 533;
                    } else if (sConfig2.lineLength >= 534 && sConfig2.lineLength < 656) {
                        n = 655;
                    }
                } else {
                    n = 450;
                    if (sConfig2.lineLength >= 0 && sConfig2.lineLength < 226) {
                        n = 225;
                    }
                }
                iDefaultsElement.initEnumValue(n);
                continue;
            }
            this.db.severe("Unknows config value" + string);
            string2 = "UNKNOWN";
        }
    }

    private void setXPGEPdhConfigToNodeVals(eEqType eEqType2, eEqType eEqType3, IDefaultsNode iDefaultsNode) throws Exception {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        sConfig sConfig2 = this.neDefaultsModel.getDefConfig(eEqType2, eEqType3);
        boolean bl = false;
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray[i];
            String string = iDefaultsElement.getName();
            String string2 = iDefaultsElement.getValue();
            if (string.equals("LineType")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.lineType = eLineType.from_int(iDefaultsElement.getEnumValue());
            } else if (string.equals("LineCoding")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.lineCoding = string2.equals("B8ZS") ? eLineCoding.B8ZS : (string2.equals("AMI") ? eLineCoding.AMI : (string2.equals("HDB3") ? eLineCoding.HDB3 : eLineCoding.B3ZS));
            } else if (string.equals("LineLength")) {
                bl |= iDefaultsElement.isDirty();
                sConfig2.lineLength = iDefaultsElement.getEnumValue();
            } else {
                this.db.severe("setXPGEPdhConfigToNodeVals: Unknown Config Value" + string);
            }
            sConfig2.clockSource = eClockSource.LOCAL_TIMING;
        }
        if (bl) {
            this.neDefaultsModel.setDefConfig(eEqType2, eEqType3, sConfig2);
            this.makeClean(iDefaultsNodeArray);
        }
    }
}

