/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.persistence;

import cerent.cms.model.IModelPersistenceConstants;
import cerent.cms.model.IModelStatePersistedMarker;
import cerent.cms.model.IStateBatchInfo;
import cerent.cms.model.IStreamer;
import cerent.cms.model.ModelStateSizer;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.ReflectionUtil;
import cerent.cms.model.persistence.IContextFactory;
import cerent.cms.model.persistence.IResultSetHandler;
import cerent.cms.model.persistence.IStateDAO;
import cerent.cms.model.persistence.SerializationStreamer;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.id.INetwideModelIdentity;
import cerent.util.id.INetwideModelTypeIdentity;
import cerent.util.id.INetwideNodeIdentity;
import cerent.util.id.ModelIdentityFactory;
import cerent.util.id.NetwideModelIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public class StateDAO
implements IStateDAO {
    public static final String DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    public static final String ORACLE_OCI_CONN_PREFIX = "jdbc:oracle:oci:@";
    public static final String ORACLE_THIN_CONN_PREFIX = "jdbc:oracle:thin:@";
    public static final int ORACLE_DEFAULT_THIN_PORT = 1521;
    public static final int ORACLE_DEFAULT_OCI_PORT = 1521;
    private static final String SIZE_UNAVAIL = "size not available";
    public static final String MODEL_STATE_TBL = "ne_model_state";
    public static final String NODE_ID_COL = "node_id";
    public static final String MODEL_TYPE_COL = "model_type";
    public static final String MODEL_INDEX_COL = "model_index";
    public static final String DATA_COL = "data";
    public static final String MODEL_TYPE_TBL = "ne_model_type";
    public static final String SEQ_NUM_COL = "sequence_num";
    public static final String PREFS_PERSIST = "ctc.model.persist";
    public static final String PREFS_PERSIST_ORACLE = "ctc.model.persist.oracle";
    public static final String PREFS_PERSIST_ORACLE_CACHE = "ctc.model.persist.oracle.OracleConnectionCacheImpl";
    public static final String PREFS_PERSIST_DRIVER = "driver";
    public static final String PREFS_PERSIST_CONN = "connect";
    public static final String PREFS_SIZER = "statesizer";
    public static final String PREFS_DSCLASS = "dsclass";
    public static final String PREFS_PERSIST_CONN_PREFIX = "connect.prefix";
    static final int BATCH_SIZE = IModelPersistenceConstants.BATCH_SIZE;
    private static final String PACKAGE_PREFIX = "ot_memfp";
    public static final String INSERT_EMPTY_BLOB_PROC = "insert_empty_blob";
    public static final String INSERT_EMPTY_BLOB_PROC_STMT = StateDAO.createCall("insert_empty_blob", 3);
    public static final String CHANGE_NODE_ID_PROC = "change_node_id";
    private static final String CHANGE_NODE_ID_PROC_STMT = StateDAO.createCall("change_node_id", 3);
    public static final String UPDATE_SEQ_NUM_PROC = "update_seq_num";
    private static final String UPDATE_SEQ_NUM_PROC_STMT = StateDAO.createCall("update_seq_num", 3);
    public static final String GET_SEQ_NUM_PROC = "get_seq_num";
    private static final String GET_SEQ_NUM_PROC_STMT = StateDAO.createCall("get_seq_num", 3);
    public static final String DEL_PARTITION_PROC = "del_partition";
    private static final String DEL_PARTITION_PROC_STMT = StateDAO.createCall("del_partition", 3);
    static final String[] StringArrayTemplate = new String[0];
    public static final String MODEL_INSERT = "INSERT INTO ne_model_state (node_id,model_type,model_index,data) values (?,?,?,empty_blob())";
    public static final String MODEL_TYPE_SEQ_NUM_INSERT = "INSERT INTO ne_model_type (node_id,model_type,sequence_num) values (?,?,?)";
    public static final String MODEL_UPDATE = "UPDATE ne_model_state SET data = ? WHERE node_id = ? AND model_type = ? AND model_index = ?";
    public static final String MODEL_TYPE_SEQ_NUM_UPDATE = "UPDATE ne_model_type SET sequence_num = ? WHERE node_id = ? AND model_type = ?";
    public static final String MODEL_SELECT = "SELECT data FROM ne_model_state WHERE node_id = ? AND model_type = ? AND model_index = ?";
    public static final String MODEL_SELECT_IN = "SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (";
    private static final String RPEN_FOR_UPDATE = ") FOR UPDATE";
    static final String[] MODEL_SELECT_IN_FOR_UPDATE_ARRAY = new String[]{StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 1) + ") FOR UPDATE", StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 2) + ") FOR UPDATE", StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 3) + ") FOR UPDATE", StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 4) + ") FOR UPDATE", StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 5) + ") FOR UPDATE", StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 6) + ") FOR UPDATE", StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 7) + ") FOR UPDATE", StateDAO.addParamListExpression("SELECT node_id,model_type,model_index,data FROM ne_model_state WHERE (node_id,model_type,model_index) IN (", 3, 8) + ") FOR UPDATE"};
    static final int JDBC_BATCH_UPDATE_COUNT_UNKNOWN = -2;
    public static final String MODELS_BY_TYPE_SELECT = "SELECT model_type,model_index,data FROM ne_model_state WHERE node_id = ? AND model_type = ?";
    public static final String MODELS_BY_NODE_SELECT = "SELECT model_type,model_index,data FROM ne_model_state WHERE node_id = ?";
    public static final String MODELS_GROUPED_BY_INDEX = "SELECT model_index,COUNT(model_type) FROM ne_model_state WHERE node_id = ? GROUP BY model_index ORDER BY model_index";
    public static final String MODEL_SELECT_FOR_UPDATE = "SELECT data FROM ne_model_state WHERE node_id = ? AND model_type = ? AND model_index = ? FOR UPDATE";
    public static final String MODEL_LENGTH_SELECT = "SELECT LENGTHB(data) FROM ne_model_state WHERE node_id = ? AND model_type = ? AND model_index = ?";
    public static final String MODEL_INDEX_SELECT = "SELECT model_index FROM ne_model_state WHERE node_id = ? AND model_type = ?";
    public static final String MODEL_TYPE_COUNT_SELECT = "SELECT COUNT(*) FROM ne_model_state WHERE node_id = ? AND model_type = ?";
    public static final String ALL_SELECT = "SELECT node_id,model_type,model_index,LENGTHB(data) FROM ne_model_state ORDER BY node_id,model_type,model_index";
    public static final String SEQUENCE_NUM_SELECT = "SELECT sequence_num FROM ne_model_type WHERE node_id = ? AND model_type = ?";
    public static final String MODEL_TYPES_SELECT = "SELECT model_type,sequence_num FROM ne_model_type WHERE node_id = ? ORDER BY model_type";
    public static final String MODEL_DELETE = "DELETE FROM ne_model_state WHERE node_id = ? AND model_type = ? AND model_index = ?";
    public static final String MODEL_INDEX_DELETE = "DELETE FROM ne_model_state WHERE node_id = ? AND model_index = ?";
    public static final String MODEL_TYPE_DELETE = "DELETE FROM ne_model_state WHERE node_id = ? AND model_type = ?";
    public static final String MODEL_TYPE_ALL_DELETE = "DELETE FROM ne_model_type";
    public static final String NODE_DELETE = "DELETE FROM ne_model_type WHERE node_id = ?";
    private static final String ORACLE_DATA_SOURCE_CLASS = "oracle.jdbc.pool.OracleConnectionCacheImpl";
    private static final String ORACLE_CONNECTION_CLASS = "oracle.jdbc.driver.OracleConnection";
    private static final String ORACLE_RESULT_SET_CLASS = "oracle.jdbc.driver.OracleResultSet";
    private static final String ORACLE_BLOB_OUTPUT_STREAM_CLASS = "oracle.jdbc.driver.OracleBlobOutputStream";
    private static final String ORACLE_BLOB_INPUT_STREAM_CLASS = "oracle.jdbc.driver.OracleBlobInputStream";
    private static final String ORACLE_BLOB_CLASS = "oracle.sql.BLOB";
    private static final String ORACLE_GET_BLOB_METHOD = "getBLOB";
    private static final String ORACLE_SET_DEFAULT_ROW_PREFETCH_METHOD = "setDefaultRowPrefetch";
    private static final String ORACLE_GET_BINARY_OUTPUT_STREAM_METHOD = "getBinaryOutputStream";
    private static final String ORACLE_SET_URL_METHOD = "setURL";
    private static final String ORACLE_SET_USER_METHOD = "setUser";
    private static final String ORACLE_SET_PWORD_METHOD = "setPassword";
    private static Class OracleDataSourceClass;
    private static DataSource DefaultDataSource;
    private static Integer CacheMin;
    private static Integer CacheMax;
    private static final int DYNAMIC_SCHEME = 1;
    private static final int FIXED_WAIT_SCHEME = 2;
    private static final int FIXED_RETURN_NULL_SCHEME = 3;
    private static boolean DsClassCantBeLoaded;
    private static Class OracleConnectionClass;
    private static Class OracleResultSetClass;
    private static Class OracleBlobOutputStreamClass;
    private static Class OracleBlobInputStreamClass;
    private static Class OracleBlobClass;
    private static Class[] OracleStreamCtorArgTypes;
    private static Class[] OraclePrefetchArgTypes;
    private static Method getBLOBMethod;
    private static Method setDefaultRowPrefetchMethod;
    private static Method getBinaryOutputStreamMethod;
    private static Method setURLMethod;
    private static Method setUserMethod;
    private static Method setPasswordMethod;
    private static Method setCacheMinMethod;
    private static Method setCacheMaxMethod;
    private static Method setCacheSchemeMethod;
    static final int CONSTR_VIOLATION_ERROR = 1;
    String connectionPrefix = "jdbc:oracle:oci:@";
    final String database;
    final String user;
    final String password;
    String connstr;
    DataSource dataSource;
    Debug db;
    ModelStateSizer sizer;
    boolean isInited;
    IStreamer streamer;

    public StateDAO(String string, String string2, String string3) {
        this.database = string;
        this.user = string2;
        this.password = string3;
    }

    @Override
    public void setDebug(SDebug sDebug) {
        if (this.db != null || !(sDebug instanceof Debug)) {
            return;
        }
        this.db = (Debug)sDebug;
        boolean bl = Preferences.instance().getBoolean(PREFS_PERSIST, PREFS_SIZER, false);
        if (bl && sDebug != null) {
            this.sizer = new ModelStateSizer(sDebug);
        }
    }

    @Override
    public boolean save(INetwideModelIdentity iNetwideModelIdentity, Object object) throws PersistenceException {
        return this.save(iNetwideModelIdentity, object, -1L, false);
    }

    @Override
    public boolean save(INetwideModelIdentity iNetwideModelIdentity, Object object, long l) throws PersistenceException {
        return this.save(iNetwideModelIdentity, object, l, true);
    }

    protected static String displayid(Object object) {
        String string;
        if (object == null) {
            string = "null";
        } else {
            String string2 = object.getClass().getName();
            string = string2.substring(string2.lastIndexOf(".") + 1) + "-0x" + Integer.toHexString(System.identityHashCode(object));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(INetwideModelIdentity iNetwideModelIdentity, Object object, long l, boolean bl) throws PersistenceException {
        PersistenceException persistenceException;
        boolean bl2;
        block23: {
            boolean bl3 = true;
            bl2 = true;
            if (this.db != null && this.db.on()) {
                this.db.println("about to save an obj: " + StateDAO.displayid(object) + " id: " + iNetwideModelIdentity.prettyString() + (!bl ? "" : " seq #: " + l) + " of memory size: " + this.sizeOf(object) + " bytes");
            }
            int n = iNetwideModelIdentity.getNodeId();
            int n2 = iNetwideModelIdentity.getModelType();
            int n3 = iNetwideModelIdentity.getIndex();
            OutputStream outputStream = null;
            persistenceException = null;
            Connection connection = null;
            try {
                block22: {
                    connection = this.getConnection();
                    CallableStatement callableStatement = StateDAO.createCallStatement(connection, INSERT_EMPTY_BLOB_PROC_STMT);
                    int n4 = 1;
                    callableStatement.setInt(n4++, n);
                    callableStatement.setInt(n4++, n2);
                    callableStatement.setInt(n4++, n3);
                    boolean bl4 = false;
                    try {
                        if (bl) {
                            try {
                                this.saveSeqNum(connection, n, n2, l);
                            }
                            catch (SQLException sQLException) {
                                if (persistenceException == null) {
                                    persistenceException = new PersistenceException("The sequence number could not be modified.", sQLException);
                                }
                                throw persistenceException;
                            }
                            bl4 = true;
                        }
                        callableStatement.execute();
                        outputStream = this.writeBlob(connection, n, n2, n3, object);
                        outputStream = StateDAO.close(outputStream);
                        connection.commit();
                        bl3 = false;
                    }
                    catch (SQLException sQLException) {
                        int n5 = sQLException.getErrorCode();
                        if (bl4 && n5 == 1) {
                            connection.rollback();
                            bl2 = false;
                            try {
                                outputStream = this.writeBlob(connection, n, n2, n3, object);
                                outputStream = StateDAO.close(outputStream);
                                connection.commit();
                                bl3 = false;
                            }
                            catch (SQLException sQLException2) {
                                if (this.db.on()) {
                                    Debug.printStackTrace((Throwable)sQLException2);
                                }
                                if (persistenceException == null) {
                                    persistenceException = new PersistenceException("StateDAO.save() update failed", sQLException);
                                }
                                break block22;
                            }
                        }
                        if (this.db.on()) {
                            Debug.printStackTrace((Throwable)sQLException);
                        }
                        if (persistenceException != null) break block22;
                        persistenceException = new PersistenceException("StateDAO.save() non-constraint insert error", sQLException);
                    }
                }
                StateDAO.close(outputStream);
            }
            catch (SQLException sQLException) {
                if (this.db.on()) {
                    Debug.printStackTrace((Throwable)sQLException);
                }
                if (persistenceException == null) {
                    persistenceException = new PersistenceException("StateDAO.save() pre commit failure", sQLException);
                }
                break block23;
            }
            finally {
                StateDAO.close(outputStream);
                StateDAO.close(connection, bl3);
            }
            StateDAO.close(connection, bl3);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.isFinestEnabled()) {
            int n = this.retrieveLength(iNetwideModelIdentity);
            this.db.finest("streamed obj: " + StateDAO.displayid(object) + " id: " + iNetwideModelIdentity.prettyString() + " " + n + " bytes to database blob");
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchSave(IStateBatchInfo[] iStateBatchInfoArray) throws PersistenceException {
        if (iStateBatchInfoArray == null || iStateBatchInfoArray.length == 0) {
            return true;
        }
        if (iStateBatchInfoArray.length > BATCH_SIZE) {
            throw new PersistenceException("batch size of " + iStateBatchInfoArray.length + " cannot exceed " + BATCH_SIZE + " - suggest setting cerent.cms.model.persist.batch=" + iStateBatchInfoArray.length, null);
        }
        boolean bl = true;
        boolean bl2 = true;
        if (this.db != null && this.db.on()) {
            this.batchLogSave(iStateBatchInfoArray);
        }
        OutputStream[] outputStreamArray = null;
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            int n;
            int n2;
            connection = this.getConnection();
            CallableStatement callableStatement = StateDAO.createCallStatement(connection, INSERT_EMPTY_BLOB_PROC_STMT);
            for (n2 = 0; n2 < iStateBatchInfoArray.length; ++n2) {
                IStateBatchInfo iStateBatchInfo = iStateBatchInfoArray[n2];
                if (iStateBatchInfo == null) {
                    throw new PersistenceException("all items in batch must be non-null. Item " + n2 + " was found null", null);
                }
                if (iStateBatchInfo.doSkip()) continue;
                INetwideModelIdentity iNetwideModelIdentity = iStateBatchInfo.getId();
                int n3 = iNetwideModelIdentity.getNodeId();
                int n4 = iNetwideModelIdentity.getModelType();
                int n5 = iNetwideModelIdentity.getIndex();
                n = 1;
                callableStatement.setInt(n++, n3);
                callableStatement.setInt(n++, n4);
                callableStatement.setInt(n++, n5);
                callableStatement.addBatch();
            }
            n2 = 0;
            n = 0;
            try {
                block26: {
                    try {
                        n = this.batchSaveSeqNum(connection, iStateBatchInfoArray);
                    }
                    catch (SQLException sQLException) {
                        if (persistenceException != null) break block26;
                        persistenceException = new PersistenceException("Sequence num modify failed", sQLException);
                        throw persistenceException;
                    }
                }
                n2 = n > 0 ? 1 : 0;
                callableStatement.executeBatch();
                outputStreamArray = this.batchWriteBlob(connection, iStateBatchInfoArray);
                outputStreamArray = StateDAO.close(outputStreamArray);
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                int n6 = sQLException.getErrorCode();
                if (n2 != 0 && n6 == 1) {
                    connection.rollback();
                    bl2 = false;
                    try {
                        outputStreamArray = this.batchWriteBlob(connection, iStateBatchInfoArray);
                        outputStreamArray = StateDAO.close(outputStreamArray);
                        connection.commit();
                        bl = false;
                    }
                    catch (SQLException sQLException2) {
                        if (this.db.on()) {
                            Debug.printStackTrace((Throwable)sQLException2);
                        }
                        if (persistenceException == null) {
                            persistenceException = new PersistenceException("StateDAO.batchSave() update failed", sQLException);
                        }
                    }
                } else {
                    if (this.db.on()) {
                        Debug.printStackTrace((Throwable)sQLException);
                    }
                    if (persistenceException == null) {
                        persistenceException = new PersistenceException("StateDAO.batchSave() non-constraint insert error", sQLException);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            if (this.db.on()) {
                Debug.printStackTrace((Throwable)sQLException);
            }
            if (persistenceException == null) {
                persistenceException = new PersistenceException("StateDAO.batchSave() pre commit failure", sQLException);
            }
        }
        finally {
            StateDAO.close(outputStreamArray);
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.isFinestEnabled()) {
            this.batchLogStream(iStateBatchInfoArray);
        }
        return bl2;
    }

    private String sizeOf(Object object) {
        String string = this.sizer != null ? Integer.toString(this.sizer.sizeOf(object)) : SIZE_UNAVAIL;
        return string;
    }

    private OutputStream writeBlob(Connection connection, int n, int n2, int n3, Object object) throws SQLException, PersistenceException {
        PreparedStatement preparedStatement = StateDAO.createSelect(connection, MODEL_SELECT_FOR_UPDATE);
        int n4 = 1;
        preparedStatement.setInt(n4++, n);
        preparedStatement.setInt(n4++, n2);
        preparedStatement.setInt(n4++, n3);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return this.writeToOutputStreamFromLocator(resultSet, 1, object);
        }
        return null;
    }

    private OutputStream[] batchWriteBlob(Connection connection, IStateBatchInfo[] iStateBatchInfoArray) throws SQLException, PersistenceException {
        int n;
        int n2;
        int n3;
        IStateBatchInfo iStateBatchInfo;
        OutputStream[] outputStreamArray = new OutputStream[iStateBatchInfoArray.length];
        if (iStateBatchInfoArray == null || iStateBatchInfoArray.length == 0) {
            return outputStreamArray;
        }
        int n4 = 0;
        for (int i = 0; i < iStateBatchInfoArray.length; ++i) {
            iStateBatchInfo = iStateBatchInfoArray[i];
            if (iStateBatchInfo.doSkip()) continue;
            ++n4;
        }
        if (n4 == 0) {
            return outputStreamArray;
        }
        String string = MODEL_SELECT_IN_FOR_UPDATE_ARRAY[n4 - 1];
        PreparedStatement preparedStatement = StateDAO.createSelect(connection, string);
        int n5 = 1;
        for (int i = 0; i < iStateBatchInfoArray.length; ++i) {
            iStateBatchInfo = iStateBatchInfoArray[i];
            if (iStateBatchInfo.doSkip()) continue;
            INetwideModelIdentity iNetwideModelIdentity = iStateBatchInfo.getId();
            n3 = iNetwideModelIdentity.getNodeId();
            n2 = iNetwideModelIdentity.getModelType();
            n = iNetwideModelIdentity.getIndex();
            preparedStatement.setInt(n5++, n3);
            preparedStatement.setInt(n5++, n2);
            preparedStatement.setInt(n5++, n);
        }
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (this.db != null && this.db.on()) {
                this.db.println("error in doing '" + string + "': " + sQLException);
            }
            throw sQLException;
        }
        int n6 = 0;
        while (resultSet.next()) {
            n3 = resultSet.getInt(1);
            Object object = StateDAO.getState(iStateBatchInfoArray, n3, n2 = resultSet.getInt(2), n = resultSet.getInt(3));
            if (object != null) {
                outputStreamArray[n6] = this.writeToOutputStreamFromLocator(resultSet, 4, object);
            }
            ++n6;
        }
        return outputStreamArray;
    }

    private static Object getState(IStateBatchInfo[] iStateBatchInfoArray, int n, int n2, int n3) {
        Object object = null;
        for (int i = 0; i < iStateBatchInfoArray.length; ++i) {
            int n4;
            int n5;
            IStateBatchInfo iStateBatchInfo = iStateBatchInfoArray[i];
            INetwideModelIdentity iNetwideModelIdentity = iStateBatchInfo.getId();
            int n6 = iNetwideModelIdentity.getNodeId();
            if (n6 != n || (n5 = iNetwideModelIdentity.getModelType()) != n2 || (n4 = iNetwideModelIdentity.getIndex()) != n3) continue;
            object = iStateBatchInfo.getState();
            break;
        }
        return object;
    }

    private void batchLogSave(IStateBatchInfo[] iStateBatchInfoArray) {
        int n = 0;
        for (int i = 0; i < iStateBatchInfoArray.length; ++i) {
            IStateBatchInfo iStateBatchInfo = iStateBatchInfoArray[i];
            if (iStateBatchInfo.doSkip()) continue;
            ++n;
            INetwideModelIdentity iNetwideModelIdentity = iStateBatchInfo.getId();
            Long l = iStateBatchInfo.getSeqNum();
            boolean bl = l != -1L;
            Object object = iStateBatchInfo.getState();
            int n2 = iNetwideModelIdentity.getNodeId();
            int n3 = iNetwideModelIdentity.getModelType();
            int n4 = iNetwideModelIdentity.getIndex();
            this.db.println("about to batch-save obj item: " + StateDAO.displayid(object) + " id: " + iNetwideModelIdentity.prettyString() + (!bl ? "" : " seq #: " + l) + " of memory size: " + this.sizeOf(object) + " bytes");
        }
        if (n > 0) {
            this.db.println("batch-saving in total: " + n + " objs");
        }
    }

    private void batchLogStream(IStateBatchInfo[] iStateBatchInfoArray) {
        for (int i = 0; i < iStateBatchInfoArray.length; ++i) {
            IStateBatchInfo iStateBatchInfo = iStateBatchInfoArray[i];
            if (iStateBatchInfo.doSkip()) continue;
            INetwideModelIdentity iNetwideModelIdentity = iStateBatchInfo.getId();
            Object object = iStateBatchInfo.getState();
            int n = -1;
            try {
                this.retrieveLength(iNetwideModelIdentity);
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
            this.db.finest("streamed obj: " + StateDAO.displayid(object) + " id: " + iNetwideModelIdentity.prettyString() + " " + n + " bytes to database blob");
        }
    }

    protected OutputStream writeToOutputStreamFromLocator(ResultSet resultSet, int n, Object object) throws PersistenceException {
        try {
            Blob blob = (Blob)getBLOBMethod.invoke((Object)resultSet, new Integer(n));
            return this.encode(this.getBlobOutputStream(blob), object);
        }
        catch (Exception exception) {
            if (this.db != null && this.db.on()) {
                this.db.println("writeToOutputStreamFromLocator failed" + exception);
                Debug.printStackTrace((Throwable)exception);
            }
            throw new PersistenceException("writeToOutputStreamFromLocator failed", exception);
        }
    }

    private OutputStream getBlobOutputStream(Blob blob) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        OutputStream outputStream = null;
        int n = IModelPersistenceConstants.BLOB_WRITE_BUFFER_SIZE;
        outputStream = (OutputStream)this.callCtor(OracleBlobOutputStreamClass, OracleStreamCtorArgTypes, new Object[]{blob, new Integer(n)});
        return outputStream;
    }

    private Object callCtor(Class clazz, Class[] classArray, Object[] objectArray) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Constructor constructor = clazz.getConstructor(classArray);
        return constructor.newInstance(objectArray);
    }

    void saveSeqNum(Connection connection, int n, int n2, long l) throws SQLException {
        CallableStatement callableStatement = StateDAO.createCallStatement(connection, UPDATE_SEQ_NUM_PROC_STMT);
        int n3 = 1;
        callableStatement.setInt(n3++, n);
        callableStatement.setInt(n3++, n2);
        callableStatement.setLong(n3++, l);
        callableStatement.executeUpdate();
        callableStatement.execute();
    }

    int batchSaveSeqNum(Connection connection, IStateBatchInfo[] iStateBatchInfoArray) throws SQLException {
        int n = 0;
        CallableStatement callableStatement = StateDAO.createCallStatement(connection, UPDATE_SEQ_NUM_PROC_STMT);
        for (int i = 0; i < iStateBatchInfoArray.length; ++i) {
            Long l;
            IStateBatchInfo iStateBatchInfo = iStateBatchInfoArray[i];
            if (iStateBatchInfo.doSkip() || (l = iStateBatchInfo.getSeqNum()) == -1L) continue;
            INetwideModelIdentity iNetwideModelIdentity = iStateBatchInfo.getId();
            int n2 = iNetwideModelIdentity.getNodeId();
            int n3 = iNetwideModelIdentity.getModelType();
            int n4 = 1;
            callableStatement.setInt(n4++, n2);
            callableStatement.setInt(n4++, n3);
            callableStatement.setLong(n4++, (long)l);
            callableStatement.addBatch();
        }
        int[] nArray = callableStatement.executeBatch();
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] == -2 ? 1 : nArray[i];
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object retrieve(INetwideModelIdentity iNetwideModelIdentity, Object object) throws PersistenceException {
        if (iNetwideModelIdentity == null) {
            return null;
        }
        int n = iNetwideModelIdentity.getNodeId();
        int n2 = iNetwideModelIdentity.getModelType();
        int n3 = iNetwideModelIdentity.getIndex();
        PersistenceException persistenceException = null;
        Object object2 = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createSelect(connection, MODEL_SELECT);
            int n4 = 1;
            preparedStatement.setInt(n4++, n);
            preparedStatement.setInt(n4++, n2);
            preparedStatement.setInt(n4++, n3);
            ResultSet resultSet = preparedStatement.executeQuery();
            long l = 0L;
            if (resultSet.next()) {
                object2 = this.decodeBlob(n, n2, resultSet, 1, object);
            } else if (this.db != null && this.db.isFinestEnabled()) {
                this.db.finest("no obj for (" + iNetwideModelIdentity.prettyString() + ") to retrieve from the database");
            }
        }
        catch (SQLException sQLException) {
            if (this.db != null && this.db.on()) {
                this.db.println("retrieve sql error: " + sQLException);
            }
            persistenceException = new PersistenceException("StateDAO.retrieve() failed", sQLException);
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null) {
            this.db.printContext();
        }
        return object2;
    }

    @Override
    public void bulkRetrieve(INetwideModelTypeIdentity iNetwideModelTypeIdentity, IContextFactory iContextFactory) throws PersistenceException {
        if (iNetwideModelTypeIdentity != null) {
            int n = iNetwideModelTypeIdentity.getNodeId();
            int n2 = iNetwideModelTypeIdentity.getModelType();
            this.bulkRetrieve(n, n2, iContextFactory);
        }
    }

    @Override
    public void bulkRetrieve(INetwideNodeIdentity iNetwideNodeIdentity, IContextFactory iContextFactory) throws PersistenceException {
        if (iNetwideNodeIdentity != null) {
            int n = iNetwideNodeIdentity.getNodeId();
            int n2 = -1;
            this.bulkRetrieve(n, n2, iContextFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object decodeBlob(int n, int n2, ResultSet resultSet, int n3, Object object) throws SQLException, PersistenceException {
        InputStream inputStream = null;
        Object object2 = null;
        Blob blob = resultSet.getBlob(n3);
        long l = 0L;
        try {
            if (blob != null) {
                ReflectiveOperationException reflectiveOperationException = null;
                try {
                    inputStream = this.getBlobInputStream(blob);
                }
                catch (IllegalAccessException illegalAccessException) {
                    reflectiveOperationException = illegalAccessException;
                }
                catch (InstantiationException instantiationException) {
                    reflectiveOperationException = instantiationException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    reflectiveOperationException = invocationTargetException;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    reflectiveOperationException = noSuchMethodException;
                }
                if (reflectiveOperationException != null) {
                    throw new PersistenceException("getBlobInputStream failed", reflectiveOperationException);
                }
                l = blob.length();
            }
            if (inputStream != null) {
                object2 = this.decode(inputStream, object, n2);
                inputStream = null;
                if (this.db != null && this.db.on()) {
                    if (object2 != null) {
                        this.db.println("read an obj: " + StateDAO.displayid(object2) + "(" + n + "," + n2 + ") of stream size: " + l + " bytes (memory size: " + this.sizeOf(object2) + ") the database");
                    } else if (this.db.isFinestEnabled()) {
                        this.db.finest("no obj for (" + n + "," + n2 + ") to retrieve from the database");
                    }
                }
            }
        }
        finally {
            StateDAO.close(inputStream);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bulkRetrieve(int n, int n2, IContextFactory iContextFactory) throws PersistenceException {
        PersistenceException persistenceException = null;
        Object object = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = n2 >= 0 ? StateDAO.createSelect(connection, MODELS_BY_TYPE_SELECT) : StateDAO.createSelect(connection, MODELS_BY_NODE_SELECT);
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            if (n2 >= 0) {
                preparedStatement.setInt(n3++, n2);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            long l = 0L;
            int n4 = 0;
            while (resultSet.next()) {
                int n5;
                ++n4;
                int n6 = resultSet.getInt(1);
                Object object2 = iContextFactory.find(n6, n5 = resultSet.getInt(2));
                if (object2 == null) continue;
                object = this.decodeBlob(n, n2, resultSet, 3, object2);
            }
            if (n4 == 0 && this.db != null && this.db.isFinestEnabled()) {
                this.db.finest("no objs for (" + n + "," + n2 + ") to retrieve from the database");
            }
        }
        catch (SQLException sQLException) {
            if (this.db != null && this.db.on()) {
                this.db.println("retrieve sql error: " + sQLException);
            }
            persistenceException = new PersistenceException("StateDAO.bulkRetrieve() failed", sQLException);
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null) {
            this.db.printContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nodeIdQuery(int n, String string, IResultSetHandler iResultSetHandler) throws PersistenceException {
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createSelect(connection, string);
            int n2 = 1;
            preparedStatement.setInt(n2++, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            while (resultSet.next()) {
                ++n3;
                if (iResultSetHandler == null) continue;
                iResultSetHandler.handle(resultSet);
            }
            if (n3 == 0 && this.db != null && this.db.isFinestEnabled()) {
                this.db.finest("no objs for (" + n + ") to retrieve from the database");
            }
        }
        catch (SQLException sQLException) {
            if (this.db != null && this.db.on()) {
                this.db.println("retrieve sql error: " + sQLException);
            }
            persistenceException = new PersistenceException("StateDAO.bulkGroupByRetrieve() failed", sQLException);
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
    }

    public void bulkGroupByRetrieve(int n, IResultSetHandler iResultSetHandler) throws PersistenceException {
        this.nodeIdQuery(n, MODELS_GROUPED_BY_INDEX, iResultSetHandler);
    }

    public void bulkRetrieveSeqNums(int n, IResultSetHandler iResultSetHandler) throws PersistenceException {
        this.nodeIdQuery(n, MODEL_TYPES_SELECT, iResultSetHandler);
    }

    private InputStream getBlobInputStream(Blob blob) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        InputStream inputStream = null;
        int n = IModelPersistenceConstants.BLOB_READ_BUFFER_SIZE;
        inputStream = (InputStream)this.callCtor(OracleBlobInputStreamClass, OracleStreamCtorArgTypes, new Object[]{blob, new Integer(n)});
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveLength(INetwideModelIdentity iNetwideModelIdentity) throws PersistenceException {
        int n = 0;
        if (iNetwideModelIdentity == null) {
            return n;
        }
        int n2 = iNetwideModelIdentity.getNodeId();
        int n3 = iNetwideModelIdentity.getModelType();
        int n4 = iNetwideModelIdentity.getIndex();
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createSelect(connection, MODEL_LENGTH_SELECT);
            int n5 = 1;
            preparedStatement.setInt(n5++, n2);
            preparedStatement.setInt(n5++, n3);
            preparedStatement.setInt(n5++, n4);
            ResultSet resultSet = preparedStatement.executeQuery();
            long l = 0L;
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            if (this.db != null && this.db.on()) {
                this.db.println("retrieve sql error: " + sQLException);
            }
            persistenceException = new PersistenceException("StateDAO.retrieve() failed", sQLException);
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] retrieve() throws PersistenceException {
        PersistenceException persistenceException = null;
        Object var2_2 = null;
        Connection connection = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createSelect(connection, ALL_SELECT);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 1;
                int n2 = resultSet.getInt(n++);
                stringBuffer.append(Integer.toString(n2) + ",");
                n2 = resultSet.getInt(n++);
                stringBuffer.append(Integer.toString(n2) + ",");
                n2 = resultSet.getInt(n++);
                stringBuffer.append(Integer.toString(n2) + ",");
                n2 = resultSet.getInt(n++);
                stringBuffer.append(Integer.toString(n2));
                linkedList.add(stringBuffer.toString());
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.retrieve() failed", sQLException);
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        return linkedList.toArray(StringArrayTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int retrieveCount(INetwideModelTypeIdentity iNetwideModelTypeIdentity) throws PersistenceException {
        int n = 0;
        if (iNetwideModelTypeIdentity == null) {
            return 0;
        }
        int n2 = iNetwideModelTypeIdentity.getNodeId();
        int n3 = iNetwideModelTypeIdentity.getModelType();
        Connection connection = null;
        PersistenceException persistenceException = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createSelect(connection, MODEL_TYPE_COUNT_SELECT);
            int n4 = 1;
            preparedStatement.setInt(n4++, n2);
            preparedStatement.setInt(n4++, n3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.retrieveCount() failed", sQLException);
            n = -1;
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List retrieveModelIndicies(INetwideModelTypeIdentity iNetwideModelTypeIdentity) throws PersistenceException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (iNetwideModelTypeIdentity == null) {
            return arrayList;
        }
        int n = iNetwideModelTypeIdentity.getNodeId();
        int n2 = iNetwideModelTypeIdentity.getModelType();
        Connection connection = null;
        PersistenceException persistenceException = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createSelect(connection, MODEL_INDEX_SELECT);
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            preparedStatement.setInt(n3++, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(new Integer(resultSet.getInt(1)));
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.retrieveModelIndicies() failed", sQLException);
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long retrieveSequenceNum(INetwideModelTypeIdentity iNetwideModelTypeIdentity, long l) throws PersistenceException {
        int n = iNetwideModelTypeIdentity.getNodeId();
        int n2 = iNetwideModelTypeIdentity.getModelType();
        PersistenceException persistenceException = null;
        long l2 = l;
        Connection connection = null;
        try {
            connection = this.getConnection();
            CallableStatement callableStatement = StateDAO.createCallStatement(connection, GET_SEQ_NUM_PROC_STMT);
            int n3 = 1;
            callableStatement.setInt(n3++, n);
            callableStatement.setInt(n3++, n2);
            callableStatement.setLong(n3++, l2);
            callableStatement.registerOutParameter(3, 4);
            try {
                callableStatement.executeUpdate();
                l2 = callableStatement.getLong(3);
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.retrieveSequenceNum() failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.retrieveSequenceNum() failed", sQLException);
        }
        finally {
            StateDAO.close(connection);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(INetwideModelIdentity iNetwideModelIdentity) throws PersistenceException {
        boolean bl = true;
        int n = 0;
        int n2 = iNetwideModelIdentity.getNodeId();
        int n3 = iNetwideModelIdentity.getModelType();
        int n4 = iNetwideModelIdentity.getIndex();
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createInsertUpdateDelete(connection, MODEL_DELETE);
            int n5 = 1;
            preparedStatement.setInt(n5++, n2);
            preparedStatement.setInt(n5++, n3);
            preparedStatement.setInt(n5++, n4);
            try {
                n = preparedStatement.executeUpdate();
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.delete(model) failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.delete(model) failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.on()) {
            this.db.println("model state delete (" + n + ") an obj: " + n2 + "/" + n3 + "/" + n4);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(INetwideModelIdentity iNetwideModelIdentity, long l) throws PersistenceException {
        boolean bl = true;
        int n = 0;
        int n2 = iNetwideModelIdentity.getNodeId();
        int n3 = iNetwideModelIdentity.getModelType();
        int n4 = iNetwideModelIdentity.getIndex();
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createInsertUpdateDelete(connection, MODEL_DELETE);
            int n5 = 1;
            preparedStatement.setInt(n5++, n2);
            preparedStatement.setInt(n5++, n3);
            preparedStatement.setInt(n5++, n4);
            try {
                n = preparedStatement.executeUpdate();
                CallableStatement callableStatement = StateDAO.createCallStatement(connection, UPDATE_SEQ_NUM_PROC_STMT);
                n5 = 1;
                callableStatement.setInt(n5++, n2);
                callableStatement.setInt(n5++, n3);
                callableStatement.setLong(n5++, l);
                callableStatement.executeUpdate();
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.delete(model, seq #) failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.delete(model, seq #) failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.on()) {
            this.db.println("model state delete (" + n + ") an obj: " + n2 + "/" + n3 + "/" + n4 + " - " + l);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteIndex(INetwideModelIdentity iNetwideModelIdentity, long l) throws PersistenceException {
        boolean bl = true;
        int n = 0;
        int n2 = iNetwideModelIdentity.getNodeId();
        int n3 = iNetwideModelIdentity.getIndex();
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createInsertUpdateDelete(connection, MODEL_INDEX_DELETE);
            int n4 = 1;
            preparedStatement.setInt(n4++, n2);
            preparedStatement.setInt(n4++, n3);
            try {
                n = preparedStatement.executeUpdate();
                CallableStatement callableStatement = StateDAO.createCallStatement(connection, UPDATE_SEQ_NUM_PROC_STMT);
                n4 = 1;
                callableStatement.setInt(n4++, n2);
                callableStatement.setInt(n4++, 0);
                callableStatement.setLong(n4++, l);
                callableStatement.executeUpdate();
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.deleteIndex(model) failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.deleteIndex(model) failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.on()) {
            this.db.println("tindex delete (" + n + ") an obj: " + n2 + "/" + n3);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(INetwideModelTypeIdentity iNetwideModelTypeIdentity) throws PersistenceException {
        boolean bl = true;
        int n = 0;
        int n2 = iNetwideModelTypeIdentity.getNodeId();
        int n3 = iNetwideModelTypeIdentity.getModelType();
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createInsertUpdateDelete(connection, MODEL_TYPE_DELETE);
            int n4 = 1;
            preparedStatement.setInt(n4++, n2);
            preparedStatement.setInt(n4++, n3);
            try {
                n = preparedStatement.executeUpdate();
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.delete(model type) failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.delete(model type) failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.on()) {
            this.db.printContext();
            this.db.println("model type delete (" + n + ") an obj: " + n2 + "/" + n3);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deletePartition(INetwideModelTypeIdentity iNetwideModelTypeIdentity) throws PersistenceException {
        boolean bl = true;
        int n = 0;
        int n2 = iNetwideModelTypeIdentity.getNodeId();
        int n3 = iNetwideModelTypeIdentity.getModelType();
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            CallableStatement callableStatement = StateDAO.createCallStatement(connection, DEL_PARTITION_PROC_STMT);
            int n4 = 1;
            callableStatement.setInt(n4++, n2);
            callableStatement.setInt(n4++, n3);
            callableStatement.registerOutParameter(n4++, 4);
            try {
                callableStatement.executeUpdate();
                n = callableStatement.getInt(3);
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.delete(model type) failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.delete(model type) failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.on()) {
            this.db.printContext();
            this.db.println("model type delete (" + n + ") an obj: " + n2 + "/" + n3);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete() throws PersistenceException {
        boolean bl = true;
        int n = 0;
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createInsertUpdateDelete(connection, MODEL_TYPE_ALL_DELETE);
            boolean bl2 = true;
            try {
                n = preparedStatement.executeUpdate();
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.delete(all!) failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.delete(all!) failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        if (this.db != null && this.db.on()) {
            this.db.println("universal delete (" + n + ")");
        }
        return n;
    }

    @Override
    public int delete(INetwideNodeIdentity iNetwideNodeIdentity) throws PersistenceException {
        int n = iNetwideNodeIdentity.getNodeId();
        return this.deleteAllStateOfNode(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteAllStateOfNode(int n) throws PersistenceException {
        boolean bl = true;
        int n2 = 0;
        PersistenceException persistenceException = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement preparedStatement = StateDAO.createInsertUpdateDelete(connection, NODE_DELETE);
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            try {
                n2 = preparedStatement.executeUpdate();
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.delete(node) failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.delete(node) failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeNodeId(int n, int n2) throws PersistenceException {
        boolean bl = true;
        PersistenceException persistenceException = null;
        Connection connection = null;
        int n3 = 0;
        try {
            connection = this.getConnection();
            CallableStatement callableStatement = StateDAO.createCallStatement(connection, CHANGE_NODE_ID_PROC_STMT);
            int n4 = 1;
            callableStatement.setInt(n4++, n);
            callableStatement.setInt(n4++, n2);
            callableStatement.registerOutParameter(n4++, 4);
            try {
                callableStatement.executeUpdate();
                n3 = callableStatement.getInt(3);
                connection.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                persistenceException = new PersistenceException("StateDAO.changeNodeId() failed", sQLException);
            }
        }
        catch (SQLException sQLException) {
            persistenceException = new PersistenceException("StateDAO.changeNodeId() failed", sQLException);
        }
        finally {
            StateDAO.close(connection, bl);
        }
        if (persistenceException != null) {
            throw persistenceException;
        }
        return n3 == 0;
    }

    @Override
    public void init(IStreamer iStreamer, Object object) throws PersistenceException {
        if (this.isInited) {
            return;
        }
        try {
            if (iStreamer == null) {
                iStreamer = new SerializationStreamer();
            }
            this.streamer = iStreamer;
            if (object instanceof DataSource) {
                this.dataSource = (DataSource)object;
            }
            StateDAO.loadOracleSpecificDriverSupportClasses();
            this.loadDriver();
            StateDAO.loadOracleSpecificClasses();
            NetwideModelIdentity netwideModelIdentity = ModelIdentityFactory.instance().createNetwideModelIdentity(0, 0, 0);
            this.retrieve((INetwideModelIdentity)netwideModelIdentity, null);
            this.isInited = true;
        }
        catch (Exception exception) {
            if (this.db != null && this.db.on()) {
                Debug.printStackTrace((Throwable)exception);
            }
            throw new PersistenceException("init failed", exception);
        }
    }

    @Override
    public void init() throws PersistenceException {
        this.init(null, null);
    }

    protected static synchronized void loadOracleSpecificDriverSupportClasses() throws NoSuchMethodException {
        if (OracleDataSourceClass != null || DsClassCantBeLoaded) {
            return;
        }
        String string = Preferences.instance().getProperty(PREFS_PERSIST, PREFS_DSCLASS, ORACLE_DATA_SOURCE_CLASS);
        try {
            OracleDataSourceClass = Class.forName(string);
            setURLMethod = OracleDataSourceClass.getMethod(ORACLE_SET_URL_METHOD, String.class);
            setUserMethod = OracleDataSourceClass.getMethod(ORACLE_SET_USER_METHOD, String.class);
            setPasswordMethod = OracleDataSourceClass.getMethod(ORACLE_SET_PWORD_METHOD, String.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DsClassCantBeLoaded = true;
            System.out.println("Could not load DS class: " + string);
        }
        if (string.equals(ORACLE_DATA_SOURCE_CLASS) && !DsClassCantBeLoaded) {
            CacheMin = new Integer(Preferences.instance().getInt(PREFS_PERSIST_ORACLE_CACHE, "MinSize", 1));
            CacheMax = new Integer(Preferences.instance().getInt(PREFS_PERSIST_ORACLE_CACHE, "MaxSize", 1));
            setCacheMinMethod = OracleDataSourceClass.getMethod("setMinLimit", Integer.TYPE);
            setCacheMaxMethod = OracleDataSourceClass.getMethod("setMaxLimit", Integer.TYPE);
            setCacheSchemeMethod = OracleDataSourceClass.getMethod("setCacheScheme", Integer.TYPE);
        }
    }

    protected static synchronized void loadOracleSpecificClasses() throws ClassNotFoundException, NoSuchMethodException {
        if (OracleConnectionClass != null) {
            return;
        }
        OracleConnectionClass = Class.forName(ORACLE_CONNECTION_CLASS);
        OracleResultSetClass = Class.forName(ORACLE_RESULT_SET_CLASS);
        OracleBlobOutputStreamClass = Class.forName(ORACLE_BLOB_OUTPUT_STREAM_CLASS);
        OracleBlobInputStreamClass = Class.forName(ORACLE_BLOB_INPUT_STREAM_CLASS);
        OracleBlobClass = Class.forName(ORACLE_BLOB_CLASS);
        OracleStreamCtorArgTypes = new Class[]{OracleBlobClass, Integer.TYPE};
        OraclePrefetchArgTypes = new Class[]{Integer.TYPE};
        getBLOBMethod = OracleResultSetClass.getMethod(ORACLE_GET_BLOB_METHOD, Integer.TYPE);
        setDefaultRowPrefetchMethod = OracleConnectionClass.getDeclaredMethod(ORACLE_SET_DEFAULT_ROW_PREFETCH_METHOD, OraclePrefetchArgTypes);
        getBinaryOutputStreamMethod = OracleBlobClass.getMethod(ORACLE_GET_BINARY_OUTPUT_STREAM_METHOD, new Class[0]);
    }

    @Override
    public boolean doesGetReallyPersisted(Object object) {
        boolean bl;
        if (!IModelPersistenceConstants.ENABLE_PERSISTENCE) {
            return false;
        }
        if (object == null) {
            bl = true;
        } else {
            bl = false;
            bl = object instanceof Class ? ReflectionUtil.doesImplement((Class)((Class)object), IModelStatePersistedMarker.class) : object instanceof IModelStatePersistedMarker;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDriver() throws SQLException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object;
        String string = Preferences.instance().getProperty(PREFS_PERSIST, PREFS_PERSIST_DRIVER, DRIVER_CLASS);
        this.connectionPrefix = Preferences.instance().getProperty(PREFS_PERSIST, PREFS_PERSIST_CONN_PREFIX, ORACLE_OCI_CONN_PREFIX);
        this.connstr = this.connectionPrefix + this.database;
        String[] stringArray = new String[]{"oci", "thin"};
        Object object2 = null;
        for (int i = 0; i < stringArray.length && object2 == null; ++i) {
            object = stringArray[i];
            int n = this.connectionPrefix.indexOf((String)object);
            if (n < 0) continue;
            object2 = object;
        }
        if (object2 == null) {
            object2 = "???";
        }
        Class<?> clazz = Class.forName(string);
        object = clazz.getDeclaredConstructor(new Class[0]);
        Driver driver = (Driver)((Constructor)object).newInstance(new Object[0]);
        DriverManager.registerDriver(driver);
        System.out.println("loaded (" + (String)object2 + ") ORACLE driver: " + DRIVER_CLASS + " version: " + driver.getMajorVersion() + "." + driver.getMinorVersion());
        Class<StateDAO> clazz2 = StateDAO.class;
        synchronized (StateDAO.class) {
            if (DefaultDataSource == null) {
                try {
                    DefaultDataSource = (DataSource)this.callCtor(OracleDataSourceClass, null, null);
                    setURLMethod.invoke((Object)DefaultDataSource, this.connstr);
                    System.out.println("connect string: '" + this.connstr + "'");
                    setUserMethod.invoke((Object)DefaultDataSource, this.user);
                    setPasswordMethod.invoke((Object)DefaultDataSource, this.password);
                    if (DefaultDataSource.getClass().getName().equals(ORACLE_DATA_SOURCE_CLASS)) {
                        setCacheMinMethod.invoke((Object)DefaultDataSource, CacheMin);
                        setCacheMaxMethod.invoke((Object)DefaultDataSource, CacheMax);
                        System.out.println("default conn cache min/max set to: " + CacheMin + "/" + CacheMax);
                        setCacheSchemeMethod.invoke((Object)DefaultDataSource, new Integer(2));
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof InvocationTargetException) {
                        throwable2 = ((InvocationTargetException)throwable).getTargetException();
                    }
                    System.out.println("(" + OracleDataSourceClass + ") data source creation exception: " + throwable2);
                    throwable2.printStackTrace(System.out);
                }
            }
            // ** MonitorExit[var8_9] (shouldn't be in output)
            this.dataSource = DefaultDataSource;
            return;
        }
    }

    Connection getConnection() throws SQLException {
        Connection connection;
        block2: {
            connection = this.dataSource != null ? this.dataSource.getConnection(this.user, this.password) : DriverManager.getConnection(this.connstr, this.user, this.password);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            connection.setTransactionIsolation(2);
            connection.setAutoCommit(false);
            try {
                Method method = OracleConnectionClass.getDeclaredMethod(ORACLE_SET_DEFAULT_ROW_PREFETCH_METHOD, OraclePrefetchArgTypes);
                method.invoke((Object)connection, new Integer(IModelPersistenceConstants.PREFETCH_SIZE));
            }
            catch (Exception exception) {
                if (this.db == null || !this.db.on()) break block2;
                Debug.printStackTrace((Throwable)exception);
            }
        }
        return connection;
    }

    static PreparedStatement createInsertUpdateDelete(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        return preparedStatement;
    }

    static CallableStatement createCallStatement(Connection connection, String string, int n, boolean bl) throws SQLException {
        String string2 = StateDAO.createCall(string, n, bl);
        return StateDAO.createCallStatement(connection, string2);
    }

    static CallableStatement createCallStatement(Connection connection, String string) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall(string);
        return callableStatement;
    }

    static CallableStatement createCallStatement(Connection connection, String string, int n) throws SQLException {
        return StateDAO.createCallStatement(connection, string, n, false);
    }

    static CallableStatement createFuncStatement(Connection connection, String string, int n) throws SQLException {
        return StateDAO.createCallStatement(connection, string, n, true);
    }

    static String createCall(String string, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(bl ? "{?=call " : "{call ");
        stringBuffer.append("ot_memfp." + string);
        if (n > 0) {
            stringBuffer.append("(");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("?");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append("}");
        String string2 = stringBuffer.toString();
        return string2;
    }

    static String createCall(String string, int n) {
        return StateDAO.createCall(string, n, false);
    }

    static String createFunc(String string, int n) {
        return StateDAO.createCall(string, n, true);
    }

    static PreparedStatement createSelect(Connection connection, String string) throws SQLException {
        int n = 1003;
        int n2 = 1007;
        PreparedStatement preparedStatement = connection.prepareStatement(string, n, n2);
        return preparedStatement;
    }

    OutputStream encode(OutputStream outputStream, Object object) throws PersistenceException {
        OutputStream outputStream2 = null;
        boolean bl = true;
        try {
            try {
                outputStream2 = this.streamer.write(outputStream, object);
                bl = false;
            }
            catch (IOException iOException) {
                throw new PersistenceException("The encode failed.", iOException);
            }
        }
        catch (PersistenceException persistenceException) {
            if (this.db != null && this.db.on()) {
                this.db.println("encode error: " + (Object)((Object)persistenceException));
                Debug.printStackTrace((Throwable)((Object)persistenceException));
            }
            throw persistenceException;
        }
        finally {
            if (bl) {
                if (outputStream != null) {
                    StateDAO.close(outputStream);
                    outputStream = null;
                }
                if (outputStream2 != null) {
                    StateDAO.close(outputStream2);
                    outputStream2 = null;
                }
            }
        }
        return outputStream2;
    }

    Object decode(InputStream inputStream, Object object, INetwideModelIdentity iNetwideModelIdentity) throws PersistenceException {
        Object object2 = null;
        InputStream inputStream2 = null;
        try {
            inputStream2 = this.streamer.createInputStream(inputStream);
            if (inputStream2 != null) {
                object2 = this.streamer.read(inputStream2, object, iNetwideModelIdentity);
            } else if (this.db != null && this.db.on()) {
                this.db.println(iNetwideModelIdentity.prettyString() + " - blob input stream is 0-length");
            }
        }
        catch (IOException iOException) {
            if (this.db != null && this.db.on()) {
                this.db.println("decode io error: " + iOException);
            }
            throw new PersistenceException("decode failed", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.db != null && this.db.on()) {
                this.db.println("decode class error: " + classNotFoundException);
            }
            throw new PersistenceException("decode failed", classNotFoundException);
        }
        finally {
            if (inputStream2 != inputStream) {
                StateDAO.close(inputStream2);
            }
            StateDAO.close(inputStream);
        }
        return object2;
    }

    Object decode(InputStream inputStream, Object object, int n) throws PersistenceException {
        Object object2 = null;
        InputStream inputStream2 = null;
        try {
            inputStream2 = this.streamer.createInputStream(inputStream);
            if (inputStream2 != null) {
                object2 = this.streamer.read(inputStream2, object, n);
            } else if (this.db != null && this.db.on()) {
                this.db.println(Integer.toString(n) + " - blob input stream is 0-length");
            }
        }
        catch (IOException iOException) {
            if (this.db != null && this.db.on()) {
                this.db.println("decode io error: " + iOException);
            }
            throw new PersistenceException("The decode failed.", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.db != null && this.db.on()) {
                this.db.println("decode class error: " + classNotFoundException);
            }
            throw new PersistenceException("The decode failed.", classNotFoundException);
        }
        finally {
            if (inputStream2 != inputStream) {
                StateDAO.close(inputStream2);
            }
            StateDAO.close(inputStream);
        }
        return object2;
    }

    static void close(Connection connection, boolean bl) {
        if (connection != null) {
            try {
                connection.rollback();
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static void close(Connection connection) {
        StateDAO.close(connection, false);
    }

    static InputStream close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static OutputStream close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static OutputStream[] close(OutputStream[] outputStreamArray) {
        if (outputStreamArray != null) {
            for (int i = 0; i < outputStreamArray.length; ++i) {
                if (outputStreamArray[i] == null) continue;
                try {
                    outputStreamArray[i].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                outputStreamArray[i] = null;
            }
        }
        return null;
    }

    private static String addParamListExpression(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("(");
            for (int j = 0; j < n; ++j) {
                if (j > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("?");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    static {
        CacheMin = new Integer(1);
        CacheMax = new Integer(1);
    }

    public class Debug
    extends SDebug {
        boolean doContext;

        public Debug(KDebug kDebug, String string) {
            super(kDebug, string);
            this.doContext = false;
        }

        public Debug(String string) {
            super(string);
            this.doContext = false;
        }

        IStreamer getStreamer(String string) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            if (string == null) {
                return null;
            }
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("instance", new Class[0]);
            IStreamer iStreamer = (IStreamer)method.invoke(null, new Object[0]);
            return iStreamer;
        }

        public final void dumpdb() throws PersistenceException {
            String[] stringArray = StateDAO.this.retrieve();
            int n = stringArray == null ? 0 : stringArray.length;
            this.println("" + n + " rows in " + (Object)((Object)StateDAO.this.db));
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.println(stringArray[i]);
            }
        }

        public final void dumpIndicies(int n) throws PersistenceException {
            this.println("indicies for: " + n + " - sorted by index + count of model type");
            StateDAO.this.bulkGroupByRetrieve(n, new IResultSetHandler(){

                @Override
                public void handle(ResultSet resultSet) throws SQLException {
                    Debug.this.print(Integer.toString(resultSet.getInt(1)));
                    Debug.this.print("\t");
                    Debug.this.println(Integer.toString(resultSet.getInt(2)));
                }
            });
        }

        public final void dumpSeqNums(int n) throws PersistenceException {
            this.println("indicies for: " + n + " - sorted by index + count of model type");
            StateDAO.this.bulkRetrieveSeqNums(n, new IResultSetHandler(){

                @Override
                public void handle(ResultSet resultSet) throws SQLException {
                    Debug.this.print(Integer.toString(resultSet.getInt(1)));
                    Debug.this.print("\t");
                    Debug.this.println(Integer.toString(resultSet.getInt(2)));
                }
            });
        }

        public final void delete(int n) throws PersistenceException {
            int n2 = StateDAO.this.deleteAllStateOfNode(n);
            this.println("# rows deleted: " + n2);
        }

        public final void context(boolean bl) {
            this.doContext = bl;
        }

        public void printContext() {
            if (this.doContext) {
                Debug.printStackTrace((Throwable)new Exception());
            }
        }

        public final void isPersistingEnabled() {
            StateDAO.this.db.display(Boolean.toString(StateDAO.this.doesGetReallyPersisted(null)));
        }
    }
}

