/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Circuits.eCircuitSize;
import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.UcpCircuits.eCircuitState;
import cerent.cms.idl.UcpCircuits.sLabel;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.ucp.ILabel;
import cerent.cms.model.ucp.LabelFactory;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractUcpCircuitModel
extends Model {
    protected NodeModelDelegate node;
    protected sCircuitId circuitId;
    protected eCircuitSize cktSize;
    protected sLabel label;
    protected eCircuitState state;
    private EventDispatcher dispatcher;

    public AbstractUcpCircuitModel(NodeModelDelegate nodeModelDelegate, int n, sCircuitId sCircuitId2, eCircuitSize eCircuitSize2, eCircuitState eCircuitState2, sLabel sLabel2, SDebug sDebug) {
        super(sDebug);
        this.node = nodeModelDelegate;
        this.index = n;
        this.circuitId = sCircuitId2;
        this.cktSize = eCircuitSize2;
        this.label = sLabel2;
        this.state = eCircuitState2;
        this.dispatcher = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    public ICircuitId getCircuitId() {
        return CircuitIdFactory.getICircuitId(this.circuitId);
    }

    public int getCktSize() {
        return this.cktSize.value();
    }

    public ILabel getLabel() {
        return LabelFactory.getILabel(this.label);
    }

    public int getCircuitState() {
        return this.state.value();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update():    this DELETED");
                    }
                    this.removeFromParent();
                    this.dispose();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + " update():    this CHANGED");
                    }
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println(this.getClass().getName() + " update():    STRUCTURE CHANGED");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println(this.getClass().getName() + "update():    " + "UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    protected abstract ObjectType getObjectType();

    protected abstract void removeFromParent();

    public void init() {
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), this.index, (Observer)this);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), this.index, (Observer)this);
        }
        super.dispose();
    }

    protected void printString(SDebug sDebug) {
        sDebug.println("CircuitId:: nodeId: " + this.circuitId.nodeId + " UniquePart:: uniqueId: " + this.circuitId.uniquePart.uniqueId);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)this.getCktSize());
        sDebug.print("cktSize: " + iCircuitSize.size2widthOfHoCircuit() + " State: ");
        switch (this.state.value()) {
            case 0: {
                sDebug.println("CLOSED");
                break;
            }
            case 1: {
                sDebug.println("OPENING");
                break;
            }
            case 2: {
                sDebug.println("WAIT_CC");
                break;
            }
            case 3: {
                sDebug.println("RETRY");
                break;
            }
            case 4: {
                sDebug.println("LISTENING");
                break;
            }
            case 5: {
                sDebug.println("OPEN_PENDING");
                break;
            }
            case 6: {
                sDebug.println("CLEARING");
                break;
            }
            case 7: {
                sDebug.println("OPEN");
                break;
            }
            case 8: {
                sDebug.println("FAILED");
                break;
            }
            default: {
                sDebug.println("UNKNOWN");
            }
        }
        sDebug.println("Label:: s: " + this.label.s + " u: " + this.label.u + " k: " + this.label.k + " l: " + this.label.l + " m: " + this.label.m);
    }
}

