/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractUcpContainers
extends Model {
    protected NodeModelDelegate node;
    protected boolean createProcessed;
    protected Map itemsByIndex;
    private EventDispatcher dispatcher;

    public AbstractUcpContainers(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        super(sDebug);
        this.node = nodeModelDelegate;
        this.createProcessed = false;
        this.itemsByIndex = Collections.synchronizedMap(new HashMap());
        this.dispatcher = null;
    }

    @Override
    public void update(Observable observable, Object object) {
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 0: {
                if (!this.db.on()) break;
                this.db.println("update(): this DELETED");
                break;
            }
            case 1: {
                if (this.db.on()) {
                    this.db.println("update(): this CHANGED");
                }
                this.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on()) {
                    this.db.println("update(): ADDED");
                }
                try {
                    if (!this.updateStructure()) break;
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.ADDED);
                }
                catch (Exception exception) {
                    this.db.println("Caught exception in update");
                    SDebug.printStackTrace((Throwable)exception);
                }
                break;
            }
            default: {
                if (!this.db.on()) break;
                this.db.println("update(): UNKNOWN NE UPDATE TYPE" + n);
            }
        }
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    protected abstract ObjectType getObjectType();

    protected abstract boolean updateStructure();

    protected abstract void disposeItems(ArrayList var1);

    public void init() {
        if (this.db.on()) {
            this.db.println("init called");
        }
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), 0, (Observer)this);
        }
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose called");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), 0, (Observer)this);
        }
        ArrayList arrayList = new ArrayList(this.itemsByIndex.values());
        this.itemsByIndex.clear();
        this.disposeItems(arrayList);
        super.dispose();
    }

    protected static Collection getAddedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet.removeAll(hashSet2);
        return hashSet;
    }

    protected static Collection getDeletedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet2.removeAll(hashSet);
        return hashSet2;
    }
}

