/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Circuits.eCircuitSize;
import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sTnaAddr;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.UcpCircuits.eCircuitState;
import cerent.cms.idl.UcpCircuits.sCircuitTermination;
import cerent.cms.idl.UcpCircuits.sLabel;
import cerent.cms.idl.UcpCircuits.xCircuitIdInUse;
import cerent.cms.idl.UcpCircuits.xLabelInUse;
import cerent.cms.idl.UcpCircuits.xNoMoreCircuitTerminations;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CircuitIdStillInUse;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.LabelInUse;
import cerent.cms.model.NoMoreCircuitTerminations;
import cerent.cms.model.NoSuchCircuitTermination;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ucp.AbstractUcpCircuitModel;
import cerent.cms.model.ucp.AbstractUcpContainers;
import cerent.cms.model.ucp.ILabel;
import cerent.cms.model.ucp.ITnaAddr;
import cerent.cms.model.ucp.IUcpCircuitTerminationModel;
import cerent.cms.model.ucp.LabelFactory;
import cerent.cms.model.ucp.TnaAddrFactory;
import cerent.cms.model.ucp.UcpCircuitTerminationModel;
import cerent.cms.model.ucp.UcpCircuits;
import cerent.util.AnnotatedException;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class UcpCircuitTerminations
extends AbstractUcpContainers
implements Observer {
    private static final String MY_DEBUG_KEY = "UcpCircuitTerminations";
    private TerminationsList termsList;
    private CreateTermination createTermination;

    public UcpCircuitTerminations(NodeModelDelegate nodeModelDelegate, UcpCircuits ucpCircuits) {
        super(nodeModelDelegate, nodeModelDelegate.getDebug());
        this.termsList = new TerminationsList(nodeModelDelegate, "UcpCircuitTerminations::termsList");
        this.createTermination = new CreateTermination(nodeModelDelegate, "UcpCircuitTerminations::createTermination");
        this.db = new UcpCircuitTerminationsDebug(nodeModelDelegate.getDebug());
    }

    public UcpCircuitTerminationModel add(ICircuitId iCircuitId, int n, ITnaAddr iTnaAddr, int n2, ILabel iLabel, int n3) throws LabelInUse, CircuitIdStillInUse, NoMoreCircuitTerminations, InvalidParams {
        Object object;
        sCircuitId sCircuitId2 = null;
        sTnaAddr sTnaAddr2 = null;
        sLabel sLabel2 = null;
        if (iCircuitId != null) {
            sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        }
        if (iTnaAddr != null) {
            sTnaAddr2 = TnaAddrFactory.getTnaAddr(iTnaAddr);
        }
        if (iLabel != null) {
            sLabel2 = LabelFactory.getLabel(iLabel);
        }
        sCircuitTermination sCircuitTermination2 = new sCircuitTermination(0, sCircuitId2, n, sTnaAddr2, eCircuitSize.from_int(n2), sLabel2, eCircuitState.from_int(n3));
        try {
            object = new Object[]{sCircuitTermination2};
            sCircuitTermination2.objIndex = (Integer)this.createTermination.get(object);
        }
        catch (xLabelInUse xLabelInUse2) {
            throw new LabelInUse(AnnotatedException.getString((Exception)((Object)xLabelInUse2)));
        }
        catch (xCircuitIdInUse xCircuitIdInUse2) {
            throw new CircuitIdStillInUse(AnnotatedException.getString((Exception)((Object)xCircuitIdInUse2)));
        }
        catch (xNoMoreCircuitTerminations xNoMoreCircuitTerminations2) {
            throw new NoMoreCircuitTerminations(AnnotatedException.getString((Exception)((Object)xNoMoreCircuitTerminations2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        if (this.db.on()) {
            this.db.println("UcpCircuitTermination created with index = " + sCircuitTermination2.objIndex);
        }
        object = new UcpCircuitTerminationModel(this.node, this, sCircuitTermination2, this.db);
        ((AbstractUcpCircuitModel)object).init();
        this.itemsByIndex.put(new Integer(sCircuitTermination2.objIndex), object);
        this.createProcessed = true;
        return object;
    }

    public IUcpCircuitTerminationModel getCircuitTerminationByIndex(int n) throws NoSuchCircuitTermination {
        UcpCircuitTerminationModel ucpCircuitTerminationModel = (UcpCircuitTerminationModel)this.itemsByIndex.get(new Integer(n));
        if (ucpCircuitTerminationModel == null) {
            throw new NoSuchCircuitTermination("objIndex =" + n + " not found");
        }
        return ucpCircuitTerminationModel;
    }

    public IUcpCircuitTerminationModel[] getCircuitTerminationList() {
        IUcpCircuitTerminationModel[] iUcpCircuitTerminationModelArray = new UcpCircuitTerminationModel[this.itemsByIndex.values().size()];
        iUcpCircuitTerminationModelArray = this.itemsByIndex.values().toArray(iUcpCircuitTerminationModelArray);
        return iUcpCircuitTerminationModelArray;
    }

    @Override
    public void init() {
        super.init();
        this.discover(this.itemsByIndex);
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            ((UcpCircuitTerminationModel)iterator.next()).init();
        }
    }

    private void discover(Map map) {
        sCircuitTermination[] sCircuitTerminationArray = null;
        sCircuitTerminationArray = this.getTerminations();
        if (sCircuitTerminationArray == null) {
            this.db.println("Error in getting UcpNeighbors (null) UcpNeighbors::discover");
            return;
        }
        for (int i = 0; i < sCircuitTerminationArray.length; ++i) {
            if (sCircuitTerminationArray[i] == null) continue;
            Integer n = new Integer(sCircuitTerminationArray[i].objIndex);
            UcpCircuitTerminationModel ucpCircuitTerminationModel = new UcpCircuitTerminationModel(this.node, this, sCircuitTerminationArray[i], this.db);
            map.put(n, ucpCircuitTerminationModel);
        }
    }

    private sCircuitTermination[] getTerminations() {
        sCircuitTermination[] sCircuitTerminationArray = new sCircuitTermination[]{};
        try {
            sCircuitTerminationArray = (sCircuitTermination[])this.termsList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sCircuitTerminationArray;
    }

    private void discoverTerminations(HashMap hashMap) {
        sCircuitTermination[] sCircuitTerminationArray = this.getTerminations();
        if (sCircuitTerminationArray == null) {
            return;
        }
        for (int i = 0; i < sCircuitTerminationArray.length; ++i) {
            hashMap.put(new Integer(sCircuitTerminationArray[i].objIndex), sCircuitTerminationArray[i]);
        }
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ObjectUcpTerminationList;
    }

    @Override
    protected boolean updateStructure() {
        UcpCircuitTerminationModel ucpCircuitTerminationModel;
        Object object;
        Object object2;
        if (this.db.on()) {
            this.db.println("Entry::UcpCircuitTerminations::updateUcpCircuitTerminationsStructure()");
        }
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverTerminations(hashMap);
        Collection collection = UcpCircuitTerminations.getAddedObjects(hashMap.keySet(), this.itemsByIndex.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println("New term found # " + collection.size());
                    this.db.println(" Termination # " + object2);
                }
                object = (sCircuitTermination)hashMap.get(object2);
                ucpCircuitTerminationModel = new UcpCircuitTerminationModel(this.node, this, (sCircuitTermination)object, this.db);
                this.itemsByIndex.put(object2, ucpCircuitTerminationModel);
                ucpCircuitTerminationModel.init();
            }
            bl = true;
        }
        if (this.createProcessed) {
            bl = true;
            this.createProcessed = false;
        }
        if ((object2 = UcpCircuitTerminations.getDeletedObjects(hashMap.keySet(), this.itemsByIndex.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println("Deleted term found # " + object2.size());
                    this.db.println("Deleted term index " + object);
                }
                if ((ucpCircuitTerminationModel = (UcpCircuitTerminationModel)this.itemsByIndex.get(object)) == null) continue;
                this.itemsByIndex.remove(object);
            }
        }
        if (this.db.on()) {
            this.db.println("Exit::UcpCircuitTerminations::updateUcpCircuitTerminationsStructure()");
        }
        return bl;
    }

    public void remove(UcpCircuitTerminationModel ucpCircuitTerminationModel) {
        this.itemsByIndex.remove(new Integer(ucpCircuitTerminationModel.getIndex()));
    }

    @Override
    protected void disposeItems(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((UcpCircuitTerminationModel)iterator.next()).dispose();
            }
            catch (Exception exception) {
                this.db.println("Exception caught while deleting circuit " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void printUcpCircuitTerminationString(SDebug sDebug) {
        if (this.itemsByIndex == null || this.itemsByIndex.size() == 0) {
            sDebug.println("No UcpCircuitTerminationModel's contained in UcpCircuitTerminations");
            return;
        }
        sDebug.println("UCPCIRCUITTERMINATIONS total size: " + this.itemsByIndex.values().size());
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            try {
                UcpCircuitTerminationModel ucpCircuitTerminationModel = (UcpCircuitTerminationModel)iterator.next();
                sDebug.println("===============================================\n");
                ucpCircuitTerminationModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private class CreateTermination
    extends NonCachedValue {
        public CreateTermination(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return new Integer(this.node.getIorRepository().getUcpCircuitTerminationsRef().create((sCircuitTermination)objectArray[0]));
        }

        public Object outer() {
            return UcpCircuitTerminations.this;
        }
    }

    private class TerminationsList
    extends NonCachedValue {
        public TerminationsList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpCircuitTerminationsRef().getCircuitTerminations();
        }

        public Object outer() {
            return UcpCircuitTerminations.this;
        }
    }

    public class UcpCircuitTerminationsDebug
    extends SDebug {
        UcpCircuitTerminationsDebug(KDebug kDebug) {
            super(kDebug, UcpCircuitTerminations.MY_DEBUG_KEY);
        }

        public final void dumpAllUcpCircuitTerminationModels() {
            UcpCircuitTerminations.this.printUcpCircuitTerminationString(this);
        }
    }
}

