/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sNeighbor;
import cerent.cms.idl.Ucp.sRsvpNeighborConfig;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.Ucp.xNeighborInUse;
import cerent.cms.idl.Ucp.xNoSuchNeighbor;
import cerent.cms.idl.Ucp.xNodeNameTooLong;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.Model;
import cerent.cms.model.NeighborInUse;
import cerent.cms.model.NoSuchNeighbor;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeNameTooLong;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.ucp.UcpNeighbors;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class UcpNeighborModel
extends Model {
    private NodeModelDelegate node;
    private UcpNeighbors parent;
    private short nIndex;
    private int nodeId;
    private String name;
    private boolean ndEnable;
    private sRsvpNeighborConfig rsvpConfig;
    private DeleteNeighbor deleteNeighbor;
    private RsvpNeighborConfig rsvpNeighborConfig;
    private NeighborName neighborName;
    private NeighborInfo neighborInfo;
    private EventDispatcher dispatcher;

    public UcpNeighborModel(NodeModelDelegate nodeModelDelegate, UcpNeighbors ucpNeighbors, sNeighbor sNeighbor2, SDebug sDebug) {
        super(nodeModelDelegate.getChildDebug(UcpNeighborModel.class));
        this.node = nodeModelDelegate;
        this.parent = ucpNeighbors;
        this.nIndex = sNeighbor2.index;
        this.nodeId = sNeighbor2.nodeId;
        this.name = sNeighbor2.name;
        this.ndEnable = sNeighbor2.ndEnable;
        this.rsvpConfig = sNeighbor2.rsvpConfig;
        this.deleteNeighbor = new DeleteNeighbor(nodeModelDelegate, "UcpNeighborModel::deleteNbr");
        this.rsvpNeighborConfig = new RsvpNeighborConfig(nodeModelDelegate, "UcpNeighborModel::rsvpConfig");
        this.neighborName = new NeighborName(nodeModelDelegate, "UcpNeighborModel::neighborName");
        this.neighborInfo = new NeighborInfo(nodeModelDelegate, "UcpNeighborModel::neighborInfo");
        this.dispatcher = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    public void setRsvpConfig(sRsvpNeighborConfig sRsvpNeighborConfig2) throws NoSuchNeighbor, InvalidParams {
        try {
            Object[] objectArray = new Object[]{new Integer(this.nIndex), sRsvpNeighborConfig2};
            this.rsvpNeighborConfig.set(objectArray);
            this.rsvpConfig = sRsvpNeighborConfig2;
        }
        catch (xNoSuchNeighbor xNoSuchNeighbor2) {
            throw new NoSuchNeighbor(AnnotatedException.getString((Exception)((Object)xNoSuchNeighbor2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            this.setChanged();
            this.updateLocal();
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void rename(String string) throws NoSuchNeighbor, NodeNameTooLong {
        try {
            Object[] objectArray = new Object[]{new Integer(this.nIndex), string};
            this.neighborName.set(objectArray);
            this.name = string;
        }
        catch (xNoSuchNeighbor xNoSuchNeighbor2) {
            throw new NoSuchNeighbor(AnnotatedException.getString((Exception)((Object)xNoSuchNeighbor2)));
        }
        catch (xNodeNameTooLong xNodeNameTooLong2) {
            throw new NodeNameTooLong(AnnotatedException.getString((Exception)((Object)xNodeNameTooLong2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public short getNbrIndex() {
        return this.nIndex;
    }

    public String getName() {
        return this.name;
    }

    public boolean getNdEnable() {
        return this.ndEnable;
    }

    public sRsvpNeighborConfig getNeighborConfig() {
        return this.rsvpConfig;
    }

    @Override
    protected void updateLocal() {
        sNeighbor sNeighbor2 = null;
        try {
            sNeighbor2 = (sNeighbor)this.neighborInfo.get();
            this.nodeId = sNeighbor2.nodeId;
            this.name = sNeighbor2.name;
            this.ndEnable = sNeighbor2.ndEnable;
            this.rsvpConfig = sNeighbor2.rsvpConfig;
        }
        catch (xNoSuchNeighbor xNoSuchNeighbor2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchNeighbor2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        super.updateLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update(): DELETED");
                    }
                    if (this.parent != null && this.node != null) {
                        this.parent.remove(this);
                    }
                    this.dispose();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + " update(): CHANGED");
                    }
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println(this.getClass().getName() + " update(): STRUCTURE CHGD");
                    break;
                }
            }
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectUcpNeighbor, (int)this.nIndex, (Observer)this);
        }
    }

    public void delete() throws NeighborInUse, NoSuchNeighbor {
        try {
            Object[] objectArray = new Object[]{new Integer(this.nIndex)};
            this.deleteNeighbor.set(objectArray);
            if (this.parent != null && this.node != null) {
                this.parent.remove(this);
            }
            this.dispose();
        }
        catch (xNeighborInUse xNeighborInUse2) {
            throw new NeighborInUse(AnnotatedException.getString((Exception)((Object)xNeighborInUse2)));
        }
        catch (xNoSuchNeighbor xNoSuchNeighbor2) {
            throw new NoSuchNeighbor(AnnotatedException.getString((Exception)((Object)xNoSuchNeighbor2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        this.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectUcpNeighbor, (int)this.nIndex, (Observer)this);
        }
        super.dispose();
    }

    protected void printString(SDebug sDebug) {
        sDebug.print("NeighborIdx: " + this.nIndex + " NodeId: " + this.nodeId + " NeighborName: " + this.name);
        if (this.ndEnable) {
            sDebug.println(" ndEnable: TRUE ");
        } else {
            sDebug.println(" ndEnable: FALSE ");
        }
        sDebug.println("RsvpNeighborConfig:: HelloEnable: " + this.rsvpConfig.helloEnable + " HelloInterval: " + this.rsvpConfig.helloInterval + " refreshReduxEnabled: " + this.rsvpConfig.refreshReduxEnabled + " NumRxmts: " + this.rsvpConfig.numRxmts);
        this.printObservers();
    }

    private class DeleteNeighbor
    extends NonCachedValue {
        public DeleteNeighbor(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpNeighborsRef().delete((short)((Integer)objectArray[0]).intValue());
        }

        public Object outer() {
            return UcpNeighborModel.this;
        }
    }

    private class NeighborInfo
    extends NonCachedValue {
        public NeighborInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpNeighborsRef().get(UcpNeighborModel.this.nIndex);
        }

        public Object outer() {
            return UcpNeighborModel.this;
        }
    }

    private class NeighborName
    extends NonCachedValue {
        public NeighborName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpNeighborsRef().rename((short)((Integer)objectArray[0]).intValue(), (String)objectArray[1]);
        }

        public Object outer() {
            return UcpNeighborModel.this;
        }
    }

    private class RsvpNeighborConfig
    extends NonCachedValue {
        public RsvpNeighborConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpNeighborsRef().setRsvpConfig((short)((Integer)objectArray[0]).intValue(), (sRsvpNeighborConfig)objectArray[1]);
        }

        public Object outer() {
            return UcpNeighborModel.this;
        }
    }
}

