/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.If.sInterface;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmHoModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractHoProvTableModel
extends AbstractTableModel {
    public static final int LINENUMBER_INDEX = 0;
    protected int protocolType;
    protected TDMTerminology terms;
    protected TdmHoModel[] model = null;
    public String[] columnNames;
    protected boolean[][] isDirty;
    protected sInterface[] info;
    protected int numLines;
    protected INodeModel node;
    protected static final SDebug db = new SDebug("AbstractHoProvTableModel");
    private EntityCellRenderer myPortRenderer;
    protected int framingTypeToDisplay;

    public AbstractHoProvTableModel(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray) {
        int n = 0;
        if (iNodeModel.getTdmProtocolTypeObj().isSdh()) {
            n = 1;
        }
        this.init(iNodeModel, tdmHoModelArray, n);
    }

    public AbstractHoProvTableModel(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray, int n) {
        this.init(iNodeModel, tdmHoModelArray, n);
    }

    public abstract void init();

    private void init(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray, int n) {
        this.node = iNodeModel;
        this.model = tdmHoModelArray;
        this.protocolType = iNodeModel.getTdmProtocolType();
        this.terms = iNodeModel.getTDMTerminology();
        this.framingTypeToDisplay = n;
        this.myPortRenderer = new EntityCellRenderer();
        this.numLines = tdmHoModelArray == null ? 0 : tdmHoModelArray.length;
        this.init();
        if (tdmHoModelArray == null) {
            if (db.on()) {
                db.println("Model is null");
            }
        } else {
            this.info = new sInterface[this.numLines];
            this.isDirty = new boolean[this.numLines][this.getColumnCount()];
            this.resetDirtyBits();
        }
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public abstract void setValueAt(Object var1, int var2, int var3);

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.info[n] == null) {
            this.info[n] = this.model[n].getInfo();
        }
        return this.info[n];
    }

    private String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        return this.myPortRenderer.getPortString((IEntityModel)this.model[n].getPortModel(), false);
    }

    public String getLineNumber(int n) throws NoSuchInterface, AbstractCmsNoSuchEntityException {
        StringBuffer stringBuffer = new StringBuffer();
        IHoNum iHoNum = null;
        this.getInfo(n);
        if (this.info[n] != null) {
            iHoNum = HoLoFactory.idlSts2HoNum(this.getFramingType(n), this.getHoNum(n));
            String string = this.terms.getTdmHoTerm(this.framingTypeToDisplay);
            stringBuffer.append("Port ");
            stringBuffer.append(this.getPortDescriptionFor(n));
            stringBuffer.append(", " + string + " ");
            stringBuffer.append(iHoNum);
        }
        return stringBuffer.toString();
    }

    protected int getHoNum(int n) {
        return this.info[n].muxIndex;
    }

    protected int getFramingType(int n) {
        return TdmHoModel.calcFramingType(this.node, this.info[n].ifSpeed);
    }

    public AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.protocolType, this.terms);
    }

    private Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal(string, n);
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        this.resetDirtyBits();
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public synchronized void setHoModel(TdmHoModel[] tdmHoModelArray) {
        this.info = new sInterface[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.refreshFromModel();
        this.fireTableDataChanged();
    }
}

