/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.ui.ppm.PpmSlotView;
import cerent.cms.ui.shelf.CardView;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;

public abstract class AbstractMrcCardView
extends CardView {
    protected PluggableSlotModel[] ppmSlots = null;
    protected PpmSlotView[] ppmSlotViews = null;
    protected static final int MAX_PER_COLUMN = 6;
    protected SDebug db;

    public AbstractMrcCardView(PluggableCarrierModel pluggableCarrierModel, SDebug sDebug) {
        super(pluggableCarrierModel);
        this.db = sDebug;
    }

    @Override
    protected void addPorts(boolean bl) {
        this.ppmSlots = new PluggableSlotModel[0];
        if (this.model instanceof PluggableCarrierModel) {
            this.ppmSlots = ((PluggableCarrierModel)this.model).getPpmSlots();
        }
        this.ppmSlotViews = new PpmSlotView[this.ppmSlots.length];
        this.addPorts(bl, this.getConstraints());
        this.repaint();
    }

    protected void addPorts(boolean bl, GridBagConstraints gridBagConstraints) {
        for (int i = 0; i < this.ppmSlots.length; ++i) {
            if (this.ppmSlots[i] != null && this.ppmSlots[i] instanceof PluggableSlotModel) {
                this.ppmSlotViews[i] = new PpmSlotView(this.ppmSlots[i]);
                this.calcPortPosition(this.ppmSlots[i].getPositionInParent(), bl, gridBagConstraints);
                this.add((Component)this.ppmSlotViews[i], gridBagConstraints);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("addPorts(): entity is NOT PluggableSlotModel");
        }
    }

    protected GridBagConstraints getConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        return gridBagConstraints;
    }

    protected void calcPortPosition(int n, boolean bl, GridBagConstraints gridBagConstraints) {
        int n2;
        int n3 = this.getPortCount();
        int n4 = n2 = n > 0 ? n - 1 : 0;
        if (bl) {
            gridBagConstraints.gridx = n2 / n3;
            gridBagConstraints.gridy = n2 % n3;
        } else {
            gridBagConstraints.gridx = n2 % n3;
            gridBagConstraints.gridy = n2 / n3;
        }
    }

    protected int getPortCount() {
        return 6;
    }

    @Override
    public void dispose() {
        int n;
        if (this.ppmSlots != null) {
            for (n = 0; n < this.ppmSlots.length; ++n) {
                if (this.ppmSlots[n] == null) continue;
                this.ppmSlots[n].dispose();
                this.ppmSlots[n] = null;
            }
            this.ppmSlots = null;
        }
        if (this.ppmSlotViews != null) {
            for (n = 0; n < this.ppmSlotViews.length; ++n) {
                if (this.ppmSlotViews[n] == null) continue;
                this.ppmSlotViews[n].dispose();
                this.ppmSlotViews[n] = null;
            }
            this.ppmSlotViews = null;
        }
        super.dispose();
    }
}

