/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlarmModel;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IStringTag;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.AnnotatedException;
import cerent.util.BlockingModeController;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;

public class CardProvAlarmsTableModel
extends AbstractProvTableModel
implements BlockingModeController {
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    public static final int PORTNUMBER_INDEX = 0;
    public static final int PROFILE_INDEX = 1;
    public static final int SUPPRESS_INDEX = 2;
    private static SDebug db = new SDebug("CardProvAlarmsTableModel");
    protected String[] availableProfileNames;
    protected AlarmModel alarmModel;
    protected String[] profileNames;
    protected Boolean[] suppressFlags;
    protected EntityCellRenderer myPortRenderer;
    private ModuleModel mm;

    public CardProvAlarmsTableModel(ModuleModel moduleModel) {
        super(moduleModel.getAlarmablePorts(), true, "");
        this.mm = moduleModel;
        this.columnNames = new String[]{"Port/PPM", "Profile", "Suppress Alarms"};
        this.myPortRenderer = new EntityCellRenderer(true);
        this.init();
    }

    protected void init() {
        this.setModels(this.getMyEntities());
        this.profileNames = new String[this.numLines];
        this.suppressFlags = new Boolean[this.numLines];
        this.alarmModel = (AlarmModel)this.mm.getNodeModel().getAlarmModel();
        this.observableManager.addObservable((Observable)((Object)this.alarmModel));
        this.observableManager.setBlockingModeController((BlockingModeController)this);
        this.getPortProfiles();
    }

    private EntityModel[] getMyEntities() {
        EntityModel[] entityModelArray = this.mm.getAlarmablePorts();
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        for (int i = 0; i < entityModelArray.length; ++i) {
            try {
                ((PortModel)entityModelArray[i]).getInterfaceModel();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                continue;
            }
            arrayList.add(entityModelArray[i]);
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.mm.getDescendantsOfType(eClass.E_MODULE));
        for (EntityModel entityModel : arrayList2) {
            if (!(entityModel instanceof PpmModel)) continue;
            arrayList.add(entityModel);
        }
        entityModelArray = arrayList.toArray(new EntityModel[arrayList.size()]);
        return entityModelArray;
    }

    protected void refreshMyPorts() {
        this.setModels(this.getMyEntities());
        this.observableManager.addObservable((Observable)((Object)this.alarmModel));
        this.profileNames = new String[this.numLines];
        this.suppressFlags = new Boolean[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.profileNames[i] = null;
            this.suppressFlags[i] = null;
            this.rowDirty[i] = false;
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    String string = (String)object;
                    if (this.profileNames[n].equals(string)) {
                        return;
                    }
                    this.profileNames[n] = string;
                    break;
                }
                case 2: {
                    Boolean bl = (Boolean)object;
                    if (this.suppressFlags[n].equals(bl)) {
                        return;
                    }
                    this.suppressFlags[n] = bl;
                    break;
                }
                default: {
                    db.println("Invalid col index #" + n2);
                    return;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.cmsModels != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized((EntityModel)this.cmsModels[n], SecurityLevel.PROVISIONING) && (n2 == 1 || n2 == 2)) {
                    return true;
                }
            }
            catch (Exception exception) {
                db.finest("Exception in isCellEditable() " + exception);
            }
        }
        return false;
    }

    @Override
    public Class getColumnClass(int n) {
        switch (n) {
            case 2: {
                return Boolean.class;
            }
            case 0: {
                return String.class;
            }
        }
        return super.getColumnClass(n);
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        if (this.cmsModels[n] instanceof PortModel) {
            PortModel portModel = (PortModel)this.cmsModels[n];
            if (portModel.getModuleModel() instanceof DwdmModuleModel && ((DwdmModuleModel)portModel.getModuleModel()).isPolluceCard()) {
                TdmLineModel tdmLineModel;
                if (portModel.getEqType() == 61 && (tdmLineModel = ((TdmPortModel)portModel).getTdmLineModel()).isWISPort()) {
                    PortModel portModel2 = (PortModel)tdmLineModel.getParentForWISLineModel().getPortModel();
                    String string = this.myPortRenderer.getPortString(portModel2, false);
                    return string.substring(0, string.length() - 1) + "-WIS)";
                }
                return this.myPortRenderer.getPortString((PortModel)this.cmsModels[n], false);
            }
            return this.myPortRenderer.getPortString((PortModel)this.cmsModels[n], false);
        }
        return ((PpmModel)this.cmsModels[n]).getParent().getPositionInParent() + " " + ((EntityModel)this.cmsModels[n]).getEqTypeName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        block8: {
            object = null;
            try {
                switch (n2) {
                    case 0: {
                        object = this.getPortDescriptionFor(n);
                        break;
                    }
                    case 1: {
                        object = this.getProfileName(n);
                        break;
                    }
                    case 2: {
                        object = this.getSuppressAlarms(n);
                        break;
                    }
                    default: {
                        db.println("Unexpected column value = " + n2);
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)new Exception());
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                db.println("Could not getValueAt(" + n + "," + n2 + ")");
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return object;
    }

    @Override
    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.profileNames[i] = null;
            this.suppressFlags[i] = null;
            this.rowDirty[i] = false;
        }
        super.refreshFromModel();
    }

    @Override
    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            if (db.on()) {
                db.println("refresh from model, mode " + n);
            }
            this.getPortProfiles();
        }
        this.refreshFromModel();
    }

    public void applyToModel() throws Exception {
        int n = 0;
        this.observableManager.setPassing(false);
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.rowDirty[n]) continue;
                EntityModel entityModel = (EntityModel)this.cmsModels[n];
                entityModel.setAlarmProfileName(this.getProfileName(n));
                entityModel.setSuppressAlarms(this.getSuppressAlarms(n));
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
        finally {
            this.observableManager.setPassing(true);
        }
    }

    public String[] getProfileNames() {
        if (this.availableProfileNames == null) {
            this.getPortProfiles();
        }
        return this.availableProfileNames;
    }

    protected void getPortProfiles() {
        IStringTag[] iStringTagArray = this.alarmModel.getAlarmProfileList();
        this.availableProfileNames = new String[iStringTagArray.length];
        for (int i = 0; i < iStringTagArray.length; ++i) {
            this.availableProfileNames[i] = iStringTagArray[i].getFirst();
        }
    }

    public AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.mm.getNodeModel());
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Received update " + object + " from " + observable);
        }
        if (observable instanceof AlarmModel) {
            this.getPortProfiles();
        }
        super.update(observable, object);
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        if (CardProvAlarmsTableModel.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if (observable instanceof AlarmModel) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    private String getProfileName(int n) {
        if (this.profileNames[n] == null) {
            this.profileNames[n] = ((EntityModel)this.cmsModels[n]).getAlarmProfileName();
        }
        return this.profileNames[n];
    }

    private Boolean getSuppressAlarms(int n) {
        if (this.suppressFlags[n] == null) {
            this.suppressFlags[n] = new Boolean(((EntityModel)this.cmsModels[n]).getSuppressAlarms());
        }
        return this.suppressFlags[n];
    }
}

