/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.IPlatform;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.ui.CardProvAlarmsPane;
import cerent.cms.ui.ILineModelUpdater;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PathTraceMaintenancePane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.CardAlarmPane;
import cerent.cms.ui.event.CardConditionsPane;
import cerent.cms.ui.event.CardHistoryPane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.shelf.SmpProtectionPane;
import cerent.util.EID;
import cerent.util.SDebug;
import java.awt.Component;

public abstract class CardTabbedView
extends MainTabbedView
implements ITabName {
    protected IEventPanelController myController = null;
    protected IUiToolkit uiToolkit = null;
    protected IPlatform pci;
    protected static final SDebug db = new SDebug("CardTabbedView");

    public abstract Pane getMaintenanceTab();

    public abstract Pane getProvTab();

    public abstract Pane getPerformanceTab();

    public CardTabbedView(Object object, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super((IModel)object);
        this.myController = iEventPanelController;
        this.uiToolkit = iUiToolkit;
        this.pci = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getPlatform();
    }

    @Override
    public Pane getAlarmTab() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)iNodeModel.getElementAlarmStore();
        return new CardAlarmPane("Alarms", (ModuleModel)this.uiModel, (TabbedView)this, elementAlarmStore, this.myController);
    }

    public Pane getConditionsTab() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)iNodeModel.getElementAlarmStore();
        return new CardConditionsPane("Conditions", (ModuleModel)this.uiModel, this, this.myController);
    }

    @Override
    public Pane getEventTab() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        ElementEventStore elementEventStore = (ElementEventStore)iNodeModel.getElementEventStore();
        return new CardHistoryPane("History", this, elementEventStore, this.myController);
    }

    @Override
    public Pane getCircuitTab() {
        return (Pane)this.uiToolkit.getGuestPane(1, (TabbedView)this);
    }

    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    public static Pane getProtectionPane(TabbedView tabbedView) {
        return new SmpProtectionPane("Protection", tabbedView);
    }

    public static Pane getPathTracePane(InterfaceModel[] interfaceModelArray, TabbedView tabbedView) {
        return CardTabbedView.getPathTracePane(interfaceModelArray, tabbedView, new ILineModelUpdater(){

            @Override
            public boolean updateIsForMe(ModuleModelUpdate moduleModelUpdate) {
                return false;
            }
        });
    }

    public static Pane getPathTracePane(InterfaceModel[] interfaceModelArray, TabbedView tabbedView, int n) {
        return CardTabbedView.getPathTracePane(interfaceModelArray, tabbedView, new ILineModelUpdater(){

            @Override
            public boolean updateIsForMe(ModuleModelUpdate moduleModelUpdate) {
                return false;
            }
        }, n);
    }

    public static Pane getPathTracePane(InterfaceModel[] interfaceModelArray, TabbedView tabbedView, ILineModelUpdater iLineModelUpdater) {
        return new PathTraceMaintenancePane("Path Trace", tabbedView, (ModuleModel)tabbedView.getUiModel(), interfaceModelArray, iLineModelUpdater);
    }

    public static Pane getPathTracePane(InterfaceModel[] interfaceModelArray, TabbedView tabbedView, ILineModelUpdater iLineModelUpdater, int n) {
        return new PathTraceMaintenancePane("Path Trace", tabbedView, (ModuleModel)tabbedView.getUiModel(), interfaceModelArray, iLineModelUpdater, n);
    }

    public static Pane getCardProvAlarmsPane(TabbedView tabbedView, boolean bl) {
        return new CardProvAlarmsPane("Alarm Profiles", tabbedView, bl);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.removeAll();
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
    }

    public IUiToolkit getUiToolkit() {
        return this.uiToolkit;
    }

    public IEventPanelController getMyController() {
        return this.myController;
    }
}

