/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.MrcModuleModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.MSIsc100T.MSIsc100TCardTabbedView;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.aici.AiciCardTabbedView;
import cerent.cms.ui.ampli.AmplifierCardTabbedView;
import cerent.cms.ui.ampli.RamanAmpliCardTabbedView;
import cerent.cms.ui.dwdm.DwdmCardTabbedView;
import cerent.cms.ui.ec1.Ec1CardTabbedView;
import cerent.cms.ui.ether.EtherCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.fcmr.FcmrCardTabbedView;
import cerent.cms.ui.hdge.HdGeCardTabbedView;
import cerent.cms.ui.mrc.MrcCardTabbedView;
import cerent.cms.ui.muxdemux.MuxDmuxCardTabbedView;
import cerent.cms.ui.oadm.OadmCardTabbedView;
import cerent.cms.ui.oscm.OscmCardTabbedView;
import cerent.cms.ui.psm.PsmCardTabbedView;
import cerent.cms.ui.sonet.TdmCardTabbedView;
import cerent.cms.ui.tdcu.TdcuCardTabbedView;
import cerent.cms.ui.wxc.WxcCardTabbedView;
import cerent.cms.ui.xpl2.XPL2CardTabbedView;
import cerent.util.SDebug;

public class CardTabbedViewFactory {
    protected static final SDebug db = new SDebug("CardTabbedViewFactory");

    protected MainTabbedView createSonetCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit, String string) {
        TdmCardTabbedView tdmCardTabbedView = null;
        if (moduleModel instanceof TdmModuleModel) {
            tdmCardTabbedView = new TdmCardTabbedView((TdmModuleModel)moduleModel, iEventPanelController, iUiToolkit, string);
        } else if (db.on()) {
            db.println("Could not cast card to SONET module model");
        }
        return tdmCardTabbedView;
    }

    protected MainTabbedView createEc1Ctv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        Ec1CardTabbedView ec1CardTabbedView = null;
        if (moduleModel instanceof TdmModuleModel) {
            ec1CardTabbedView = new Ec1CardTabbedView((TdmModuleModel)moduleModel, iEventPanelController, iUiToolkit);
        } else if (db.on()) {
            db.println("Could not cast EC1 card to SONET module model");
        }
        return ec1CardTabbedView;
    }

    protected MainTabbedView createEtherCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new EtherCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private MainTabbedView createAiciCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        AiciCardTabbedView aiciCardTabbedView = null;
        aiciCardTabbedView = new AiciCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
        return aiciCardTabbedView;
    }

    private MainTabbedView createHdGeCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new HdGeCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private MainTabbedView createFcmrCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new FcmrCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    protected MainTabbedView createMrcCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit, String string) {
        MrcCardTabbedView mrcCardTabbedView = null;
        if (moduleModel instanceof MrcModuleModel) {
            mrcCardTabbedView = new MrcCardTabbedView((MrcModuleModel)moduleModel, iEventPanelController, iUiToolkit);
        } else if (db.on()) {
            db.println("Could not cast card to MRC module model");
        }
        return mrcCardTabbedView;
    }

    private static MainTabbedView createDwdmCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new DwdmCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createMSISC100TCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new MSIsc100TCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createXPL2Ctv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new XPL2CardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createOadmCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new OadmCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createPsmCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new PsmCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createMuxDmuxCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new MuxDmuxCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createWxcCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new WxcCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createAmpliCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new AmplifierCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createRamanCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new RamanAmpliCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createOscmCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new OscmCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    private static MainTabbedView createTdcuCtv(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        return new TdcuCardTabbedView(moduleModel, iEventPanelController, iUiToolkit);
    }

    public MainTabbedView getCardView(IModuleModel iModuleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        MainTabbedView mainTabbedView = null;
        ModuleModel moduleModel = (ModuleModel)iModuleModel;
        switch (moduleModel.getEqType()) {
            case 9: {
                mainTabbedView = this.createSonetCtv(moduleModel, iEventPanelController, iUiToolkit, "OC3");
                break;
            }
            case 106: {
                mainTabbedView = this.createSonetCtv(moduleModel, iEventPanelController, iUiToolkit, "OC3-8");
                break;
            }
            case 10: {
                mainTabbedView = this.createSonetCtv(moduleModel, iEventPanelController, iUiToolkit, "OC12");
                break;
            }
            case 85: {
                mainTabbedView = this.createSonetCtv(moduleModel, iEventPanelController, iUiToolkit, "OC12-4");
                break;
            }
            case 11: 
            case 87: {
                mainTabbedView = this.createSonetCtv(moduleModel, iEventPanelController, iUiToolkit, "OC48");
                break;
            }
            case 60: 
            case 86: 
            case 251: {
                mainTabbedView = this.createSonetCtv(moduleModel, iEventPanelController, iUiToolkit, "OC192");
                break;
            }
            case 12: 
            case 13: {
                mainTabbedView = this.createEc1Ctv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 14: 
            case 15: {
                mainTabbedView = this.createEtherCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 62: {
                mainTabbedView = this.createHdGeCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 97: {
                mainTabbedView = this.createAiciCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 143: {
                mainTabbedView = this.createFcmrCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 220: {
                mainTabbedView = this.createMrcCtv(moduleModel, iEventPanelController, iUiToolkit, "MRC_1");
                break;
            }
            case 219: {
                mainTabbedView = this.createMrcCtv(moduleModel, iEventPanelController, iUiToolkit, "MRC_12");
                break;
            }
            case 253: {
                mainTabbedView = this.createMrcCtv(moduleModel, iEventPanelController, iUiToolkit, "MRC_12_2.5G");
                break;
            }
            case 254: {
                mainTabbedView = this.createMrcCtv(moduleModel, iEventPanelController, iUiToolkit, "MRC_4_2.5G");
                break;
            }
            case 271: 
            case 272: {
                mainTabbedView = CardTabbedViewFactory.createXPL2Ctv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 238: {
                mainTabbedView = CardTabbedViewFactory.createMSISC100TCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 249: {
                mainTabbedView = CardTabbedViewFactory.createOadmCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 286: {
                mainTabbedView = CardTabbedViewFactory.createPsmCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 191: 
            case 192: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: {
                mainTabbedView = CardTabbedViewFactory.createMuxDmuxCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 266: 
            case 270: 
            case 297: {
                mainTabbedView = CardTabbedViewFactory.createWxcCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 129: 
            case 130: 
            case 196: 
            case 277: 
            case 278: 
            case 281: 
            case 294: 
            case 295: 
            case 296: {
                mainTabbedView = CardTabbedViewFactory.createAmpliCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 287: 
            case 321: {
                mainTabbedView = CardTabbedViewFactory.createRamanCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 127: 
            case 128: {
                mainTabbedView = CardTabbedViewFactory.createOscmCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 241: 
            case 242: {
                mainTabbedView = CardTabbedViewFactory.createMuxDmuxCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 239: 
            case 240: {
                mainTabbedView = CardTabbedViewFactory.createAmpliCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            case 298: 
            case 299: {
                mainTabbedView = CardTabbedViewFactory.createTdcuCtv(moduleModel, iEventPanelController, iUiToolkit);
                break;
            }
            default: {
                if (moduleModel instanceof DwdmModuleModel) {
                    mainTabbedView = CardTabbedViewFactory.createDwdmCtv(moduleModel, iEventPanelController, iUiToolkit);
                    break;
                }
                db.severe("Unknown Card model=" + moduleModel + " eqType=" + moduleModel.getEqType());
            }
        }
        return mainTabbedView;
    }

    public static boolean isCardViewAvailable(IModuleModel iModuleModel) {
        boolean bl = false;
        switch (iModuleModel.getEqType()) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 60: 
            case 62: 
            case 85: 
            case 97: 
            case 106: 
            case 143: 
            case 219: 
            case 220: 
            case 253: 
            case 254: {
                bl = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 37: 
            case 47: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 83: 
            case 86: 
            case 87: 
            case 102: 
            case 103: 
            case 108: 
            case 109: 
            case 113: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 145: 
            case 146: 
            case 157: 
            case 163: 
            case 164: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 191: 
            case 192: 
            case 196: 
            case 218: 
            case 221: 
            case 229: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 248: 
            case 249: 
            case 251: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 321: 
            case 356: 
            case 358: {
                if (((ModuleModel)iModuleModel).getState() == eEqState.DELETED) break;
                bl = true;
                break;
            }
            case 330: {
                bl = true;
                break;
            }
            case 238: {
                bl = iModuleModel instanceof L2scModuleModel;
                break;
            }
            default: {
                if (iModuleModel instanceof DwdmModuleModel) {
                    bl = true;
                    break;
                }
                if (!db.on()) break;
                db.println("isCardViewAvailable false for eqType=" + iModuleModel.getEqType());
            }
        }
        return bl;
    }
}

