/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eLogLevel;
import cerent.cms.idl.Equipment.eShowCmd;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongEquipmentType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.StringChoicePropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class MaintShowCmdPane
extends AbstractPane
implements ITabName,
ActionListener,
PropertyChangeListener {
    protected static final String SHOW_STRING = "Show";
    protected DwdmModuleModel eqpmtModel = null;
    private StringChoicePropertyEditor commandBox = null;
    private StringChoicePropertyEditor levelBox = null;
    private JButton showButton = null;
    private JTextArea terminalArea = null;
    private JTextField keyTF = new JTextField(15);
    private JLabel keyLabel = new JLabel("Key :");

    public MaintShowCmdPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.commandBox = new StringChoicePropertyEditor("Command : ", this.getShowCommands());
        this.levelBox = new StringChoicePropertyEditor("Level : ", this.getLogLevels());
        this.showButton = new JButton(SHOW_STRING);
        this.showButton.addActionListener(this);
        Dimension dimension = new Dimension(5, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.commandBox);
        this.commandBox.addPropertyChangeListener(this);
        this.commandBox.setMaximumSize(this.commandBox.getPreferredSize());
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.levelBox);
        this.levelBox.setMaximumSize(this.levelBox.getPreferredSize());
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.keyLabel);
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.keyTF);
        this.keyTF.setPreferredSize(new Dimension(80, 25));
        this.keyTF.setMaximumSize(this.keyTF.getPreferredSize());
        jPanel.add(Box.createRigidArea(dimension));
        jPanel.add(this.showButton);
        this.commandBox.setEnabled(false);
        this.levelBox.setEnabled(false);
        this.keyTF.setEnabled(false);
        this.terminalArea = new JTextArea(21, 80);
        this.terminalArea.setEditable(false);
        this.terminalArea.setOpaque(true);
        this.terminalArea.setFont(new Font("Monospaced", 0, 12));
        UScrollPane uScrollPane = new UScrollPane((Component)this.terminalArea);
        uScrollPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        Box box = Box.createVerticalBox();
        box.add(jPanel);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add((Component)uScrollPane);
        this.setLayout(new BorderLayout());
        this.add(box, "West");
    }

    private Attribute[] getShowCommands() {
        return new Attribute[]{new Attribute("OAM STATUS", 9)};
    }

    private Attribute[] getLogLevels() {
        return new Attribute[]{new Attribute("Normal", 0)};
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("calling enteringPage");
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("calling leavingPage");
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.MaintShowCmdPane;
    }

    @Override
    public final void refresh() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        eShowCmd eShowCmd2 = eShowCmd.from_int(((Attribute)this.commandBox.getValue()).getIntValue());
        if (eShowCmd2 == eShowCmd.SHOW_ETH_OAM_STATUS || eShowCmd2 == eShowCmd.SHOW_ETH_OAM_SUMMARY) {
            this.levelBox.setEnabled(false);
            this.keyTF.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.showButton) {
            eShowCmd eShowCmd2 = eShowCmd.from_int(((Attribute)this.commandBox.getValue()).getIntValue());
            eLogLevel eLogLevel2 = eLogLevel.from_int(((Attribute)this.levelBox.getValue()).getIntValue());
            int n = 0;
            try {
                if (this.keyTF.getText() != null && !this.keyTF.getText().equalsIgnoreCase("")) {
                    n = Integer.parseInt(this.keyTF.getText().trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_ID);
                this.keyTF.setText("");
                return;
            }
            try {
                this.terminalArea.setText(this.eqpmtModel.showCommand(eShowCmd2, eLogLevel2, n));
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
                ErrorMsg.displayDetailed(MaintShowCmdPane.getFrame(this.eqpmtModel), EMC.EID_UNSUPPORTED_OPERATION_PARAM_1, notSupportedOnEquipment.getMessage());
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                ErrorMsg.displayDetailed(MaintShowCmdPane.getFrame(this.eqpmtModel), EMC.EID_UNSUPPORTED_OPERATION_PARAM_1, noSuchInterface.getMessage());
            }
            catch (WrongEquipmentType wrongEquipmentType) {
                SDebug.printStackTrace((Throwable)wrongEquipmentType);
                ErrorMsg.displayDetailed(MaintShowCmdPane.getFrame(this.eqpmtModel), EMC.EID_UNSUPPORTED_OPERATION_PARAM_1, wrongEquipmentType.getMessage());
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
                ErrorMsg.displayDetailed(MaintShowCmdPane.getFrame(this.eqpmtModel), EMC.EID_UNSUPPORTED_OPERATION_PARAM_1, provisionError.getMessage());
            }
        }
    }

    private static Component getFrame(DwdmModuleModel dwdmModuleModel) {
        return dwdmModuleModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

